package v50b.v50bOperacionesPaso.v50bconsultas.v50bHistoricoConsultas;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bBeans.V50bDificultadBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bBeans.V50bSubcategoriasBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


/**
 * 
 * @author alata
 *
 */
public class V50bComboSubcatResolDificPostAjaxAction extends V50bActionPasoOP  {
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @throws Exception Se lanza la excepcin
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		V50bClsTrazas.depura("V50bComboSubcatResolDificPostAjaxAction.processForward() ");
		
		String idioma = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		List lCombos = (ArrayList)contexto.get("v50bListaSubcategoriasResolutoresDificultades");
		List lSubcategorias = (ArrayList)lCombos.get(0);
		List lResolutores = (ArrayList)lCombos.get(1);
		List lDificultades = (ArrayList)lCombos.get(2);
		
		String busqueda = (String)contexto.get("busqRealizada");
		if(!"true".equals(busqueda) || lSubcategorias.size()>0) {
			contexto.set("v50bListaSubcategoriasAmbito", lSubcategorias);
			contexto.set("v50bListaResolutoresAmbito", lResolutores);
			contexto.set("v50bListaDificultadesAmbito", lDificultades);
		}
		
		final StringBuffer xmlAjax = new StringBuffer(V50bClsConstantes.CUATROCIENTOSCUARENTAYCINCO);
		xmlAjax.append("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>");
		xmlAjax.append("<ajax-response><responseCombosSubcategoriaResolutorDificultad>");
		
		xmlAjax.append("<tamSubcategorias>");
		xmlAjax.append(lSubcategorias.size());
		xmlAjax.append("</tamSubcategorias>");
		
		xmlAjax.append("<tamResolutores>");
		xmlAjax.append(lResolutores.size());
		xmlAjax.append("</tamResolutores>");
		
		xmlAjax.append("<tamDificultades>");
		xmlAjax.append(lDificultades.size());
		xmlAjax.append("</tamDificultades>");
		
		for (int i=0; i<lSubcategorias.size(); i++){
			V50bSubcategoriasBean subcategoria = (V50bSubcategoriasBean)lSubcategorias.get(i);
			xmlAjax.append("<lSubcategoria"+i+">");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				xmlAjax.append(subcategoria.getDesCas());
			} else {
				xmlAjax.append(subcategoria.getDesEus());
			}
			xmlAjax.append("</lSubcategoria"+i+">");
			xmlAjax.append("<vSubcategoria"+i+">");
			xmlAjax.append(subcategoria.getCodSub());
			xmlAjax.append("</vSubcategoria"+i+">");
		}
		
		for (int i=0; i<lResolutores.size(); i++){
			V50bResolutoresBean resolutor = (V50bResolutoresBean)lResolutores.get(i);
			xmlAjax.append("<lResolutor"+i+">");
			if ("".equals(resolutor.getNombreApellidos())) {
				xmlAjax.append("null");
			}else {
				xmlAjax.append(resolutor.getNombreApellidos());
			}
			xmlAjax.append("</lResolutor"+i+">");
			xmlAjax.append("<vResolutor"+i+">");
			xmlAjax.append(resolutor.getCodResol());
			xmlAjax.append("</vResolutor"+i+">");
		}
		
		for (int i=0; i<lDificultades.size(); i++){
			V50bDificultadBean dificultad = (V50bDificultadBean)lDificultades.get(i);
			xmlAjax.append("<lDificultad"+i+">");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)){
				xmlAjax.append(dificultad.getDescc());
			} else {
				xmlAjax.append(dificultad.getDesce());
			}
			xmlAjax.append("</lDificultad"+i+">");
			xmlAjax.append("<vDificultad"+i+">");
			xmlAjax.append(dificultad.getCoddif());
			xmlAjax.append("</vDificultad"+i+">");
		}
		
		xmlAjax.append("</responseCombosSubcategoriaResolutorDificultad></ajax-response>");
		response.setContentType("text/xml");
		response.setHeader("Cache-Control", "no-cache");
		PrintWriter pw = response.getWriter();
		pw.write(xmlAjax.toString());
		pw.close();

		return null;
	}

}
