package v50b.v50bOperacionesPaso.v50bTablas.v50bSubcategorias;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bBeans.V50bSubcategoriasBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsInformes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author acompes
 *
 */
public class V50bImprimirBusquedaAction extends Q70ActionPasoOP {

	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param arg2 : ActionMapping
	 * @param arg3 : ActionForm
	 * @param req : request
	 * @param arg5 : response
	 * @throws Exception Se eleva la excepcin
	*/
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest req,
			HttpServletResponse arg5) throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processOP() ");
		
		//Idioma
		String idioma = Q70ListenerUtils.getLanguage(req);
		
		//Plantilla
		String strPlantilla = (String) contexto.get("plantillaBusqueda");
	
		//Parametros
		ArrayList arrParametros = new ArrayList();
		
		//Imagen
		StringBuffer imagenSB = new StringBuffer(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB.append(V50bClsConstantes.CONSTANTE_LOGO_IVAP);
		String imagenString = imagenSB.toString();
		String imagen = this.getClass().getResource(imagenString).toString();
		
		arrParametros.add(imagen);
		
		//Fecha
		String fecha=V50bClsFecha.fncPresentarFechaSistemaCorta((String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
	    arrParametros.add(fecha);
		
		//Idioma
		arrParametros.add(idioma);
				
		//Literales
		ArrayList arrLiterales = new ArrayList();
		arrLiterales.add("comun.subcategorias");
		arrLiterales.add("subcategorias.codigo");
		arrLiterales.add("subcategorias.descripcion");
		arrLiterales.add("subcategorias.ambito");
		arrLiterales.add("subcategorias.situacion");

		//ArrayList Busqueda
		ArrayList arrDatosTablasBusquedas = (ArrayList)contexto.get("v50bListaSubcategorias");
		
		V50bSubcategoriasBean datosSubcategorias = (V50bSubcategoriasBean)contexto.get("v50bSubcategoriasBeanOrig");
				
		String codigo=datosSubcategorias.getCodSub();
		String baja=datosSubcategorias.getEstado();
		String desc=datosSubcategorias.getDesCas();
		String descAmbito=datosSubcategorias.getDesAmbitoCas();
		
		if ("eu".equals(idioma)){
			desc=datosSubcategorias.getDesEus();
		}
							
		if(codigo!=null && !"".equals(codigo)){
			arrParametros.add(codigo);
		}
		else{
			arrParametros.add("");
		}
		if (desc!=null && !"".equals(desc)){
			arrParametros.add(desc);
		}
		else{
			arrParametros.add("");
		}
		if (descAmbito!=null && !"".equals(descAmbito)){
			arrParametros.add(descAmbito);
		}
		else{
			arrParametros.add("");
		}
		if (baja!=null && !"".equals(baja)){
			arrParametros.add(V50bClsConstantes.LITERAL_DESC_BAJA);
		}
		else{
			arrParametros.add(V50bClsConstantes.LITERAL_DESC_ALTA);
		}
					
		//Generamos PDF
		V50bClsInformes.fncSacarListadoFOP(req,arg5,idioma,Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA")+strPlantilla,arrParametros,arrLiterales,arrDatosTablasBusquedas,"v50bcomun", null);
		
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param mapping : ActionMapping
	 * @param arg3 : ActionForm
	 * @param request : request
	 * @param arg5 : response
	 * @return ActionForward
	 * @throws Exception Se eleva la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors arg1, ActionMapping mapping, ActionForm arg3,
			HttpServletRequest request, HttpServletResponse arg5)
			throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processForward() ");
		
		if (arg1.isEmpty()){
			String hayBusqueda=(String)contexto.get("busqRealizada");
			
			if("false".equals(hayBusqueda)){
				contexto.set("v50bListaSubcategorias",null);
			}
			return mapping.findForward("ok");
		}
		else{
			return mapping.findForward("error");
		}
	}
}