package v50b.v50bOperacionesPaso.v50bTablas.v50bResolutores;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsInformes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author acompes
 * 
 */
public class V50bImprimirBusquedaAction extends Q70ActionPasoOP {

	/**
	 * 
	 * @param contexto :
	 *            Q70ContextoEJIE
	 * @param arg1 :
	 *            ActionErrors
	 * @param arg2 :
	 *            ActionMapping
	 * @param arg3 :
	 *            ActionForm
	 * @param req :
	 *            request
	 * @param arg5 :
	 *            response
	 * @throws Exception
	 *             Se eleva la excepcin
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest req,
			HttpServletResponse arg5) throws Exception {

		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processOP() ");

		// Idioma
		String idioma = Q70ListenerUtils.getLanguage(req);

		// Plantilla
		String strPlantilla = (String) contexto.get("plantillaBusqueda");

		// Parametros
		ArrayList arrParametros = new ArrayList();

		// Imagen
		StringBuffer imagenSB = new StringBuffer(Q70ListenerUtils
				.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB.append(V50bClsConstantes.CONSTANTE_LOGO_IVAP);
		String imagenString = imagenSB.toString();
		String imagen = this.getClass().getResource(imagenString).toString();

		arrParametros.add(imagen);

		// Fecha
		String fecha = V50bClsFecha
				.fncPresentarFechaSistemaCorta((String) contexto
						.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		arrParametros.add(fecha);

		// Idioma
		arrParametros.add(idioma);

		// Literales
		ArrayList arrLiterales = new ArrayList();
		arrLiterales.add("comun.resolutores");
		arrLiterales.add("resolutores.id");
		arrLiterales.add("comun.situacion");
		arrLiterales.add("resolutores.nombre");
		arrLiterales.add("resolutores.nombre");
		arrLiterales.add("resolutores.apellidoUno");
		arrLiterales.add("resolutores.apellidoDos");
		arrLiterales.add("resolutores.tieneMovil");
		arrLiterales.add("resolutores.tieneEmail");
		arrLiterales.add("resolutores.perfil");
		arrLiterales.add("resolutores.recibeAvisoBandEntrada");
		arrLiterales.add("resolutores.nombreApellidos");
		arrLiterales.add("resolutores.email");
		arrLiterales.add("resolutores.movil");
		arrLiterales.add("resolutores.recAvisos");

		// ArrayList Busqueda
		ArrayList arrDatosTablasBusquedas = (ArrayList) contexto
				.get("v50bListaResolutores");

		V50bResolutoresBean datosResolutores = (V50bResolutoresBean) contexto
				.get("v50bResolutoresBeanOrig");

		String id = datosResolutores.getIdResol();
		String baja = datosResolutores.getEstado();
		String nombre = datosResolutores.getNombre();
		String ape1 = datosResolutores.getApe1();
		String ape2 = datosResolutores.getApe2();
		String tieneMovil = datosResolutores.getTieneMovil();
		String tieneEmail = datosResolutores.getTieneEmail();
		String perfil = datosResolutores.getPerfil();
		String recibeAvisoBandEntrada = datosResolutores.getAvisoBandEntrada();
		String strEstado = "";

		if (id != null && !"".equals(id)) {
			arrParametros.add(id);
		} else {
			arrParametros.add("");
		}

		if (baja == null || "".equals(baja)) {
			strEstado = Q70GestorMensajesi18n.getSingleton().getMessage(
					"v50bcomun", "comun.alta", idioma);
		} else {
			strEstado = Q70GestorMensajesi18n.getSingleton().getMessage(
					"v50bcomun", "comun.baja", idioma);
		}
		arrParametros.add(strEstado);

		if (nombre != null && !"".equals(nombre)) {
			arrParametros.add(nombre);
		} else {
			arrParametros.add("");
		}

		if (ape1 != null && !"".equals(ape1)) {
			arrParametros.add(ape1);
		} else {
			arrParametros.add("");
		}

		if (ape2 != null && !"".equals(ape2)) {
			arrParametros.add(ape2);
		} else {
			arrParametros.add("");
		}

		if (tieneMovil != null) {
			if ("".equals(tieneMovil)) {
				arrParametros.add("");
			} else if (tieneMovil.equals(V50bClsConstantes.CONSTANTE_SI)) {
				arrParametros.add(Q70GestorMensajesi18n.getSingleton()
						.getMessage("v50bcomun", "comun.si", idioma));
			} else {
				arrParametros.add(Q70GestorMensajesi18n.getSingleton()
						.getMessage("v50bcomun", "comun.no", idioma));
			}
		}
		if (tieneEmail != null) {
			if ("".equals(tieneEmail)) {
				arrParametros.add("");
			} else if (tieneEmail.equals(V50bClsConstantes.CONSTANTE_SI)) {
				arrParametros.add(Q70GestorMensajesi18n.getSingleton()
						.getMessage("v50bcomun", "comun.si", idioma));
			} else {
				arrParametros.add(Q70GestorMensajesi18n.getSingleton()
						.getMessage("v50bcomun", "comun.no", idioma));
			}
		}

		if (perfil != null && !"".equals(perfil)) {
			if (V50bClsConstantes.PERFIL_AMBOS_BD.equals(perfil)) {
				arrParametros.add(Q70GestorMensajesi18n.getSingleton()
						.getMessage("v50bcomun", "resolutores.ambos", idioma));
			} else if (V50bClsConstantes.PERFIL_TECNICO_IVAP_BD.equals(perfil)) {
				arrParametros
						.add(Q70GestorMensajesi18n.getSingleton().getMessage(
								"v50bcomun", "resolutores.tecnico", idioma));

			} else {
				arrParametros.add(Q70GestorMensajesi18n.getSingleton()
						.getMessage("v50bcomun", "resolutores.resolutor",
								idioma));
			}
		} else {
			arrParametros.add("");
		}

		if (recibeAvisoBandEntrada != null) {
			if ("".equals(recibeAvisoBandEntrada)) {
				arrParametros.add("");
			} else if (recibeAvisoBandEntrada
					.equals(V50bClsConstantes.CONSTANTE_SI)) {
				arrParametros.add(Q70GestorMensajesi18n.getSingleton()
						.getMessage("v50bcomun", "comun.si", idioma));
			} else {
				arrParametros.add(Q70GestorMensajesi18n.getSingleton()
						.getMessage("v50bcomun", "comun.no", idioma));
			}
		}

		// Generamos PDF
		V50bClsInformes.fncSacarListadoFOP(req, arg5, idioma, Q70ListenerUtils
				.getApplicationProperty("RUTA_PLANTILLA")
				+ strPlantilla, arrParametros, arrLiterales,
				arrDatosTablasBusquedas, "v50bcomun", null);

	}

	/**
	 * 
	 * @param contexto :
	 *            Q70ContextoEJIE
	 * @param arg1 :
	 *            ActionErrors
	 * @param mapping :
	 *            ActionMapping
	 * @param arg3 :
	 *            ActionForm
	 * @param request :
	 *            request
	 * @param arg5 :
	 *            response
	 * @return ActionForward
	 * @throws Exception
	 *             Se eleva la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors arg1, ActionMapping mapping, ActionForm arg3,
			HttpServletRequest request, HttpServletResponse arg5)
			throws Exception {

		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processForward() ");

		if (arg1.isEmpty()) {
			String hayBusqueda = (String) contexto.get("busqRealizada");

			if ("false".equals(hayBusqueda)) {
				contexto.set("v50bListaResolutores", null);
			}
			return mapping.findForward("ok");
		} else {
			return mapping.findForward("error");
		}
	}
}