package v50b.v50bOperacionesPaso.v50bTablas.v50bDificultad;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bDificultadBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsInformes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bActionPasoOP;


/**
 * 
 * @author alata
 *
 */
public class V50bImprimirBusquedaAction extends V50bActionPasoOP {
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param arg2 : ActionMapping
	 * @param arg3 : ActionForm
	 * @param req : request
	 * @param arg5 : response
	 * @throws Exception Se lanza la excepcin
	*/
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest req,
			HttpServletResponse arg5) throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processOP() ");
		
		//Idioma
		String idioma = Q70ListenerUtils.getLanguage(req);
		
		//Plantilla
		String strPlantilla = (String) contexto.get("plantillaBusqueda");
	
		//Parametros
		ArrayList arrParametros = new ArrayList();
		
		//Imagen
		StringBuffer imagenSB = new StringBuffer(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB.append(V50bClsConstantes.CONSTANTE_LOGO_IVAP);
		String imagenString = imagenSB.toString();
		String imagen = this.getClass().getResource(imagenString).toString();
		
		arrParametros.add(imagen);
		
		//Fecha
		String fecha=V50bClsFecha.fncPresentarFechaSistemaCorta((String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
	    arrParametros.add(fecha);
		
		//Idioma
		arrParametros.add(idioma);
			
		//Literales
		ArrayList arrLiterales = new ArrayList();
		arrLiterales.add("comun.dificultad");
		arrLiterales.add("comun.codigo");
		arrLiterales.add("comun.baja");
		arrLiterales.add("comun.descripcion");
		arrLiterales.add("comun.situacion");
		arrLiterales.add("comun.ambito");
		arrLiterales.add("comun.dias");

		//ArrayList Busqueda
		ArrayList arrDatosTablasBusquedas = (ArrayList)contexto.get("v50bListaDificultades");
		
		V50bDificultadBean datosDificultad = (V50bDificultadBean)contexto.get("v50bDificultadBeanOrig");
				
		String codigo=datosDificultad.getCoddif();
		String baja=datosDificultad.getEstado();
		String desc=datosDificultad.getDescc();
		String dias = datosDificultad.getDias();
		String descAmbito = datosDificultad.getDescAmbitoc();
		String strEstado="";
		
		if ("eu".equals(idioma)){
			desc=datosDificultad.getDesce();
		}
		
		if(codigo!=null && !"".equals(codigo)){
			arrParametros.add(codigo);
		}
		else{
			arrParametros.add("");
		}
		
		if (desc!=null && !"".equals(desc)){
			arrParametros.add(desc);
		}
		else{
			arrParametros.add("");
		}
		
		if(dias!=null && !"".equals(dias)){
			arrParametros.add(dias);
		}
		else{
			arrParametros.add("");
		}
		
		if (descAmbito!=null && !"".equals(descAmbito)){
			arrParametros.add(descAmbito);
		}
		else{
			arrParametros.add("");
		}
		
		if (baja==null || "".equals(baja)){
			strEstado=Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.alta",idioma);
		}else{
			strEstado=Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.baja",idioma);
		}
		arrParametros.add(strEstado);
					
		//Generamos PDF
		V50bClsInformes.fncSacarListadoFOP(req,arg5,idioma,Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA")+strPlantilla,arrParametros,arrLiterales,arrDatosTablasBusquedas,"v50bcomun", null);
		
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param mapping : ActionMapping
	 * @param arg3 : ActionForm
	 * @param request : request
	 * @param arg5 : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors arg1, ActionMapping mapping, ActionForm arg3,
			HttpServletRequest request, HttpServletResponse arg5)
			throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processForward() ");
		
		if (arg1.isEmpty()){
			String hayBusqueda=(String)contexto.get("busqRealizada");
			
			if("false".equals(hayBusqueda)){
				contexto.set("v50bListaDificultades",null);
			}
			return mapping.findForward("ok");
		}
		else{
			return mapping.findForward("error");
		}
	}

}
