package v50b.v50bOperacionesPaso.v50bTablas.v50bAmbito;

import java.util.ArrayList;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bBeans.V50bAmbitoBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsInformes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bActionPasoOP;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author alata
 *
 */
public class V50bImprimirBusquedaAction extends V50bActionPasoOP {

	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param arg1 : ActionErrors
	 * @param arg2 : ActionMapping
	 * @param arg3 : ActionForm
	 * @param req : request
	 * @param arg5 : response
	 * @throws Exception Se lanza la excepcin
	*/
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest req,
			HttpServletResponse arg5) throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processOP() ");
		
		//Idioma
		String idioma = Q70ListenerUtils.getLanguage(req);
		
		//Plantilla
		String strPlantilla = (String) contexto.get("plantillaBusqueda");
	
		//Parametros
		ArrayList listParametros = new ArrayList();
		
		//Imagen
		StringBuffer imagenSB = new StringBuffer(Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA"));
		imagenSB.append(V50bClsConstantes.CONSTANTE_LOGO_IVAP);
		String imagenString = imagenSB.toString();
		String imagen = this.getClass().getResource(imagenString).toString();
		
		listParametros.add(imagen);
		
		//Fecha
		String fecha=V50bClsFecha.fncPresentarFechaSistemaCorta((String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		listParametros.add(fecha);
		
		//Idioma
		listParametros.add(idioma);
				
		//Literales
		ArrayList listLiterales = new ArrayList();
		listLiterales.add("comun.ambitoConsulta");
		listLiterales.add("comun.codigo");
		listLiterales.add("comun.baja");
		listLiterales.add("comun.descripcion");
		listLiterales.add("comun.situacion");

		//ArrayList Busqueda
		ArrayList arrDatosTablasBusquedas = (ArrayList)contexto.get("v50bListaAmbitos");
		
		V50bAmbitoBean datosAmbito = (V50bAmbitoBean)contexto.get("v50bAmbitoBeanOrig");
				
		String codigo=datosAmbito.getCambit();
		String baja=datosAmbito.getEstado();
		String desc=datosAmbito.getDesamc();
		String strEstado="";
		
		if ("eu".equals(idioma)){
			desc=datosAmbito.getDesame();
		}
							
		if(codigo!=null && !"".equals(codigo)){
			listParametros.add(codigo);
		}
		else{
			listParametros.add("");
		}
		if (baja==null || "".equals(baja)){
			strEstado=Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.alta",idioma);
		}else{
			strEstado=Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.baja",idioma);
		}
		listParametros.add(strEstado);
		if (desc!=null && !"".equals(desc)){
			listParametros.add(desc);
		}
		else{
			listParametros.add("");
		}
					
		//Generamos PDF
		V50bClsInformes.fncSacarListadoFOP(req,arg5,idioma,Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLA")+strPlantilla,listParametros,listLiterales,arrDatosTablasBusquedas,"v50bcomun", null);
		
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param actionerrors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param arg3 : ActionForm
	 * @param request : request
	 * @param arg5 : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors actionerrors, ActionMapping mapping, ActionForm arg3,
			HttpServletRequest request, HttpServletResponse arg5)
			throws Exception {
		
		V50bClsTrazas.depura("V50bImprimirBusquedaAction.processForward() ");
		
		if (actionerrors.isEmpty()){
			String flagBusqueda=(String)contexto.get("busqRealizada");
			
			if("false".equals(flagBusqueda)){
				contexto.set("v50bListaAmbitos",null);
			}
			return mapping.findForward("ok");
		}
		else{
			return mapping.findForward("error");
		}
	}
}