package v50b.v50bOperacionesPaso.v50bEncuestas.v50bResultado;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.validator.GenericValidator;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFunciones;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bActionPasoOP;

/**
 * <p>
 * Ttulo: V50bGraficoEncuestasResultadosOP
 * </p>
 * <p>
 * Copyright: Copyright (c) 2009
 * </p>
 * <p>
 * Empresa: Eurohelp Consulting
 * </p>
 * 
 * @author brey
 * @version 1.0
 */
public class V50bGraficoEncuestasResultadosOP extends V50bActionPasoOP{
	
	/**
	 * @author brey
	 * @version 1.0
	 * @throws Exception
	 *             excepcin
	 * @param contexto
	 *            Q70ContextoEJIE
	 * @param arg1
	 *            ActionErrors
	 * @param arg2
	 *            ActionMapping
	 * @param arg3
	 *            ActionForm
	 * @param req
	 *            HttpServletRequest
	 * @param arg5
	 *            HttpServletResponse
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest req,
			HttpServletResponse arg5) throws Exception {

	}

	/**
	 * @author brey
	 * @version 1.0
	 * @throws Exception
	 *             excepcin
	 * @param contexto
	 *            Q70ContextoEJIE
	 * @param arg1
	 *            ActionErrors
	 * @param mapping
	 *            ActionMapping
	 * @param arg3
	 *            ActionForm
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return ActionForward
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors arg1, ActionMapping mapping, ActionForm arg3,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		
		// todos los datos del Excel
		final List listaExcel = (List) contexto.get("v50bListaExcelR");
		
		
		// Los campos de porcentaje de radio buttons
		final List listaCompleta = (List) listaExcel.get(0);
		
		final List listaGrafico = new ArrayList();
		final List listaTitulo = new ArrayList();
		String idioma = Q70ListenerUtils.getLanguage(request);
		int intTam = listaCompleta.size() - 1;
		Map mapDatos = new LinkedHashMap();
		for (int i = 0; i <= intTam; i++) {
			V50bEncuestaBean encuestaBean = (V50bEncuestaBean) listaCompleta
					.get(i);
			String porcentaje;
			if (i > 0) {
				V50bEncuestaBean beanAntiguo = (V50bEncuestaBean) listaCompleta
						.get(i - 1);
				int antiguo = beanAntiguo.getStrNumPreguntaInt().intValue();
				int actual = encuestaBean.getStrNumPreguntaInt().intValue();
				if (antiguo != actual) {
					listaGrafico.add(mapDatos);
					if (V50bClsConstantes.CONSTANTE_EUSKARA.equals(idioma)) {
						listaTitulo.add(encuestaBean.getStrPreguntaEus());
					}
					if (V50bClsConstantes.CONSTANTE_CASTELLANO
							.equals(idioma)) {
						listaTitulo.add(encuestaBean.getStrPreguntaCas());
					}

					mapDatos = this.crearMap();
				}
			} else {
				if (V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)) {
					listaTitulo.add(encuestaBean.getStrPreguntaCas());
				}
				if (V50bClsConstantes.CONSTANTE_EUSKARA.equals(idioma)) {
					listaTitulo.add(encuestaBean.getStrPreguntaEus());
				}
			}

			if (!GenericValidator
					.isBlankOrNull(encuestaBean.getStrPorcentaje())) {
				porcentaje = String.valueOf(V50bClsFunciones.cambioPrecision(
						Double.valueOf(encuestaBean.getStrPorcentaje())
								.doubleValue(), 2));
			} else {
				porcentaje = "";
			}
			if (V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)) {
				mapDatos.put(encuestaBean.getStrRespuestaCas(), porcentaje);// respuesta,porcentaje
			}
			if (V50bClsConstantes.CONSTANTE_EUSKARA.equals(idioma)) {
				mapDatos.put(encuestaBean.getStrRespuestaEus(), porcentaje);// respuesta,porcentaje
			}
		}
		listaGrafico.add(mapDatos);

		contexto.set("v50bListaGrafico", listaGrafico);
		contexto.set("v50bListaTitulos", listaTitulo);

		String ancho = (String) contexto.get("ancho");

		int anchoInt = Integer.parseInt(ancho);
		anchoInt = (anchoInt / 2) - V50bClsConstantes.CUARENTAYCINCO;
		contexto.set("ancho", Integer.toString(anchoInt));
		V50bClsTrazas.depura("ancho", Integer.toString(anchoInt));

		return mapping.findForward("ok");

	}

	/**
	 * @author Virginia Caldern
	 * @version 1.0
	 * @return LinkedHashMap
	 */
	public Map crearMap() {
		return new LinkedHashMap();
	}

}
