package v50b.v50bOperacionesPaso.v50bEncuestas.v50bResultado;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsExcel;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsFunciones;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bCeldaExcelBean;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bExcelBean;
import v50b.v50bComun.V50bActionPasoOP;

/**
 * <p>
 * Ttulo: V50bExcelEncuestasResultadosOP
 * </p>
 * <p>
 * Copyright: Copyright (c) 2009
 * </p>
 * <p>
 * Empresa: Eurohelp Consulting
 * </p>
 * 
 * @author brey
 * @version 1.0
 */
public class V50bExcelEncuestasResultadosOP extends V50bActionPasoOP{
	
	/**
	 * @author brey
	 * @version 1.0
	 * @throws Exception
	 *             excepcin
	 * @param contexto
	 *            Q70ContextoEJIE
	 * @param arg1
	 *            ActionErrors
	 * @param arg2
	 *            ActionMapping
	 * @param arg3
	 *            ActionForm
	 * @param request
	 *            HttpServletRequest
	 * @param arg5
	 *            HttpServletResponse
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest request,
			HttpServletResponse arg5) throws Exception {

		// GENERAR EXCEL
		final V50bExcelBean libroExcelBean = new V50bExcelBean();
		// Ponemos nombre hoja
		libroExcelBean
				.setNombreLibro(Q70GestorMensajesi18n
						.getSingleton()
						.getMessage(
								"v50bcomun",
								"titulo.encuestas",
								(String) contexto
										.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA)));
		final List celdas = new ArrayList();
		List listaExcel = (List) contexto.get("v50bListaExcelR");

		// Generamos la hoja excel para las preguntas de check
		int tamanio= ((List) listaExcel.get(0)).size();
		//int tamanio2= ((List) listaExcel.get(1)).size();
		String idioma = Q70ListenerUtils.getLanguage(request);
		String fec="19/12/1981";
		
		V50bClsTrazas.depura(V50bClsFecha.fncFormateaFecha(fec, idioma).toString());
		V50bEncuestaBean bean = (V50bEncuestaBean) contexto
				.get("v50bEncuestaSelecI");
		V50bClsTrazas.depura(idioma);
		final V50bCeldaExcelBean celda1 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda2 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda3 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda4 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda9 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda10 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda11 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda12 = new V50bCeldaExcelBean();
		
		// TTULO
		celda1.setPosicionX(0);
		celda1.setPosicionY(0);
		celda1.setNumeroHoja(0);
		celda1.setDato((Q70GestorMensajesi18n.getSingleton().getMessage(
				"v50bcomun",
				"encuestas.titulo",
				(String) contexto
						.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))).toUpperCase());
		celda1.setColorFuente(V50bClsExcel.BLANCO);
		celda1.setColorFondo(V50bClsExcel.AZULGRISACEO);
		celda1.setFuenteNegrita(true);
		celdas.add(celda1);
		celda2.setPosicionX(1);
		celda2.setPosicionY(0);
		celda2.setNumeroHoja(0);
		celda2.setColorFuente(V50bClsExcel.NEGRO);
		celda2.setColorFondo(V50bClsExcel.BLANCO);

		if (V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)) {
			celda2.setDato(bean.getStrTituloCas());
		} else {
			celda2.setDato(bean.getStrTituloEus());
		}
		celda2.setFuenteNegrita(true);
		celdas.add(celda2);

		// FECHA
		celda3.setPosicionX(0);
		celda3.setPosicionY(1);
		celda3.setNumeroHoja(0);
		celda3.setDato((Q70GestorMensajesi18n.getSingleton().getMessage(
				"v50bcomun",
				"comun.fechas",
				(String) contexto
						.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))).toUpperCase());
		celda3.setColorFuente(V50bClsExcel.BLANCO);
		celda3.setColorFondo(V50bClsExcel.AZULGRISACEO);
		celda3.setFuenteNegrita(true);
		celdas.add(celda3);

		celda4.setPosicionX(1);
		celda4.setPosicionY(1);
		celda4.setNumeroHoja(0);
		celda4.setColorFuente(V50bClsExcel.NEGRO);
		celda4.setColorFondo(V50bClsExcel.BLANCO);
		StringBuffer fecha = new StringBuffer(bean.getStrFechaInicio());
		fecha.append(" - ");
		fecha.append(bean.getStrFechaFinal());
		celda4.setDato(fecha.toString());
		celda4.setFuenteNegrita(true);
		celdas.add(celda4);

		// GENERAR EL LA BARRA DE TTULOS
		this.fncGenerarCabeceraColumna(celdas,contexto, idioma);

		//generar columnas de datos de la encuesta
		if (tamanio!=0){
		this.fncGenerarDatos(celdas, listaExcel,idioma);}
		
		
		
		// TTULO LIBRE
		celda9.setPosicionX(0);
		celda9.setPosicionY(0);
		celda9.setNumeroHoja(1);
		celda9.setDato((Q70GestorMensajesi18n.getSingleton().getMessage(
				"v50bcomun",
				"encuestas.titulo",
				(String) contexto
						.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))).toUpperCase());
		celda9.setColorFuente(V50bClsExcel.BLANCO);
		celda9.setColorFondo(V50bClsExcel.AZULGRISACEO);
		celda9.setFuenteNegrita(true);
		celdas.add(celda9);
		celda10.setPosicionX(1);
		celda10.setPosicionY(0);
		celda10.setNumeroHoja(1);
		celda10.setColorFuente(V50bClsExcel.NEGRO);
		celda10.setColorFondo(V50bClsExcel.BLANCO);

		if (V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)) {
			celda10.setDato(bean.getStrTituloCas().toUpperCase());
		} else {
			celda10.setDato(bean.getStrTituloEus().toUpperCase());
		}
		celda10.setFuenteNegrita(true);
		celdas.add(celda10);

		// FECHA LIBRE
		celda11.setPosicionX(0);
		celda11.setPosicionY(1);
		celda11.setNumeroHoja(1);
		celda11.setDato((Q70GestorMensajesi18n.getSingleton().getMessage(
				"v50bcomun",
				"comun.fechas",
				(String) contexto
						.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))).toUpperCase());
		celda11.setColorFuente(V50bClsExcel.BLANCO);
		celda11.setColorFondo(V50bClsExcel.AZULGRISACEO);
		celda11.setFuenteNegrita(true);
		celdas.add(celda11);

		celda12.setPosicionX(1);
		celda12.setPosicionY(1);
		celda12.setNumeroHoja(1);
		celda12.setColorFuente(V50bClsExcel.NEGRO);
		celda12.setColorFondo(V50bClsExcel.BLANCO);
		StringBuffer fecha2 = new StringBuffer(bean.getStrFechaInicio());
		fecha2.append(" - ");
		fecha2.append(bean.getStrFechaFinal());
		celda12.setDato(fecha2.toString());
		celda12.setFuenteNegrita(true);
		celdas.add(celda12);
		
		
		
		// GENERAR EL LA BARRA DE TTULOS
		this.fncGenerarCabeceraColumnaLibre(celdas,contexto, idioma);
		
		
		//generar columnas de datos de la encuesta de preguntas libres
		//if (tamanio2!=0){
		this.fncGenerarDatosLibre(celdas, listaExcel,idioma);
		//}
		
		libroExcelBean.setCeldas(celdas);
		libroExcelBean.setNombresHojas(new String[] {Q70GestorMensajesi18n
				.getSingleton()
				.getMessage(
						"v50bcomun",
						"encuestas.respuestas",
						(String) contexto
								.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA)),Q70GestorMensajesi18n
								.getSingleton()
								.getMessage(
										"v50bcomun",
										"encuestas.respuestasLibres",
										(String) contexto
												.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA)) });
		
		V50bClsExcel.fncGenerarExcelEncuestas(libroExcelBean, arg5);
		

	}
	

	/**
	 * @author brey
	 * @version 1.0
	 * @throws Exception
	 *             excepcin
	 * @param contexto
	 *            Q70ContextoEJIE
	 * @param arg1
	 *            ActionErrors
	 * @param mapping
	 *            ActionMapping
	 * @param arg3
	 *            ActionForm
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return ActionForward
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors arg1, ActionMapping mapping, ActionForm arg3,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		if (arg1.isEmpty()) {
			return mapping.findForward("ok");
		} else {
			return mapping.findForward("error");
		}
	}
	
	
	/**
	 * @author brey
	 * @version 1.0
	 * @param celdas List 
	 * @param contexto Q70ContextoEJIE
	 * @param idioma String
	 */
	
	public void fncGenerarCabeceraColumna(List celdas, Q70ContextoEJIE contexto, String idioma){
		// generar ttulos columnas

		// GENERAR EL LA BARRA DE TTULOS

		final V50bCeldaExcelBean celda5 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda6 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda7 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda8 = new V50bCeldaExcelBean();
		celda5.setPosicionX(1);
		celda5.setPosicionY(V50bClsConstantes.SEIS);
		celda5.setNumeroHoja(0);
		try {
			celda5.setDato((Q70GestorMensajesi18n.getSingleton().getMessage(
					"v50bcomun",
					"encuestas.pregunta",
					(String) contexto
							.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))).toUpperCase());
		} catch (Q70GestorMensajesException e) {
			e.printStackTrace();
		}
		celda5.setColorFuente(V50bClsExcel.BLANCO);
		celda5.setColorFondo(V50bClsExcel.AZULGRISACEO);
		celda5.setFuenteNegrita(true);
		celdas.add(celda5);

		celda6.setPosicionX(2);
		celda6.setPosicionY(V50bClsConstantes.SEIS);
		celda6.setNumeroHoja(0);
		try {
			celda6.setDato((Q70GestorMensajesi18n.getSingleton().getMessage(
					"v50bcomun",
					"comun.respuesta",
					(String) contexto
							.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))).toUpperCase());
		} catch (Q70GestorMensajesException e) {
			e.printStackTrace();
		}
		celda6.setColorFuente(V50bClsExcel.BLANCO);
		celda6.setColorFondo(V50bClsExcel.AZULGRISACEO);
		celda6.setFuenteNegrita(true);
		celdas.add(celda6);

		celda7.setPosicionX(V50bClsConstantes.TRES);
		celda7.setPosicionY(V50bClsConstantes.SEIS);
		celda7.setNumeroHoja(0);
		try {
			celda7.setDato((Q70GestorMensajesi18n.getSingleton().getMessage(
					"v50bcomun",
					"encuestas.numRespuestas",
					(String) contexto
							.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))).toUpperCase());
		} catch (Q70GestorMensajesException e) {
			e.printStackTrace();
		}
		celda7.setColorFuente(V50bClsExcel.BLANCO);
		celda7.setColorFondo(V50bClsExcel.AZULGRISACEO);
		celda7.setFuenteNegrita(true);
		celdas.add(celda7);

		celda8.setPosicionX(V50bClsConstantes.CUATRO);
		celda8.setPosicionY(V50bClsConstantes.SEIS);
		celda8.setNumeroHoja(0);
		try {
			celda8.setDato((Q70GestorMensajesi18n.getSingleton().getMessage(
					"v50bcomun",
					"comun.porcentaje",
					(String) contexto
							.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))).toUpperCase());
		} catch (Q70GestorMensajesException e) {
			e.printStackTrace();
		}
		celda8.setColorFuente(V50bClsExcel.BLANCO);
		celda8.setColorFondo(V50bClsExcel.AZULGRISACEO);
		celda8.setFuenteNegrita(true);
		celdas.add(celda8);
		
	}
	
	
	/**
	 * @author brey
	 * @version 1.0
	 * @param celdas List 
	 * @param contexto Q70ContextoEJIE
	 * @param idioma String
	 */
	
	public void fncGenerarCabeceraColumnaLibre(List celdas, Q70ContextoEJIE contexto, String idioma){
		// generar ttulos columnas

		// GENERAR EL LA BARRA DE TTULOS
		final V50bCeldaExcelBean celda13 = new V50bCeldaExcelBean();
		final V50bCeldaExcelBean celda14 = new V50bCeldaExcelBean();

		celda13.setPosicionX(1);
		celda13.setPosicionY(V50bClsConstantes.SEIS);
		celda13.setNumeroHoja(1);
		try {
			celda13.setDato((Q70GestorMensajesi18n.getSingleton().getMessage(
					"v50bcomun",
					"encuestas.pregunta",
					(String) contexto
							.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))).toUpperCase());
		} catch (Q70GestorMensajesException e) {
			e.printStackTrace();
		}
		celda13.setColorFuente(V50bClsExcel.BLANCO);
		celda13.setColorFondo(V50bClsExcel.AZULGRISACEO);
		celda13.setFuenteNegrita(true);
		celdas.add(celda13);

		celda14.setPosicionX(2);
		celda14.setPosicionY(V50bClsConstantes.SEIS);
		celda14.setNumeroHoja(1);
		try {
			celda14.setDato((Q70GestorMensajesi18n.getSingleton().getMessage(
					"v50bcomun",
					"comun.respuesta",
					(String) contexto
							.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))).toUpperCase());
		} catch (Q70GestorMensajesException e) {
			e.printStackTrace();
		}
		celda14.setColorFuente(V50bClsExcel.BLANCO);
		celda14.setColorFondo(V50bClsExcel.AZULGRISACEO);
		celda14.setFuenteNegrita(true);
		celdas.add(celda14);
	}
	
	
	
	/**
	 * @author brey
	 * @version 1.0
	 * @param celdas List 
	 * @param listaExcel List
	 * @param idioma String
	 */
	
	public void fncGenerarDatos(List celdas, List listaExcel, String idioma){
		// generar datos de las preguntas check

		List listaRespuestas = (List) listaExcel.get(0);
		// columna preguntas
		int posY = V50bClsConstantes.SIETE;
		String preguntaAnterior = "0";

		for (int i = 0; listaRespuestas.size() > i; i++) {
			V50bEncuestaBean encuesta = (V50bEncuestaBean) listaRespuestas
					.get(i);
			V50bCeldaExcelBean celda = this.generarCelda();
			if (preguntaAnterior.equals(encuesta.getStrNumPregunta())) {
				celda.setPosicionX(1);
				celda.setPosicionY(posY);
				celda.setNumeroHoja(0);
				celda.setDato(" ");
				celda.setColorFuente(V50bClsExcel.NEGRO);
				celda.setColorFondo(V50bClsExcel.BLANCO);
				celdas.add(celda);
			} else {

				celda.setPosicionX(1);
				celda.setPosicionY(posY);
				celda.setNumeroHoja(0);
				if (V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)) {
					celda.setDato(encuesta.getStrPreguntaCas());
				} else {
					celda.setDato(encuesta.getStrPreguntaEus());
				}

				celda.setColorFuente(V50bClsExcel.NEGRO);
				celda.setColorFondo(V50bClsExcel.BLANCO);
				celdas.add(celda);
			}
			preguntaAnterior = encuesta.getStrNumPregunta();
			posY++;
		}

		// columna respuestas
		posY = V50bClsConstantes.SIETE;
		for (int i = 0; listaRespuestas.size() > i; i++) {
			V50bEncuestaBean encuesta = (V50bEncuestaBean) listaRespuestas
					.get(i);
			V50bCeldaExcelBean celda = this.generarCelda();
			celda.setPosicionX(2);
			celda.setPosicionY(posY);
			celda.setNumeroHoja(0);
			if (V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)) {
				celda.setDato(encuesta.getStrRespuestaCas());
			} else {
				celda.setDato(encuesta.getStrRespuestaEus());
			}
			celda.setColorFuente(V50bClsExcel.NEGRO);
			celda.setColorFondo(V50bClsExcel.BLANCO);
			celdas.add(celda);
			posY++;
		}

		// columna numRespuestas
		posY = V50bClsConstantes.SIETE;
		for (int i = 0; listaRespuestas.size() > i; i++) {
			V50bEncuestaBean encuesta = (V50bEncuestaBean) listaRespuestas
					.get(i);
			V50bCeldaExcelBean celda = this.generarCelda();
			celda.setPosicionX(V50bClsConstantes.TRES);
			celda.setPosicionY(posY);
			celda.setNumeroHoja(0);
			celda.setDato(encuesta.getStrRespuestas());
			celda.setColorFuente(V50bClsExcel.NEGRO);
			celda.setColorFondo(V50bClsExcel.BLANCO);
			celdas.add(celda);
			posY++;
		}

		// columna porcentaje
		posY = V50bClsConstantes.SIETE;
		for (int i = 0; listaRespuestas.size() > i; i++) {
			V50bEncuestaBean encuesta = (V50bEncuestaBean) listaRespuestas
					.get(i);
			V50bCeldaExcelBean celda = this.generarCelda();
			celda.setPosicionX(V50bClsConstantes.CUATRO);
			celda.setPosicionY(posY);
			celda.setNumeroHoja(0);
			try {
				celda.setDato(V50bClsFunciones.fncFormateaCifraValida(encuesta.getStrPorcentaje()));
			} catch (Q70GestorMensajesException e) {
				e.printStackTrace();
			}
			celda.setColorFuente(V50bClsExcel.NEGRO);
			celda.setColorFondo(V50bClsExcel.BLANCO);
			celdas.add(celda);
			posY++;
		}
		
	}
	
	/**
	 * @author brey
	 * @version 1.0
	 * @param celdas List 
	 * @param listaExcel List
	 * @param idioma String
	 */
	
	public void fncGenerarDatosLibre(List celdas, List listaExcel, String idioma){
		// generar datos de las preguntas libres

		List listaRespuestas = (List) listaExcel.get(1);
		// columna preguntas
		int posY = V50bClsConstantes.SIETE;
		String preguntaAnterior = "0";

		for (int i = 0; listaRespuestas.size() > i; i++) {
			V50bEncuestaBean encuesta = (V50bEncuestaBean) listaRespuestas
					.get(i);
			V50bCeldaExcelBean celda = this.generarCelda();
			if (preguntaAnterior.equals(encuesta.getStrNumPregunta())) {
				celda.setPosicionX(1);
				celda.setPosicionY(posY);
				celda.setNumeroHoja(1);
				celda.setDato(" ");
				celda.setColorFuente(V50bClsExcel.NEGRO);
				celda.setColorFondo(V50bClsExcel.BLANCO);
				celdas.add(celda);
			} else if(encuesta.getStrRespuestaCas()!=null && !encuesta.getStrRespuestaCas().equals("")){

				celda.setPosicionX(1);
				celda.setPosicionY(posY);
				celda.setNumeroHoja(1);
				if (V50bClsConstantes.CONSTANTE_CASTELLANO.equals(idioma)) {
					celda.setDato(encuesta.getStrPreguntaCas());
				} else {
					celda.setDato(encuesta.getStrPreguntaEus());
				}

				celda.setColorFuente(V50bClsExcel.NEGRO);
				celda.setColorFondo(V50bClsExcel.BLANCO);
				celdas.add(celda);
				
				preguntaAnterior = encuesta.getStrNumPregunta();
			}
			if(encuesta.getStrRespuestaCas()!=null && !encuesta.getStrRespuestaCas().equals("")){
				posY++;
			}
		}

		// columna respuestas
		posY = V50bClsConstantes.SIETE;
		for (int i = 0; listaRespuestas.size() > i; i++) {
			V50bEncuestaBean encuesta = (V50bEncuestaBean) listaRespuestas
					.get(i);
			V50bCeldaExcelBean celda = this.generarCelda();
			celda.setPosicionX(2);
			celda.setPosicionY(posY);
			celda.setNumeroHoja(1);
			if(encuesta.getStrRespuestaCas()!=null && !encuesta.getStrRespuestaCas().equals("")){				
				//quitamos el posible salto de linea
				celda.setDato((encuesta.getStrRespuestaCas()).replaceAll("\r\n"," "));
				//no pregunto por el idiomma porque la repsuesa la he guardado en cas siempre, ya que solo hay una
				celda.setColorFuente(V50bClsExcel.NEGRO);
				celda.setColorFondo(V50bClsExcel.BLANCO);
				celdas.add(celda);
				posY++;
			}
		}
	}

	/**
	 * @author brey
	 * @version 1.0
	 * @return ArrayList
	 */
	public List crearArray() {
		return new ArrayList();
	}

	/**
	 * @author brey
	 * @version 1.0
	 * @return V50bCeldaExcelBean
	 */
	public V50bCeldaExcelBean generarCelda() {
		return new V50bCeldaExcelBean();
	}

}
