package v50b.v50bOperacionesInternas.v50bTablas;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;

import v50b.v50bBeans.V50bCalendarioBean;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author iurkidi
 *
 */
public class V50bObtenerServInactivoAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :configuracion con los datos de busqueda
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception {
	
		V50bClsTrazas.depura("V50bObtenerServInactivoAction.preProcessMappingEntrada() ");
		
		super.preProcessMappingEntrada(contexto, arg1, arg2);
		
	}

	/**
	 * @param contexto :configuracion con los datos de busqueda
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {
		
		V50bClsTrazas.depura("V50bObtenerServInactivoAction.postProcessMappingSalida() ");
		
		List listResultado=(List)contexto.get("v50bListaCargaCalendario");
		
		if(listResultado!=null && listResultado.size()>0){//Tenemos una lista de dos posiciones
			//en la primera posicion tenemos el bean con las fechas del servicio inactivo
			List listPerInactivo=(List)listResultado.get(0);
			if(listPerInactivo!=null && listPerInactivo.size()>0){
				V50bCalendarioBean beanR=(V50bCalendarioBean)listPerInactivo.get(0);
				beanR.setHayPeriodoInactivo(true);
				contexto.set("v50bCalendarioBean", beanR);
				contexto.set("v50bCalendarioBeanBackup", BeanUtils.cloneBean(contexto.get("v50bCalendarioBean")));
			}
			//en la segunda posicion tenemos una lista con las fechas para pinchar el calendario
			List listFestivos=(List)listResultado.get(1);
			V50bClsTrazas.depura("V50bObtenerServInactivoAction. listFestivos.SIZE() "+listFestivos.size());
			contexto.set("v50bListaFestivos",listFestivos);
			contexto.set("v50bListaFestivosMostrar", ((ArrayList)listFestivos).clone());
		}
		
		//Ao y mes actuales
		contexto.set("annoActual",String.valueOf(V50bClsFecha.fncObtenerAnyoSistema()));
		//Calendar calendario = GregorianCalendar.getInstance();
		//contexto.set("mesActual",String.valueOf(V50bClsFecha.fncObtenerMesSistema()));
		GregorianCalendar gregoriancalendar = new GregorianCalendar();
		contexto.set("mesActual",String.valueOf(gregoriancalendar.get(2) + 1));
		
		//Inicializamos las listas de modificaciones
		contexto.set("v50bListaAdiciones",new ArrayList());
		contexto.set("v50bListaSupresiones",new ArrayList());
		
		super.postProcessMappingSalida(contexto, arg1);
	}

}
