package v50b.v50bOperacionesInternas.v50bTablas;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bSubcategoriasBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


/**
 * 
 * @author acompes
 *
 */
public class V50bModificarSubcategoriasAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :subcategoras con los datos de modificacin
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception 
	{		
		V50bClsTrazas.depura("V50bModificarSubcategoriasAction.preProcessMappingEntrada() ");
			
		V50bSubcategoriasBean detalle = (V50bSubcategoriasBean)contexto.get("v50bDetNuevoSubcategoriasBean");
		V50bSubcategoriasBean detalleOrig = (V50bSubcategoriasBean)contexto.get("v50bDetNuevoSubcategoriasBeanOrig");
		String[] lista = (String[])contexto.get("comboCheck");
		detalle.setAmbitos(lista);
		detalle.setHabilitar(detalleOrig.getHabilitar());
		
		V50bSubcategoriasBean subcategoria = new V50bSubcategoriasBean();
		
		List listaAmbitos = (ArrayList)contexto.get("v50bListaAmbitosSubcategoria");
		String[] combo = new String[listaAmbitos.size()];
		for (int i=0;i<listaAmbitos.size();i++){
			subcategoria = (V50bSubcategoriasBean)listaAmbitos.get(i);
			combo[i] = subcategoria.getCodAmbito();
		}
		
		contexto.set("v50bDetNuevoSubcategoriasBean",detalle);
		
		if(detalle.getCodSub()==null){
			detalle.setCodSub(detalleOrig.getCodSub());
		}
		
		detalle.setCodAmbito(detalleOrig.getCodAmbito());
		
		if(detalle.getEstado() != null){
			detalle.setFormHabilitado(V50bClsConstantes.CONSTANTE_NO);
		}
		
		contexto.set("operacion",V50bClsConstantes.MODO_MODIFICAR);
				
		super.preProcessMappingEntrada(contexto, arg1, arg2);
		
	}
	
	/**
	 * @param contexto :Subcategorias con los datos de modificacin
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {
		
		V50bClsTrazas.depura("V50bModificarSubcategoriasAction.postProcessMappingSalida() ");
		
		V50bSubcategoriasBean subcategoria = (V50bSubcategoriasBean)contexto.get("v50bDetNuevoSubcategoriasBean");
		
		if (contexto.get("v50bintModif") != null) {
			if (((Integer) contexto.get("v50bintModif")).intValue() >= 1) {
				subcategoria.setHabilitar(subcategoria.getEstado());
				contexto.set("v50bDetNuevoSubcategoriasBeanOrig", subcategoria);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.actualizado");
			} else if(((Integer)contexto.get("v50bintModif")).intValue()==V50bClsConstantes.TRES_NEGATIVO){
				subcategoria.setEstado(subcategoria.getHabilitar());
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.errorBajaSubcategoria");
			} else if (((Integer) contexto.get("v50bintModif")).intValue() == V50bClsConstantes.DOS_NEGATIVO) {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.errorSubcategEnConsulta");
			} else if (((Integer) contexto.get("v50bintModif")).intValue() == 0) {
				subcategoria.setEstado(subcategoria.getHabilitar());
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.errorSubcategAmbitoBaja");
			} else {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.error");
			}
		}	
		
		contexto.set("v50bDetNuevoSubcategoriasBean",subcategoria);

		super.postProcessMappingSalida(contexto, arg1);
	}

}
