package v50b.v50bOperacionesInternas.v50bTablas;

import java.util.ArrayList;
import java.util.List;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author acompes
 * 
 */
public class V50bModificarResolutoresAction extends V50bOperacionInterna {

	/**
	 * @param contexto
	 *            :Resolutores con los datos de modificacin
	 * @param arg1 :
	 *            Q70OperacionInternaConfigBean
	 * @param arg2 :
	 *            errores
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto,
			Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2)
			throws Exception {
		V50bClsTrazas
				.depura("V50bModificarResolutoresAction.preProcessMappingEntrada() ");
		
		V50bUsuarioBean usuario = (V50bUsuarioBean)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_USUARIO_BEAN);
		contexto.set("usuario", usuario.getUsuarioXlnets());
		
		V50bResolutoresBean detalle = (V50bResolutoresBean) contexto
				.get("v50bDetNuevoResolutoresBean");
		V50bResolutoresBean detalleOrig = (V50bResolutoresBean) contexto
				.get("v50bDetNuevoResolutoresBeanOrig");
		String[] lista = (String[]) contexto.get("comboCheck");
		detalle.setAmbitos(lista);

		V50bResolutoresBean resolutor = new V50bResolutoresBean();

		List listaAmbitos = (ArrayList) contexto
				.get("v50bListaAmbitosResolutor");
		String[] combo = new String[listaAmbitos.size()];
		for (int i = 0; i < listaAmbitos.size(); i++) {
			resolutor = (V50bResolutoresBean) listaAmbitos.get(i);
			combo[i] = resolutor.getCodambito();
		}

		contexto.set("v50bDetNuevoResolutoresBean", detalle);

		if (detalle.getCodResol() == null) {
			detalle.setCodResol(detalleOrig.getCodResol());
		}

		detalle.setCodambito(detalleOrig.getCodambito());
		
		if(detalle.getEstado() != null){
			detalle.setFormHabilitado(V50bClsConstantes.CONSTANTE_NO);
		}
		
	//	contexto.set("v50bDetNuevoResolutoresBeanOrig", detalle);

		contexto.set("operacion", V50bClsConstantes.MODO_MODIFICAR);

		super.preProcessMappingEntrada(contexto, arg1, arg2);

	}

	/**
	 * @param contexto
	 *            :Resolutores con los datos de modificacin
	 * @param arg1 :
	 *            errores
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto,
			Q70OperacionInternaErrors arg1) throws Exception {

		V50bClsTrazas
				.depura("V50bModificarResolutoresAction.postProcessMappingSalida() ");
		
		V50bResolutoresBean resolutor = (V50bResolutoresBean)contexto.get("v50bDetNuevoResolutoresBean");
		
		if (contexto.get("v50bintModif") != null) {
			if (((Integer) contexto.get("v50bintModif")).intValue() == 1) {
				contexto.set("v50bDetNuevoResolutoresBeanOrig", resolutor);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.actualizado");
			} else if (((Integer) contexto.get("v50bintModif")).intValue() == -1) {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.idResolutorExiste");
			} else if (((Integer) contexto.get("v50bintModif")).intValue() == V50bClsConstantes.DOS_NEGATIVO) {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.errorResolutorEnConsulta");
			} else if(((Integer)contexto.get("v50bintModif")).intValue()==2){
				resolutor.setEstado(V50bClsConstantes.CONSTANTE_ALTA);
				contexto.set("v50bDetNuevoResolutoresBean", contexto.get("v50bDetNuevoResolutoresBeanOrig"));
				resolutor.setFormHabilitado(V50bClsConstantes.CONSTANTE_SI);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, 
						"infobd.errorConsultaResolutor");
			} else if(((Integer)contexto.get("v50bintModif")).intValue()==V50bClsConstantes.TRES_NEGATIVO){
				resolutor.setEstado(V50bClsConstantes.CONSTANTE_ALTA);
				resolutor.setFormHabilitado(V50bClsConstantes.CONSTANTE_SI);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, 
						"infobd.errorUsuarioResolutor");
			} else if(((Integer)contexto.get("v50bintModif")).intValue()==0){
				resolutor.setEstado(V50bClsConstantes.CONSTANTE_BAJA);
				resolutor.setFormHabilitado(V50bClsConstantes.CONSTANTE_NO);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, 
						"infobd.errorResolutorAlta");
			}else {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.error");
			}
		}

	//	contexto.set("v50bDetNuevoResolutoresBeanOrig",
	//			(V50bResolutoresBean) contexto
	//					.get("v50bDetNuevoResolutoresBean"));
		contexto.set("v50bDetNuevoResolutoresBean", resolutor);
		
		super.postProcessMappingSalida(contexto, arg1);
	}

}
