package v50b.v50bOperacionesInternas.v50bTablas;

import v50b.v50bBeans.V50bProfesionesBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


/**
 * 
 * @author acompes
 *
 */
public class V50bModificarProfesionesAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :Profesiones con los datos de modificacin
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception 
	{		
		V50bClsTrazas.depura("V50bModificarProfesionesAction.preProcessMappingEntrada() ");
			
		V50bProfesionesBean detalle = (V50bProfesionesBean) contexto.get("v50bDetNuevoProfesionesBean");
		V50bProfesionesBean detalleOrig = (V50bProfesionesBean) contexto.get("v50bDetNuevoProfesionesBeanOrig");
		
		if(detalle.getCodProf()==null){
			detalle.setCodProf(detalleOrig.getCodProf());
		}

		contexto.set("operacion", V50bClsConstantes.MODO_MODIFICAR);
				
		super.preProcessMappingEntrada(contexto, arg1, arg2);
		
	}
	
	/**
	 * @param contexto :Profesiones con los datos de modificacin
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {
		
		V50bClsTrazas.depura("V50bModificarProfesionesAction.postProcessMappingSalida() ");
		
		V50bProfesionesBean profesion = (V50bProfesionesBean)contexto.get("v50bDetNuevoProfesionesBean");
		
		if (contexto.get("v50bintModif") != null) {
			if (((Integer) contexto.get("v50bintModif")).intValue() == 1) {
				if(profesion.getEstado() != null){
					profesion.setFormHabilitado(V50bClsConstantes.CONSTANTE_NO);
				}
				contexto.set("v50bDetNuevoProfesionesBeanOrig", profesion);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.actualizado");
			} else if (((Integer) contexto.get("v50bintModif")).intValue() == -1) {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.codProfesionExiste");
			} else if (((Integer) contexto.get("v50bintModif")).intValue() == V50bClsConstantes.DOS_NEGATIVO) {
				profesion.setEstado(profesion.getFormHabilitado());
				contexto.set("v50bDetNuevoProfesionesBean", contexto.get("v50bDetNuevoProfesionesBeanOrig"));
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.codProfesionUsuario");
			}else {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION,
						"infobd.error");
			}
		}
		
		contexto.set("v50bDetNuevoProfesionesBean",profesion);
		
		super.postProcessMappingSalida(contexto, arg1);
	}

}
