package v50b.v50bOperacionesInternas.v50bTablas;

import v50b.v50bBeans.V50bMotivosBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author alata
 *
 */
public class V50bModificarMotivosAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :motivo con los datos de busqueda
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception 
	{		
		V50bClsTrazas.depura("V50bModificarMotivosAction.preProcessMappingEntrada() ");
			
		V50bMotivosBean detalle = (V50bMotivosBean)contexto.get("v50bDetNuevoMotivosBean");
		V50bMotivosBean detalleOrig = (V50bMotivosBean)contexto.get("v50bDetNuevoMotivosBeanOrig");

		if(detalle.getCmotiv()==null){
			detalle.setCmotiv(detalleOrig.getCmotiv());
		}
		
		contexto.set("v50bDetNuevoMotivosBeanOrig",detalle);
		
		contexto.set("operacion",V50bClsConstantes.MODO_MODIFICAR);
		
		super.preProcessMappingEntrada(contexto, arg1, arg2);
		
	}
	
	/**
	 * @param contexto :motivo con los datos de busqueda
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {
		
		V50bClsTrazas.depura("V50bModificarMotivosAction.postProcessMappingSalida() ");
		
		if(contexto.get("v50bintModif")!=null)
		{
			if(((Integer)contexto.get("v50bintModif")).intValue()==1){
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.actualizado");
			}
			else{
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.error");
			}
		}
		V50bMotivosBean motivo = (V50bMotivosBean)contexto.get("v50bDetNuevoMotivosBeanOrig");
		motivo.setHabilitar(motivo.getEstado());
	
		contexto.set("v50bDetNuevoMotivosBean", motivo);
		
		super.postProcessMappingSalida(contexto, arg1);
	}

}
