package v50b.v50bOperacionesInternas.v50bTablas;

import java.util.ArrayList;
import java.util.List;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bDificultadBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;


/**
 * 
 * @author alata
 *
 */
public class V50bModificarDificultadAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :dificultad con los datos de busqueda
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception 
	{		
		V50bClsTrazas.depura("V50bModificarDificultadAction.preProcessMappingEntrada() ");
			
		V50bDificultadBean detalle = (V50bDificultadBean)contexto.get("v50bDetNuevoDificultadBean");
		V50bDificultadBean detalleOrig = (V50bDificultadBean)contexto.get("v50bDetNuevoDificultadBeanOrig");
		String[] lista = (String[])contexto.get("comboCheck");
		detalle.setAmbitos(lista);
		
		V50bDificultadBean dificultad = new V50bDificultadBean();
		
		List listaAmbitos = (ArrayList)contexto.get("v50bListaAmbitosDificultad");
		String[] combo = new String[listaAmbitos.size()];
		for (int i=0;i<listaAmbitos.size();i++){
			dificultad = (V50bDificultadBean)listaAmbitos.get(i);
			combo[i] = dificultad.getCodambit();
		}
		
		contexto.set("v50bDetNuevoDificultadBean",detalle);
		if(detalle.getCoddif()==null){
			detalle.setCoddif(detalleOrig.getCoddif());
		}
		detalle.setCodambit(detalleOrig.getCodambit());
		
		contexto.set("operacion",V50bClsConstantes.MODO_MODIFICAR);
		
		super.preProcessMappingEntrada(contexto, arg1, arg2);
		
	}
	
	/**
	 * @param contexto :dificultad con los datos de busqueda
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {
		
		V50bClsTrazas.depura("V50bModificarDificultadAction.postProcessMappingSalida() ");
		
		V50bDificultadBean dificultad = (V50bDificultadBean)contexto.get("v50bDetNuevoDificultadBean");
		
		if(contexto.get("v50bintModif")!=null)
		{
			if(((Integer)contexto.get("v50bintModif")).intValue()==1){
				dificultad.setHabilitar(dificultad.getEstado());
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.actualizado");
				contexto.set("v50bDetNuevoDificultadBeanOrig",dificultad);
			}
			else if(((Integer)contexto.get("v50bintModif")).intValue()==V50bClsConstantes.DOS){
				dificultad.setEstado(dificultad.getHabilitar());
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.errorAmbitosDificultad");
			}
			else if(((Integer)contexto.get("v50bintModif")).intValue()==V50bClsConstantes.TRES){
				dificultad.setEstado(dificultad.getHabilitar());
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.errorConsultaDificultad");
			}
			else if(((Integer)contexto.get("v50bintModif")).intValue()==V50bClsConstantes.DOS_NEGATIVO){
				dificultad.setEstado(dificultad.getHabilitar());
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.errorBajaDificultad");
			}
			else if(((Integer)contexto.get("v50bintModif")).intValue()==V50bClsConstantes.TRES_NEGATIVO){
				dificultad.setEstado(dificultad.getHabilitar());
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.error24Horas");
			}
			else if(((Integer)contexto.get("v50bintModif")).intValue()==0){
				dificultad.setHabilitar(V50bClsConstantes.LITERAL_DESC_BAJA);
				dificultad.setEstado(dificultad.getHabilitar());
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.errorDificultadAlta");
			}
			else{
				dificultad.setEstado(dificultad.getHabilitar());
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.error");
			}
		}
		
		contexto.set("v50bDetNuevoDificultadBean",dificultad);
		
		super.postProcessMappingSalida(contexto, arg1);
	}

}
