package v50b.v50bOperacionesInternas.v50bTablas;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bConfiguracionBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


/**
 * 
 * @author alata
 *
 */
public class V50bEliminarConfiguracionAction extends V50bOperacionInterna {
	
	
	/**
	 * @param contexto :buzon con los datos de busqueda
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception {
		
		V50bClsTrazas.depura("V50bEliminarConfiguracionAction.preProcessMappingEntrada() ");
		final String strSeleccionado = (String)contexto.get("selec");
		final List lisContenidos = (ArrayList)contexto.get("v50bListaConfiguracion");
		
		V50bConfiguracionBean buzon = new V50bConfiguracionBean();
		if(strSeleccionado!=null && !strSeleccionado.equals("")){
			buzon = (V50bConfiguracionBean)lisContenidos.get(Integer.valueOf(strSeleccionado).intValue()-1);
			if(buzon!=null && buzon.getEstado()!=null && buzon.getEstado().equals(V50bClsConstantes.CONSTANTE_ACTIVO)){
				buzon.setModo("ERROR_ACTIVO");
			}
		}else{
			buzon.setModo("ERROR_NO_SELECCIONADO");
		}
		
		
		contexto.set("v50bConfiguracionBean",buzon);
		
		super.preProcessMappingEntrada(contexto, arg1, arg2);
		
	}

	/**
	 * @param contexto :buzon con los datos de busqueda
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {

		V50bClsTrazas.depura("V50bEliminarConfiguracionAction.postProcessMappingSalida() ");
		Integer intRetorno = (Integer)contexto.get("v50bintModif");		
		
		if(intRetorno!=null)
		{
			if((intRetorno).intValue()==1){
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.actualizado");
			}
			else if((intRetorno).intValue()==2){
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.buzonActivo");
			}
			else {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.error");
			}
		}
		
		super.postProcessMappingSalida(contexto, arg1);
	}

}
