package v50b.v50bOperacionesInternas.v50bTablas;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bConfiguracionBean;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


/**
 * 
 * @author alata
 *
 */
public class V50bBuscarConfiguracionAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto : buzon con los datos de busqueda
	 * @param configBean : Q70OperacionInternaConfigBean
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		
		V50bClsTrazas.depura("V50bBuscarConfiguracionAction.preProcessMappingEntrada() ");
		
		V50bConfiguracionBean buzon = (V50bConfiguracionBean)contexto.get("v50bConfiguracionBean");
		
		contexto.set("v50bConfiguracionBeanOrig",buzon);
		
		super.preProcessMappingEntrada(contexto, configBean, errors);
		
	}
	/**
	 * @param contexto :buzon con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
	
		V50bClsTrazas.depura("V50bBuscarConfiguracionAction.postProcessMappingSalida() ");
		
		contexto.set("busqRealizada","true");
		contexto.set("operacion", "");
		
		List listaBuzon = (ArrayList)contexto.get("v50bListaConfiguracion");
		
		List lisTabla = new ArrayList();
		V50bConfiguracionBean configBean = new V50bConfiguracionBean();
		V50bConfiguracionBean bean = new V50bConfiguracionBean();
		
		for(int i=0;i<listaBuzon.size();i++){
			bean = (V50bConfiguracionBean)listaBuzon.get(i);
			
			if(bean.getCoddes()!=null || "".equals(bean.getCoddes())){
				lisTabla.add(bean);
			}
		}
		
		contexto.set("v50bListaConfiguracion",lisTabla);
		contexto.set("v50bConfiguracionBean", configBean);
		
		super.postProcessMappingSalida(contexto, errors);
	}

}
