package v50b.v50bOperacionesInternas.v50bTablas;

import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bConfiguracionBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;


/**
 * 
 * @author alata
 *
 */
public class V50bBuscarConfigTextosAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto : buzon con los datos de busqueda
	 * @param configBean : Q70OperacionInternaConfigBean
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		
		V50bClsTrazas.depura("V50bBuscarConfigTextosAction.preProcessMappingEntrada() ");
		
		V50bConfiguracionBean buzonTextos = (V50bConfiguracionBean)contexto.get("v50bConfigTextosBean");
		
		contexto.set("v50bConfigTextosBeanOrig",buzonTextos);
		
		super.preProcessMappingEntrada(contexto, configBean, errors);
		
	}
	/**
	 * @param contexto :buzon con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
	
		V50bClsTrazas.depura("V50bBuscarConfigTextosAction.postProcessMappingSalida() ");
		
		contexto.set("busqRealizada","true");
		contexto.set("operacion", "");
		V50bConfiguracionBean configTextosBean = (V50bConfiguracionBean)contexto.get("v50bConfigTextosBean");
		
		List listaBuzon = (ArrayList)contexto.get("v50bListaConfigTextos");
		
		V50bConfiguracionBean bean = new V50bConfiguracionBean();
		
		String codigo = bean.getCpropi();
		for(int i=0;i<listaBuzon.size();i++){
			bean = (V50bConfiguracionBean)listaBuzon.get(i);
			codigo = bean.getCpropi();
			
			if(codigo.equals(V50bClsConstantes.CONSTANTE_TEXTO_CONTACTO_IVAP)){
				configTextosBean.setTextoContactoIvapes(bean.getTextoes());
				configTextosBean.setTextoContactoIvapeu(bean.getTextoeu());
			}else if(codigo.equals(V50bClsConstantes.CONSTANTE_TEXTO_OLVIDO_CONTRASENYA)){
				configTextosBean.setTextoOlvidoContraseniaes(bean.getTextoes());
				configTextosBean.setTextoOlvidoContraseniaeu(bean.getTextoeu());
			}else if(codigo.equals(V50bClsConstantes.CONSTANTE_TEXTO_ALTA_SUSCRIPCION)){
				configTextosBean.setTextoAltaSuscripciones(bean.getTextoes());
				configTextosBean.setTextoAltaSuscripcioneu(bean.getTextoeu());
			}else if(codigo.equals(V50bClsConstantes.CONSTANTE_TEXTO_RECIBIR_NOTIFICACION)){
				configTextosBean.setTextoRecibirNotificaciones(bean.getTextoes());
				configTextosBean.setTextoRecibirNotificacioneu(bean.getTextoeu());
			}else if(codigo.equals(V50bClsConstantes.CONSTANTE_TEXTO_PROTECCION_DATOS)){
				configTextosBean.setTextoProteccionDatoses(bean.getTextoes());
				configTextosBean.setTextoProteccionDatoseu(bean.getTextoeu());
			}else if(codigo.equals(V50bClsConstantes.CONSTANTE_TEXTO_COMUNICACION_CLAVES)){
				configTextosBean.setTextoComunicacionClaveses(bean.getTextoes());
				configTextosBean.setTextoComunicacionClaveseu(bean.getTextoeu());
			}else if(codigo.equals(V50bClsConstantes.CONSTANTE_TEXTO_SERVICIO_INACTIVO)){
				configTextosBean.setTextoServicioInactivoes(bean.getTextoes());
				configTextosBean.setTextoServicioInactivoeu(bean.getTextoeu());
			}else if(codigo.equals(V50bClsConstantes.CONSTANTE_TEXTO_EMAIL_REMITENTE)){
				configTextosBean.setTextoEmailRemitente(bean.getEmail());
			}else if(codigo.equals(V50bClsConstantes.CONSTANTE_TEXTO_EMAIL_TECNICOS)){
				configTextosBean.setEmailTecicoIvap(bean.getEmail());
			}
		}
		
		contexto.set("v50bConfigTextosBean", configTextosBean);
			
		if(listaBuzon.size()==0){
			contexto.set("listaVacia","true");
		}else{
			contexto.set("listaVacia","false");
		}
		
		super.postProcessMappingSalida(contexto, errors);
	}


}
