package v50b.v50bOperacionesInternas.v50bTablas;

import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author acompes
 *
 */
public class V50bAniadirResolutoresAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :Resolutores con los datos del alta
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception{
		
		V50bClsTrazas.depura("V50bAniadirResolutoresAction.preProcessMappingEntrada() ");
		
		V50bResolutoresBean resolutor = (V50bResolutoresBean)contexto.get("v50bDetNuevoResolutoresBean");
		String[] lista = (String[])contexto.get("comboCheck");
		resolutor.setAmbitos(lista);
		contexto.set("v50bDetNuevoResolutoresBean",resolutor);
			
		super.preProcessMappingEntrada(contexto, arg1, arg2);
		
	}
	
	/**
	 * @param contexto :Resolutores con los datos del alta
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {
		
		V50bClsTrazas.depura("V50bAniadirResolutoresAction.postProcessMappingSalida() ");
							
		V50bResolutoresBean resolutoresNuevo = (V50bResolutoresBean)contexto.get("v50bDetNuevoResolutoresBean");
		
		contexto.set("v50bDetNuevoResolutoresBeanOrig",resolutoresNuevo);
		
		contexto.set("filaSelec", null);
		
		if(contexto.get("v50bintModif")!=null)
		{
			if(((Integer)contexto.get("v50bintModif")).intValue()==1){
				V50bResolutoresBean detResolutoresBean = new V50bResolutoresBean();
				detResolutoresBean.setAviso(V50bClsConstantes.AVISO_NO);
				contexto.set("v50bDetNuevoResolutoresBean", detResolutoresBean);
				contexto.set("comboCheck", null);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.actualizado");
			}
			else if(((Integer)contexto.get("v50bintModif")).intValue()== -1){
				resolutoresNuevo.setIdResol("");
				contexto.set("v50bDetNuevoResolutoresBean", resolutoresNuevo);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.idResolutorExiste");
			}else{
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.error");
			}
		}
		
		super.postProcessMappingSalida(contexto, arg1);
	}

}
