package v50b.v50bOperacionesInternas.v50bGestion.v50busuariosregistrados;

import org.apache.commons.beanutils.BeanUtils;

import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author llaparra
 *
 */
public class V50bModificarUsuarioRegistradoAction extends V50bOperacionInterna{
	
	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param configBean : Q70OperacionInternaConfigBean
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		V50bClsTrazas.depura("V50bModificarUsuarioRegistradoAction.preProcessMappingEntrada() ");
		
		super.preProcessMappingEntrada(contexto, configBean, errors);
	}
	
	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
		V50bClsTrazas.depura("V50bModificarUsuarioRegistradoAction.postProcessMappingSalida() ");
		
		Integer result = (Integer)contexto.get("v50bResultadoModificar");
		
		if(result.intValue()>0){
			//Pasamos a modo modificar
			contexto.set("v50bBDModificada", V50bClsConstantes.CONSTANTE_SI);
			
			//Guardamos un backup de los parmetros de guardado
			contexto.set("v50bUsuarioRegistradoDetFormBackup", BeanUtils.cloneBean(contexto.get("v50bUsuarioRegistradoDetForm")));
			
			//Mensaje ok
			contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.actualizado");
			
		} else if (result.intValue()==-1) {
			//Mensaje suscriptor existe
			contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.suscriptorExiste");
		} else if (result.intValue()==-V50bClsConstantes.DOS) {
			//Mensaje usuario existe
			contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.usuarioExiste");
		} else {
			//Mensaje no ok
			contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.error");
		}
		
		super.postProcessMappingSalida(contexto, errors);
	}

}
