package v50b.v50bOperacionesInternas.v50bGestion.v50bconsultas;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author llaparra
 *
 */
public class V50bNuevaConsultaAction extends V50bOperacionInterna{
	
	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
		V50bClsTrazas.depura("V50bNuevaConsultaAction.postProcessMappingSalida() ");
		
		List lResult = (ArrayList)contexto.get("v50bResultadoGuardar");
		Integer result = (Integer)lResult.get(0);
		String codConsulta = (String)lResult.get(1);
		
		if(result.intValue()>0){
			//Pasamos a modo modificar
			contexto.set("v50bBDModificada", V50bClsConstantes.CONSTANTE_SI);
			
			//Metemos el cdigo de la consulta en el bean para modificaciones
			V50bConsultaBean bean = (V50bConsultaBean)contexto.get("fNuevaConsulta");
			bean.setCodigo(codConsulta);
			contexto.set("fNuevaConsulta", BeanUtils.cloneBean(bean));
			
			//Guardamos un backup de los parmetros de guardado
			contexto.set("fNuevaConsultaBackup", BeanUtils.cloneBean(bean));
			
			//Mensaje ok
			contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.actualizado");
			
			//Guardamos el fichero para ver
			contexto.set("v50bverdocumento", bean.getFichRespuesta());
			contexto.set("v50bverdocumentoRes", bean.getFichResolutor());
			
			//Limpiamos
			//contexto.set("v50bBDCambios", V50bClsConstantes.CONSTANTE_SI);
			contexto.set("fNuevaConsulta", new V50bConsultaBean());
			contexto.set("fNuevaConsultaBackup", new V50bConsultaBean());
			contexto.set("v50bverdocumento", null);
			contexto.set("v50bverdocumentoRes", null);
//			contexto.set("fileFichAdicional", null);
//			contexto.set("fileFichAdicionalRes", null);
			
		} else {
			//Mensaje no ok
			contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.error");
		}
		
		
		super.postProcessMappingSalida(contexto, errors);
	}

}
