package v50b.v50bOperacionesInternas.v50bGestion.v50bbandejaentrada;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author llaparra
 *
 */
public class V50bCatalogarConsultaPreAction extends V50bOperacionInterna{
	
	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param configBean : Q70OperacionInternaConfigBean
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		V50bClsTrazas.depura("V50bCatalogarConsultaPreAction.preProcessMappingEntrada() ");
		
		//Sacar de la lista la consulta seleccionada y meterla en el contexto
		List lTabla = (ArrayList)contexto.get("v50bListaConsultas");
		String id = (String)contexto.get("filaSelecConsulta");
		V50bConsultaBean selec = (V50bConsultaBean)lTabla.get(Integer.parseInt(id)-1);
		contexto.set("fCatalogacion", BeanUtils.cloneBean(selec));
		
		//Cambio el ttulo de la pantalla
		String strIdioma = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","menu.gestion.bandejaEntrada.catalogar",strIdioma));
		
		super.preProcessMappingEntrada(contexto, configBean, errors);
	}
	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
		V50bClsTrazas.depura("V50bCatalogarConsultaPreAction.postProcessMappingSalida() ");
		
		//Guardamos un backup
		contexto.set("fCatalogacionBackup", BeanUtils.cloneBean(contexto.get("fCatalogacion")));
		
		super.postProcessMappingSalida(contexto, errors);
	}

}
