package v50b.v50bOperacionesInternas.v50bGestion.v50bbandejaentrada;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author llaparra
 *
 */
public class V50bBuscarNotificacionesAction extends V50bOperacionInterna{
	
	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param configBean : Q70OperacionInternaConfigBean
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		V50bClsTrazas.depura("V50bBuscarNotificacionesAction.preProcessMappingEntrada() ");
		super.preProcessMappingEntrada(contexto, configBean, errors);
		
	}
	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
		V50bClsTrazas.depura("V50bBuscarNotificacionesAction.postProcessMappingSalida() ");
		
		//Cambio el ttulo de la pantalla
		String strIdioma = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		
		String last = (String)contexto.get("subOpFlag");
		if(V50bClsConstantes.PANTALLA_GESTION_BANDEJA_ENTRADA.equals(last)){
			contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","menu.gestion.bandejaEntrada.detalleN",strIdioma));
			String subPantalla = (String)contexto.get("v50bSubpantalla");
			
			if(V50bClsConstantes.SUBPANTALLA_SOLICINFOADICIONAL.equals(subPantalla)){
				contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","menu.gestion.bandejaEntrada.solicitudN",strIdioma));
			}
			
			List lRastro = (ArrayList)contexto.get("v50bRastro");
			String strRastro=(String)lRastro.get(0);
			String subOpFlag2 = (String)contexto.get("subOpFlag2");
			if(V50bClsConstantes.PANTALLA_GESTION_BANDEJA_ENTRADA.equals(strRastro) && lRastro.size()>1 && 
					StringUtils.isNotEmpty(subOpFlag2) && V50bClsConstantes.PANTALLA_BANDEJA_ENTRADA_ASIGNAR.equals(subOpFlag2)) {
					contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","menu.gestion.bandejaEntrada.asignar.consultas.detalle.notificacion",strIdioma));
			} 
			
			if (V50bClsConstantes.PANTALLA_GESTION_BANDEJA_ENTRADA.equals(strRastro) && lRastro.size()>1 && 
					StringUtils.isNotEmpty(subOpFlag2) && V50bClsConstantes.PANTALLA_BANDEJA_ENTRADA_REENVIAR.equals(subOpFlag2)){
					contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","menu.gestion.bandejaEntrada.reenvio.consultas.detalle.notificacion",strIdioma));
			}
		}
		if(V50bClsConstantes.PANTALLA_CONSULTAS_HISTORICO_CONSULTAS.equals(last)){
			contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","historicoConsultas.detalleN",strIdioma));
		}
		else if(V50bClsConstantes.PANTALLA_GESTION_ESTADO_CONSULTAS.equals(last)){
			contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","estadoConsultas.detalleN",strIdioma));
		}
		else if(V50bClsConstantes.PANTALLA_GESTION_VISTA_RESOLUTORES.equals(last)){
			contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","vistaResolutores.titulo.notificacionConsultas",strIdioma));
		}
		else if(V50bClsConstantes.PANTALLA_GESTION_CATALOGO_CONSULTAS.equals(last)){
			contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","catalogoConsultas.titulo.notificacion",strIdioma));
		}
		
		contexto.set("v50bConsultaNotifBackup", BeanUtils.cloneBean(contexto.get("v50bConsultaNotif")));
		
		super.postProcessMappingSalida(contexto, errors);
	}

}
