package v50b.v50bOperacionesInternas.v50bGestion.v50bbandejaentrada;

import org.apache.commons.beanutils.BeanUtils;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import v50b.v50bComun.V50bOperacionInterna;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * 
 * @author llaparra
 *
 */
public class V50bBuscarBandejaEntradaAction extends V50bOperacionInterna{
	
	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param configBean : Q70OperacionInternaConfigBean
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		V50bClsTrazas.depura("V50bBuscarBandejaEntradaAction.preProcessMappingEntrada() ");
		
		//Reseteamos el radio
		contexto.set("filaSelecConsulta", "1");
		
		//Guardamos un backup de los parmetros de la bsqueda
		contexto.set("fBandejaEntradaBackup",BeanUtils.cloneBean(contexto.get("fBandejaEntrada")));
		
		//Cambio el ttulo de la pantalla
		String strIdioma = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","menu.gestion.bandejaEntrada",strIdioma.toString()));
		
		V50bConsultaBean consulta = (V50bConsultaBean)contexto.get("fBandejaEntrada");
		V50bUsuarioBean usuario = (V50bUsuarioBean)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_USUARIO_BEAN);
		usuario.setPerfilUsuario((String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_PERFIL_USUARIO));
		consulta.setUsuarioXlnets(usuario);
		contexto.set("fBandejaEntrada",consulta);
		
		super.preProcessMappingEntrada(contexto, configBean, errors);
	}
	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
		V50bClsTrazas.depura("V50bBuscarBandejaEntradaAction.postProcessMappingSalida() ");
		
		contexto.set("v50bHayBusqueda", V50bClsConstantes.CONSTANTE_SI);
		
		super.postProcessMappingSalida(contexto, errors);
	}

}
