package v50b.v50bOperacionesInternas.v50bGestion.v50bVistaResolutores;

import java.util.ArrayList;
import java.util.List;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;

/**
 * 
 * @author brey
 *
 */
public class V50bBuscarPendientesAction extends V50bOperacionInterna{

	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param configBean : Q70OperacionInternaConfigBean
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		V50bClsTrazas.depura("V50bBuscarPendientesAction.preProcessMappingEntrada() ");
			
		V50bConsultaBean consulta = (V50bConsultaBean)contexto.get("v50bVistaResolutoresBean");
		if (consulta.getAmbito().getCambit()!=null){
			contexto.set("v50bCodAmbito",consulta.getAmbito().getCambit());
		}
		String idioma = (String) contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		contexto.set("v50bStrIdioma",idioma);
		
		super.preProcessMappingEntrada(contexto, configBean, errors);
	}
	/**
	 * @param contexto :ambito con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
		V50bClsTrazas.depura("V50bBuscarPendientesAction.postProcessMappingSalida() ");
		
		contexto.set("busqRealizada","true");
		
		List listaConsultas = (ArrayList)contexto.get("v50bListaPendientes");
		if(listaConsultas.size()==0){
			contexto.set("listaVacia","true");
		}else{
			contexto.set("listaVacia","false");
		}
		
		contexto.set("v50bLista", listaConsultas);
		V50bConsultaBean consulta = (V50bConsultaBean)contexto.get("v50bVistaResolutoresBean");
		consulta.getAmbito().setCambit((String)contexto.get("v50bCodAmbito"));
		contexto.set("v50bVistaResolutoresBean", consulta);
		
		super.postProcessMappingSalida(contexto, errors);
	}
}
