package v50b.v50bOperacionesInternas.v50bGestion.v50bEstadoConsultas;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.beanutils.BeanUtils;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;


/**
 * 
 * @author alata
 *
 */
public class V50bBuscarEstConsultasAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param configBean : Q70OperacionInternaConfigBean
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		
		V50bClsTrazas.depura("V50bBuscarEstConsultasAction.preProcessMappingEntrada() ");
		
		contexto.set("v50bConsultasBeanOrig",BeanUtils.cloneBean(contexto.get("v50bConsultasBean")));
		
		super.preProcessMappingEntrada(contexto, configBean, errors);
		
	}
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
	
		V50bClsTrazas.depura("V50bBuscarEstConsultasAction.postProcessMappingSalida() ");
		
		contexto.set("busqRealizada","true");
		contexto.set("operacion", "");
		contexto.set("v50bHayBusqueda", V50bClsConstantes.CONSTANTE_SI);
		
		List listaConsultas = (ArrayList)contexto.get("v50bListaEstConsultas");
		
		if(listaConsultas.size()==0){
			contexto.set("listaVacia","true");
		}else{
			contexto.set("listaVacia","false");
		}
		
		super.postProcessMappingSalida(contexto, errors);
	}

}
