package v50b.v50bOperacionesInternas.v50bGestion.v50bCatalogoConsultas;

import java.util.ArrayList;
import java.util.List;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;


/**
 * 
 * @author acompes
 *
 */
public class V50bBuscarCatalogoConsultasAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param configBean : Q70OperacionInternaConfigBean
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		
		V50bClsTrazas.depura("V50bBuscarCatalogoConsultasAction.preProcessMappingEntrada() ");
		
		V50bConsultaBean consulta = (V50bConsultaBean)contexto.get("consultaBean");
		
		contexto.set("consultaBeanOrig",consulta);
		
		super.preProcessMappingEntrada(contexto, configBean, errors);
		
	}
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
	
		V50bClsTrazas.depura("V50bBuscarCatalogoConsultasAction.postProcessMappingSalida() ");
		
		contexto.set("busqRealizada","true");
		contexto.set("operacion", "");
		
		List listaConsultas = (ArrayList)contexto.get("v50bListaConsultas");
		
		if(listaConsultas.size()==0){
			contexto.set("listaVacia","true");
		}else{
			contexto.set("listaVacia","false");
		}
		
		super.postProcessMappingSalida(contexto, errors);
	}

}
