package v50b.v50bOperacionesInternas.v50bEncuestas.v50bResultado;

import java.util.List;

import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFunciones;
import v50b.v50bClasesComunes.V50bClsTrazas;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * <p>
 * Ttulo: V50bExcelEncuestasAction
 * </p>
 * <p>
 * Copyright: Copyright (c) 2009
 * </p>
 * <p>
 * Empresa: Eurohelp Consulting
 * </p>
 * 
 * @author brey
 * @version 1.0
 */
public class V50bExcelEncuestasAction extends Q70OperacionInterna {
	
	/**
	 * @author brey
	 * @version 1.0
	 * @throws Exception
	 *             excepcin
	 * @param contexto
	 *            Q70ContextoEJIE
	 * @param arg1
	 *            Q70OperacionInternaConfigBean
	 * @param arg2
	 *            Q70OperacionInternaErrors
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception 
	{
		V50bClsTrazas.depura("ACCION",(String)contexto.get("accion"));

		final List listaEncuestas = (List)contexto.get("v50bListEncuestasR");
		int intNumfila=Integer.parseInt((String)contexto.get("filaSelec"));
		V50bEncuestaBean bean = (V50bEncuestaBean)listaEncuestas.get(intNumfila-1);
		contexto.set("v50bEncuestaSelecI", bean);

		V50bClsFunciones.fncRellenarIdiomaYSubOpFlag(contexto);
		
		//Para tener los datos de la busqueda al volver atras
		V50bEncuestaBean beanBusq = (V50bEncuestaBean)contexto.get("v50bEncuestaBeanI");
		contexto.set("v50bEncuestaBeanBusq", beanBusq);
		
		//Para la cabecera de la encuesta
		V50bEncuestaBean beanCargado = new V50bEncuestaBean();
		beanCargado.setStrNumEncuesta(bean.getStrNumEncuesta());
		beanCargado.setStrFechaInicio(bean.getStrFechaInicio());
		beanCargado.setStrFechaFinal(bean.getStrFechaFinal());
		beanCargado.setStrTituloCas(bean.getStrTituloCas());
		beanCargado.setStrTituloEus(bean.getStrTituloEus());
		beanCargado.setStrTipo(bean.getStrTipo());
		beanCargado.setStrEstado(bean.getStrEstado());
		contexto.set("v50bEncuestaCargadaBeanI", beanCargado);

		super.preProcessMappingEntrada(contexto, arg1, arg2);

	}


	/**
	 * @author brey
	 * @version 1.0
	 * @throws Exception
	 *             excepcin
	 * @param contexto
	 *            Q70ContextoEJIE
	 * @param arg1
	 *            Q70OperacionInternaErrors
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {

		V50bClsTrazas.depura("ACCION","Fin OI de excel encuesta");
		
		final List lisRetorno = (List)contexto.get("v50bListaExcelR");
		
		contexto.set("v50bListaExcelR", lisRetorno);
		V50bClsTrazas.depura("Lista Excel",lisRetorno);
		
		//Cambio el ttulo de la pantalla
		String strIdioma = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		contexto.set("v50bstrTituloKey", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","encuestasResultados.titulo.grafico",strIdioma));
		
		super.postProcessMappingSalida(contexto, arg1);
	}

}
