package v50b.v50bOperacionesInternas.v50bEncuestas.v50bResultado;

import java.util.List;

import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bBeans.V50bRespuestasBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * <p>
 * Ttulo: V50bCargarEncuestaAction
 * </p>
 * <p>
 * Copyright: Copyright (c) 2009
 * </p>
 * <p>
 * Empresa: Eurohelp Consulting
 * </p>
 * 
 * @author brey
 * @version 1.0
 */
public class V50bCargarEncuestaAction extends Q70OperacionInterna{
	
	/**
	 * @author brey
	 * @version 1.0
	 * @throws Exception
	 *             excepcin
	 * @param contexto
	 *            Q70ContextoEJIE
	 * @param arg1
	 *            Q70OperacionInternaConfigBean
	 * @param arg2
	 *            Q70OperacionInternaErrors
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto,
			Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2)
			throws Exception {
		
		V50bClsTrazas.depura("V50bCargarEncuestaAction.preProcessMappingEntrada");
		
		V50bEncuestaBean beanCargado = new V50bEncuestaBean();
		final List listaEncuestas = (List) contexto.get("v50bListEncuestasR");

		V50bClsTrazas.depura("listaEncuestas", listaEncuestas);
		String fila = (String) contexto.get("filaSelec");
		V50bEncuestaBean bean = null;
		if ("".equals(fila)) {
			bean = (V50bEncuestaBean) contexto.get("v50bEncuestaCargadaBeanI");
		} else {
			int intNumfila = Integer.parseInt(fila);
			bean = (V50bEncuestaBean) listaEncuestas.get(intNumfila - 1);
		}
		// Para la cabecera de la encuesta
		beanCargado.setStrNumEncuesta(bean.getStrNumEncuesta());
		beanCargado.setStrFechaInicio(bean.getStrFechaInicio());
		beanCargado.setStrFechaFinal(bean.getStrFechaFinal());
		beanCargado.setStrTituloCas(bean.getStrTituloCas());
		beanCargado.setStrTituloEus(bean.getStrTituloEus());
		beanCargado.setStrEstado(bean.getStrEstado());
		beanCargado.setStrTipo(bean.getStrTipo());
		contexto.set("v50bEncuestaCargadaBeanI", beanCargado);
		// Para tener los datos de la busqueda al volver atras
		V50bEncuestaBean beanBusq = (V50bEncuestaBean) contexto
				.get("v50bEncuestaBeanOld");
		contexto.set("v50bEncuestaBeanBusq", beanBusq);
		V50bClsTrazas.depura("listaEncuestas", listaEncuestas);
		contexto.set("estado",bean.getStrEstado());
		contexto.set("tipo",bean.getStrTipo());
		V50bClsTrazas.depura("v50bEncuestaBeanI",(V50bEncuestaBean)contexto.get("v50bEncuestaBeanI"));
		V50bClsTrazas.depura("v50bEncuestaBeanBusq",(V50bEncuestaBean)contexto.get("v50bEncuestaBeanBusq"));
	
		String strTituloDet = Q70GestorMensajesi18n.getSingleton().getMessage(
				"v50bcomun",
				"encuestas.encuestaDetResp",
				(String) contexto
						.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
		contexto.set("v50bstrTituloKey", strTituloDet);

		super.preProcessMappingEntrada(contexto, arg1, arg2);

	}

	/**
	 * @author brey
	 * @version 1.0
	 * @throws Exception
	 *             excepcin
	 * @param contexto
	 *            Q70ContextoEJIE
	 * @param arg1
	 *            Q70OperacionInternaErrors
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto,
			Q70OperacionInternaErrors arg1) throws Exception {

		V50bClsTrazas.depura("V50bCargarEncuestaAction.postProcessMappingSalida");
		
		V50bClsTrazas.depura("v50bListEncuestasCargadasR", (List) contexto
				.get("v50bListEncuestasCargadasR"));
		List listaEncuestas = (List) contexto.get("v50bListEncuestasCargadasR");
		V50bEncuestaBean beanCar = (V50bEncuestaBean)contexto.get("v50bEncuestaCargadaBeanI");
		beanCar.setStrTipo((String)contexto.get("tipo"));
		beanCar.setStrEstado((String)contexto.get("estado"));
		contexto.set("v50bEncuestaCargadaBeanI", beanCar);
		V50bClsTrazas.depura("v50bEncuestaCargadaBeanI",(V50bEncuestaBean)contexto.get("v50bEncuestaCargadaBeanI"));
		
		// Para inicializar los radiobuttons
		String idPreguntaAnterior = "0";
		String idPreguntaActual = "0";
		int contador = 0;
		boolean defecto = false;
		boolean libre = false;
		boolean primero = false;
		V50bRespuestasBean respuestasBean = new V50bRespuestasBean();

		for (int j = 0; listaEncuestas != null && j < listaEncuestas.size(); j++) {
			V50bEncuestaBean bean = (V50bEncuestaBean) listaEncuestas.get(j);
			
			String codigoEncuesta = bean.getStrNumEncuesta();
			String codigoPregunta = bean.getStrNumPregunta();
			String codigoRespuesta = bean.getStrNumRespuesta();
			int resInt=Integer.parseInt(codigoRespuesta);
			
			idPreguntaAnterior = idPreguntaActual;
			idPreguntaActual = codigoPregunta;

			if (!idPreguntaAnterior.equals(idPreguntaActual)) {
				defecto = false;
				libre = false;
				primero = false;
				contador++;
			}
			
			if(bean.getStrOrdenRespuesta()==null || resInt==0){ // Si la pregunta es textarea
				libre = true;
			}
			String valor="";
			if (bean.getStrRespPorDefecto()!=null && bean.getStrRespPorDefecto().equals(V50bClsConstantes.CONSTANTE_SI)){
				valor = codigoEncuesta + "/" + codigoPregunta + "/"
					+ codigoRespuesta;
				defecto = true;
				respuestasBean.setRadios(contador, valor);
			} 
			else if(!defecto && !libre && !primero){
				valor = null;
				respuestasBean.setRadios(contador, valor);
				primero = true;
			}
		}
		
		respuestasBean.setNumPreguntas(idPreguntaActual);
		contexto.set("v50bRespuestasBeanI", respuestasBean);
		super.postProcessMappingSalida(contexto, arg1);
	}

}
