package v50b.v50bOperacionesInternas.v50bEncuestas.v50bDefinicion;

import java.util.ArrayList;
import java.util.List;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;


/**
 * 
 * @author alata
 *
 */
public class V50bModificarPreguntasAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception {
	
		V50bClsTrazas.depura("V50bModificarPreguntasAction.preProcessMappingEntrada()");
	
		//List listaPreguntas = (List)contexto.get("v50bListPreguntasR");
		//leyre
		List listaPreguntas = (List)contexto.get("listaLeyre");

		//fin
		V50bEncuestaBean enc =(V50bEncuestaBean)contexto.get("v50bDetEncuestaBeanI");
		
		/*listaPreguntasOperaciones es la lista q pasaremos al ejb para realizar las altas 
		 * y bajas de las preguntas.*/
		List listaPreguntasOperaciones = new ArrayList();
		if(listaPreguntas!=null){
			int orden = 1;
			for(int i=0;i<listaPreguntas.size();i++){
				V50bEncuestaBean preguntaBean = (V50bEncuestaBean)listaPreguntas.get(i);
				preguntaBean.setStrOrdenPregunta(String.valueOf(orden));
				preguntaBean.setStrEstado(enc.getStrEstado());
				/*pasamos todas las preguntas a listaPreguntasOperaciones por si ha cambiado
				 * el orden de alguna de ellas*/ 
				listaPreguntasOperaciones.add(preguntaBean);
				orden++;			
			}
			 /*si t59bListPreguntasOperaciones del contexto es nulo, no se ha borrado nada 
			  * previamente. Si no es nulo, concatenamos las altas con los borrados*/ 
				if((List)contexto.get("v50bListPreguntasOperaciones")!=null && ((List)contexto.get("v50bListPreguntasOperaciones")).size()>0 ){
					listaPreguntasOperaciones.addAll(listaPreguntasOperaciones.size(), (List)contexto.get("v50bListPreguntasOperaciones"));
				}
				
		}
		
		contexto.set("v50bListPreguntasOperaciones",listaPreguntasOperaciones);
		
		V50bEncuestaBean encuestaBean=(V50bEncuestaBean)contexto.get("v50bDetEncuestaBeanI");
		encuestaBean.setModo((String)contexto.get("modo"));
		contexto.set("v50bDetEncuestaBeanI",encuestaBean);
				
		super.preProcessMappingEntrada(contexto, arg1, arg2);		
	}


	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {	
		V50bClsTrazas.depura("V50bModificarPreguntasAction.postProcessMappingSalida()");
		
		final List listGuardarDetalle=(List)contexto.get("v50bListGuardarDetalleR");
		long longMovimientoR=Long.parseLong(listGuardarDetalle.get(0).toString());
		
		V50bEncuestaBean encuestaBean=(V50bEncuestaBean)contexto.get("v50bDetEncuestaBeanI");
			if (encuestaBean.getModo().equals(V50bClsConstantes.MODO_ALTA)){
				if(longMovimientoR>0){		
					encuestaBean.setStrNumEncuesta(String.valueOf(longMovimientoR));
					encuestaBean.setStrEstadoBD(encuestaBean.getStrEstado());
					contexto.set("v50bDetEncuestaBeanI",encuestaBean);
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.actualizado");
				}else if(longMovimientoR<0){
					encuestaBean.setStrNumEncuesta(String.valueOf(longMovimientoR*(-1)));
					contexto.set("v50bDetEncuestaBeanI",encuestaBean);
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.encuestaactiva");
				}else{
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.error");
				}
			}else if (encuestaBean.getModo().equals(V50bClsConstantes.MODO_MODIFICAR)){
				
				if(longMovimientoR>=0){
					encuestaBean.setStrEstadoBD(encuestaBean.getStrEstado());
					contexto.set("v50bDetEncuestaBeanI",encuestaBean);
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.actualizado");
				}else{
					contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.encuestaactiva");
					encuestaBean.setStrEstadoBD(V50bClsConstantes.CONSTANTE_INACTIVA);
				}
			}
		
		encuestaBean.setModo(V50bClsConstantes.MODO_MODIFICAR);
		contexto.set("filaPreguntaSelec", "1");
		contexto.set("preguntasAlmacenadas","true");
		contexto.set("modo",V50bClsConstantes.MODO_MODIFICAR);
		contexto.set("v50bListPreguntasOperaciones", new ArrayList());
		
		if(contexto.get("v50bListPreguntasR")!=null){
			contexto.set("v50bListPreguntasOrig", new ArrayList((List)contexto.get("v50bListPreguntasR")));
		}
		
		contexto.set("v50bDetEncuestaBeanOrig",encuestaBean);
		contexto.set("fncHabilitar","false");
		
		V50bClsTrazas.depura(encuestaBean.toString());

		super.postProcessMappingSalida(contexto, arg1);
	}

}
