package v50b.v50bOperacionesInternas.v50bEncuestas.v50bDefinicion;

import java.util.List;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;


/**
 * 
 * @author alata
 *
 */
public class V50bEliminarEncuestaAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception  {
		
		V50bClsTrazas.depura("V50bEliminarEncuestaAction.preProcessMappingEntrada() ");
		
		final String filaSelec = (String)contexto.get("filaSelec");
		final List listEncuestas = (List)contexto.get("v50bListEncuestasR");		
		V50bEncuestaBean encuestaBean = new V50bEncuestaBean();
		
		if(filaSelec!=null && !filaSelec.equals("")){
			encuestaBean = (V50bEncuestaBean)listEncuestas.get(Integer.valueOf(filaSelec).intValue()-1);
		}else{
			encuestaBean.setModo("ERROR_NO_SELECCIONADO");
		}
		
		contexto.set("v50bEncuestaSelecI", encuestaBean);
		
		super.preProcessMappingEntrada(contexto, arg1, arg2);
		
	}
	

	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {
		
		V50bClsTrazas.depura("V50bEliminarEncuestaAction.postProcessMappingSalida() ");
		
		if(contexto.get("v50bintElim")!=null)
		{
			if(((Integer)contexto.get("v50bintElim")).intValue()>0){		
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.actualizado");
			}
			else {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.error");
			}
		}
		
		super.postProcessMappingSalida(contexto, arg1);
	}
	
}

