package v50b.v50bOperacionesInternas.v50bEncuestas.v50bDefinicion;

import java.util.List;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;


/**
 * 
 * @author alata
 *
 */
public class V50bCopiarEncuestaAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception  {
		
		V50bClsTrazas.depura("V50bCopiarEncuestaAction.preProcessMappingEntrada() ");
		
		final String filaSelec = (String)contexto.get("filaSelec");
		final List listEncuestas = (List)contexto.get("v50bListEncuestasR");
		
		V50bClsTrazas.depura("listaencuestas",listEncuestas);
		V50bEncuestaBean encuestaBean = new V50bEncuestaBean();
		
		if(filaSelec!=null && !filaSelec.equals("")){
			encuestaBean = (V50bEncuestaBean)listEncuestas.get(Integer.valueOf(filaSelec).intValue()-1);
		}else{
			encuestaBean.setModo("ERROR_NO_SELECCIONADO");
		}
		
		contexto.set("v50bEncuestaSelecI", encuestaBean);
		
		V50bClsTrazas.depura("EncuestaCopiar", encuestaBean);
		
		super.preProcessMappingEntrada(contexto, arg1, arg2);
		
	}
	

	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {
		
		V50bClsTrazas.depura("V50bCopiarEncuestaAction.postProcessMappingSalida() ");
		
		if(contexto.get("v50blongGuardarEncuestaR")!=null)
		{
			if(((Long)contexto.get("v50blongGuardarEncuestaR")).longValue()>0){		
				V50bEncuestaBean encuestaBean = (V50bEncuestaBean) contexto.get("v50bEncuestaSelecI");
				encuestaBean.setStrNumEncuesta(String.valueOf(contexto.get("v50blongGuardarEncuestaR")));
				contexto.set("v50bDetEncuestaBeanI", encuestaBean);
				contexto.set("modo",V50bClsConstantes.MODO_MODIFICAR);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobdencuestas.copiado");
			} else if(((Long)contexto.get("v50blongGuardarEncuestaR")).longValue()<0) {
				V50bEncuestaBean encuestaBean = (V50bEncuestaBean) contexto.get("v50bEncuestaSelecI");
				encuestaBean.setStrNumEncuesta(String.valueOf(((Long)contexto.get("v50blongGuardarEncuestaR")).longValue()*(-1)));
				encuestaBean.setStrEstadoBD(V50bClsConstantes.CONSTANTE_INACTIVA);
				contexto.set("v50bDetEncuestaBeanI", encuestaBean);
				contexto.set("modo",V50bClsConstantes.MODO_MODIFICAR);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobdencuestas.copiadoinactivo");				
			}
			else {
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, "infobd.error");
			}
		}
		
		super.postProcessMappingSalida(contexto, arg1);
	}
	
}