package v50b.v50bOperacionesInternas.v50bEncuestas.v50bDefinicion;

import java.util.ArrayList;
import java.util.List;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;


/**
 * 
 * @author alata
 *
 */
public class V50bBuscarRespuestasAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, 
											Q70OperacionInternaErrors arg2) throws Exception {
		
		V50bClsTrazas.depura("V50bBuscarRespuestasAction.preProcessMappingEntrada() ");
		final String filaSelec = (String)contexto.get("filaPreguntaSelec");
		final List listPreguntas = (List)contexto.get("v50bListPreguntasR");
		V50bEncuestaBean encuestaBean = new V50bEncuestaBean();
		String idioma = (String)contexto.get("idioma");
		if(filaSelec!=null && !filaSelec.equals("")){
			encuestaBean = (V50bEncuestaBean)listPreguntas.get(Integer.parseInt(filaSelec)-1);
			V50bClsTrazas.depura("DatosDelBeanLista", encuestaBean);
		}else{
			encuestaBean.setModo("ERROR_NO_SELECCIONADO");
		}
		encuestaBean.setIdioma(idioma);
		contexto.set("v50bPreguntaBeanI", encuestaBean);	
		
		
		super.preProcessMappingEntrada(contexto, arg1, arg2);		
	}



	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {	
		
		V50bClsTrazas.depura("V50bBuscarRespuestasAction.postProcessMappingSalida() ");
		final List listaRespuestas = (List)contexto.get("v50bListRespuestasR");		
		final List listaRespuestasOriginal = new ArrayList(listaRespuestas);
		final List listaRespuestasOperaciones = new ArrayList();
		
		contexto.set("v50bListRespuestasOrig", listaRespuestasOriginal);
		contexto.set("v50bListRespuestasOperacionesI", listaRespuestasOperaciones);
		
		if(listaRespuestas !=null) {
			if(listaRespuestas.size()>0){
				contexto.set("activarRespuestas","true");				
			}
			else {
				contexto.set("activarRespuestas","false");				
			}			
		} else {
			contexto.set("activarRespuestas","false");		
		}		

		V50bClsTrazas.depura("ListBusquedaRespuestas", listaRespuestas);
		
		//LEYRE
		//LEYRE
		contexto.set("listaLeyreRespuestas", new ArrayList(listaRespuestas));
		//fin
		
		contexto.set("filaRespuestaSelec", "1");
		
		contexto.set("respuestasAlmacenadas","true");
		
		contexto.set("fncHabilitarRespuesta","false");
		
		String boton = (String)contexto.get("boton");
		String strIdioma = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		
		if(!Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.borrardetabla",strIdioma).equals(boton)){
			//Cambio el ttulo de la pantalla
			contexto.set("v50bstrTituloKeyRespuestas", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","encuestas.definicionRespuestas.titulo",strIdioma));
			contexto.set("v50bstrTituloKey",(String)contexto.get("v50bstrTituloKeyRespuestas"));
		}		
		
		super.postProcessMappingSalida(contexto, arg1);
	}

}
