package v50b.v50bOperacionesInternas.v50bEncuestas.v50bDefinicion;

import java.util.ArrayList;
import java.util.List;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;


/**
 * 
 * @author alata
 *
 */
public class V50bBuscarPreguntasAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception {
		
		V50bClsTrazas.depura("V50bBuscarPreguntasAction.preProcessMappingEntrada() ");
		V50bClsTrazas.depura("filaSelec", (String)contexto.get("filaSelec"));
		//Rellenamos los datos de la encuesta
		final List listRetorno = (List)contexto.get("v50bListEncuestasR");
		V50bEncuestaBean bean = (V50bEncuestaBean) contexto.get("v50bEncuestaBeanI"); 
		V50bEncuestaBean detalleBean = new V50bEncuestaBean(); 
		if(listRetorno!=null && listRetorno.size()>0){
			int intNumfila=Integer.parseInt((String)contexto.get("filaSelec"));
			detalleBean = (V50bEncuestaBean)listRetorno.get(intNumfila-1);						
		}	
		detalleBean.setIdioma(bean.getIdioma());
		detalleBean.setModo(V50bClsConstantes.MODO_MODIFICAR);
		V50bClsTrazas.depura("DetalleEncuestaBean",detalleBean);
		contexto.set("v50bDetEncuestaBeanI",detalleBean);
		contexto.set("v50bDetEncuestaBeanOrig",detalleBean);
		
		contexto.set("modo",V50bClsConstantes.MODO_MODIFICAR);
		//Inicializamos la lista de preguntas
		contexto.set("v50bListPreguntasR",null);
		super.preProcessMappingEntrada(contexto, arg1, arg2);		
	}


	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {	
		
		V50bClsTrazas.depura("V50bBuscarPreguntasAction.postProcessMappingSalida() ");
		//Lista de preguntas
		final List listaPreguntas = (List)contexto.get("v50bListPreguntasR");
		final String filaSelec = (String)contexto.get("filaPreguntaSelec");
		final List listaPreguntasOriginal = new ArrayList(listaPreguntas);
		final List listaPreguntasOperaciones = new ArrayList();
		
		contexto.set("v50bListPreguntasOrig", listaPreguntasOriginal);
		contexto.set("v50bListPreguntasOperaciones", listaPreguntasOperaciones);
		
		
		
		if(listaPreguntas !=null) {
			if(listaPreguntas.size()>0){
				contexto.set("activarPreguntas","true");				
			}
			else {
				contexto.set("activarPreguntas","false");				
			}			
		} else {
			contexto.set("activarPreguntas","false");		
		}
		
		V50bClsTrazas.depura("ListBusquedaPreguntas", listaPreguntas);		
		
		//LEYRE
		contexto.set("listaLeyre", new ArrayList(listaPreguntas));
	
		//fin
		
		if(filaSelec!= null &&  !filaSelec.equals("")) {
			if(Integer.parseInt(filaSelec)<1) {
				contexto.set("filaPreguntaSelec", "1");
			}						
		} else {
			contexto.set("filaPreguntaSelec", "1");
		}
		
		contexto.set("preguntasAlmacenadas","true");
		
		contexto.set("fncHabilitar","false");
		
		//Cambio el ttulo de la pantalla
		String strIdioma = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		contexto.set("v50bstrTituloKeyPreguntas", Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","encuestas.definicionPreguntas.titulo",strIdioma));
		contexto.set("v50bstrTituloKey",(String)contexto.get("v50bstrTituloKeyPreguntas"));
				
		super.postProcessMappingSalida(contexto, arg1);
	}

}
