package v50b.v50bOperacionesInternas.v50bEncuestas.v50bDefinicion;

import java.util.List;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bBeans.V50bEncuestaBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;


/**
 * 
 * @author alata
 *
 */
public class V50bBuscarEncuestasAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : Q70OperacionInternaConfigBean
	 * @param arg2 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean arg1, Q70OperacionInternaErrors arg2) throws Exception {
		
		V50bClsTrazas.depura("V50bBuscarEncuestasAction.preProcessMappingEntrada() ");
		V50bClsTrazas.depura("EncuestaABuscar",(V50bEncuestaBean)contexto.get("v50bEncuestaBeanI"));
		super.preProcessMappingEntrada(contexto, arg1, arg2);		
	}

	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param arg1 : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors arg1) throws Exception {	
		
		V50bClsTrazas.depura("V50bBuscarEncuestasAction.postProcessMappingSalida() ");
		List listaEncuestas = (List)contexto.get("v50bListEncuestasR");
		
		if(listaEncuestas!=null && listaEncuestas.size()>0){
			contexto.set("busqRealizada", "true");
		} else {
			contexto.set("busqRealizada", "false");
		}
		
		V50bClsTrazas.depura("ListBusquedaEncuestas", listaEncuestas);
		
		contexto.set("filaSelec", "1");	
		contexto.set("v50bstrTituloKey",Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","encuestas.definicion.titulo",(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA)));
		
		super.postProcessMappingSalida(contexto, arg1);
	}
}
