package v50b.v50bOperacionesInternas.v50bConsultas.v50bHistoricoConsultas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaConfigBean;
import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bComun.V50bOperacionInterna;


/**
 * 
 * @author alata
 *
 */
public class V50bBuscarHistConsultasAction extends V50bOperacionInterna {
	
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param configBean : Q70OperacionInternaConfigBean
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void preProcessMappingEntrada(Q70ContextoEJIE contexto, Q70OperacionInternaConfigBean configBean, Q70OperacionInternaErrors errors) throws Exception{				
		
		V50bClsTrazas.depura("V50bBuscarHistConsultasAction.preProcessMappingEntrada() ");
		
		contexto.set("v50bHistConsultasBeanOrig",BeanUtils.cloneBean(contexto.get("v50bHistConsultasBean")));
		
		//Reseteamos los checks
		contexto.set("filaSelec", "1");
		contexto.set("v50bConsultasCheckeadas", null);
		contexto.set("v50bConsultasCheckeadasAjax", null);
		contexto.set("arrArrays", null);
		contexto.set("pagActual", null);
		contexto.set("ELEMENTOS_SELECCIONADOS", null);
		
		super.preProcessMappingEntrada(contexto, configBean, errors);
		
	}
	/**
	 * @param contexto :consulta con los datos de busqueda
	 * @param errors : errores 
	 * @throws Exception Se eleva la excepcin.
	 */
	protected void postProcessMappingSalida(Q70ContextoEJIE contexto, Q70OperacionInternaErrors errors) throws Exception {
	
		V50bClsTrazas.depura("V50bBuscarHistConsultasAction.postProcessMappingSalida() ");
		
		contexto.set("busqRealizada","true");
		contexto.set("operacion", "");
		contexto.set("v50bHayBusqueda", V50bClsConstantes.CONSTANTE_SI);
		
		List listaConsultas = (ArrayList)contexto.get("v50bListaHistConsultas");
		
		if(listaConsultas.size()==0){
			contexto.set("listaVacia","true");
		}else{
			contexto.set("listaVacia","false");
		}
		
		List array = new ArrayList();
		
		if (listaConsultas!=null && listaConsultas.size()>0){
			int size = listaConsultas.size();
			int nElementos = V50bClsConstantes.DIEZ;
			int total = size / nElementos; // tamao array/num elementos pagina
			int resto = size % nElementos;
			List listaVacia = new ArrayList();
			if (resto !=0) {//si divisin no entera, tengo que aadirle uno ms
				total++;
			}
			for (int i=0; i<total; i++){
				array.add(listaVacia);
			}
		}
		
		contexto.set("arrArrays",array);
	
		Map mapa = new HashMap();
		mapa.put("PAGINA_ACTUAL","pagActual");
		mapa.put("ARRAY_PAGINAS","arrArrays");
		mapa.put("ELEMENTOS_SELECCIONADOS",(String)contexto.get("nombreListaBusqSel"));
		contexto.set("j81hsmOrdenacion",mapa);

		contexto.set("pagActual","1");		
		
		contexto.set("v50bHayBusqueda", V50bClsConstantes.CONSTANTE_SI);
		
		contexto.set("v50bBDModifVisInternet",V50bClsConstantes.CONSTANTE_NO);		
		
		super.postProcessMappingSalida(contexto, errors);
	}

}
