package v50b.v50bComun;


import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFichero;
import v50b.v50bClasesComunes.V50bClsFunciones;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bPIDUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class V50bMostrarFicheroAction.
 * 
 * @author iurkidi
 */
public class V50bMostrarFicheroAction extends Q70ActionPasoOP{
	
	/**
     * 
     * @param contexto Q70ContextoEJIE
     * @param errors ActionErrors
     * @param mapping ActionMapping
     * @param form ActionForm
     * @param arg4 HttpServletRequest
     * @param arg5 HttpServletResponse
     * 
     * @throws Exception Se eleva la excepcin.
     */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest arg4, HttpServletResponse arg5) throws Exception {
		
	}
	
	/**
     * @param contexto Q70ContextoEJIE
     * @param error errors
     * @param mapping ActionMapping
     * @param arg3 ActionForm
     * @param arg4 HttpServletRequest
     * @param response HttpServletResponse
     * 
     * @return ActionForward
     * 
     * @throws Exception Se eleva la excepcin.
     */
 	protected ActionForward processForward(Q70ContextoEJIE contexto,
			   ActionErrors error, 
			   ActionMapping mapping, 
			   ActionForm arg3,
			   HttpServletRequest arg4, 
			   HttpServletResponse response) throws Exception {
		 V50bClsTrazas.depura("V50bMostrarFicheroAction.processForward() ");


		 V50bClsFichero ficheroMostrar=(V50bClsFichero)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_FICHERO);

		 if (ficheroMostrar==null){                  
			 return mapping.findForward("error");
		 }else{            
			 String strNombreFichero=(String)ficheroMostrar.getNombreReal();		
			 if(StringUtils.isNotEmpty(strNombreFichero)){
				 V50bClsTrazas.depura("NOMBRE FICHERO",strNombreFichero);
			 }
			 //Si el documento no tine nombre le ponemos como extension .pdf
			 String strExtensionDoc=".pdf";
			 if(strNombreFichero!=null){				
				 List arrExtensionFich=V50bClsFunciones.fncSplit(strNombreFichero, ".");
				 if(arrExtensionFich!=null && arrExtensionFich.size()==1){
					 strNombreFichero = strNombreFichero.concat(strExtensionDoc);
				 }else{
					 strExtensionDoc=arrExtensionFich.get(1).toString();
				 }
			 }else{
				 strNombreFichero="Dudanet"+strExtensionDoc;
			 }
			 String strContentType = V50bClsFunciones.fncContextTypeFichero(strExtensionDoc);
			 byte[] bytesFichero= V50bPIDUtils.getDocument(ficheroMostrar.getOid());		 			
			 response.setContentLength(bytesFichero.length);
			 response.addHeader("Expires", "-1");
		     response.addHeader("Cache-control", "no-store, no-cache, must-revalidate");
			 response.setContentType(strContentType);
			 response.setHeader("Content-Disposition",
					 "inline" + ";fileName=" + strNombreFichero);
			 response.getOutputStream().write(bytesFichero);             
			 return null;
		 }
	 }    

}
