package v50b.v50bComun;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectOutputStream;

import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;

import v50b.v50bClasesComunes.V50bClsTrazas;

/**
 * Listener de atributos de session que comprueba si el objeto que se esta
 * metiendo, modificando o borrando es Serializable
 * 
 * Meter en web.xml <listener>
 * <listener-class>es.eurohelp.listeners.ListenerAtributosNoSerializables
 * </listener-class> </listener>
 * 
 * @author umartinez
 * 
 */
public class V50bListenerAtributosNoSerializables implements HttpSessionAttributeListener {

	/**
	 * Atributo insertado
	 */
	public void attributeAdded(HttpSessionBindingEvent event) {
		checkSerializable(event);
	}

	/**
	 * Atributo eliminado
	 */
	public void attributeRemoved(HttpSessionBindingEvent event) {
		checkSerializable(event);
	}

	/**
	 * Atributo reemplazado
	 */
	public void attributeReplaced(HttpSessionBindingEvent event) {
		checkSerializable(event);
	}

	/**
	 * Comprueba si el objeto asociado al evento es serializable
	 * 
	 * @param event
	 * @return
	 */
	private boolean checkSerializable(HttpSessionBindingEvent event) {
		boolean isSer = true;
		Object o = event.getValue();
		try {
			ObjectOutputStream outL = new ObjectOutputStream(new V50bNullOutputStream());
			outL.writeObject(o);
		} catch (FileNotFoundException e) {
			V50bClsTrazas.error("V50B ListenerAtributosNoSerializables.checkSerializable() : " + e);
			e.printStackTrace();
			isSer = false;
		} catch (IOException e) {
			V50bClsTrazas.error("V50B ListenerAtributosNoSerializables.checkSerializable() : " + e);
			isSer = false;
			e.printStackTrace();
		}

		return isSer;
	}

}
