package v50b.v50bComun;

import java.io.PrintWriter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
/**
 * 
 * @author llaparra
 *
 */
public class V50bHayCheckAjaxAction extends V50bActionPasoOP  {
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @throws Exception Se lanza la excepcin
	 */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errors,
			ActionMapping mapping, ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
	}
	
	/**
	 * 
	 * @param contexto : Q70ContextoEJIE
	 * @param errors : ActionErrors
	 * @param mapping : ActionMapping
	 * @param form : ActionForm
	 * @param request : request
	 * @param response : response
	 * @return ActionForward
	 * @throws Exception Se lanza la excepcin
	 */
	protected ActionForward processForward(Q70ContextoEJIE contexto,
			ActionErrors errors, ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		V50bClsTrazas.depura("V50bHayCheckAjaxAction.processForward() ");
		
		//Recogemos los parmetros de la request
		final String rownum = (String)request.getParameter("rownum");
		final String fncName = (String)request.getParameter("fncName");
		
		//La lista de checkeadas
		String[] lCheckeadas = (String[])contexto.get((String) contexto.get("nombreListaBusqSel")+"Ajax");
		if(null==lCheckeadas){
			lCheckeadas = new String[0];
		}
		
		final StringBuffer xml = new StringBuffer(V50bClsConstantes.DOSCIENTOSCINCUENTAYCINCO);
		xml.append("<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?>");
		xml.append("<ajax-response><"+fncName+">");
		xml.append("<hayCheck>");
		xml.append(this.fncHayCkeck(rownum, lCheckeadas, contexto));
		xml.append("</hayCheck>");
		xml.append("</"+fncName+"></ajax-response>");
		
		response.setContentType("text/xml");
		response.setHeader("Cache-Control", "no-cache");
		
		PrintWriter pw = response.getWriter();
		pw.write(xml.toString());
		pw.close();
		
		return null;
	}
	
	/**
	 * <p>Ttulo: fncHayCkeck</p>
	 * <p>Descripcin: comprueba si hay checkeadas actualizando la info de local a contexto</p>
	 * <p>Copyright: Copyright (c) Nov 27, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param rownum La fila a investigar
	 * @param lCheckeadas La lista de checkeadas en contexto
	 * @param contexto El contexto
	 * @return String 'S' si hay check, 'N' e.c.c
	 */
	private String fncHayCkeck(String rownum, String[] lCheckeadas, Q70ContextoEJIE contexto){
		V50bClsTrazas.depura("V50bHayCheckAjaxAction.fncHayCkeck() ");
		
		//Si ha sido al selec/deselec algun check
		if(StringUtils.isNotEmpty(rownum)){
			String[] lCheckeadasAux = new String[lCheckeadas.length+1];
			boolean existe = false;
			int rownumInt=Integer.parseInt(rownum);
			for(int i=0; i<lCheckeadas.length; i++){
				int aux = Integer.parseInt(lCheckeadas[i]);
				int auxSig = -1;
				if(i!=lCheckeadas.length-1){
					auxSig = Integer.parseInt(lCheckeadas[i+1]);
				}
				//Si existe actualizamos el flag y no lo insertamos (lo quitamos)
				if(aux==rownumInt){
					existe=true;
				}
				//Si no existe permanece y si adems se encuentra en esta posicin lo insertamos y actualizamos el flag
				else {
					lCheckeadasAux[i]=String.valueOf(aux);
					if(aux<rownumInt && -1!=auxSig && rownumInt<auxSig){
						existe=true;
						lCheckeadasAux[i+1]=rownum;
						lCheckeadasAux[i+2]=String.valueOf(auxSig);
						i+=2;
					}
				}
			}
			
			String[] lCheckeadasRes;
			//Si no lo hemos podido colocar, lo colocamos al final
			if(!existe){
				lCheckeadasAux[lCheckeadasAux.length-1]=rownum;
			} else {
				lCheckeadasRes = new String[lCheckeadas.length-1];
				int k=0;
				for(int j=0;j<lCheckeadasAux.length; j++){
					String aux = lCheckeadasAux[j];
					if(StringUtils.isNotEmpty(aux)){
						lCheckeadasRes[k]=aux;
						k++;
					}
				}
				lCheckeadasAux=lCheckeadasRes;
			}
			
			contexto.set((String) contexto.get("nombreListaBusqSel")+"Ajax", lCheckeadasAux);
			
			if(lCheckeadasAux.length>0){
				return V50bClsConstantes.CONSTANTE_SI;
			} else {
				return V50bClsConstantes.CONSTANTE_NO;
			}
		} 
		//si slo se quiere comprobar la lista
		else {
			if(null!=lCheckeadas){
				if(lCheckeadas.length>0){
					return V50bClsConstantes.CONSTANTE_SI;
				} else {
					return V50bClsConstantes.CONSTANTE_NO;
				}
			} else {
				return V50bClsConstantes.CONSTANTE_NO;
			}
		}
	}
}
