package v50b.v50bComun;


import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * <p>Ttulo: V50bFiltroSeguridad</p>
 * <p>Descripcin: Filtro de seguridad</p>
 * <p>Copyright: Copyright (c) 2007</p>
 * <p>Empresa: Eurohelp Consulting</p>.
 * 
 * @author iurkidi
 * @version 1.0
 */
public class V50bFiltroSeguridad implements Filter {
	private static String ESTADO_ACTIVADO="activado";
	//private static String ESTADO_DEBUG="debug";
	private FilterConfig filterConfig = null; 
	private static String USUARIO_SINVALIDAR="usuarioSinValidar";
	private String tipoError = "USUARIO";
	/**
	 * Instancia del log de trazas
     */
    private static String COMPONENTE="v50bFiltroSeguridad"; 

    /**
     * *****************************************
     * Este filtro tiene 3 estados posibles indicados en una variable "estado" en el WEB.XML
     * DEBUG---------->Aade actions a los archivos properties de los usuarios.
     * ACTIVADO------->Activa el filtro para el acceso no permitido de usuarios.
     * OFF(cualquier otro valor)----------->
     * *****************************************
     * 
     * @param p1 the p1
     * @param p2 the p2
     */
    
    private void trazasSeguridad(String p1, String p2){
    	V50bClsTrazas.depura(p1,p2);
    }
    
    /**
     * 
     * @param servletRequest ServletRequest
     * @param servletResponse ServletResponse
     * @param filterChain FilterChain
     * 
     * @throws ServletException Se eleva la ServletException.
     * @throws IOException Se eleva la IOException.
     */
    public void doFilter(ServletRequest servletRequest,ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {
    	
    	HttpServletRequest request = (HttpServletRequest) servletRequest;
    	HttpSession session = request.getSession(false);

    	try{
    		String estado = this.filterConfig.getInitParameter("estado");
    		//trazasSeguridad(COMPONENTE, "### Pasando por Seguridad Filtro ###");                
    		//trazasSeguridad(COMPONENTE, "### ESTADO: "+estado+"###(activado,debug,off)");
    		//Comprobamos si en sesion hay un ArrayList de errores y si es asi lo borramos  

    		//trazasSeguridad(COMPONENTE,"Pasando por ruta " + request.getRequestURI());    
    		
    		
    		if(session==null){
    			this.trazasSeguridad(V50bFiltroSeguridad.COMPONENTE,"*********************SE HA PERDIDO LA SESION*******************");
    			session = request.getSession(true);
    		}else{
    			this.trazasSeguridad(V50bFiltroSeguridad.COMPONENTE,"*********************ID DE LA SESION*******************: "+session.getId());
    			if(null!=request.getSession().getAttribute("JFreeChart_Deleter")){
        			 request.getSession().setAttribute("JFreeChart_Deleter",null);
        		}
    		}
    		
    			
    		Q70ContextoEJIE contexto = (Q70ContextoEJIE)session.getAttribute("contexto");  
    		
    		if (estado.equalsIgnoreCase(V50bFiltroSeguridad.ESTADO_ACTIVADO)){
    			if(contexto!=null){
    				String tipoUsuario = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_TIPO_USUARIO);
    				String action="";
    				String strut=""; 
    				if (V50bClsConstantes.USUARIO_TECNICO_IVAP.equals(tipoUsuario)){
    					tipoUsuario=V50bClsConstantes.USUARIO_TECNICO_IVAP;
    				}   
    				else {
    					tipoUsuario=V50bFiltroSeguridad.USUARIO_SINVALIDAR;
    				}  
    				
    				action =(String)request.getRequestURI().substring(1);
    				action = action.substring(action.indexOf("/")+1);//path completo del action dentro de la aplicacion.                
    				if(action.indexOf("/")!=-1){
    					strut= action.substring(0,action.indexOf("/"));//Ya tenemos el strut y el action
    					action=action.substring(action.indexOf("/")+1);
    				}

    				//trazasSeguridad(COMPONENTE,"Strut/Action: "+strut+"/"+action);

    				if (this.esPermitido(tipoUsuario,action,strut)) {

    					//trazasSeguridad(COMPONENTE, "Permiso concedido a "+action);                      
    					//trazasSeguridad(COMPONENTE, "### Saliendo de Seguridad Filtro ###");

    					filterChain.doFilter(servletRequest, servletResponse); 
    				}else{
    					//String idSesionOriginal = (String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_SESSION_TOKEN);
    					//Miramos si la sesion ha expirado primero.
    					if ((((HttpServletRequest) request).getRequestedSessionId() != null)) {
    						if (!((HttpServletRequest) request).isRequestedSessionIdValid()) {
    							this.tipoError = "SESION";
    							this.trazasSeguridad(V50bFiltroSeguridad.COMPONENTE,"Sesion Expirada");
    						} 
    					} 
    					else{
    						this.tipoError = "USUARIO";
    						this.trazasSeguridad(V50bFiltroSeguridad.COMPONENTE,"*******************************************************");
    						this.trazasSeguridad("Permiso denegado a",strut+"/"+action);
    						this.trazasSeguridad(V50bFiltroSeguridad.COMPONENTE,"*******************************************************");
    					}
    					this.redireccionarError(request,servletResponse);     
    				} 
    			}else{//FIN contexto
    				filterChain.doFilter(servletRequest, servletResponse);
    			}    		
    		/**************************FILTRO DESACTIVADO****************************/    
			}else{
				filterChain.doFilter(servletRequest, servletResponse);
			}
    	}catch (Exception ex) {
 
    		this.trazasSeguridad(V50bFiltroSeguridad.COMPONENTE,"Excepcion: "+ex.getMessage());
	
    		this.redireccionarError(request,servletResponse);			
		}
    }
    
    /**
     * Comprueba si un usuario tiene permiso para ir a un action.
     * 
     * @param usuario String con el usuario que quiere acceder
     * @param action String con el action al que quiere acceder
     * @param strut String con el strut en el que est el action
     * 
     * @return True si tiene permiso, false si no
     * 
     * @throws Q70GestorMensajesException the q70 gestor mensajes exception
     */    
    public boolean esPermitido(String usuario, String action,String strut) throws Q70GestorMensajesException {
    	boolean bolResultado = false;   
    	this.trazasSeguridad(action, strut);
    	if(!"".equals(strut)){
    		this.trazasSeguridad("esPermitido USUARIO Q LLEGA",usuario);
	    	if((strut+"/"+action).equals(Q70ListenerUtils.getApplicationProperty(V50bFiltroSeguridad.COMPONENTE, null, "URL_INCIO"))
	    			|| (strut+"/"+action).equals("comunJSP/submitlogin.do")	){//esta segunda opcion es para pruebas con SimulaLogin
				bolResultado=true;
	    	}else{
		    	if(usuario.equals(V50bClsConstantes.USUARIO_TECNICO_IVAP)){
		    		bolResultado=true;
		    	}
		    	else{
		    		bolResultado=false;
		    	}
	    	}
    	}else{
    		bolResultado=true;
    	}   
    	//this.trazasSeguridad(V50bFiltroSeguridad.COMPONENTE,"****************************** esPermitido: "+bolResultado);
    	return bolResultado;
    }
    
    /**
     * Redireccionar error.
     * 
     * @param request the request
     * @param servletResponse the servlet response
     * 
     * @throws ServletException the servlet exception
     * @throws IOException Signals that an I/O exception has occurred.
     */
    public void redireccionarError(HttpServletRequest request,ServletResponse servletResponse) throws ServletException, IOException{
    	RequestDispatcher dispatcher;
    	if("SESION".equals(this.tipoError)){
    		dispatcher = this.filterConfig.getServletContext().getRequestDispatcher("/v50berrorSesion.do");
    	}
    	else{
    		dispatcher = this.filterConfig.getServletContext().getRequestDispatcher("/v50berrorUsuario.do");
    	}

		//trazasSeguridad(COMPONENTE,"### Saliendo de Seguridad Filtro ###");

		dispatcher.forward(request, servletResponse);       
    }
    
    /**
     * 
     * @param filterConfig FilterConfig
     */
    public void init(FilterConfig filterConfig) {
    	this.filterConfig = filterConfig;    
    }

    /**
     * 
     */
    public void destroy() {
    	this.filterConfig = null;
    }

    // Sin este, no anda
    /**
     * Gets the filter config.
     * 
     * @return the filter config
     */
    public FilterConfig getFilterConfig() {
    	return this.filterConfig;
    }

    // Sin este, no anda
    /**
     * Sets the filter config.
     * 
     * @param f the new filter config
     */
    public void setFilterConfig(FilterConfig f) {
    	this.filterConfig = f;
    }

	/**
	 * Gets the tipo error.
	 * 
	 * @return the tipo error
	 */
	public String getTipoError() {
		return this.tipoError;
	}

	/**
	 * Sets the tipo error.
	 * 
	 * @param tipoError the new tipo error
	 */
	public void setTipoError(String tipoError) {
		this.tipoError = tipoError;
	}
}
