package v50b.v50bComun;

import java.io.IOException;
import java.util.Enumeration;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import v50b.v50bClasesComunes.V50bClsConstantes;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * <p>Ttulo: V50bFiltroMensajes</p>
 * <p>Descripcin: Filtro de mensajes</p>
 * <p>Copyright: Copyright (c) 2007</p>
 * <p>Empresa: Eurohelp Consulting</p>.
 * 
 * @author iurkidi
 * @version 1.0
 */
public class V50bFiltroMensajes implements Filter {
	private FilterConfig filterConfig = null; 
	private String encoding = "ISO-8859-1";

	/**
     * 
     * @param servletRequest ServletRequest
     * @param servletResponse ServletResponse
     * @param filterChain FilterChain
     * 
     * @throws ServletException Se eleva la ServletException.
     * @throws IOException Se eleva la IOException.
     */
	public void doFilter(ServletRequest servletRequest,ServletResponse servletResponse, FilterChain filterChain) throws ServletException, IOException {

		final HttpServletRequest request = (HttpServletRequest) servletRequest;
		final HttpServletResponse response = (HttpServletResponse) servletResponse;

		// Conseguimos asegurar que todas las request vienen con el mismo encoding
		if(this.filterConfig.getInitParameter("encoding")!=null){
			this.encoding = this.filterConfig.getInitParameter("encoding");
		}
		request.setCharacterEncoding(this.encoding);

		// Conseguirmos asegurar que no se va a cachear nunca nada
		response.addHeader("Expires", "-1");
		response.addHeader("Cache-control", "no-store, no-cache, must-revalidate");

		final Q70ContextoEJIE contexto = (Q70ContextoEJIE)request.getSession().getAttribute("contexto");

		if(contexto!=null){
			String strColumnaOrdenada = "";
			String parametro = "";
			Enumeration nombreParametros = request.getParameterNames();
			boolean encontrado = false;
			while (nombreParametros.hasMoreElements() && !encontrado){
				parametro = (String) nombreParametros.nextElement();
				if (parametro.startsWith("d-") && parametro.endsWith("-s")){
					strColumnaOrdenada = (String) request.getParameter(parametro);
					encontrado = true;
				}
			}
			if(encontrado){
				contexto.set(V50bClsConstantes.INDICE_ORDENADO_TABLA, strColumnaOrdenada);
			}
		}

		try{
			if(contexto!= null 
					&& contexto.get(V50bClsConstantes.MENSAJE_INFORMACION)!=null
					&& !((String)contexto.get(V50bClsConstantes.MENSAJE_INFORMACION)).equals("")){
				
				/*final String strKeyMensaje = (String)contexto.get(V50bClsConstantes.MENSAJE_INFORMACION);
				contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, null);
				ActionMessages messages = new ActionMessages();
				messages.add("mensajesPropios", new  ActionMessage(Q70GestorMensajesi18n.getSingleton().getMessage("v50brecursosErrores",strKeyMensaje,(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA))));
				this.saveMessages(request, messages);*/

				final String strKeyMensaje = (String)contexto.get(V50bClsConstantes.MENSAJE_INFORMACION);
	    		final List listaArgsMensaje = (List)contexto.get(V50bClsConstantes.MENSAJE_ARGS_INFORMACION);
	    		//Object[] strArgsMensaje = null;
	    		String strMensaje= "";
	    		if (listaArgsMensaje != null){
		    		//strArgsMensaje = listaArgsMensaje.toArray();
	    			strMensaje=(String)listaArgsMensaje.get(0);
	    		}
	    		
	    		String strMsgInfo=Q70GestorMensajesi18n.getSingleton().getMessage("v50brecursosErrores",strKeyMensaje,(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
	    		
	    		
	    		contexto.set(V50bClsConstantes.MENSAJE_INFORMACION, null);
	    		contexto.set(V50bClsConstantes.MENSAJE_ARGS_INFORMACION, null);
	    		
	    		ActionMessages messages = new ActionMessages();
	    		
	    		messages.add("mensajesPropios", new  ActionMessage(strMsgInfo+strMensaje));
	    		this.saveMessages(request, messages);
				
				
				
				String confirm = (String)contexto.get("confirm");
				if("infobd.actualizado".equals(strKeyMensaje) && confirm!=null && "INICIO".equals(confirm)){
					contexto.set("confirm", null);
					//if("INICIO".equals(confirm)){
						RequestDispatcher dispatcher = this.filterConfig.getServletContext().getRequestDispatcher("/comunJSP/v50binicioVerificado.do");
						dispatcher.forward(request, servletResponse);       
					//}
				} else {
					if ("infobd.actualizado".equals(strKeyMensaje) && confirm!=null &&
							("/comunJSP/v50bcambioIdioma.do?v50bCgaIdioma=eu".equals(confirm) || 
									"/comunJSP/v50bcambioIdioma.do?v50bCgaIdioma=es".equals(confirm))){
						RequestDispatcher dispatcher = this.filterConfig.getServletContext().getRequestDispatcher(confirm);
						dispatcher.forward(request, servletResponse);
					}
				}
			}

		}catch (Q70GestorMensajesException e) {
			this.redireccionarError(request,servletResponse);		
		}

		filterChain.doFilter(servletRequest, servletResponse);
	}

	/**
	 * Save messages.
	 * 
	 * @param request the request
	 * @param messages the messages
	 */
	private void saveMessages(
			HttpServletRequest request,
			ActionMessages messages) {

		if ((messages == null) || messages.isEmpty()) {
			request.removeAttribute(Globals.MESSAGE_KEY);
			return;
		}
		request.setAttribute(Globals.MESSAGE_KEY, messages);
	}

	/**
	 * Redireccionar error.
	 * 
	 * @param request the request
	 * @param servletResponse the servlet response
	 * 
	 * @throws javax.servlet.ServletException  the exception
	 * @throws java.io.IOException the exception
	 */
	public void redireccionarError(HttpServletRequest request,ServletResponse servletResponse) throws ServletException, IOException{
		RequestDispatcher dispatcher = this.filterConfig.getServletContext().getRequestDispatcher("/v50berror.do");

		dispatcher.forward(request, servletResponse);       
	}

	/**
     * 
     * @param filterConfig FilterConfig
     */
	public void init(FilterConfig filterConfig) {
		this.filterConfig = filterConfig;
		this.encoding = this.filterConfig.getInitParameter("encoding");
	}

	/**
     * 
     */
	public void destroy() {
		this.filterConfig = null;
	}

	/**
	 * Gets the filter config.
	 * 
	 * @return the filter config
	 */
	public FilterConfig getFilterConfig() {
		return this.filterConfig;
	}

	/**
	 * Sets the filter config.
	 * 
	 * @param f the new filter config
	 */
	public void setFilterConfig(FilterConfig f) {
		this.filterConfig = f;
	}

	/**
	 * Gets the encoding.
	 * 
	 * @return the encoding
	 */
	public String getEncoding() {
		return this.encoding;
	}

	/**
	 * Sets the encoding.
	 * 
	 * @param encoding the new encoding
	 */
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}
}
