package v50b.v50bComun;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.GenericTypeValidator;
import org.apache.commons.validator.GenericValidator;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.upload.FormFile;

import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsFunciones;
import v50b.v50bClasesComunes.V50bClsTrazas;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.datos.Q70OPValidatorForm;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;
import es.ejie.frmk.presentacion.validacion.Q70ValidacionesCampo;
import es.ejie.frmk.presentacion.validacion.Q70ValidacionesGenericas;

/**
 * The Class V50bClsValidaciones.
 * 
 * @author iurkidi
 */
public class V50bClsValidaciones extends Q70ValidacionesGenericas {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static String COMPONENTE = "V50bClsValidaciones";
	private static String ERROR_FORMATO_NIE="error.formatoNIE";
	private static String ERROR_FORMATO_NAN="error.formatoNAN";
	

	/**
	 * Instantiates a new v50b cls validaciones.
	 */
	private V50bClsValidaciones() {
	}

	 /**
	 * validateDate
	 * 
	 * @param bean
	 *            a
	 * @param va
	 *            a
	 * @param field
	 *            a
	 * @param errors
	 *            a
	 * @param request
	 *            a
	 * @return Date
	 */
	public static Date validateDate(Object bean, ValidatorAction va,
			Field field, ActionErrors errors, HttpServletRequest request) {
		Date bResultado = null;
		// boolean fechaCorrecta = true;
		String strValor = "";
		if (V50bClsValidaciones.isString(bean)) {
			strValor = (String) bean;
		} else {
			strValor = ValidatorUtil
					.getValueAsString(bean, field.getProperty());
		}

		// Si el idioma es euskera, validar la fecha
		String strIdioma = Q70ListenerUtils.getLanguage(request);
		boolean bolFecVacia = StringUtils.isEmpty(strValor);
		if (!bolFecVacia
				&& strIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA)) {
			boolean bolFechaEu = V50bClsValidaciones
					.fncValidarFechaEu(strValor);
			if (bolFechaEu) {
				try {
					bResultado = V50bClsFecha.fncFormatearFecha(strValor,
							V50bClsConstantes.CONSTANTE_EUSKARA);
				} catch (Exception e) {
					if (V50bClsValidaciones.tr.isTraceActive()) {
						V50bClsValidaciones.tr.trace(
								V50bClsValidaciones.COMPONENTE,
								Q70TraceLevel.ERROR,
								"ERROR al formatear fecha en euskera: " + e);
					}
				}
			} else {
				if (V50bClsValidaciones.tr.isTraceActive()) {
					V50bClsValidaciones.tr.trace(
							V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO,
							"fecha erronea");
				}
			}
		} else if (!bolFecVacia
				&& strIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO)) {
			boolean bolFechaEs = V50bClsValidaciones
					.fncValidarFechaEs(strValor);
			if (bolFechaEs) {
				try {
					bResultado = V50bClsFecha.fncFormatearFecha(strValor,
							V50bClsConstantes.CONSTANTE_CASTELLANO);
				} catch (Exception e) {
					if (V50bClsValidaciones.tr.isTraceActive()) {
						V50bClsValidaciones.tr.trace(
								V50bClsValidaciones.COMPONENTE,
								Q70TraceLevel.ERROR,
								"ERROR al formatear fecha en castellano: " + e);
					}
				}
			} else {
				if (V50bClsValidaciones.tr.isTraceActive()) {
					V50bClsValidaciones.tr.trace(
							V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO,
							"fecha erronea");
				}
			}
		}
		if (bResultado == null && !bolFecVacia) {
			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(
					request, va, field));
		}
		return bResultado;
	}

    /**
	 * Valida una fecha en el idioma indicado est en el formato correcto
	 * 
	 * @param fecha
	 *            El String fecha
	 * @param strIdioma
	 *            El String del idioma
	 * @return boolean. True si es correcta
	 */
    public static boolean fncValidarFecha(String fecha, String strIdioma) {
    	boolean fechaCorrecta=true;
    	String strValor = fecha;       
    	
    	if(strValor!=null && !strValor.equals("")){
	    	// Si el idioma es euskera, validar la fecha
			if (strIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA)){
				fechaCorrecta = V50bClsValidaciones.fncValidarFechaEu(strValor);
			// Si el idioma es castellano
			}else{ 				
				fechaCorrecta = V50bClsValidaciones.fncValidarFechaEs(strValor);
			}
    	}else{
    		fechaCorrecta=false;
    	}
    	
		return fechaCorrecta;
    }
    
    /**
     * Valida un fichero antes de subirlo al servidor
     * 
     * @param bean Object
     * @param va ValidatorAction
     * @param field Field
     * @param errors a
     * @param request a
     * @return FormFile si validacion OK, null si error
     */

    public static boolean validateFile(Object bean, ValidatorAction va,
            Field field, ActionErrors errors, HttpServletRequest request) { 
    	try{
    	FormFile fichero = (FormFile)((Q70OPValidatorForm)bean).get(field.getProperty());
        
       if(fichero==null){
    	    return true;
       }
       if((fichero.getFileName()==null) || (fichero.getFileName().equals(""))){
   	    return true;
       }
        if(fichero.getFileSize()==0){
            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
            return false;
        }
        else
        {
        	byte[] b=fichero.getFileData();
			//V50bClsTrazas.depura("getFileData",b);
			String[] extensiones = V50bClsConstantes.CONSTANTE_EXTENSIONES_PERMITIDAS;
			
			int correcta=0;
			for (int i=0;i<extensiones.length;i++)
			{
				int contador =0;
				while (contador<V50bClsConstantes.CUATRO)
				{
					//V50bClsTrazas.depura("extensiones["+i+"].getBytes()["+contador+"]",extensiones[i].getBytes()[contador]+"");
					//V50bClsTrazas.depura("b[contador]",b[contador]+"");
					if(extensiones[i].getBytes()[contador]==b[contador]){
						correcta++;
					}
					contador++;
				}
			}
			//V50bClsTrazas.depura("correcta",correcta+"");
			if(correcta>V50bClsConstantes.TRES){
				return true;
			}else{
				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	            return false;
			}
				
        }
    	}catch(Exception e)
    	{
    		//e.printStackTrace();
    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
            return false;
    	}
    }
    
    /**
     * Valida un fichero antes de subirlo al servidor
     * @author omartinez
     * @param bean bean
     * @param va ValidatorAction
     * @param field Field
     * @param errors errores
     * @param request request
     * @return boolean
     */

    public static boolean validateFileImg(Object bean, ValidatorAction va,
            Field field, ActionErrors errors, HttpServletRequest request) { 
    	try{
    	FormFile fichero = (FormFile)((Q70OPValidatorForm)bean).get(field.getProperty());
        
       if(fichero==null){
    	    return true;
       }
       if((fichero.getFileName()==null) || (fichero.getFileName().equals(""))){
    	   return true;
       }
   	    
        if(fichero.getFileSize()==0){
            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
            return false;
        }
        else
        {
        	List arrExtensionFich=V50bClsFunciones.fncSplit(fichero.getFileName(), ".");
			 if(arrExtensionFich!=null && arrExtensionFich.size()==1){
				 errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
				 return false;
			 }else{
				 V50bClsTrazas.depura("EXTENSION FICHERO", arrExtensionFich.get(1).toString().trim());
				 if(!arrExtensionFich.get(1).toString().trim().toLowerCase().equals("gif") &&
					!arrExtensionFich.get(1).toString().trim().toLowerCase().equals("png")	&&
					!arrExtensionFich.get(1).toString().trim().toLowerCase().equals("jpg") ){
					 errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
					 return false;
				 }else{
					 return true;
				 }
			 }
				
        }
    	}catch(Exception e)
    	{
    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
            return false;
    	}
    }
    
    /**
     * Valida que una fecha en euskera este en formato correcto
     * 
     * @param strPfValor
     *            String: valor de la fecha
     * @return boolean: true si es correcto, false si no lo es
     */
    public static boolean fncValidarFechaEu(String strPfValor) {
        boolean bolRetorno = true;
        try {
        	List listFecha=V50bClsFunciones.fncSplit(strPfValor, "/");
        	/*int intDia = Integer.parseInt(strPfValor.substring(V50bClsConstantes.MAGIC_NUMBER8, V50bClsConstantes.MAGIC_NUMBER10));
            int intAnyo = Integer.parseInt(strPfValor.substring(0, V50bClsConstantes.CUATRO));
            int intMes = Integer.parseInt(strPfValor.substring(CINCO, V50bClsConstantes.MAGIC_NUMBER7));            
            if (!strPfValor.substring(V50bClsConstantes.CUATRO, CINCO).equals("/")) {
                bolRetorno = false;
            }
            if (!strPfValor.substring(V50bClsConstantes.MAGIC_NUMBER7, V50bClsConstantes.MAGIC_NUMBER8).equals("/")) {
                bolRetorno = false;
            }*/
        	
        	//para que acepte fechas con formato 8/11/2008. Cambia la longitud de la cadena
        	//Este cambio esta aqui pq hay varias validaciones de fechas pero la validacion de euskera esta centralizado aqui
        	int intAnyo=Integer.parseInt(listFecha.get(0).toString());
        	int intMes=Integer.parseInt(listFecha.get(1).toString());
        	int intDia=0;
        	if(listFecha.get(2).toString().length()==1){
        		intDia=Integer.parseInt(V50bClsFunciones.fncRellenaConCeros(listFecha.get(2).toString(), 2));
        	}else{
        		intDia=Integer.parseInt(listFecha.get(2).toString());
        	}

            List arrDiasMes = (List)V50bClsFecha.getArrayDias(intAnyo);
            if (intMes < 1 || intMes > V50bClsConstantes.DOCE) {
                // Comprobamos que el mes sea correcto
                return false;
            } else if (!(intMes < 1 || intMes > V50bClsConstantes.DOCE)) {
                String strDiasMes = arrDiasMes.get(intMes - 1).toString();
                int intDiasMes = Integer.parseInt(strDiasMes);
                if (intDia < 1 || intDia > V50bClsConstantes.TREINTAYUNO || intDia > intDiasMes) {
                    // Comprobamos que el numero de dias en el mes sea correcto
                    return false;
                } else if (intAnyo == 0) {
                    // Comprobamos que el ao sea correcto
                    return false;
                }
            }
            
			// Comprobamos que el ao proporcionado se mayor o igual que el ao
			// minimo
			/*if (intAnyo < V50bClsConstantes.ANYO_MINIMO_PARA_FECHAS) {
				return false;
			}else if(intAnyo > V50bClsValidaciones.ANYO_MAX_CONV){
				return false;
			}*/

        } catch (Exception e) {
            if (V50bClsValidaciones.tr.isTraceActive()) {
            	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR,
                        "ERROR en parseInt");                
            }        
            bolRetorno = false;
            return bolRetorno;
        }
        return bolRetorno;
    }
    
    /**
     * Valida que una fecha en euskera este en formato correcto
     * 
     * @param strPfValor
     *            String: valor de la fecha
     * @return boolean: true si es correcto, false si no lo es
     */
    public static boolean fncValidarFechaEs(String strPfValor) {
    	boolean bolRetorno = true;
    	try {
    		List listFecha=V50bClsFunciones.fncSplit(strPfValor, "/");
    		/*String aux=strPfValor;
    		//para que acepte fechas con formato 8/11/2008. Cambia la longitud de la cadena
    		//Este cambio esta aqui pq hay varias validaciones de fechas pero la validacion de castellano esta centralizado aqui
    		if(aux.length()!=V50bClsConstantes.DIEZ){
    			aux=V50bClsFunciones.fncRellenaConCeros(aux,V50bClsConstantes.DIEZ);
    		}
    		int intAnyo = Integer.parseInt(aux.substring(V50bClsConstantes.SEIS, V50bClsConstantes.DIEZ));
    		int intMes = Integer.parseInt(aux.substring(V50bClsConstantes.TRES, V50bClsConstantes.CINCO));
    		int intDia = Integer.parseInt(aux.substring(0, 2));
    		if (!aux.substring(2, V50bClsConstantes.TRES).equals("/")) {
    			bolRetorno = false;
    		}
    		if (!aux.substring(V50bClsConstantes.CINCO, V50bClsConstantes.SEIS).equals("/")) {
    			bolRetorno = false;
    		}
    		*/
    		
    		int intAnyo=Integer.parseInt(listFecha.get(2).toString());
        	int intMes=Integer.parseInt(listFecha.get(1).toString());
        	int intDia=0;
        	if(listFecha.get(0).toString().length()==1){
        		intDia=Integer.parseInt(V50bClsFunciones.fncRellenaConCeros(listFecha.get(0).toString(), 2));
        	}else{
        		intDia=Integer.parseInt(listFecha.get(0).toString());
        	}
    		
    		List arrDiasMes = (List)V50bClsFecha.getArrayDias(intAnyo);
    		if (intMes < 1 || intMes > V50bClsConstantes.DOCE) {
    			// Comprobamos que el mes sea correcto
    			return false;
    		} else if (!(intMes < 1 || intMes > V50bClsConstantes.DOCE)) {
    			String strDiasMes = arrDiasMes.get(intMes - 1).toString();
    			int intDiasMes = Integer.parseInt(strDiasMes);
    			if (intDia < 1 || intDia > V50bClsConstantes.TREINTAYUNO || intDia > intDiasMes) {
    				// Comprobamos que el numero de dias en el mes sea correcto
    				return false;
    			} else if (intAnyo == 0) {
    				// Comprobamos que el ao sea correcto
    				return false;
    			}
    		}
    		
    		// Comprobamos que el ao proporcionado se mayor o igual que el ao
			// minimo
			/*if (intAnyo < V50bClsConstantes.ANYO_MINIMO_PARA_FECHAS) {
				return false;
			}else if(intAnyo > V50bClsValidaciones.ANYO_MAX_CONV){
				return false;
			}*/
    		
    	} catch (Exception e) {
    		if (V50bClsValidaciones.tr.isTraceActive()) {
    			V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR,
    					"ERROR en parseInt");                
    		}        
    		bolRetorno = false;
    		return bolRetorno;
    	}
    	return bolRetorno;
    }
    /**
     * isString
     * @param o o
     * @return boolean
     */
    protected static boolean isString(Object o) {
        return o != null ? java.lang.String.class.isInstance(o) : true;
    }

    /**
     * Valida que un Numero 
     * @param bean a
     * @param va a
     * @param field a
     * @param errors a
     * @param request a
     * @return String
     */
    public static String fncValidarNumero(Object bean, 
            							  ValidatorAction va,
            							  Field field, 
            							  ActionErrors errors, 
            							  HttpServletRequest request) {
    	if (V50bClsValidaciones.tr.isTraceActive()) {
    		V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR, "en fncValidarNumero");                
        }
        String strValor="";
        if (V50bClsValidaciones.isString(bean)) {
            strValor = (String) bean;
        } else {
            strValor = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        boolean bolRetorno = true;
      try {
        int intValor;
        for (int i=1; i<strValor.length()+1; i++) {
            intValor = Integer.parseInt(strValor.substring(i-1, i));
            if (intValor < 0 || intValor > V50bClsConstantes.NUEVE){
                bolRetorno=false;
            }
        }
      } catch (Exception e) {
          if (V50bClsValidaciones.tr.isTraceActive()) {
        	  V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR,
                      "ERROR en parseInt");                
          }        
          bolRetorno = false;
      }//fin try
        if(!bolRetorno){
               errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));    
        } 
        return strValor;
    }//fin fncValidarNumero  
    
    /**
     * Valida que un Numero se positivo
     * @param bean a
     * @param va a
     * @param field a
     * @param errors a
     * @param request a
     * @return String
     */
    public static String fncValidarPositivo(Object bean, 
            							  ValidatorAction va,
            							  Field field, 
            							  ActionErrors errors, 
            							  HttpServletRequest request) {
    	if (V50bClsValidaciones.tr.isTraceActive()) {
    		V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR, "en fncValidarNumero");                
        }
        String strValor="";
        if (V50bClsValidaciones.isString(bean)) {
            strValor = (String) bean;
        } else {
            strValor = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        boolean bolRetorno = true;
      try {
        int intValor;
        intValor = Integer.parseInt(strValor);
        if (intValor == 0 ){
        	bolRetorno=false;
        }
      } catch (Exception e) {
          if (V50bClsValidaciones.tr.isTraceActive()) {
        	  V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR,
                      "ERROR en parseInt");                
          }        
          bolRetorno = false;
      }//fin try
        if(!bolRetorno){
               errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));    
        } 
        return strValor;
    }//fin fncValidarPositivo  
    
   /**
    * Valida que un Numero 
    * @param bean a
    * @param va a
    * @param field a
    * @param errors a
    * @param request a
    * @return String
    */
    public static String fncValidarUnElemento(Object bean, 
            							  ValidatorAction va,
            							  Field field, 
            							  ActionErrors errors, 
            							  HttpServletRequest request) {
        if (V50bClsValidaciones.tr.isTraceActive()) {
        	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR, "fncValidarUnElemento");                
        }
        String strValor="";
        if (V50bClsValidaciones.isString(bean)) {
            strValor = (String) bean;
        } else {
            strValor = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        //boolean bolRetorno = true;   
        StringTokenizer stValor=new StringTokenizer(strValor,",");   
        if (stValor.countTokens()>1){
            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
        }
        return stValor.nextToken();
    }//fin fncValidarNumero  
    
    /**
     * Valida que todos los caracteres de un string sean numeros
     * 
     * @param s
     * 	  *            String: valor del String
     * @return boolean: true si son todos, false algn carcter no es nmero
     */
    private static boolean fncValidarNumeros(String s)
    {
    	for (int i=0;i<s.length();i++)
    	{
    		if ( !Character.isDigit(s.charAt(i)) )
    		{
    			return false;
    		}
    	}
    	return true;
    }
    
    
    /**
     * Valida que un DNI este en formato correcto
     * @param bean a
     * @param va a
     * @param field a
     * @param errors a
     * @param request a
     * @return boolean: true si es correcto, false si no lo es
     */
    public static boolean fncValidarDNI(Object bean, 
    									ValidatorAction va,
										Field field, 
										ActionErrors errors, 
										HttpServletRequest request)
    {
    	String strPfDNI="";
        if (V50bClsValidaciones.isString(bean)) {
        	strPfDNI = (String) bean;
        } else {
        	strPfDNI = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        strPfDNI = strPfDNI.trim().toUpperCase();
        if (strPfDNI.length()==0){
        	return true;
        }
        if (strPfDNI.length()!=V50bClsConstantes.NUEVE) 
        {
        	 errors.add(V50bClsValidaciones.ERROR_FORMATO_NAN, new ActionError(V50bClsValidaciones.ERROR_FORMATO_NAN, Q70ValidacionesCampo.getActionError(
 					request, va, field)));
        	return false;
        }
    	 String strCadena="TRWAGMYFPDXBNJZSQVHLCKE"; //Cadena predefinida para comprobar la letra    	
    	 boolean boolOk=false;
    	 int intPosLetra=strPfDNI.length()-1;
    	 char chLetra=strPfDNI.charAt(intPosLetra); 
    	 if (Character.isLetter(chLetra))
    	 {
    	 	String parteNumeros=strPfDNI.substring(0,intPosLetra);
    	 	if (V50bClsValidaciones.fncValidarNumeros(parteNumeros))
    	 	{
    	 		int intDNI=Integer.parseInt(parteNumeros);
    	 		if (intDNI>0 && intDNI<=V50bClsConstantes.NOVENTAYNUEVE_MILLONES_999999)
    	 		{
    	 			intDNI%=V50bClsConstantes.VEINTITRES;
    	 			if (strCadena.charAt(intDNI) == chLetra){
    	 				boolOk=true;
    	 			}
    	 		}
    	 	}
    	 }
    	if(!boolOk){
            //errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
            errors.add(V50bClsValidaciones.ERROR_FORMATO_NAN, new ActionError(V50bClsValidaciones.ERROR_FORMATO_NAN, Q70ValidacionesCampo.getActionError(
					request, va, field)));
    	}
       	return boolOk;
    }
    
    /**
     * Comprueba que un NIF tenga un formato vlido
     * 
     * @param nif String: valor del NIF ya extrado del bean 
     * @return boolean: true si es correcto, false si no lo es
     */   
    
    private static boolean fncComprobarNIF(String nif) {
    	 String strCadena="TRWAGMYFPDXBNJZSQVHLCKE"; //Cadena predefinida para comprobar la letra    	
    	 boolean boolOk=false;
    	 int intPosLetra=nif.length()-1;
    	 char chLetra=nif.charAt(intPosLetra); 
    	 if (Character.isLetter(chLetra))
    	 {
    	 	String parteNumeros=nif.substring(0,intPosLetra);
    	 	if (V50bClsValidaciones.fncValidarNumeros(parteNumeros))
    	 	{
    	 		int intDNI=Integer.parseInt(parteNumeros);
    	 		if (intDNI>0 && intDNI<=V50bClsConstantes.NOVENTAYNUEVE_MILLONES_999999)
    	 		{
    	 			intDNI%=V50bClsConstantes.VEINTITRES;
    	 			if (strCadena.charAt(intDNI) == chLetra){
    	 				boolOk=true;
    	 			}
    	 		}
    	 	}
    	 }    	
       	return boolOk;
    }
    
    
    /**
     * Valida que la primera letra del CIF sea correcta
     * @param letra a
     * @return boolean: true si es correcto, false si no lo es
     */
    private static boolean fncComprobarLetraInicioCIF(char letra)
    {
    	String strTipoOrganizacion="ABCDEFGHKLMNPQS";
    	char[] c=strTipoOrganizacion.toCharArray();
    	for (int i=0;i<c.length-1;i++)
    	{
    		if (letra==c[i]){
    			return true;
    		}
    	}
		return false;
        }
    /**
     * Calcula el dgito de control
     * @param parteNumeros a
     * @return int: numero de digito de control
     */
    private static int fncCalculoDigito(String parteNumeros)
    {
    	char[] c=parteNumeros.toCharArray();
    	int A=0,B=0;
    	int aux;
    	String cifras;
    	char[] arrayCifras;
    	for (int i=1;i<=c.length;i++)
    	{
    		aux=Integer.parseInt(Character.toString(c[i-1]));
    		if (i%2==0)
    		{
//    			Numero par
    			A+=aux;
    		}
    		else
//    			Numero impar
    		{
    			aux= aux*2;
    			//cifras=(new Integer(aux)).toString();
    			cifras=(Integer.toString(aux));
    			arrayCifras=cifras.toCharArray();
    			B+=Integer.parseInt(Character.toString(arrayCifras[0]));
    			if (aux>=V50bClsConstantes.DIEZ){
    				B+=Integer.parseInt(Character.toString(arrayCifras[1]));
    			}
    		}
    	}
    	Integer C=new Integer(A+B);
    	String num=C.toString();
    	char dig=num.charAt(num.length()-1);    	
		return V50bClsConstantes.DIEZ-Integer.parseInt(Character.toString(dig));
        }
    /**
     * Valida que el digito de control sea correcto
     * @param digitoCalculado a
     * @param valor a
     * @return boolean: true si es correcto, false si no lo es
     */
    private static boolean fncDigitoCorrecto(int digitoCalculado,char valor)
    {
    	if (Character.isDigit(valor)){
    		int aux=Integer.parseInt(Character.toString(valor));
    		if (aux==digitoCalculado){
    			return true;
    		}
    	}else{
    		switch (digitoCalculado)
    		{
    		case 1: if (valor=='A'){
		    			return true;
		    		}
    				break;
    		case 2: if (valor=='B'){
		    			return true;
		    		}
					break;
    		case V50bClsConstantes.TRES: if (valor=='C'){
		    			return true;
		    		}
					break;
    		case V50bClsConstantes.CUATRO: if (valor=='D'){
		    			return true;
		    		}
					break;
    		case V50bClsConstantes.CINCO: if (valor=='E'){
		    			return true;
		    		}
					break;
    		case V50bClsConstantes.SEIS: if (valor=='F'){
		    			return true;
		    		}
					break;
    		case V50bClsConstantes.SIETE: if (valor=='G'){
		    			return true;
		    		}
					break;
    		case V50bClsConstantes.OCHO: if (valor=='H'){
		    			return true;
		    		}
					break;
    		case V50bClsConstantes.NUEVE: if (valor=='I'){
    					return true;
    				}
					break;
			case 0: if (valor=='J'){
						return true;
					}
					break;
			default:
					break;
			
    		}
    	}
    	return false;
    }
    
    /**
     * Valida que un CIF este en formato correcto
     * @param bean a
     * @param va a
     * @param field a
     * @param errors a
     * @param request a      
     * @return boolean: true si es correcto, false si no lo es
     */
    public static boolean fncValidarCIF(Object bean, 
    									ValidatorAction va,
										Field field, 
										ActionErrors errors, 
										HttpServletRequest request)
    {
    	String strPfCIF="";
        if (V50bClsValidaciones.isString(bean)) {
        	strPfCIF = (String) bean;
        } else {
        	strPfCIF = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        if (strPfCIF.length()==0){
        	return true;
        }
        if (strPfCIF.length()!=V50bClsConstantes.NUEVE) 
        {
        	errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
        	return false;
        }
    	 //Cadena predefinida para comprobar la letra
    	 boolean boolOk=false;
    	 int intPosDigitoControl=strPfCIF.length()-1;
    	 char chLetraTipo=strPfCIF.charAt(0);
    	 char chDigitoControl=strPfCIF.charAt(intPosDigitoControl);
    	 if (Character.isLetter(chLetraTipo) && V50bClsValidaciones.fncComprobarLetraInicioCIF(chLetraTipo))
    	 {
    		String parteNumeros=strPfCIF.substring(1,intPosDigitoControl);
     	 	if (V50bClsValidaciones.fncValidarNumeros(parteNumeros))
     	 	{
     	 		int result = V50bClsValidaciones.fncCalculoDigito(parteNumeros);
     	 		boolOk=V50bClsValidaciones.fncDigitoCorrecto(result,chDigitoControl);
     	 	}
    	 }
    	if(!boolOk){
            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    	}
       	return boolOk;
    }
    
    /**
     * Comprueba que un CIF tenga un formato vlido
     * 
     * @param cif String: valor del CIF ya extrado del bean 
     * @return boolean: true si es correcto, false si no lo es
     */   
    
    private static boolean fncComprobarCIF(String cif) {
    	boolean boolOk=false;
    	int intPosDigitoControl=cif.length()-1;
    	char chLetraTipo=cif.charAt(0);
    	char chDigitoControl=cif.charAt(intPosDigitoControl);
    	if (Character.isLetter(chLetraTipo) && V50bClsValidaciones.fncComprobarLetraInicioCIF(chLetraTipo)) {
    		String parteNumeros=cif.substring(1,intPosDigitoControl);
     	 	if (V50bClsValidaciones.fncValidarNumeros(parteNumeros)) {
     	 		int result = V50bClsValidaciones.fncCalculoDigito(parteNumeros);
     	 		boolOk=V50bClsValidaciones.fncDigitoCorrecto(result,chDigitoControl);
     	 	}
    	}
    	return boolOk;
   }
    
    /**
     * Valida un campo que pueda contener tanto NIFs, como CIFs: 
     * Este mtodo se utiliza en formularios que no contengan el atributo indFiJu, 
     * el cual se encarga de distinguir entre el tipo de identificacin (NIF O CIF)  
     * @param bean a
     * @param va a
     * @param field a
     * @param errors a
     * @param request a 
     * @return boolean: true si es correcto, false si no lo es
     */    
    public static boolean fncValidarNIFoCIF(Object bean, ValidatorAction va, 
    									Field field, ActionErrors errors,
    									HttpServletRequest request) {
    	String strPf="";
        if (V50bClsValidaciones.isString(bean)) {
        	strPf = (String) bean;
        } else {
        	strPf = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
    	if (strPf.length()==0){
    		return true;
    	}
        if (strPf.length()!=V50bClsConstantes.NUEVE) {
        	errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
        	return false;
        }
        if(V50bClsValidaciones.fncComprobarNIF(strPf)||V50bClsValidaciones.fncComprobarCIF(strPf)){
        	return true;
        }
        else {
        	errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
        	return false;        	
        }    	
    } 
    
    /**
     * Valida que un n de la seguridad social (de una persona)
     * @param bean a
     * @param va a
     * @param field a
     * @param errors a
     * @param request a 
     * @return boolean: true si es correcto, false si no lo es
     */
    public static boolean fncValidarNSSPersona(Object bean, 
												ValidatorAction va,
												Field field, 
												ActionErrors errors, 
												HttpServletRequest request)
    {
    	String strPfNSS="";
    	 if (V50bClsValidaciones.isString(bean)) {
        	strPfNSS = (String) bean;
        } else {
        	strPfNSS = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
    	if (strPfNSS.length()==0){
    		return true;
    	}
    	boolean boolOk=false;
    	if (V50bClsValidaciones.fncValidarNumeros(strPfNSS))
	 	{
    		if (strPfNSS.length()==V50bClsConstantes.DOCE)//El n debe ser de 12 digitos, si es de 11 es que el n es de empresa
    		{
    			//El formato es PPXNNNNNNNCC
    			//PP=Codigo provincia
    			//X sera 1 o 0. Si es 0, hay que quitarlo antes de hacer el calculo del digito de control 
    			//NNNNNNN=Numero de orden de la seguridad social
    			//CC= Digitos de control
    			//El modulo de PPXNNNNNNN entre 97 debe dar como resultado los digitos de control 
//    			String strTemp=strPfNSS.substring(0,2);//Tomamos el codigo de provincia
    			String strTemp="";
    			StringBuffer bufferTemp = new StringBuffer(strPfNSS.substring(0,2));
    			if (strPfNSS.charAt(2)=='0'){
    				//strTemp+=strPfNSS.substring(V50bClsConstantes.TRES,V50bClsConstantes.MAGIC_NUMBER10);
    				bufferTemp.append(strPfNSS.substring(V50bClsConstantes.TRES,V50bClsConstantes.DIEZ));//X=0, ignoramos el digito
    				strTemp=bufferTemp.toString();
    			}else if (strPfNSS.charAt(2)=='1'){
    				//strTemp+=strPfNSS.substring(2,V50bClsConstantes.MAGIC_NUMBER10);
    				bufferTemp.append(strPfNSS.substring(2,V50bClsConstantes.DIEZ));//X=1, tenemos en cuenta el digito
    				strTemp=bufferTemp.toString();
    			}else{
    				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    				return boolOk;
    			}
    			double doNum=Double.parseDouble(strTemp);
    			int intCC=Integer.parseInt(strPfNSS.substring(V50bClsConstantes.DIEZ,V50bClsConstantes.DOCE));
    			if (doNum%V50bClsConstantes.NOVENTAYSIETE==intCC){
    				boolOk=true;
    			}
    		}
	 	}
    	if(!boolOk){
            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    	}
    	return boolOk;
    }
    
    
    /**
     * Valida que un n de la seguridad social (de una empresa)
     * @param bean a
     * @param va a
     * @param field a
     * @param errors a
     * @param request a 
     * @return boolean: true si es correcto, false si no lo es
     */
    //Sin comprobar que funcione al 100%, falta hacer la prueba con un n real
    public static boolean fncValidarNSSEmpresa(Object bean, 
												ValidatorAction va,
												Field field, 
												ActionErrors errors, 
												HttpServletRequest request)
    {
    	String strPfNSS="";
    	if (V50bClsValidaciones.isString(bean)) {
       	strPfNSS = (String) bean;
       } else {
       	strPfNSS = ValidatorUtil.getValueAsString(bean, field.getProperty());
       }
    	if (strPfNSS.length()==0){
    		return true;
    	}
    	boolean boolOk=false;
    	if (V50bClsValidaciones.fncValidarNumeros(strPfNSS))
	 	{
    		if (strPfNSS.length()==V50bClsConstantes.ONCE)//El n debe ser de 12 digitos, si es de 11 es que el n es de empresa
    		{
    			//El formato es PPXNNNNNNCC
    			//PP=Codigo provincia
    			//X sera 1 o 0. Si es 0, hay que quitarlo antes de hacer el calculo del digito de control 
    			//NNNNNN=Numero de orden de la seguridad social
    			//CC= Digitos de control
    			//El modulo de PPXNNNNNN entre 97 debe dar como resultado los digitos de control 
    			//String strTemp=strPfNSS.substring(0,2);//Tomamos el codigo de provincia
    			String strTemp="";
    			StringBuffer bufferTemp = new StringBuffer(strPfNSS.substring(0,2));
    			if (strPfNSS.charAt(2)=='0'){
    				//strTemp+=strPfNSS.substring(V50bClsConstantes.TRES,V50bClsConstantes.MAGIC_NUMBER9);
    				bufferTemp.append(strPfNSS.substring(V50bClsConstantes.TRES,V50bClsConstantes.NUEVE));//X=0, ignoramos el digito
    				strTemp=bufferTemp.toString();
    			}
    			else if (strPfNSS.charAt(2)=='1'){
    				//strTemp+=strPfNSS.substring(V50bClsConstantes.MAGIC_NUMBER2,V50bClsConstantes.MAGIC_NUMBER9);
    				bufferTemp.append(strPfNSS.substring(V50bClsConstantes.DOS,V50bClsConstantes.NUEVE));//X=1, tenemos en cuenta el digito
    				strTemp=bufferTemp.toString();
    			}else{
    				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    				return boolOk;
    			}
    			double doNum=Double.parseDouble(strTemp);
    			int intCC=Integer.parseInt(strPfNSS.substring(V50bClsConstantes.NUEVE,V50bClsConstantes.ONCE));
    			if (doNum%V50bClsConstantes.NOVENTAYSIETE==intCC){
    				boolOk=true;
    			}
    		}
	 	}
    	if(!boolOk){
            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    	}
    	return boolOk;
    }
    
	 /**
     * Validacion de un numero de cuenta corriente
     * @param bean a
     * @param va a
     * @param field a
     * @param errors a
     * @param request a 
     * @return boolean: true correcto
     * 					false no es correcto
     */    
   public static boolean fncValidateNumeroCuenta(Object bean, 
		ValidatorAction va,
		Field field, 
		ActionErrors errors, 
		HttpServletRequest request)
   {
	    String nombreBean = field.getProperty();
    	String strNumeroTotal="";
    	String strNumBanco =(String)ValidatorUtil.getValueAsString(bean, nombreBean+".codBanco");
    	String strNumOficina =(String)ValidatorUtil.getValueAsString(bean, nombreBean+".codSucursal");
    	String strNumDC =(String)ValidatorUtil.getValueAsString(bean, nombreBean+".digitoControl");
    	String strNumCC =(String)ValidatorUtil.getValueAsString(bean, nombreBean+".numCuenta");
    	
    	int tamNumBanco = strNumBanco.length();
    	int tamNumOficina = strNumOficina.length();

    	StringBuffer bufferNumBanco = new StringBuffer(strNumBanco);
    	StringBuffer bufferNumOficina = new StringBuffer(strNumOficina);
    	
    	if(tamNumBanco!=0 && tamNumBanco!=V50bClsConstantes.CUATRO && tamNumBanco<V50bClsConstantes.CUATRO){
    		for(int i=1; i<V50bClsConstantes.CUATRO-tamNumBanco+1;i++){
    			//strNumBanco = "0"+strNumBanco;
    			bufferNumBanco.insert(0, "0");
    		}
    		strNumBanco=bufferNumBanco.toString();
    	}
    	if(tamNumOficina!=0 && tamNumOficina!=V50bClsConstantes.CUATRO && tamNumOficina<V50bClsConstantes.CUATRO){
    		for(int i=1; i<V50bClsConstantes.CUATRO-tamNumOficina+1;i++){
    			//strNumOficina = "0"+strNumOficina;
    			bufferNumOficina.insert(0, "0");
    		}
    		strNumOficina=bufferNumOficina.toString();
    	}

    	//el numero tiene que ser de 20 digitos
    	strNumeroTotal=strNumBanco + strNumOficina + strNumDC + strNumCC;
    	
    	if(V50bClsFunciones.fncValidarCCC(strNumeroTotal)){
    		return true;
    	} else {
    		 errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    		 return false;
    	}
    }		
   
	   /**
	    * Validacion de un numero de IBAN
	    * @param bean a
	    * @param va a
	    * @param field a
	    * @param errors a
	    * @param request a 
	    * @return boolean: true correcto
	    * 					false no es correcto
	    */    
	  public static boolean fncValidateIBAN(Object bean, 
			ValidatorAction va,
			Field field, 
			ActionErrors errors, 
			HttpServletRequest request)
	  {	   	
	   	String cuentaString =(String)ValidatorUtil.getValueAsString(bean, field.getProperty());
	   	
	   	try{
		   	if(V50bClsFunciones.fncValidarIBAN(cuentaString)){
		   		return true;
		   	} else {
		   		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
		   		return false;
		   	}
	   	}catch(Exception e){
	   		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	   		return false;
	   	}
	   }		
   
  
    
    /**
     * Comprueba si dos CP pertenecen a la misma provincia
     * 
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param request a 
     * @return boolean: true el codigo de provincia coincide
     * 					false el codigo de provincia del usuario no es correcto
     */
    public static boolean fncValidateCpConCpProvincia(Object bean, 
    		ValidatorAction va,
    		Field field, 
    		ActionErrors errors, 
    		HttpServletRequest request    		
			)
    {
    	String nombreCampo=field.getVarValue("campoAccion");
    	String valorCampo=field.getVarValue("valorAccion");
    	
    	if (GenericValidator.isBlankOrNull(nombreCampo) ||
    		GenericValidator.isBlankOrNull(valorCampo) ||
    		valorCampo.equals((String)ValidatorUtil.getValueAsString(bean, nombreCampo)) )
    	{
    		
    	
    	String strCPMunicipio;
    	StringBuffer bufferCPMunicipio = new StringBuffer();
		if(!GenericValidator.isBlankOrNull(field.getVarValue("IDPROVINCIA"))){
			strCPMunicipio = (String)ValidatorUtil.getValueAsString(bean,field.getVarValue("IDPROVINCIA"));
		}else{
			strCPMunicipio = (String)ValidatorUtil.getValueAsString(bean, "IDPROVINCIA");
		}
    	// los parametros se cojen directamente del formulario
    	String strCP =(String)ValidatorUtil.getValueAsString(bean,field.getProperty());    	
    	if ((strCPMunicipio.length()==0) || (strCP.length()==0))
    	{    		
    		return true;
    	}    	
    	if (strCPMunicipio.length()==1){
    		//strCPMunicipio="0"+strCPMunicipio+"000";
    		bufferCPMunicipio.append("0").append(strCPMunicipio).append("000");
    		strCPMunicipio=bufferCPMunicipio.toString();
    	}else if (strCPMunicipio.length()==2){
    		//strCPMunicipio=strCPMunicipio+"000";
    		bufferCPMunicipio.append(strCPMunicipio).append("000");
    		strCPMunicipio=bufferCPMunicipio.toString();
    	}
    	//si no son numericos, no son correctos    	
    	if(!V50bClsValidaciones.fncValidarNumeros(strCP))
    	{
    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    		return false;
    	}
    	if(!V50bClsValidaciones.fncValidarNumeros(strCPMunicipio))
    	{
    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    		return false;
    	}
    	if (!(strCPMunicipio.length()==V50bClsConstantes.CINCO) || !(strCP.length()==V50bClsConstantes.CINCO))
    	{
    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    		return false;
    	}
    	
    	//Comparo los dos primeros caracteres, a ver si el codigo coincide
    	String strCMunicipio=String.valueOf(strCP.charAt(0))+String.valueOf(strCP.charAt(1));
    	String strcUsuario=String.valueOf(strCPMunicipio.charAt(0))+String.valueOf(strCPMunicipio.charAt(1));
    	if(strCMunicipio.equals(strcUsuario)){
    		return true;
    	}else{
    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    		return false;
    	}
    	
    	}else{
    		return true;
    	}
    }   
    /**
     * Validacion de un numero de telefono
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param request a 
     * @return boolean: true correcto
     * 					false no es correcto
     */
    public static boolean fncValidarTelefono(Object bean, 
											ValidatorAction va,
											Field field, 
											ActionErrors errors, 
											HttpServletRequest request)
    {
    	
       	String strtel="";
    	if (V50bClsValidaciones.isString(bean)) {
           	strtel = (String) bean;
        }else 
        {
           strtel = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
    	if (strtel.length()==0 ||(strtel.length() == V50bClsConstantes.NUEVE && V50bClsValidaciones.fncValidarNumeros(strtel))){
    		return true;
    	}
    	errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));    
    	return false;
    }
    
    private static final String	PROTOCOL_PATTERN	= "((http|https|HTTP|HTTPS)\\://)?";
	private static final String	HOST_PATTERN		= "(www|WWW)([0-9])?(\\.[\\w&&[\\D]][\\w\\-]*)+(\\:(\\d){1,5})?";
	private static final String	FILE_PATTERN		= "(/[\\w&&[\\D]][\\w\\-&&[^\\.]]*)*(\\.([\\w&&[\\D]][\\w&&[^\\.]]*))?";
	private static final String	URL_PATTERN			= V50bClsValidaciones.PROTOCOL_PATTERN
															+ V50bClsValidaciones.HOST_PATTERN
															+ V50bClsValidaciones.FILE_PATTERN;
    
    /**
	 * Validacion de una pgina web
	 * 
	 * @param bean
	 *            a
	 * @param va
	 *            a
	 * @param field
	 *            a
	 * @param errors
	 *            a
	 * @param request
	 *            a
	 * @return boolean: true correcto false no es correcto
	 */
	public static boolean fncValidarPaginaWeb(Object bean, ValidatorAction va,
			Field field, ActionErrors errors, HttpServletRequest request) {
		boolean esValido = true;
		try {
			String strPagWeb = ValidatorUtil.getValueAsString(bean, field
					.getProperty());

			if (!StringUtils.isEmpty(strPagWeb)) {
				StringBuffer urlPatternBuffer = new StringBuffer();
				urlPatternBuffer.append(V50bClsValidaciones.PROTOCOL_PATTERN)
						.append(V50bClsValidaciones.HOST_PATTERN).append(
								V50bClsValidaciones.FILE_PATTERN);
				Pattern pattern = Pattern
						.compile(V50bClsValidaciones.URL_PATTERN);
				Matcher matcher = pattern.matcher(strPagWeb.trim());
				esValido = matcher.matches();
			}
		} catch (Exception e) {
			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(
					request, va, field));
			return false;
		}
		
		if (!esValido) {
			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(
					request, va, field));
		}
		return esValido;
	}
    
    
    /**
	 * Validacion de territorio historico si el pas es Espaa o nulo
	 * 
	 * @param bean
	 *            a
	 * @param va
	 *            a
	 * @param field
	 *            a
	 * @param errors
	 *            a
	 * @param request
	 *            a
	 * @return boolean: true correcto false no es correcto
	 */
    public static boolean fncValidarRequiredPais(Object bean, 
			ValidatorAction va,
			Field field, 
			ActionErrors errors, 
			HttpServletRequest request)
	{
    	boolean esValido = false;
    	try {
    	
    	String nombreCampo=field.getVarValue("campoAccion");
    	String valorCampo=field.getVarValue("valorAccion");
    	
    	if (GenericValidator.isBlankOrNull(nombreCampo) ||
    		GenericValidator.isBlankOrNull(valorCampo) ||
    		valorCampo.equals((String)ValidatorUtil.getValueAsString(bean, nombreCampo)) )
    	{
	    	String value = null;
	        if(V50bClsValidaciones.isString(bean)){
	            value = (String)bean;
	        }else{
	            value = ValidatorUtil.getValueAsString(bean, field.getProperty());
	        }
			String valorNulo;
			if(!GenericValidator.isBlankOrNull(field.getVarValue("valorNulo"))){
					valorNulo = field.getVarValue("valorNulo");
			}else{
				valorNulo = "";
			}
			String valorEspana;
			if(!GenericValidator.isBlankOrNull(field.getVarValue("valorEspaa"))){
				valorEspana = field.getVarValue("valorEspaa");
			}else{
				valorEspana="108";
			}
			String pais;
			if(!GenericValidator.isBlankOrNull(field.getVarValue("pais"))){
				pais = (String)ValidatorUtil.getValueAsString(bean, field.getVarValue("pais"));
			}else{
				errors.add(field.getKey(),new ActionError("Error en el fichero de validaciones: Faltan parametros para validar el TH")); 
				return esValido;
			}
				
			if (pais.equals(valorNulo) || pais.equals(valorEspana))
			{
				if (GenericValidator.isBlankOrNull(value))
				{
					errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
					return esValido;
				}
				
			}			
			return true;
    	}else{
    		return true;
    	}
		} catch (Exception e) {     
			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
			return esValido;
		}
		
	}
    
    /**
     * Validacion de un nmero, si es menor que otro o no
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param request a
     * @return boolean: true correcto
     * 					false no es correcto
     */
    public static boolean fncEsNumMenor(Object bean, 
			ValidatorAction va,
			Field field, 
			ActionErrors errors, 
			HttpServletRequest request)
	{
    	boolean esValido = false;
    	try {
    	
    	String max=field.getVarValue("maximoValor");
    	String num= ValidatorUtil.getValueAsString(bean, field.getProperty());
    		
    	if (GenericValidator.isBlankOrNull(max) || GenericValidator.isBlankOrNull(num) ){
    		esValido= true;
    	}else if(V50bClsValidaciones.fncValidarNumeros(max)&&V50bClsValidaciones.fncValidarNumeros(num)&&(Integer.parseInt(max)>=Integer.parseInt(num))){
    		esValido= true;
    	}else{
    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    	}
    	return esValido;	
		} catch (Exception e) {     
			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
			return esValido;
		}
		
	}
    
    /**
     * Validacion de un nmero, si es menor que otro o no
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param request a
     * @return boolean: true correcto
     * 					false no es correcto
     */
    public static boolean fncValidarImporte(Object bean, 
			ValidatorAction va,
			Field field, 
			ActionErrors errors, 
			HttpServletRequest request)
	{
    	boolean esValido = false;
    	try {
    	String max=field.getVarValue("maximoValor");
    	String importe= ValidatorUtil.getValueAsString(bean, field.getProperty());
    	if (importe!=null && !importe.equals(""))
    	{
    		importe=importe.replace('.',',');
	    	StringTokenizer stk= new StringTokenizer(importe,",");
			String num = null;
			String decimales = "0";
			if (stk.hasMoreTokens()){
				num=stk.nextToken();
			}
			if (stk.hasMoreTokens()){
				decimales=stk.nextToken();
			}
			String nombreCampo=field.getVarValue("campoAccion");
	    	String nombreCampo1=(String)ValidatorUtil.getValueAsString(bean, nombreCampo);
	    	
	    	if (GenericValidator.isBlankOrNull(max) || GenericValidator.isBlankOrNull(num) || (!"guardar".equals(nombreCampo1) &&!"guardarAutof".equals(nombreCampo1))){
	    		esValido= true;
	    	}
	    	else if(V50bClsValidaciones.fncValidarNumeros(max)&&V50bClsValidaciones.fncValidarNumeros(num)&&V50bClsValidaciones.fncValidarNumeros(decimales)&&(Long.parseLong(max)>(Long.parseLong(num)))){
	    		esValido= true;
	    	}
	    	else{
	    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	    	}
    	}
    	else{
    		esValido = true;
    	}
    	return esValido;	
		} catch (Exception e) {     
			e.printStackTrace();
			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
			return esValido;
		}
		
	}
    
    /**
     * Validacion de un nmero, si es menor que otro o no
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param request a
     * @return boolean: true correcto false no es correcto
     * @throws Exception ex
     */
    public static boolean fncValidarRespuestaHTML(Object bean, 
			ValidatorAction va,
			Field field, 
			ActionErrors errors, 
			HttpServletRequest request) throws Exception{
    	boolean esValido = false;
    	    	
    	String max =field.getVarValue("field[0]");
    	String respuestaHTML = ValidatorUtil.getValueAsString(bean, field.getProperty());
    	
    	/*String respuesta = Normalizer.normalize(respuestaHTML, Normalizer.DECOMP, 0).toUpperCase()
    							.replaceAll("<[^<]+?>", "")
    							.replaceAll("&NBSP;", "")
    							.replaceAll("&LT;", "<")
    							.replaceAll("&GT;", ">");*/
    	
    	String respuesta = V50bClsFunciones.fncNormalizarCadena(respuestaHTML).toUpperCase()
		.replaceAll("<[^<]+?>", "")
		.replaceAll("&NBSP;", "")
		.replaceAll("&LT;", "<")
		.replaceAll("&GT;", ">");
    	
    	if(respuesta.length()>Integer.parseInt(max)){
    		esValido = false;
    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    	} else {
    		esValido = true;
    	}
    	
    	return esValido;
	}
    
    /**
     * Validacion de 2 horas que comprueba que una es anterior a la otra (desde-hasta)
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param validator a
	 * @param request a
     * @return boolean: true fechas correcta
     *                  false fechas incorrectas
     */
   /* public static String fncValidarHoraMenor(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request){
    	
    	if(V50bClsValidaciones.tr.isTraceActive()){
        	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fncValidarHoraMenor");
        }
        String strHoraDesde = "";
        if(V50bClsValidaciones.isString(bean)){
        	strHoraDesde = (String)bean;
        }else{
            strFecDesde = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        Object form = validator.getResource(Validator.BEAN_KEY);
        String horahasta = field.getVarValue("field[0]");
        
        int calDesde = 0;
        int calHasta = 0;
        Date bResultado = null;
            if (bolFechaEu) {
                try {
                    bResultado = V50bClsFecha.fncFormatearFecha(strFecHasta,
                            V50bClsConstantes.CONSTANTE_EUSKARA);
                } catch (Exception e) {
                    if (V50bClsValidaciones.tr.isTraceActive()) {
                    	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR,
                                "ERROR al formatear fecha en euskera: " + e);
                    }
                }
            } else {
                if (V50bClsValidaciones.tr.isTraceActive()) {
                	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fecha erronea");
                }
            }

        	boolean bolFechaEs = V50bClsValidaciones.fncValidarFechaEs(strFecHasta);
            
            if (bolFechaEs) {
                try {
                    bResultado = V50bClsFecha.fncFormatearFecha(strFecHasta,
                            V50bClsConstantes.CONSTANTE_CASTELLANO);
                } catch (Exception e) {
                    if (V50bClsValidaciones.tr.isTraceActive()) {
                    	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR,
                                "ERROR al formatear fecha en castellano: " + e);
                    }
                }
            } else {
                if (V50bClsValidaciones.tr.isTraceActive()) {
                	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fecha erronea");
                }
            }
        
        if(bResultado!=null)
        {
	        if ((strFecDesde!=null)&&(strFecHasta!=null)&&(!strFecDesde.equals(""))&&(!strFecHasta.equals("")))
	        {
		        try{
		        	StringBuffer bufferFecDesde = new StringBuffer(V50bClsFecha.fncFormateaFecha(strFecDesde,strIdioma));
		        	StringBuffer bufferFecHasta = new StringBuffer(V50bClsFecha.fncFormateaFecha(strFecHasta,strIdioma));
		        	//strFecDesde = V50bClsFecha.fncFormateaFecha(strFecDesde,strIdioma);
		        	//strFecHasta = V50bClsFecha.fncFormateaFecha(strFecHasta,strIdioma);
		        	strFecDesde = bufferFecDesde.toString();
		        	strFecHasta = bufferFecHasta.toString();
		        
		        int intAnyo;
		        int intMes;
		        int intDia;
		        int intAnyoHasta;
		        int intMesHasta;
		        int intDiaHasta;
		       
		        intDia = Integer.parseInt(strFecDesde.substring(0, 2));
	            intMes = Integer.parseInt(strFecDesde.substring(V50bClsConstantes.TRES, CINCO));
	            intAnyo = Integer.parseInt(strFecDesde.substring(V50bClsConstantes.MAGIC_NUMBER6, V50bClsConstantes.MAGIC_NUMBER10));
	            intDiaHasta = Integer.parseInt(strFecHasta.substring(0, 2));
	            intMesHasta = Integer.parseInt(strFecHasta.substring(V50bClsConstantes.TRES, CINCO));
	            intAnyoHasta = Integer.parseInt(strFecHasta.substring(V50bClsConstantes.MAGIC_NUMBER6, V50bClsConstantes.MAGIC_NUMBER10));
		        
		        calDesde = (new Integer(V50bClsFunciones.fncCalculaFechaJulianaK81(intDia,intMes,intAnyo)).intValue());
		        calHasta = (new Integer(V50bClsFunciones.fncCalculaFechaJulianaK81(intDiaHasta,intMesHasta,intAnyoHasta)).intValue());
		        }
		        catch(Exception e){
		        	 errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
		        	 return "";
		        }
	        }
	        
	        boolean bolRetorno = true;

		    if ((strFecDesde!=null)&&(strFecHasta!=null)&&(!strFecDesde.equals(""))&&(!strFecHasta.equals(""))&&(calDesde>calHasta)){
	        	bolRetorno = false;
		    }else{
	            bolRetorno = true;
		    }
	        if(!bolRetorno){
	            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	        }

        }
        
	    

        return strFecDesde;
    }*/
    
    
    /**
     * Validacion de 2 fechas que comprueba que una es anterior a la otra (desde-hasta)
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param validator a
	 * @param request a
     * @return boolean: true fechas correcta
     *                  false fechas incorrectas
     */
    public static String fncValidarFechaMenor(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request)
    {
        if(V50bClsValidaciones.tr.isTraceActive()){
        	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fncValidarFechaMenor");
        }
        String strFecDesde = "";
        if(V50bClsValidaciones.isString(bean)){
            strFecDesde = (String)bean;
        }else{
            strFecDesde = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        Object form = validator.getResource(Validator.BEAN_KEY);
        String dependProp = field.getVarValue("field[0]");
        String strFecHasta = ValidatorUtil.getValueAsString(form, dependProp);
        String strIdioma = Q70ListenerUtils.getLanguage(request);
        
        int calDesde = 0;
        int calHasta = 0;
        Date bResultado = null;
        if (strIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA)
                && !StringUtils.isEmpty(strFecHasta)) {
            boolean bolFechaEu = V50bClsValidaciones.fncValidarFechaEu(strFecHasta);
            
            if (bolFechaEu) {
                try {
                    bResultado = V50bClsFecha.fncFormatearFecha(strFecHasta,
                            V50bClsConstantes.CONSTANTE_EUSKARA);
                } catch (Exception e) {
                    if (V50bClsValidaciones.tr.isTraceActive()) {
                    	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR,
                                "ERROR al formatear fecha en euskera: " + e);
                    }
                }
            } else {
                if (V50bClsValidaciones.tr.isTraceActive()) {
                	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fecha erronea");
                }
            }

        } else if (strIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO)) {
        	boolean bolFechaEs = V50bClsValidaciones.fncValidarFechaEs(strFecHasta);
            
            if (bolFechaEs) {
                try {
                    bResultado = V50bClsFecha.fncFormatearFecha(strFecHasta,
                            V50bClsConstantes.CONSTANTE_CASTELLANO);
                } catch (Exception e) {
                    if (V50bClsValidaciones.tr.isTraceActive()) {
                    	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR,
                                "ERROR al formatear fecha en castellano: " + e);
                    }
                }
            } else {
                if (V50bClsValidaciones.tr.isTraceActive()) {
                	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fecha erronea");
                }
            }
        }
        
        if(bResultado!=null)
        {
	        if (!StringUtils.isEmpty(strFecDesde) && !StringUtils.isEmpty(strFecHasta))
	        {
		        try{
		        	StringBuffer bufferFecDesde = new StringBuffer(V50bClsFecha.fncFormateaFecha(strFecDesde,strIdioma));
		        	StringBuffer bufferFecHasta = new StringBuffer(V50bClsFecha.fncFormateaFecha(strFecHasta,strIdioma));
		        	//strFecDesde = V50bClsFecha.fncFormateaFecha(strFecDesde,strIdioma);
		        	//strFecHasta = V50bClsFecha.fncFormateaFecha(strFecHasta,strIdioma);
		        	strFecDesde = bufferFecDesde.toString();
		        	strFecHasta = bufferFecHasta.toString();
		        
		        int intAnyo;
		        int intMes;
		        int intDia;
		        int intAnyoHasta;
		        int intMesHasta;
		        int intDiaHasta;
		       
		        intDia = Integer.parseInt(strFecDesde.substring(0, 2));
	            intMes = Integer.parseInt(strFecDesde.substring(V50bClsConstantes.TRES, V50bClsConstantes.CINCO));
	            intAnyo = Integer.parseInt(strFecDesde.substring(V50bClsConstantes.SEIS, V50bClsConstantes.DIEZ));
	            intDiaHasta = Integer.parseInt(strFecHasta.substring(0, 2));
	            intMesHasta = Integer.parseInt(strFecHasta.substring(V50bClsConstantes.TRES, V50bClsConstantes.CINCO));
	            intAnyoHasta = Integer.parseInt(strFecHasta.substring(V50bClsConstantes.SEIS, V50bClsConstantes.DIEZ));
		        
		        calDesde = (new Integer(V50bClsFunciones.fncCalculaFechaJulianaK81(intDia,intMes,intAnyo)).intValue());
		        calHasta = (new Integer(V50bClsFunciones.fncCalculaFechaJulianaK81(intDiaHasta,intMesHasta,intAnyoHasta)).intValue());
		        }
		        catch(Exception e){
		        	 errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
		        	 return "";
		        }
	        }
	        
	        boolean bolRetorno = true;

		    if (!StringUtils.isEmpty(strFecDesde) && !StringUtils.isEmpty(strFecHasta) && (calDesde>calHasta)){
	        	bolRetorno = false;
		    }else{
	            bolRetorno = true;
		    }
	        if(!bolRetorno){
	            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	        }

        }
        
	    

        return strFecDesde;
    }
    
    
    
    
    /**
     * Validacion de 2 fechas que comprueba que una es anterior a la otra (desde-hasta)
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param validator a
	 * @param request a
     * @return boolean: true fechas correcta
     *                  false fechas incorrectas
     */
    public static String fncValidarFechaMayorHoy(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request)
    {
        if(V50bClsValidaciones.tr.isTraceActive()){
        	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fncValidarFechaMayorHoy");
        }
        String strFecDesde = "";
        if(V50bClsValidaciones.isString(bean)){
            strFecDesde = (String)bean;
        }else{
            strFecDesde = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        
        Object form = validator.getResource(Validator.BEAN_KEY);
        String dependProp = field.getVarValue("field[0]");
        String estado = ValidatorUtil.getValueAsString(form, dependProp);
        
        if (estado.equals(V50bClsConstantes.CONSTANTE_ACTIVA)) {
	        Calendar c1 = Calendar.getInstance();
			String dia = Integer.toString(c1.get(Calendar.DATE));
			String mes = Integer.toString(c1.get(Calendar.MONTH)+1);
			String anio = Integer.toString(c1.get(Calendar.YEAR));
			StringBuffer fechaHoy = new StringBuffer(V50bClsConstantes.DIEZ);
			
			String strIdioma = Q70ListenerUtils.getLanguage(request);
			
			if (strIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO)) {
				fechaHoy.append(dia);
				fechaHoy.append("/");
				fechaHoy.append(mes);
				fechaHoy.append("/");
				fechaHoy.append(anio);
			} else if (strIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA)) {
				fechaHoy.append(anio);
				fechaHoy.append("/");
				fechaHoy.append(mes);
				fechaHoy.append("/");
				fechaHoy.append(dia);
			}
			
			String fechaDeHoy = fechaHoy.toString();
			Date fechaHoyF = null;
			String strFecHasta = "";
			try {
				fechaHoyF = V50bClsFecha.fncFormatearFecha(fechaDeHoy,strIdioma);
				strFecHasta = fechaHoyF.toString();
			} catch (Exception e) {
	            if (V50bClsValidaciones.tr.isTraceActive()) {
	            	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR,
	                        "ERROR al formatear fecha en castellano: " + e);
	            }
	        }
	
	        int intDesde = 0;
	        int intHasta = 0;
	   
	        if(fechaHoyF!=null)
	        {
		        if (!StringUtils.isEmpty(strFecDesde) && !StringUtils.isEmpty(strFecHasta))
		        {
			        try{
			        	StringBuffer sbFecDesde = new StringBuffer(V50bClsFecha.fncFormateaFecha(strFecDesde,strIdioma));
			        	StringBuffer sbFecHasta = new StringBuffer(V50bClsFecha.fncFormateaFecha(fechaDeHoy,strIdioma));
			        	//strFecDesde = V50bClsFecha.fncFormateaFecha(strFecDesde,strIdioma);
			        	//strFecHasta = V50bClsFecha.fncFormateaFecha(strFecHasta,strIdioma);
			        	strFecDesde = sbFecDesde.toString();
			        	strFecHasta = sbFecHasta.toString();
			        
			        int numAnyo;
			        int numMes;
			        int numDia;
			        int numAnyoHasta;
			        int numMesHasta;
			        int numDiaHasta;
			       
			        numDia = Integer.parseInt(strFecDesde.substring(0, 2));
			        numMes = Integer.parseInt(strFecDesde.substring(V50bClsConstantes.TRES, V50bClsConstantes.CINCO));
			        numAnyo = Integer.parseInt(strFecDesde.substring(V50bClsConstantes.SEIS, V50bClsConstantes.DIEZ));
			        numDiaHasta = Integer.parseInt(strFecHasta.substring(0, 2));
		            numMesHasta = Integer.parseInt(strFecHasta.substring(V50bClsConstantes.TRES, V50bClsConstantes.CINCO));
		            numAnyoHasta = Integer.parseInt(strFecHasta.substring(V50bClsConstantes.SEIS, V50bClsConstantes.DIEZ));
			        
		            intDesde = (new Integer(V50bClsFunciones.fncCalculaFechaJulianaK81(numDia,numMes,numAnyo)).intValue());
		            intHasta = (new Integer(V50bClsFunciones.fncCalculaFechaJulianaK81(numDiaHasta,numMesHasta,numAnyoHasta)).intValue());
			        }
			        catch(Exception e){
			        	 errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
			        	 return "";
			        }
		        }
		        
		        boolean bolRetorno = true;
	
			    if (!StringUtils.isEmpty(strFecDesde) && !StringUtils.isEmpty(strFecHasta) && (intDesde<intHasta)){
		        	bolRetorno = false;
			    }else{
		            bolRetorno = true;
			    }
		        if(!bolRetorno){
		            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
		        }
	
	        }
        }

        return strFecDesde;
    }
    
    /**
     * Validacion de 2 fechas que comprueba que una es anterior a la otra (desde-hasta)
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param validator a
	 * @param request a
     * @return boolean: true fechas correcta
     *                  false fechas incorrectas
     */
    public static String fncValidarFechaMenorHoy(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request)
    {
        if(V50bClsValidaciones.tr.isTraceActive()){
        	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fncValidarFechaMenorHoy");
        }
        String strFecDesde = "";
        if(V50bClsValidaciones.isString(bean)){
            strFecDesde = (String)bean;
        }else{
            strFecDesde = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        
        Calendar c1 = Calendar.getInstance();
		String dia = Integer.toString(c1.get(Calendar.DATE));
		String mes = Integer.toString(c1.get(Calendar.MONTH)+1);
		String anio = Integer.toString(c1.get(Calendar.YEAR));
		StringBuffer fechaHoy = new StringBuffer(V50bClsConstantes.DIEZ);
		
		String strIdioma = Q70ListenerUtils.getLanguage(request);
		
		if (strIdioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO)) {
			fechaHoy.append(dia);
			fechaHoy.append("/");
			fechaHoy.append(mes);
			fechaHoy.append("/");
			fechaHoy.append(anio);
		} else if (strIdioma.equals(V50bClsConstantes.CONSTANTE_EUSKARA)) {
			fechaHoy.append(anio);
			fechaHoy.append("/");
			fechaHoy.append(mes);
			fechaHoy.append("/");
			fechaHoy.append(dia);
		}
			
		String fechaDeHoy = fechaHoy.toString();
		Date fechaHoyF = null;
		String strFecHasta = "";
		try {
			fechaHoyF = V50bClsFecha.fncFormatearFecha(fechaDeHoy,strIdioma);
			strFecHasta = fechaHoyF.toString();
		} catch (Exception e) {
            if (V50bClsValidaciones.tr.isTraceActive()) {
            	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.ERROR,
                        "ERROR al formatear fecha en castellano: " + e);
            }
        }
	
        int intDesde = 0;
        int intHasta = 0;
	   
        if(fechaHoyF!=null)
        {
	        if (!StringUtils.isEmpty(strFecDesde) && !StringUtils.isEmpty(strFecHasta))
	        {
		        try{
		        	StringBuffer sbFecDesde = new StringBuffer(V50bClsFecha.fncFormateaFecha(strFecDesde,strIdioma));
		        	StringBuffer sbFecHasta = new StringBuffer(V50bClsFecha.fncFormateaFecha(fechaDeHoy,strIdioma));
		        	//strFecDesde = V50bClsFecha.fncFormateaFecha(strFecDesde,strIdioma);
		        	//strFecHasta = V50bClsFecha.fncFormateaFecha(strFecHasta,strIdioma);
		        	strFecDesde = sbFecDesde.toString();
		        	strFecHasta = sbFecHasta.toString();
			        
		        int numAnyo;
		        int numMes;
		        int numDia;
		        int numAnyoHasta;
		        int numMesHasta;
		        int numDiaHasta;
		       
		        numDia = Integer.parseInt(strFecDesde.substring(0, 2));
		        numMes = Integer.parseInt(strFecDesde.substring(V50bClsConstantes.TRES, V50bClsConstantes.CINCO));
		        numAnyo = Integer.parseInt(strFecDesde.substring(V50bClsConstantes.SEIS, V50bClsConstantes.DIEZ));
		        numDiaHasta = Integer.parseInt(strFecHasta.substring(0, 2));
	            numMesHasta = Integer.parseInt(strFecHasta.substring(V50bClsConstantes.TRES, V50bClsConstantes.CINCO));
	            numAnyoHasta = Integer.parseInt(strFecHasta.substring(V50bClsConstantes.SEIS, V50bClsConstantes.DIEZ));
			        
	            intDesde = (new Integer(V50bClsFunciones.fncCalculaFechaJulianaK81(numDia,numMes,numAnyo)).intValue());
	            intHasta = (new Integer(V50bClsFunciones.fncCalculaFechaJulianaK81(numDiaHasta,numMesHasta,numAnyoHasta)).intValue());
		        }
		        catch(Exception e){
		        	 errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
		        	 return "";
		        }
	        }
		        
	        boolean bolRetorno = true;
	
		    if (!StringUtils.isEmpty(strFecDesde) && !StringUtils.isEmpty(strFecHasta) && (intDesde>intHasta)){
	        	bolRetorno = false;
		    }else{
	            bolRetorno = true;
		    }
	        if(!bolRetorno){
	            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	        }
	
        }

        return strFecDesde;
    }
    
    
    /**
	 * Validacion de 2 horas que comprueba que una es anterior a la otra
	 * (desde-hasta)
	 * 
	 * @param bean
	 *            a
	 * @param va
	 *            a
	 * @param field
	 *            a
	 * @param errors
	 *            a
	 * @param validator
	 *            a
	 * @param request
	 *            a
	 * @return boolean: true fechas correcta false fechas incorrectas
	 */
	public static String fncValidarHoraMenor(Object bean, ValidatorAction va,
			Field field, ActionErrors errors, Validator validator,
			HttpServletRequest request) {
		if (V50bClsValidaciones.tr.isTraceActive()) {
			V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE,
					Q70TraceLevel.INFO, "fncValidarHoraMenor");
		}
		
		String horaDesde = (V50bClsValidaciones.isString(bean)) ? ((String) bean)
				: ValidatorUtil.getValueAsString(bean, field.getProperty());
		Object form = validator.getResource(Validator.BEAN_KEY);
		String dependProp = field.getVarValue("field[0]");
		String horaHasta = ValidatorUtil.getValueAsString(form, dependProp);
		
		try {
			StringTokenizer horaDesdeTokenizer = new StringTokenizer(horaDesde,":");
			int horaDesdeHora = Integer.parseInt(horaDesdeTokenizer.nextToken());
			int horaDesdeMinuto = Integer.parseInt(horaDesdeTokenizer.nextToken());
			StringTokenizer horaHastaTokenizer = new StringTokenizer(horaHasta,":");
			int horaHastaHora = Integer.parseInt(horaHastaTokenizer.nextToken());
			int horaHastaMinuto = Integer.parseInt(horaHastaTokenizer.nextToken());
			
			boolean error = false;
			if (horaDesdeHora < horaHastaHora) {
				error = false;
			} else if (horaDesdeHora > horaHastaHora) {
				error = true;
			} else if (horaDesdeMinuto > horaHastaMinuto){
				error = true;
			}
			
			if (error) {
				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(
						request, va, field));
			}
			
		} catch (Exception e) {
			if (V50bClsValidaciones.tr.isTraceActive()) {
				V50bClsValidaciones.tr.trace(
						V50bClsValidaciones.COMPONENTE,
						Q70TraceLevel.ERROR,
						"ERROR al tratar hora: " + e);
			}
		}
		
		return (horaDesde);
	}
    
    /**
	 * Validacion de 2 horas que comprueba que una es anterior a la otra
	 * (desde-hasta) y a su vez menor a otro par desde-hasta
	 * 
	 * @param bean
	 *            a
	 * @param va
	 *            a
	 * @param field
	 *            a
	 * @param errors
	 *            a
	 * @param validator
	 *            a
	 * @param request
	 *            a
	 * @return boolean: true horas correcta false horas incorrectas
	 */
    public static String fncValidarHorasMenor(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request)
    {
        if(V50bClsValidaciones.tr.isTraceActive()){
        	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fncValidarFechaMenor");
        }
        String strHoraDesde = "";
        if(V50bClsValidaciones.isString(bean)){
            strHoraDesde = (String)bean;
        }else{
            strHoraDesde = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        Object form = validator.getResource(Validator.BEAN_KEY);
        
        //String strIdioma = Q70ListenerUtils.getLanguage(request);
        String strHoraHasta = ValidatorUtil.getValueAsString(form, field.getVarValue("field[0]"));
        
        float horaInicioMan = (strHoraDesde!=null && !strHoraDesde.equals(""))?Float.parseFloat(strHoraDesde.substring(0,2)):0;
		float minInicioMan = (strHoraDesde!=null && !strHoraDesde.equals(""))?Float.parseFloat(strHoraDesde.substring(V50bClsConstantes.TRES,V50bClsConstantes.CINCO)):0;
		float horaFinMan = (strHoraHasta!=null && !strHoraHasta.equals(""))?Float.parseFloat(strHoraHasta.substring(0,2)):0;
		float minFinMan = (strHoraHasta!=null && !strHoraHasta.equals(""))?Float.parseFloat(strHoraHasta.substring(V50bClsConstantes.TRES,V50bClsConstantes.CINCO)):0;		
		
		float inicioMan= (horaInicioMan*V50bClsConstantes.SESENTA)+minInicioMan;
		float finMan= (horaFinMan*V50bClsConstantes.SESENTA)+minFinMan;
				
        boolean bolRetorno = true;
        
        if((strHoraDesde!=null)&&(strHoraHasta!=null)&&(!strHoraDesde.equals(""))&&(!strHoraHasta.equals(""))&&(inicioMan>=finMan)){
        	bolRetorno=false;
        }
        if(!bolRetorno){
        	errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
        }
        return strHoraDesde;
    }
    
    /**
     * Validacion de 2 horas que comprueba que una es anterior a la otra (desde-hasta) y a su vez menor a otro par desde-hasta
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param validator a
	 * @param request a
     * @return boolean: true horas correcta
     *                  false horas incorrectas
     */
    public static boolean fncIntegerIf(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request)
    {
        if(V50bClsValidaciones.tr.isTraceActive()){
        	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fncIntegerIf");
        }
        String nif = "";
        if(V50bClsValidaciones.isString(bean)){
            nif = (String)bean;
        }else{
        	nif = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }
        //Object form = validator.getResource(Validator.BEAN_KEY);
        
        //String strIdioma = Q70ListenerUtils.getLanguage(request);
        
        	boolean rdo = V50bClsValidaciones.fncValidarNumerosJava(nif);
        	
        	if(rdo){
        		return true;
        	}else{
        		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
        		return false;
        	}
    }   
    
    /**
     * Valida que haya un par de Horas (desde-hasta) Completo
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param validator a
	 * @param request a
     * @return boolean: true horas correcta
     *                  false horas incorrectas
     */
    public static String fncParHorasCurso(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request)
    {
    	Object form = validator.getResource(Validator.BEAN_KEY);
    	if(V50bClsValidaciones.tr.isTraceActive()){
    		V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fncParHorasCurso");
    	}
        String strHD = ValidatorUtil.getValueAsString(form, field.getVarValue("field[0]"));
        String strHH = ValidatorUtil.getValueAsString(form, field.getVarValue("field[1]"));
        String strHDT = ValidatorUtil.getValueAsString(form, field.getVarValue("field[2]"));
        String strHHT = ValidatorUtil.getValueAsString(form, field.getVarValue("field[3]"));
        String strAccion = ValidatorUtil.getValueAsString(form, field.getVarValue("field[4]"));
        String strHoras= "";
        if(V50bClsValidaciones.isString(bean)){
        	strHoras = (String)bean;
        }else{
        	strHoras = ValidatorUtil.getValueAsString(bean, field.getProperty());
        }		
       
        boolean bolRetorno = true;
       
       if("guardar".equals(strAccion)&&("true".equals(strHoras)))
       {
    	   if ("".equals(strHD)&& "".equals(strHH)&& "".equals(strHDT)&& "".equals(strHHT)){
    		   bolRetorno=false;
    	   }
    	   if (("".equals(strHD)&& (!"".equals(strHH)))||(!"".equals(strHD))&& ("".equals(strHH))){
    		   bolRetorno=false;
    	   }
    	   if (("".equals(strHDT)&& (!"".equals(strHHT)))||(!"".equals(strHDT))&& ("".equals(strHHT))){
    		   bolRetorno=false;
    	   }
       }
       
        if(!bolRetorno){
        	errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
        }
        return strHoras;
    }   
    
    
    /**
     * Validacion de una hora con el formato HH:MM
     * 
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param request a
     * @return boolean: true correcto
     * 					false no es correcto
     */
    public static boolean validateTime(Object bean, 
											ValidatorAction va,
											Field field, 
											ActionErrors errors, 
											HttpServletRequest request)
    {
    	boolean esValido = true;
        try {
            String strHora= ValidatorUtil.getValueAsString(bean, field.getProperty());
            String ptos=":";
            if((strHora!=null)&&(!strHora.equals("")))
            {
            	
            	if ((strHora.indexOf(ptos)==2)&&(strHora.length()==V50bClsConstantes.CINCO))
            	{
            		String strHoras = strHora.substring(0,2);
            		Pattern p = Pattern.compile("^[0-2]?[0-9]:[0-5][0-9]$");
        			Matcher m = p.matcher(strHora);
        			boolean found = m.find();
            		if ((!found)||((Integer.parseInt(String.valueOf(strHoras))>V50bClsConstantes.VEINTITRES))){
		            	esValido=false;
		            	errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
            		}
            	}
            	else
            	{
            		esValido=false;
	            	errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
            	}
            } 
        } catch (Exception e) {     
            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
            return false;
        }
        return esValido;
    }
    
    /**
     * Validacion de uan serie de campos, en el q al menos uno debe tener 3 o ms caracteres.
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param request a       
     * @return boolean: true correcto
     * 					false no es correcto
     */  
    public static boolean fncValidarMinCarateres(Object bean, 
			ValidatorAction va,
			Field field, 
			ActionErrors errors, 
			HttpServletRequest request)
    {
    	try {
    		String valor;
    		String accion=ValidatorUtil.getValueAsString(bean,(String)field.getVarValue("nomAccion"));
    		
    		HttpSession session = request.getSession();
    		Q70ContextoEJIE contexto = (Q70ContextoEJIE)session.getAttribute("contexto");
    		String operacion = (String)contexto.get("subOpFlag");
    		//Si estamos en SolicitudCentro que omita la validacion
    		if (!"solicitudCentro".equals(operacion)){
	    		boolean accionValidable=false;
	    		int i=0;
	    		for(i=0; !GenericValidator.isBlankOrNull(field.getVarValue("valorAccion[" + i + "]")); i++)
	            {
	    			valor=field.getVarValue("valorAccion[" + i + "]");
	    			if (valor.equals(accion))
	    			{
	    				accionValidable=true;
	    				break;
	    			}
	            }
	    	   
	    		if (!accionValidable){
	    			return true;
	    		}
	    		valor = "";
	    		for(i=0; !GenericValidator.isBlankOrNull(field.getVarValue("field[" + i + "]")); i++)
	            {
	    			valor=ValidatorUtil.getValueAsString(bean,field.getVarValue("field[" + i + "]"));
	    			if (valor.length()<V50bClsConstantes.TRES && valor.length()>0)
	    			{
	    				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	    				return false;
	    			}
	            }
	    		return true;
    		}else{
    			return true;
    		}
    	}
        catch (Exception e) {     
            errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
            return false;
        }
    }
    
    
    /**
     * Validacion de un nmero, si es menor que otro o no
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param request a 
     * @return boolean: true correcto
     * 					false no es correcto
     */
    public static boolean fncValidarHora(Object bean, 
			ValidatorAction va,
			Field field, 
			ActionErrors errors, 
			HttpServletRequest request)
	{
    	boolean esValido = false;
    	try {
    	String max=field.getVarValue("maximoValor");
    	String importe= ValidatorUtil.getValueAsString(bean, field.getProperty());
    	if (importe!=null && !importe.equals(""))
    	{
    		if (importe.indexOf(":")==-1){
    			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    			return esValido;
    		}
	    	StringTokenizer stk= new StringTokenizer(importe,":");
			String num = null;
			String decimales = "0";
			if (stk.hasMoreTokens()){
				num=stk.nextToken();
			}
			if (stk.hasMoreTokens()){
				decimales=stk.nextToken();
			}
			float horas = Float.valueOf(num).floatValue();
			float minutos = Float.valueOf(decimales).floatValue();
			num =Double.toString(V50bClsFunciones.cambioPrecision(horas+(minutos/V50bClsConstantes.SESENTA),2));
			
			
			String nombreCampo=field.getVarValue("campoAccion");
	    	String nombreCampo1=(String)ValidatorUtil.getValueAsString(bean, nombreCampo);
	    	
	    	if (GenericValidator.isBlankOrNull(max) || GenericValidator.isBlankOrNull(num) || (!"guardar".equals(nombreCampo1) &&!"guardarAutof".equals(nombreCampo1))){
	    		esValido= true;
	    	}
	    	else if(Float.parseFloat(max)>(Float.parseFloat(num)) && minutos<V50bClsConstantes.CINCUENTAYNUEVE){
	    		esValido= true;
	    	}
	    	else{
	    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	    	}
    	}
    	else{
    		esValido = true;
    	}
    	return esValido;	
		} catch (Exception e) {     
			e.printStackTrace();
			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
			return esValido;
		}
		
	}
    
    /**
    * Valida si el ENA es obligatorio dependiendo de si es particular o empresaValida que un ENA este en formato correcto
     * @param bean a
	 * @param va a
	 * @param field a
	 * @param errors a
	 * @param request a 
    * @return boolean: true si es correcto, false si no lo es
    */
    public static boolean fncValidarENA(Object bean,
    ValidatorAction va,
    Field field,
    ActionErrors errors,
    HttpServletRequest request)
    {
    try
    {
	    String ENA = ValidatorUtil.getValueAsString(bean, field.getProperty());
	
	    if (ENA != null && !ENA.equals("")){
		    Pattern pat=Pattern.compile("^[A-Z]\\d{1,7}[A-Z]$");
		    Matcher matcher=pat.matcher(ENA);
		    boolean flag=matcher.find(); // true;
		    if (!flag){
		    	errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
		    }
		    return flag;
	    }else{
	    return true;
	    }
    }
    catch (Exception e) {
	    errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	    return false;
    }

    }
    
		/**
	     * fncNoComillas
	     * @param bean a
		 * @param va a
		 * @param field a
		 * @param errors a
		 * @param request a
	     * @return boolean: true si es correcto, false si no lo es
	     */	
		
		public static boolean fncNoComillas(Object bean, 
				ValidatorAction va,
				Field field, 
				ActionErrors errors, 
				HttpServletRequest request)
		{
			DynaActionForm b = (DynaActionForm)bean;
			
			HttpSession session = request.getSession();
			Q70ContextoEJIE contexto = (Q70ContextoEJIE)session.getAttribute("contexto");
			
			try
			{
			if ((Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.comunicar",(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA)).equals((String)b.get("boton"))))
				{
				if ("".equals((String)b.get("radioMailMov"))) 
				{
					errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
					return false;
				
				}
				}
			}catch(Exception e)
			{return false;}	
			return true;
		}
		
		/**
		 * Valida si se ha seleccionado alguna imagen (a traves del atrib. idImgSeleccionado) al pulsar el boton Eliminar
		* @param bean a
		* @param va a
		* @param field a
		* @param errors a
		* @param request a
		 * @return boolean
		 */
		public static boolean fncRadioPulsadoEliminar(Object bean, 
				ValidatorAction va,
				Field field, 
				ActionErrors errors, 
				HttpServletRequest request)
		{
			DynaActionForm b = (DynaActionForm)bean;
			
			HttpSession session = request.getSession();
			Q70ContextoEJIE contexto = (Q70ContextoEJIE)session.getAttribute("contexto");
			
			try{
				if ((Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.herramientas.eliminar",(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA)).equals((String)b.get("boton")))){
					if ("".equals((String)b.get("idImgSeleccionado"))) {
						errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
						return false;
					}
				}
			}catch(Exception e)
				{return false;}	
			return true;
		}
		
		/**
		 * Valida si un el fichero introducido es de tipo .doc
		* @param bean a
		* @param va a
		* @param field a
		* @param errors a
		* @param request a
		 * @return boolean
		 */
		public static boolean fncValidarFormatoPlantilla(Object bean, 
				ValidatorAction va,
				Field field, 
				ActionErrors errors, 
				HttpServletRequest request) {
			DynaActionForm b = (DynaActionForm)bean;
			FormFile fichero = (FormFile)b.get("filePlantilla");
			boolean bandera = false;
			if(fichero!=null && fichero.getFileName().endsWith(V50bClsConstantes.CONSTANTE_WORD)) {
				bandera = true;
			} else {
				bandera = false;
			}
			return bandera;
		}
		
		/**
	     * Valida un fichero antes de subirlo al servidor si su cabecera corresponde a un documento word
		* @param bean a
		* @param va a
		* @param field a
		* @param errors a
		* @param request a
	     * @return boolean
	     */
	    public static boolean fncValidarCabeceraPlantilla(Object bean, ValidatorAction va,
	            Field field, ActionErrors errors, HttpServletRequest request) { 
	    	try{
	    		FormFile fichero = (FormFile)((Q70OPValidatorForm)bean).get(field.getProperty());
	    		if(fichero==null) {
	    			return false;
	    		}
	    		if((fichero.getFileName()==null) || (fichero.getFileName().equals(""))) {
	    			return false;
	    		}
	    		if(fichero.getFileSize()==0) {
	    			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	    			return false;
	    		} else {
	    			byte[] b=fichero.getFileData();
	    			String[] extensiones = V50bClsConstantes.CONSTANTE_EXTENSIONES_WORD;
				
	    			int correcta=0;
	    			for (int i=0;i<extensiones.length;i++) {
	    				int contador =0;
	    				while (contador<V50bClsConstantes.CUATRO) {
	    					if(extensiones[i].getBytes()[contador]==b[contador]) {
	    						correcta++;
	    					}
	    					contador++;
	    				}
	    			}
	    			if(correcta>V50bClsConstantes.TRES) {
	    				return true;
	    			} else {
	    				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	    				return false;
	    			}	
	    		}
	    	} catch(Exception e) {
	    		//e.printStackTrace();
	    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	            return false;
	    	}
	    }
		
	    /**
	     * Valida que un campo String[] no est vaco
	     * @param bean a
	     * @param va a
	     * @param field a
	     * @param errors a
	     * @param request a
	     * @return boolean
	     */
	    public static boolean fncValidarArrayStringsVacio(Object bean, ValidatorAction va,
	            Field field, ActionErrors errors, HttpServletRequest request) { 
	    	try{
	    		String[] array= (String[])((Q70OPValidatorForm)bean).get(field.getProperty());
	    		
    			if(array.length>0) {
    				return true;
    			} else {
    				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
    				return false;
    			}	
	    	} catch(Exception e) {
	    		//e.printStackTrace();
	    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	            return false;
	    	}
	    }
	    
		/**
	     * Validacion un importe q este en formato correcto
		 * @param bean a
		 * @param va a
		 * @param field a
		 * @param errors a
		 * @param request a
	     * @return boolean: true correcto
	     * 					false no es correcto
	     */
	    public static boolean fncValidarImporteDecimales(Object bean, 
				ValidatorAction va,
				Field field, 
				ActionErrors errors, 
				HttpServletRequest request)
		{
	    	try {

	    	String importe= ValidatorUtil.getValueAsString(bean, field.getProperty());
	    	if (importe != null && !importe.equals("")){
		    	boolean flag=V50bClsFunciones.fncValidarImporteDecimales(importe);
		    	if (!flag){
		    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
		    	}
		    	return flag;
	    	}else{
	    		return true;
	    	}
	    	
			} catch (Exception e) {     
				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
				return false;
			}
			
		}
	    
	    
	    /**
		 * Valida un campo solo si ha pulsado el boton especificado
		 * @param bean a
		 * @param va a
		 * @param field a
		 * @param errors a
		 * @param request a
		 * @return boolean
		 */
		public static boolean fncValidateIfBoton(Object bean, 
				ValidatorAction va,
				Field field, 
				ActionErrors errors, 
				HttpServletRequest request)
		{
			DynaActionForm b = (DynaActionForm)bean;
			
			HttpSession session = request.getSession();
			Q70ContextoEJIE contexto = (Q70ContextoEJIE)session.getAttribute("contexto");
			
			try{
				String strBoton = field.getVarValue("field[" + 0 + "]");
				String strValidacion = field.getVarValue("field[" + 1 + "]");
			    				 
				if ((Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",strBoton,(String)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA)).equals((String)b.get("boton")))){
					if("integer".equals(strValidacion)){
						V50bClsValidaciones.fncValidarNumero(bean,va,field,errors,request);
					}else if ("required".equals(strValidacion)){
						if (GenericValidator.isBlankOrNull((String)ValidatorUtil.getValueAsString(bean,field.getProperty())))
						{
							errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
							return false;
						}
						return true;
					}else if("fecha".equals(strValidacion)){
						V50bClsValidaciones.validateDate(bean,va,field,errors,request);
					}
				}
			}catch(Exception e)
				{return false;}	
			return true;
		}
		
	    /**
		* Valida una direccin de correo
		* @param bean a
		* @param va a
		* @param field a
		* @param errors a
		* @param request a
		* @return boolean: true correcto
		* false no es correcto
		*/
		public static boolean fncValidarEmail(Object bean, 
				ValidatorAction va,
				Field field, 
				ActionErrors errors, 
				HttpServletRequest request)
		{
			try {
	
				//Proceso la direccin introducida
				String email = ValidatorUtil.getValueAsString(bean, field.getProperty());
				if (email != null && !email.equals("")){
					boolean flag=V50bClsValidaciones.fncEsMailValido(email);
					if (!flag){
						errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
					}
					return flag;
				}else{
					return true;
				}
			}
			catch (Exception e) {
				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
				return false;
			}
		}
		
		
		/**
		* Valida una direccin de correo
		* @param bean a
		* @param va a
		* @param field a
		* @param errors a
		* @param request a
		* @return boolean: true correcto
		* false no es correcto
		*/
		public static boolean fncComprobarMailsIntroducidos(Object bean, 
				ValidatorAction va,
				Field field, 
				ActionErrors errors, 
				HttpServletRequest request)
		{
			try {
				boolean flag = false;
				//Proceso la direccin introducida
				String email = ValidatorUtil.getValueAsString(bean, field.getProperty());
				
				//Procesar los mails seleccionados (elementos: x,x,x,)
				ArrayList arrayMails = new ArrayList();
				StringTokenizer st = new StringTokenizer(email,";");
				while (st.hasMoreTokens()){
					arrayMails.add(st.nextToken());
				}
				
				if (arrayMails != null && !arrayMails.equals("")){
					for(int i=0;i<arrayMails.size();i++)
					{
						String dir = (String)arrayMails.get(i);
						flag=V50bClsValidaciones.fncEsMailValido(dir);
						//flag=V50bClsValidaciones.isEmail(dir);
						if (!flag){
							errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
							break;
						}
					}
					return flag;
				}else{
					return true;
				}
	
			}catch (Exception e) {
				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
				return false;
			}
		}
		
		/**
		 * Valida una direccion de correo
		 * @param strMail Email a comprobar
		 * @return boolean True or false si el e-mail cumple con el patrn o no
		 */
		public static boolean fncEsMailValido(String strMail){
			
			/*OLD acepta eurohelp@euro-help.net: [\\w-]+@[\\w-]+\\.{1}[a-zA-Z]{2,4}$ 
			//acepta ej111m@ejgva2: pat=Pattern.compile("[a-zA-Z]+[0-9]*[a-zA-Z]*@[a-z]*[0-9]*"); 
			//se junta todo en un unico patron. Acepta los siguientes mails:
			 * ej1234k@ejgva2 // ej1234k@ejgva // co00593k@ejgva2 // dfdfkj23@jkjkjdffdfdfdfd 
			 * iurkidi@euro-help.net // iurkidi81@hotmail.com // ivap@ivap.es
			 */
			Pattern pat=Pattern.compile("[\\w-][0-9]*[\\w-]*@[\\w-]+[\\.{1}]*[[a-zA-Z]{2,4}]*$");
			//Matcher matcher=pat.matcher(strMail);
			return pat.matcher(strMail).find();
		}
		
		/**
		 * Valida una direccion de correo
		 * @param correo Email a comprobar
		 * @return boolean True or false si el e-mail cumple con el patrn o no
		 */
	    public static boolean isEmail(String correo) {
	        Pattern pat = null;
	        Matcher mat = null;        
	        pat = Pattern.compile("^([0-9a-zA-Z]([_.w]*[0-9a-zA-Z])*@([0-9a-zA-Z][-w]*[0-9a-zA-Z].)+([a-zA-Z]{2,9}.)+[a-zA-Z]{2,3})$");
	        mat = pat.matcher(correo);
	        return mat.find();
	    }

		
		/**
		* Valida documento de office (*.doc)
		* @param bean a
		* @param va a
		* @param field a
		* @param errors a
		* @param request a
		* @return boolean: true correcto
		* false no es correcto
		*/
		public static boolean fncValidarDocOffice(Object bean, 
				ValidatorAction va,
				Field field, 
				ActionErrors errors, 
				HttpServletRequest request)
		{

			String doc = ValidatorUtil.getValueAsString(bean, field.getProperty());
			if (!"".equals(doc) && null!=doc){
				try {
					boolean flag = false;
					//Proceso el documento introducido
					
					
					Pattern pat=Pattern.compile("\\.([dD][oO][cC])$");
					Matcher matcher=pat.matcher(doc);
					flag=matcher.find();
					if (!flag){
						errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
					}
					return flag;	
				}
				catch (Exception e) {
					errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
					return false;
				}
			}else{
				return true;
			}
		}
		/**
		* Valida documento sea menor o igual a 50 caracteres
		* @param bean a
		* @param va a
		* @param field a
		* @param errors a
		* @param request a
		* @return boolean: true correcto
		* false no es correcto
		*/
		public static boolean fncLongitudValida50(Object bean, 
				ValidatorAction va,
				Field field, 
				ActionErrors errors, 
				HttpServletRequest request)
		{

			String doc = ValidatorUtil.getValueAsString(bean, field.getProperty());
			
			if (doc.length()> V50bClsConstantes.CINCUENTA)
			{
				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
				return false;
			}else{
				return true;
			}
			
			
		}
		
	    
	    /**
	     * Valida que un DNI este en formato correcto
		 * @param bean a
		 * @param va a
		 * @param field a
		 * @param errors a
		 * @param request a
	     * @return boolean: true si es correcto, false si no lo es
	     */
	    public static boolean fncAnyoMenor(Object bean, 
	    									ValidatorAction va,
											Field field, 
											ActionErrors errors, 
											HttpServletRequest request)
	    { 	
	    	
	    	String anyoDesdeStr;
	    	
	    	if (V50bClsValidaciones.isString(bean)) {
	    		anyoDesdeStr = (String) bean;
	        } else {
	        	anyoDesdeStr = ValidatorUtil.getValueAsString(bean, field.getProperty());
	        }
	    	
	    	DynaActionForm form = (DynaActionForm)bean;	    	
	    	String dependProp = field.getVarValue("field[0]");
	        String anyoHastaStr = ValidatorUtil.getValueAsString(form, dependProp);
	    	
	    	

	    	boolean resp = false;     		
	
	    	resp = V50bClsValidaciones.fncValidarNumeros(anyoDesdeStr);
	    	if (resp){
	    		resp = V50bClsValidaciones.fncValidarNumeros(anyoHastaStr);
	    	}
	    	
	    	if (resp){
	    		int anyoDesde = Integer.parseInt(anyoDesdeStr);
	    		int anyoHasta = Integer.parseInt(anyoHastaStr);
	    	
	    		if (anyoDesde>anyoHasta){
	    			errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));    
	    			return false;		 
	    		}
	    	} else {
	    		return false;
	    	}
	    	return true;   
	    }
	    
	    /**
	     * Validacion un importe q este en formato correcto
		 * @param bean a
		 * @param va a
		 * @param field a
		 * @param errors a
		 * @param request a
	     * @return boolean: true correcto
	     * 					false no es correcto
	     */
	    public static boolean fncValidarIRPFDecimales(Object bean, 
				ValidatorAction va,
				Field field, 
				ActionErrors errors, 
				HttpServletRequest request)
		{
	    	try {

	    	String importe= ValidatorUtil.getValueAsString(bean, field.getProperty());
	    	if (importe != null && !importe.equals("")){
		    	boolean flag=V50bClsFunciones.fncValidarIRPFDecimales(importe);
		    	if (!flag){
		    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
		    	}
		    	return flag;
	    	}else{
	    		return true;
	    	}
	    	
			} catch (Exception e) {     
				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
				return false;
			}
			
		}
	    
	    /**
	     * Validacion Ve si es requerido en funcin de una variable 
		 * @param bean a
		 * @param va a
		 * @param field a
		 * @param errors a
		 * @param validator a
		 * @param request a
	     * @return boolean: true 
	     *                  false 
	     */
	    public static boolean fncRequiredIfLiterales(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request)
	    {
	    	
	    	try{
	        if(V50bClsValidaciones.tr.isTraceActive()){
	        	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fncRequiredIfLiterales");
	        }

	        String variable = field.getVarValue("field[0]");
	        String valor = field.getVarValue("fieldValue[0]");
	        //String contextooForm = field.getVarValue("field[2]");
	        String strIdioma = Q70ListenerUtils.getLanguage(request);
	        
	        //valor = Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",valor,strIdioma);
	        StringBuffer bufferValor = new StringBuffer(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",valor,strIdioma));
	        valor=bufferValor.toString();
	        
	        HttpSession session = request.getSession();
	        Q70ContextoEJIE contexto = (Q70ContextoEJIE)session.getAttribute("contexto");
	        
	        //String valorVariable ="";
	        String	valorVariable = (String)contexto.get(variable);
	        if (null==valorVariable||"".equals(valorVariable)){
	           	DynaActionForm form = (DynaActionForm)bean;	    	
	        	valorVariable = ValidatorUtil.getValueAsString(form, variable);
	        }
	        
	        
	        String valorRequerido= ValidatorUtil.getValueAsString(bean, field.getProperty());
	        
	        if (null!=valorVariable&&valor.equals(valorVariable)){
	        	if ("".equals(valorRequerido)){
	        		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
	        		return false;
	        	}else{
	        		return true;	        		
	        	}
	        	
	        }
	        
	        return true;
		    } catch (Exception e) {     
				errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field)); 
				return false;
			}

	    }
	    
	    
	    /**
	     * Valida un fichero antes de subirlo al servidor
		 * @param bean a
		 * @param va a
		 * @param field a
		 * @param errors a
		 * @param request a
	     * @return FormFile si validacion OK, null si error
	     */
	    public static boolean fncExisteFichero(Object bean, ValidatorAction va,
	    		Field field, ActionErrors errors, HttpServletRequest request) {
	    	
	    	try{
			    FormFile fichero = (FormFile)((Q70OPValidatorForm)bean).get(field.getProperty());
		
			    if(fichero==null){
			    	return true;
			    }
			    if((fichero.getFileName()==null) || (fichero.getFileName().equals(""))){
			    	return true;
			    }
	
			    if(fichero.getFileSize()==0){
				    errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
				    return false;
			    }
			    else{
			    	return true;
			    }
		    }
	    	catch(Exception e){
	    		errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
	    		return false;
		    }

	    }
	    
	    
	    /**
	     * Valida que todos los caracteres de un string sean numeros
	     * 
	     * @param s
	     * 	  *            String: valor del String
	     * @return boolean: true si son todos, false algn carcter no es nmero
	     */
	    public static boolean fncValidarNumerosJava(String s)
	    {
	    	for (int i=0;i<s.length();i++)
	    	{
	    		if ( !Character.isDigit(s.charAt(i)) )
	    		{
	    			return false;
	    		}
	    	}
	    	return true;
	    }
	    
	   
	    
	    /**
		 * fncEsInteger
		 * @param strPfNum String. numero a validar
		 * @return boolean. True or False
		 */
		public static boolean fncEsInteger(String strPfNum){
			
			Integer result=null;
			if (strPfNum!=null & !"".equals(strPfNum)) {
				result = GenericTypeValidator.formatInt(strPfNum);

				if (result == null) {
					return false;
				}
			}

			return true;
		}
		
		/**
	     * Validacion de si el resolutor tiene perfil
	     * @param bean a
		 * @param va a
		 * @param field a
		 * @param errors a
		 * @param validator a
		 * @param request a
	     * @return boolean: true tiene perfil
	     *                  false no tiene perfil
	     */
	    public static String fncHayPerfil(Object bean, ValidatorAction va, Field field, ActionErrors errors, Validator validator, HttpServletRequest request)
	    {
	        if(V50bClsValidaciones.tr.isTraceActive()){
	        	V50bClsValidaciones.tr.trace(V50bClsValidaciones.COMPONENTE, Q70TraceLevel.INFO, "fncHayPerfil");
	        }
	        String perfilTecnico = "";
	        if(V50bClsValidaciones.isString(bean)){
	        	perfilTecnico = (String)bean;
	        }else{
	        	perfilTecnico = ValidatorUtil.getValueAsString(bean, field.getProperty());
	        }
	        Object form = validator.getResource(Validator.BEAN_KEY);
	        String dependProp = field.getVarValue("field[0]");
	        String perfilResolutor = ValidatorUtil.getValueAsString(form, dependProp);
	              
		    boolean bolRetorno = true;

			if (perfilTecnico==null && perfilResolutor==null){
		       	bolRetorno = false;
			}else{
		        bolRetorno = true;
			}
		    if(!bolRetorno){
		        errors.add(field.getKey(), Q70ValidacionesCampo.getActionError(request, va, field));
		    }

	        return perfilTecnico;
	    }
	    
	    /**
		 * Mtodo que valida una identificacin  dependiendo del tipo
		 * @param bean El bean a validar.
		 * @param va El mensaje de error.
		 * @param field El campo que vamos a validar.
		 * @param errors Los errores que se generen.
		 * @param request la peticion
		 * @return boolean
		 */
		public static boolean fncValidarDNIPorTipoIdentificacion(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request){
			boolean hayError = false;
			String tipo = ValidatorUtil.getValueAsString(bean, field.getVarValue(V50bClsConstantes.LABEL_CAMPO));
			if(tipo != null && tipo.length()>0){
				if(V50bClsConstantes.CONSTANTE_DNI.equals(tipo)){
					hayError = !fncValidarDNI(bean, va, field, errors, request);
				}else if(V50bClsConstantes.CONSTANTE_NIE.equals(tipo)){
					hayError = !fncValidarNIE(bean, va, field, errors, request);
				}
			}	
			return hayError;
		}

		/**
		 * Mtodo que valida un NIE
		 * @param bean El bean a validar.
		 * @param va El mensaje de error.
		 * @param field El campo que vamos a validar.
		 * @param errors Los errores que se generen.
		 * @param request la peticion
		 * @return boolean
		 */
		public static boolean fncValidarNIE(Object bean, ValidatorAction va, Field field, ActionErrors errors, HttpServletRequest request){
			String nie = ValidatorUtil.getValueAsString(bean, field.getProperty());
			boolean boolOk = false;
			if(nie != null && nie.length()>0){
				nie = nie.trim().toUpperCase();
				char letra  = nie.charAt(0);
				String parteDNINIE = nie.substring(1);
				
				if ( letra == 'X') {
		              if (nie.length()!=9 && nie.length()!=10){
		                   boolOk = false;
		              }
		       }
		        if (letra == 'Y' || letra == 'Z'){
		              if (nie.length()!=9){
		            	  boolOk = false;
		              }
		       }
				
			   if(letra != 'X'&&letra != 'Y'&&letra != 'Z'){
					   boolOk = false;
			   }else{
				    if(letra == 'X'){
				    	 boolOk = V50bClsValidaciones.validarDNI(new StringBuffer("0").append(parteDNINIE).toString());
				    }
				    if(letra == 'Y'){
				    	 boolOk = V50bClsValidaciones.validarDNI(new StringBuffer("1").append(parteDNINIE).toString());
				    }
				    if(letra == 'Z'){
				    	boolOk = V50bClsValidaciones.validarDNI(new StringBuffer("2").append(parteDNINIE).toString());
				    }
			   } 
				
			}
			
			if (!boolOk) {
				errors.add(V50bClsValidaciones.ERROR_FORMATO_NIE, new ActionError(V50bClsValidaciones.ERROR_FORMATO_NIE, Q70ValidacionesCampo.getActionError(
						request, va, field)));
			}
			return boolOk;
		}
		/**
		 * Funcion que valida si un dni es correcto
		 * @param dni numero de DNI
		 * @return boolean
		 */
		public static boolean validarDNI(String dni){
			try{
				if(dni != null && dni.length()>0){
					dni = dni.toUpperCase();
					int longitudDNI = dni.length();
					char letra = dni.charAt(longitudDNI-1);
					String parteNumericaDNI = dni.substring(0,longitudDNI-1);
					if(letra<'A' || letra>'Z'){
						return false;
					}
					Integer.parseInt(parteNumericaDNI);	
					StringBuffer stbDni = new StringBuffer();
					stbDni.append(parteNumericaDNI);
					stbDni.append("-");
					stbDni.append(letra);
					if(V50bClsValidaciones.validarLetraDNI(stbDni.toString())){
						return true;
					}
				}
				return false;
			}catch(Exception e){
			    return false;
			}
		}
		
		/**
		 * Funcion que cmprueba si la letra del dni es correcta. Formato 12345678-Q
		 * @param dni
		 * @return boolean
		 */
		public static boolean validarLetraDNI(String dni){
			String[] nif = dni.split("-");	
			int letra=(Integer.valueOf(nif[0]).intValue())%23;
			String[] abc={"T","R","W","A","G","M","Y","F","P","D","X","B","N","J","Z","S","Q","V","H","L","C","K","E","T"};	
			if(abc[letra].compareToIgnoreCase(nif[1])==0){
				return true;
			}
			return false;
		}
	    
}
