package v50b.v50bComun;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

import v50b.v50bBeans.V50bCalendarioBean;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesException;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

/**
 * Clase java para el tag Calendario usado en las paginas de Calendario.
 * 
 * @author Iigo Rodrguez
 * @version 1.0
 * 
 */
public class V50bCalendario implements Serializable {

	private static final long serialVersionUID = 1L;

	private String estado = "HABILITADO";
	private static String NEWLINE = "\n";
	private transient Hashtable cnf;
	private int anno;
	private int mes;
	private transient String fuente;
	private String idioma;
	private transient Map diasEsp;
	// private transient String th;
	// private transient List comboAnnos;
	private transient boolean paginacionAtras;
	private transient boolean paginacionAdel;
	// private Map diasCurso;
	private transient boolean sabadosFestivos;
	// private transient boolean pantallaDatosCurso;
	// private List listaConvocatorias;//Se usara para la lista de convocatorias
	// para pintar los dias q tienen datos
	private List listaFestivos;
	private List listaFestivosOriginal;

	/**
	 * Constructor
	 * 
	 */
	public V50bCalendario() {
		this.fuente = null;
		GregorianCalendar gregoriancalendar = new GregorianCalendar();
		this.cnf = new Hashtable();
		V50bCalendario.NEWLINE = System.getProperty("line.separator");
		this.idioma = V50bClsConstantes.CONSTANTE_CASTELLANO;
		this.diasEsp = new HashMap();
		// this.diasCurso = new HashMap();
		// this.th=V50bClsConstantes.CONSTANTE_FESTIVOS_GENERALES;
		// this.comboAnnos = new ArrayList();
		this.paginacionAtras = false;
		this.paginacionAdel = false;
		this.mes = gregoriancalendar.get(2) + 1;
		this.anno = gregoriancalendar.get(1);
		this.sabadosFestivos = true;
		// pantallaDatosCurso = false;
	}

	/**
	 * setSabadoFestivo
	 * 
	 * @param sf
	 *            sf
	 */
	public void setSabadoFestivo(String sf) {
		this.sabadosFestivos = "N".equals(sf) ? false : true;
		// pantallaDatosCurso = true;
	}

	/**
	 * getPaginacionAtras
	 * 
	 * @return paginacionAtras
	 */
	public boolean getPaginacionAtras() {
		return this.paginacionAtras;
	}

	/**
	 * getPaginacionAdel
	 * 
	 * @return paginacionAdel
	 */
	public boolean getPaginacionAdel() {
		return this.paginacionAdel;
	}

	/**
	 * setTH
	 * 
	 * @param terriHist
	 *            terriHist
	 */
	/*
	 * public void setTH (String terriHist) { this.th = terriHist; }
	 */
	/**
	 * getTH
	 * 
	 * @return th
	 */
	/*
	 * public String getTH () { return this.th; }
	 */
	/**
	 * setAnnos
	 * 
	 * @param cAnnos
	 *            cAnnos
	 */
	/*
	 * public void setAnnos (List cAnnos) { this.comboAnnos = cAnnos; }
	 */
	/**
	 * getAnnos
	 * 
	 * @return comboAnnos
	 */
	/*
	 * public List getAnnos() { return this.comboAnnos; }
	 */
	/**
	 * setFestivos
	 * 
	 * @param diasEspeciales
	 *            diasEspeciales
	 */
	public void setFestivos(Map diasEspeciales) {
		this.diasEsp = diasEspeciales;
	}

	/**
	 * getFestivos
	 * 
	 * @return diasEsp
	 */
	public Map getFestivos() {
		return this.diasEsp;
	}

	/**
	 * setDiasCurso
	 * 
	 * @param diasC
	 *            diasC
	 */
	/*
	 * public void setDiasCurso (Map diasC) { this.diasCurso = diasC; }
	 */
	/**
	 * getDiasCurso
	 * 
	 * @return diasCurso
	 */
	/*
	 * public Map getDiasCurso() { return this.diasCurso; }
	 */
	/**
	 * setIdioma
	 * 
	 * @param idi
	 *            idi
	 */
	public void setIdioma(String idi) {
		this.idioma = idi;
	}

	/**
	 * getIdioma
	 * 
	 * @return idioma
	 */
	public String getIdioma() {
		return this.idioma;
	}

	/**
	 * setAnnoCombo
	 * 
	 * @param i
	 *            i
	 */
	/*
	 * public void setAnnoCombo(int i) { if (i > 0) { for (int k = 0; k <
	 * this.comboAnnos.size(); k++) { if (((String)
	 * this.comboAnnos.get(k)).equals(String.valueOf(i))) { this.anno = i;
	 * break; } } this.cnf.clear(); } }
	 */
	/**
	 * setAnno
	 * 
	 * @param anno
	 *            anno
	 */
	public void setAnno(int anno) {
		this.anno = anno;
	}

	/**
	 * getAnno
	 * 
	 * @return anno
	 */
	public int getAnno() {
		return this.anno;
	}

	/**
	 * setMes
	 * 
	 * @param mes
	 *            mes
	 */
	public void setMes(int mes) {
		this.paginacionAtras = true;
		this.paginacionAdel = true;
		if (mes >= 1 && mes <= V50bClsConstantes.DOCE) {
			this.mes = mes;
			this.cnf.clear();
		} else if (mes > V50bClsConstantes.DOCE) {
			int annoI = this.anno;
			this.mes = mes - V50bClsConstantes.DOCE;
			this.anno = annoI + 1;
			this.cnf.clear();
		} else if (mes < 1) {
			int annoI = this.anno;
			this.mes = mes + V50bClsConstantes.DOCE;
			this.anno = annoI - 1;
			this.cnf.clear();
		}
	}

	/**
	 * getMes
	 * 
	 * @return mes
	 */
	public int getMes() {
		return this.mes;
	}

	/**
	 * getDia
	 * 
	 * @param calendar
	 *            calendar
	 * @return int
	 */
	private int getDia(Calendar calendar) {
		return (calendar.get(V50bClsConstantes.SIETE) + V50bClsConstantes.CINCO)
				% V50bClsConstantes.SIETE;
	}

	/**
	 * setEstado
	 * 
	 * @param e
	 *            e
	 */
	public void setEstado(String e) {
		this.estado = e;
	}

	/**
	 * getEstado
	 * 
	 * @return estado
	 */
	public String getEstado() {
		return this.estado;
	}

	/**
	 * getHtml
	 * 
	 * @return String
	 */
	public String getHtml() {
		// V50bClsTrazas.depura("V50bCalendario.getHtml()");

		StringBuffer stringbuffer = new StringBuffer(
				V50bClsConstantes.QUINIENTOS);

		GregorianCalendar gregoriancalendar = new GregorianCalendar(this.anno,
				this.mes - 1, 1);

		V50bClsTrazas.depura("V50bCalendario.getHtml(). MES: ",String.valueOf(this.mes));
		
		int i = this.mes - 1;
		int j = 0;

		stringbuffer
				.append("<div style=\"float: left; border: 0 none; display: block; \" ><table width=\"30%\" border=\"1\" cellpadding=\"0\" cellspacing=\"1\" class=\"calendarioFechas NombreMes\">\n");
		stringbuffer.append("<label>"
				+ this.formateaNombreMes(gregoriancalendar.get(2) + 1) + " "
				+ this.anno + "</label><br>\n");
		stringbuffer.append("<tr><th>"
				+ this.formatearObjeto(this.fuente, this.formateaDiaSemana(1))
				+ "</th>\n");

		for (int l = 2; l < V50bClsConstantes.OCHO; l++) {
			stringbuffer.append("<th>"
					+ this.formatearObjeto(this.fuente, this
							.formateaDiaSemana(l)) + "</th>\n");
		}
		stringbuffer.append("</tr>\n");

		int i1 = 0;
		j = 0;

		if (this.getDia(gregoriancalendar) > 0) {
			stringbuffer.append("<tr>");

			for (; i1 < this.getDia(gregoriancalendar); i1++) {
				stringbuffer.append("<td class=\"alinearDerecha\">");
				if (this.fuente != null) {
					stringbuffer.append(this.fuente).append("&nbsp;</font>");
				} else {
					stringbuffer.append("&nbsp;");
				}
				stringbuffer.append("</td>\n");

				j++;
			}
		}
		
		List lCambios = this.fncCambios(this.listaFestivos, this.listaFestivosOriginal);
		lCambios.addAll(this.fncCambios(this.listaFestivosOriginal, this.listaFestivos));
		
		for (; gregoriancalendar.get(2) == i; gregoriancalendar.add(V50bClsConstantes.CINCO, 1)) {
			boolean flagRed=false;
			String clase = "";
			for (int cal = 0; this.listaFestivosOriginal != null && cal < this.listaFestivosOriginal.size(); cal++) {
				V50bCalendarioBean bean = (V50bCalendarioBean) this.listaFestivosOriginal.get(cal);
				// String identificador = bean.getIdentificador();
				String fechaFestivo = bean.getFecha();
				if (fechaFestivo != null && fechaFestivo.equals(this.stringFecha(gregoriancalendar))) {
					clase = "verde";
				}
			}
			
			for (int cal = 0; lCambios != null && cal < lCambios.size(); cal++) {
				V50bCalendarioBean bean = (V50bCalendarioBean) lCambios.get(cal);
				// String identificador = bean.getIdentificador();
				String fechaFestivo = bean.getFecha();
				if (fechaFestivo != null && fechaFestivo.equals(this.stringFecha(gregoriancalendar))) {
					flagRed = true;
				}
			}
			
			int j1 = gregoriancalendar.get(V50bClsConstantes.CINCO);
			int k1 = (i1 + j1) % V50bClsConstantes.SIETE;
			if (k1 == 1) {
				stringbuffer.append("<tr>").append(V50bCalendario.NEWLINE);
				j = 0;
			}

			if (k1 == 0) {
				stringbuffer
						.append("<td id=\""
								+ this.stringFecha(gregoriancalendar)
								+ "\" onclick=\"javascript:fncGuardaFestivo(this,'"
								+ clase
								+ "');fncHabilitar();\" class=\"FinSemanaGris alinearDerecha "
								+ clase + "\"");
				if(flagRed){
					stringbuffer.append(" style=\"background-color:red;\">");
				} else {
					stringbuffer.append(" >");
				}
			} else if (k1 == V50bClsConstantes.SEIS && this.sabadosFestivos) {
				stringbuffer
						.append("<td id=\""
								+ this.stringFecha(gregoriancalendar)
								+ "\" onclick=\"javascript:fncGuardaFestivo(this,'"
								+ clase
								+ "');fncHabilitar();\" class=\"FinSemanaGris alinearDerecha "
								+ clase + "\"");
				if(flagRed){
					stringbuffer.append(" style=\"background-color:red;\">");
				} else {
					stringbuffer.append(" >");
				}
			}/*
				 * else
				 * if(this.diasEsp.containsKey(this.stringFecha(gregoriancalendar)+"/"+this.th)){
				 * stringbuffer.append("<td id=\""+this.stringFecha(gregoriancalendar)+"\" onclick=\"javascript:fncGuardaFestivo(this,'"+clase+"');fncHabilitar();\" class=\"FinSemanaGris alinearDerecha "+clase+"\">"); }
				 */else if (this.diasEsp.containsKey(this
					.stringFecha(gregoriancalendar)
					+ "/" + V50bClsConstantes.CONSTANTE_FESTIVOS_GENERALES)) {
				stringbuffer
						.append("<td id=\""
								+ this.stringFecha(gregoriancalendar)
								+ "\" onclick=\"javascript:fncGuardaFestivo(this,'"
								+ clase
								+ "');fncHabilitar();\" class=\"FinSemanaGris alinearDerecha "
								+ clase + "\"");
				if(flagRed){
					stringbuffer.append(" style=\"background-color:red;\">");
				} else {
					stringbuffer.append(" >");
				}
			}/*
				 * else
				 * if(this.diasEsp.containsKey(this.stringFecha(gregoriancalendar)) &&
				 * ((String)this.diasEsp.get(this.stringFecha(gregoriancalendar))).equals("CURSO")){
				 * stringbuffer.append("<td id=\""+this.stringFecha(gregoriancalendar)+"\" onclick=\"javascript:fncGuardaFestivo(this,'"+clase+"');fncHabilitar();\" class=\"FechasCurso "+clase+"\">"); }
				 */else {
				stringbuffer
						.append("<td id=\""
								+ this.stringFecha(gregoriancalendar)
								+ "\" onclick=\"javascript:fncGuardaFestivo(this,'"
								+ clase
								+ "');fncHabilitar();\" class=\"negrita alinearDerecha "
								+ clase + "\"");
				if(flagRed){
					stringbuffer.append(" style=\"background-color:red;\">");
				} else {
					stringbuffer.append(" >");
				}
			}

			j++;
			if (this.fuente != null) {
				stringbuffer.append(this.fuente);
			}

			String s;
			if ((s = (String) this.cnf.get(j1 + "")) != null && false) {
				stringbuffer.append("<a href=\"");

				if (s.toUpperCase().startsWith("HTT") || s.indexOf(".") > 0) {
					stringbuffer.append(s);

					if (s.indexOf("?") < 0) {
						stringbuffer.append("?date=").append(
								this.stringFecha(gregoriancalendar));
					} else {
						stringbuffer.append("&date=").append(
								this.stringFecha(gregoriancalendar));
					}
				} else {
					// ITZIAR
					stringbuffer.append("javascript:fncGuardaFestivo(this,'"
							+ clase + "');");
				}

				stringbuffer.append("\"");

				if ((s = (String) this.cnf.get(j1 + "target")) != null) {
					stringbuffer.append(" target=\"" + s + "\"");
				}

				stringbuffer.append(">");
				stringbuffer.append(gregoriancalendar
						.get(V50bClsConstantes.CINCO));
				stringbuffer.append("</a>\n");

			} else {
				stringbuffer.append(j1).append("");
			}

			if (this.fuente != null) {
				stringbuffer.append("</font>");
			}
			stringbuffer.append("</td>\n");

			if (k1 == 0) {
				stringbuffer.append("</tr>\n");
			}
		}

		if (j < V50bClsConstantes.SIETE) {
			for (; j < V50bClsConstantes.SIETE; j++) {
				stringbuffer.append("<td class=\"alinearDerecha\">");

				if (this.fuente != null) {
					stringbuffer.append(this.fuente);
				}
				stringbuffer.append("&nbsp;");

				if (this.fuente != null) {
					stringbuffer.append("</font>");
				}
				stringbuffer.append("</td>\n");
			}
			stringbuffer.append("</tr>\n");
		}
		stringbuffer.append("</table>\n</div>\n");
		// }

		return stringbuffer.toString();

	}
	
	/**
	 * 
	 * <p>Ttulo: fncCambios</p>
	 * <p>Descripcin: Crea una lista con los objetos que no tienen en comn las dos listas</p>
	 * <p>Copyright: Copyright (c) Feb 13, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param lista1 Lista 1
	 * @param lista2 Lista 2
	 * @return lista con los objetos que no tienen en comn las dos listas 
	 */
	private List fncCambios(List lista1, List lista2){
		List lResult = new ArrayList();
		
		for(int i=0; i<lista1.size(); i++){
			boolean flagDiferente = true;
			V50bCalendarioBean bean1 = (V50bCalendarioBean)lista1.get(i);
			for(int j=0; j<lista2.size(); j++){
				V50bCalendarioBean bean2 = (V50bCalendarioBean)lista2.get(j);
				if (bean1.getFecha().equals(bean2.getFecha())){
					flagDiferente = false;
				}
			}
			if(flagDiferente){
				lResult.add(bean1);
			}
		}
		return lResult;
	}
	
	/**
	 * stringFecha
	 * 
	 * @param calendar
	 *            calendar
	 * @return String
	 */
	private String stringFecha(Calendar calendar) {
		String s = "" + calendar.get(1);

		return s + this.dosDigitos(calendar.get(2) + 1)
				+ this.dosDigitos(calendar.get(V50bClsConstantes.CINCO));
	}

	/**
	 * dosDigitos
	 * 
	 * @param i
	 *            i
	 * @return String
	 */
	private String dosDigitos(int i) {
		String s = "" + i;

		if (s.length() == 1) {
			return "0" + s;
		} else {
			return s;
		}
	}

	/**
	 * formatearObjeto
	 * 
	 * @param s
	 *            s
	 * @param obj
	 *            obj
	 * @return String
	 */
	private String formatearObjeto(String s, Object obj) {
		String s1 = "";
		if (obj != null) {
			s1 = "" + obj;
		}
		if (s == null) {
			return s1;
		} else {
			return s + s1 + "</font>";
		}
	}

	/**
	 * formateaDiaSemana
	 * 
	 * @param numDia
	 *            numDia
	 * @return String
	 */
	private String formateaDiaSemana(int numDia) {
		String diaSemana = "";

		try {
			switch (numDia) {
			case 1:
				diaSemana = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.lunescal", this.idioma);
				break;
			case 2:
				diaSemana = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.martescal", this.idioma);
				break;
			case V50bClsConstantes.TRES:
				diaSemana = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.miercolescal", this.idioma);
				break;
			case V50bClsConstantes.CUATRO:
				diaSemana = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.juevescal", this.idioma);
				break;
			case V50bClsConstantes.CINCO:
				diaSemana = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.viernescal", this.idioma);
				break;
			case V50bClsConstantes.SEIS:
				diaSemana = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.sabadocal", this.idioma);
				break;
			case V50bClsConstantes.SIETE:
				diaSemana = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.domingocal", this.idioma);
				break;
			default:
				break;
			}
		} catch (Q70GestorMensajesException e) {
			e.printStackTrace();
		}
		return diaSemana;
	}

	/**
	 * formateaNombreMes
	 * 
	 * @param numMes
	 *            numMes
	 * @return String
	 */
	private String formateaNombreMes(int numMes) {
		String nombreMes = "";

		try {
			switch (numMes) {
			case 1:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.enero", this.idioma);
				break;
			case 2:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.febrero", this.idioma);
				break;
			case V50bClsConstantes.TRES:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.marzo", this.idioma);
				break;
			case V50bClsConstantes.CUATRO:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.abril", this.idioma);
				break;
			case V50bClsConstantes.CINCO:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.mayo", this.idioma);
				break;
			case V50bClsConstantes.SEIS:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.junio", this.idioma);
				break;
			case V50bClsConstantes.SIETE:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.julio", this.idioma);
				break;
			case V50bClsConstantes.OCHO:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.agosto", this.idioma);
				break;
			case V50bClsConstantes.NUEVE:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.septiembre", this.idioma);
				break;
			case V50bClsConstantes.DIEZ:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.octubre", this.idioma);
				break;
			case V50bClsConstantes.ONCE:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.noviembre", this.idioma);
				break;
			case V50bClsConstantes.DOCE:
				nombreMes = Q70GestorMensajesi18n.getSingleton().getMessage(
						"v50bcomun", "comun.diciembre", this.idioma);
				break;
			default:
				break;
			}
		} catch (Q70GestorMensajesException e) {
			e.printStackTrace();
		}
		return nombreMes;
	}

	/**
	 * @return lista festivos
	 */
	public List getListaFestivos() {
		return this.listaFestivos;
	}

	/**
	 * @param listaFestivos
	 *            lsitafestivos
	 */
	public void setListaFestivos(List listaFestivos) {
		this.listaFestivos = listaFestivos;
	}

	/**
	 * @return the listaFestivosOriginal
	 */
	public List getListaFestivosOriginal() {
		return this.listaFestivosOriginal;
	}

	/**
	 * @param listaFestivosOriginal
	 *            the listaFestivosOriginal to set
	 */
	public void setListaFestivosOriginal(List listaFestivosOriginal) {
		this.listaFestivosOriginal = listaFestivosOriginal;
	}

}