package v50b.v50bAcceso;
 

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsIdioma;
import v50b.v50bClasesComunes.V50bClsPermisos;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import v50b.v50bControlador.V50bControladorFactory;
import es.ejie.frmk.infraestructura.seguridad.Q70LogonException;
import es.ejie.frmk.infraestructura.seguridad.Q70SeguridadException;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class V50bVerificacionAcceso.
 * 
 * @author iurkidi
 */
public class V50bVerificacionAcceso extends Q70ActionPasoOP {
	
	/**
     * 
     * @param contexto Q70ContextoEJIE
     * @param arg1 ActionErrors
     * @param arg2 ActionMapping
     * @param arg3 ActionForm
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * 
     * @throws Exception Se eleva la excepcin.
     */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest request,
			HttpServletResponse response) throws Exception {		
		//contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_SESSION_TOKEN,request.getSession().getId());

	}
	

	/**
     * @param contexto Q70ContextoEJIE
     * @param errores errors
     * @param actionMapping ActionMapping
     * @param arg3 ActionForm
     * @param request HttpServletRequest
     * @param arg5 HttpServletResponse
     * 
     * @return ActionForward
     * 
     * @throws Exception Se eleva la excepcin.
     */
    protected ActionForward processForward(Q70ContextoEJIE contexto, 
			   ActionErrors errores,
			   ActionMapping actionMapping, 
			   ActionForm arg3, 
			   HttpServletRequest request,
			   HttpServletResponse arg5) throws Exception {
    	
    	
    	if (errores.isEmpty()){ 
    		
    		String retorno = "";
    		try{
    			
    			//Primero ponemos el idioma desde XLNets
    			//String idioma = V50bClsPermisos.fncObtenerIdioma(request);
    			String idioma = request.getParameter(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);	
    			String idiomaGlobal = Q70ListenerUtils.getAppGroupLanguage(request,null);			
    			if (null == idiomaGlobal){	    
    				//Actualizar el valor del idioma compartido del contexto de aplicacion y el de la sesion
    				if(V50bClsConstantes.CONSTANTE_EUSKARA.equals(idioma)){
    					V50bClsIdioma.fncCambiarIdioma(request,contexto,idioma);
    				}else{
    					V50bClsIdioma.fncCambiarIdioma(request,contexto,V50bClsConstantes.CONSTANTE_CASTELLANO);
    				}
    			}else{
    				errores.add(V50bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA,new ActionError("error.idioma"));
    				return actionMapping.findForward("error");
    			}
	    		//Actualizar el valor del idioma compartido del contexto de aplicacion y el de la sesion
	    		/*if(idioma!=null && idioma.equals(V50bClsConstantes.XLNETS_CASTELLANO)){
	    			V50bClsIdioma.fncCambiarIdioma(request,contexto,V50bClsConstantes.CONSTANTE_CASTELLANO);
	    		}
	    		else{
	    			V50bClsIdioma.fncCambiarIdioma(request,contexto,V50bClsConstantes.CONSTANTE_EUSKARA);
	    		}*/
	    		
	    		//Ahora el tipo de usuario con el que estamos logeados en XLNets
	    		boolean bolPerfilTecnicoIvap = V50bClsPermisos.fncEsTecnicoIvap(request);
	    		
	    		V50bClsTrazas.depura("Es tecnico IVAP de XLNETS ",Boolean.valueOf(bolPerfilTecnicoIvap));	    		
	    		
	    		if(bolPerfilTecnicoIvap){
	    			//El usuario registrado pertenece al IVAP
	    			//contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_TIPO_USUARIO, V50bClsConstantes.PERFIL_TECNICO);
	    			contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_TIPO_USUARIO, V50bClsConstantes.USUARIO_TECNICO_IVAP);
	    				 
	    			//Dejamos datos del usuario logueado en el Contexto.
    				V50bUsuarioBean usuarioLogueado=V50bVerificacionAcceso.fncGuardarUsuarioLogueado(request, contexto);
	    			
	    			//Consultamos en la bd el perfil del usuario 
	    			final List listPerfiles = (List)V50bControladorFactory.getFachada().fncObtenerPerfilUsuario(usuarioLogueado);
	    			
	    			
	    			if(listPerfiles!=null && listPerfiles.size()>0){//si el usuario tiene perfil
	    				
	    				String strPerfil=((V50bUsuarioBean)listPerfiles.get(0)).getPerfilUsuario();
	    				V50bClsTrazas.depura("Perfil BD: ",strPerfil);
	    				//guardamos en contexto el perfil del usuario
	    				if(!"".equals(strPerfil) && V50bClsConstantes.PERFIL_TECNICO_IVAP_BD.equals(strPerfil)){
	    					//es tecnico
	    					contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_PERFIL_USUARIO, V50bClsConstantes.PERFIL_TECNICO);
	    					retorno = "tecnico";
	    				}else if(!"".equals(strPerfil) && V50bClsConstantes.PERFIL_RESOLUTOR_BD.equals(strPerfil)){
	    					//es resolutor
	    					contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_PERFIL_USUARIO, V50bClsConstantes.PERFIL_RESOLUTOR);
	    					retorno = "resolutor";
	    				}else if(!"".equals(strPerfil) && V50bClsConstantes.PERFIL_AMBOS_BD.equals(strPerfil)){
	    					//tiene ambos perfiles
	    					contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_PERFIL_USUARIO, V50bClsConstantes.PERFIL_AMBOS);
	    					retorno = "ambos";
	    				}else{//no tiene guardado el perfil
	    					contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_PERFIL_USUARIO, V50bClsConstantes.USUARIO_ANONIMO);
			    			retorno = "noValido";
	    				}
	    				//Modificamos el perfil del usuario logueado guardado en contexto
	    				V50bVerificacionAcceso.fncGuardarPerfilUsuarioLogueado(contexto,strPerfil,((V50bUsuarioBean)listPerfiles.get(0)).getNombreUsuario());
	    				
	    			}else{//no obtenemos perfil del usuario. lo ponemos como no valido
	    				contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_TIPO_USUARIO, V50bClsConstantes.USUARIO_ANONIMO);
		    			retorno = "noValido";
	    			}
	    			
	    		}else{
	    			contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_TIPO_USUARIO, V50bClsConstantes.USUARIO_ANONIMO);
	    			retorno = "noValido";
	    		}
    		} catch(Q70LogonException e){
    			contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_TIPO_USUARIO, V50bClsConstantes.USUARIO_ANONIMO);
                retorno = "noValido";	
    		}
    		    		
    		V50bClsTrazas.depura("Perfil usuario: ",retorno);
    		return actionMapping.findForward(retorno);	
    		
    	}else{
    		return actionMapping.findForward("error");
        }
   
    }//fin processForward
    
    /**
     * Guardamos los datos del usuario logueado en el contexto
     * @param request Request
     * @param contexto contexto 
     * @return V50bUsuarioBean usuario
     * @throws Q70SeguridadException ex
     * @throws Q70LogonException ex
     */
    private static V50bUsuarioBean fncGuardarUsuarioLogueado(HttpServletRequest request,Q70ContextoEJIE contexto) throws Q70SeguridadException, Q70LogonException{
    	
    	//Dejamos datos del usuario logeado en el Contexto.
		final V50bUsuarioBean usuario = new V50bUsuarioBean();
		usuario.setUsuarioXlnets(V50bClsPermisos.fncObtenerUsuarioLogin(request));
		usuario.setIpPuesto(V50bClsPermisos.fncObtenerIpPuesto(request));
		usuario.setDniUsuario(V50bClsPermisos.fncObtenerDniUsuarioLogin(request));
		contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_USUARIO_BEAN, usuario);
		
		return usuario;
    }
    
    /**
     * Guardamos el perfil del usuario logueado en el contexto
     * @param contexto contexto
     * @param strPerfil perfil del usuario
     * @param nombreUsuario nombre del usuario
     */
    private static void fncGuardarPerfilUsuarioLogueado(Q70ContextoEJIE contexto,String strPerfil,String nombreUsuario){
    	
    	V50bUsuarioBean usuarioLogueado=(V50bUsuarioBean)contexto.get(V50bClsConstantes.CONSTANTE_CONTEXTO_USUARIO_BEAN);
    	usuarioLogueado.setPerfilUsuario(strPerfil);
    	usuarioLogueado.setNombreUsuario(nombreUsuario);
    	contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_USUARIO_BEAN,usuarioLogueado);
    }

}
