package v50b.v50bAcceso;
 

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsIdioma;
import v50b.v50bClasesComunes.V50bClsPermisos;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import v50b.v50bControlador.V50bControladorFactory;
import es.ejie.frmk.infraestructura.seguridad.Q70LogonException;
import es.ejie.frmk.infraestructura.seguridad.Q70SeguridadException;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

/**
 * The Class V50bSimulaLoginAction.
 * 
 * @author iurkidi
 */
public class V50bSimulaLoginAction extends Q70ActionPasoOP {
	
	/**
     * 
     * @param contexto Q70ContextoEJIE
     * @param arg1 ActionErrors
     * @param arg2 ActionMapping
     * @param arg3 ActionForm
     * @param request HttpServletRequest
     * @param response HttpServletResponse
     * 
     * @throws Exception Se eleva la excepcin.
     */
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors arg1,
			ActionMapping arg2, ActionForm arg3, HttpServletRequest request,
			HttpServletResponse response) throws Exception {		
		//contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_SESSION_TOKEN,request.getSession().getId());

	}
	

	/**
     * @param contexto Q70ContextoEJIE
     * @param errores errors
     * @param actionMapping ActionMapping
     * @param arg3 ActionForm
     * @param request HttpServletRequest
     * @param arg5 HttpServletResponse
     * 
     * @return ActionForward
     * 
     * @throws Exception Se eleva la excepcin.
     */
    protected ActionForward processForward(Q70ContextoEJIE contexto, 
			   ActionErrors errores,
			   ActionMapping actionMapping, 
			   ActionForm arg3, 
			   HttpServletRequest request,
			   HttpServletResponse arg5) throws Exception {
    	
    	
    	//if (errores.isEmpty()){ 
    			
    			String retorno="";
    			
    			//Usuario
    			String usuarioLogin=request.getParameter("usuarioLogin");
    	
    			//guardamos el usuario logueado en contexto
    			V50bUsuarioBean usuarioLogueado=V50bSimulaLoginAction.fncGuardarUsuarioLogueado(request, contexto,usuarioLogin);
    			
    			//comprobamos que el usuario est dado de alta
	    		final List listPerfiles = (List)V50bControladorFactory.getFachada().fncObtenerPerfilUsuario(usuarioLogueado);
	    		
	    		if(listPerfiles!=null && listPerfiles.size()>0){//si el usuario tiene perfil
    		
	    			//Perfil
	    			//String perfil=request.getParameter("perfilLogin");
	    			String perfil;
	    			String strPerfil=((V50bUsuarioBean)listPerfiles.get(0)).getPerfilUsuario();
    				
    				//guardamos en contexto el perfil del usuario
    				if(!"".equals(strPerfil) && V50bClsConstantes.PERFIL_TECNICO_IVAP_BD.equals(strPerfil)){
    					//es tecnico
    					V50bClsTrazas.depura("Perfil BD: ",strPerfil);
    					perfil=V50bClsConstantes.PERFIL_TECNICO;
    				}else if(!"".equals(strPerfil) && V50bClsConstantes.PERFIL_RESOLUTOR_BD.equals(strPerfil)){
    					//es resolutor
    					V50bClsTrazas.depura("Perfil BD: ",strPerfil);
    					perfil=V50bClsConstantes.PERFIL_RESOLUTOR;
    				}else if(!"".equals(strPerfil) && V50bClsConstantes.PERFIL_AMBOS_BD.equals(strPerfil)){
    					//tiene ambos perfiles
    					V50bClsTrazas.depura("Perfil BD: ",strPerfil);
    					perfil=V50bClsConstantes.PERFIL_AMBOS;
    				}else{//no tiene guardado el perfil
    					perfil=V50bClsConstantes.USUARIO_ANONIMO;
    					V50bClsTrazas.depura("EL USUARIO NO TIENE SU PERFIL ERGISTRADO EN BD");
    				}
	    			
	    			//Idioma
	    			String idioma = request.getParameter("idiomaLogin");
	
		    		//Actualizar el valor del idioma compartido del contexto de aplicacion y el de la sesion
		    		if(idioma!=null && idioma.equals(V50bClsConstantes.CONSTANTE_CASTELLANO)){
		    			V50bClsIdioma.fncCambiarIdioma(request,contexto,V50bClsConstantes.CONSTANTE_CASTELLANO);
		    		}
		    		else{
		    			V50bClsIdioma.fncCambiarIdioma(request,contexto,V50bClsConstantes.CONSTANTE_EUSKARA);
		    		}
		    		
		    		contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_TIPO_USUARIO, V50bClsConstantes.USUARIO_TECNICO_IVAP);
		    		contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_PERFIL_USUARIO, perfil);
		    		//guardamos los datos del usuario en contexto
		    		usuarioLogueado.setPerfilUsuario(perfil);
		    		contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_USUARIO_BEAN, usuarioLogueado);
		    		
		    		V50bClsTrazas.depura("Perfil Usuario: ",perfil);	   
		    		V50bClsTrazas.depura("Idioma: ",idioma);
		    		
		    		retorno = perfil;
	    		
	    		}else{//no obtenemos perfil del usuario. lo ponemos como no valido
    				contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_TIPO_USUARIO, V50bClsConstantes.USUARIO_ANONIMO);
	    			retorno = "noValido";
    			}
    		
    		return actionMapping.findForward(retorno);	
    		
    	/*}else{
    		return actionMapping.findForward("error");
        }*/
   
    }//fin processForward
    
   
    /**
     * Guardamos los datos del usuario logueado en el contexto
     * @param request Request
     * @param contexto contexto 
     * @param usuarioLogin usuario logueado en el simulalogin
     * @return V50bUsuarioBean. datos del usuario logueado
     * @throws Q70SeguridadException ex
     * @throws Q70LogonException ex
     */
    private static V50bUsuarioBean fncGuardarUsuarioLogueado(HttpServletRequest request,Q70ContextoEJIE contexto,String usuarioLogin) throws Q70SeguridadException, Q70LogonException{
    	
    	V50bClsTrazas.depura("Dejando usuario en contexto.....");	 
    	
    	//Dejamos datos del usuario logeado en el Contexto.
		final V50bUsuarioBean usuario = new V50bUsuarioBean();
		usuario.setUsuarioXlnets(usuarioLogin);
		usuario.setIpPuesto(V50bClsPermisos.fncObtenerIpPuesto(request));
		usuario.setDniUsuario(V50bClsPermisos.fncObtenerDniUsuarioLogin(request));
		//usuario.setPerfilUsuario(strPerfil);
		//contexto.set(V50bClsConstantes.CONSTANTE_CONTEXTO_USUARIO_BEAN, usuario);
		
		return usuario;
    }

}
