package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bClasesComunes.V50bClsFunciones;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bConfiguracionTextosBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bConsultasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bMunicipiosBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bProvinciasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bSuscriptoresBD;
import v50b.v50bModelo.V50bDAOFactory;
import v50b.v50bModelo.v50bDao.V50bUsuariosRegistradosDAO;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;


/**
 * 
 * @author iurkidi
 *
 */
public class V50bUsuariosRegistradosDAOImpl implements V50bUsuariosRegistradosDAO{

	
	/**
	 * 
	 * <p>Ttulo: fncBuscarUsuariosRegistrados</p>
	 * <p>Descripcin: Busca usuarios registrados en base a un filtro</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Filtro de la bsqueda
	 * @return Lista resultados
	 * @throws Exception Cualquier excepcin
	 */
	public List fncBuscarUsuariosRegistrados(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosDAOImpl.fncBuscarUsuariosRegistrados() ");
		
		
		final StringBuffer sql = new StringBuffer(567);
		final List arrParams = new ArrayList();
		final String strIdioma = form.getIdioma();
		
		sql.append("SELECT T02.").append(V50bSuscriptoresBD.CSUSCR).append(" AS CODIGO, ");
		sql.append("LPAD(T02.").append(V50bSuscriptoresBD.CSUSCR).append(",?,'0') AS CODIGOORDEN, ");
		arrParams.add(new Integer(V50bClsConstantes.CINCO));
		sql.append("T02.").append(V50bSuscriptoresBD.DNICIF).append(" AS NIFOTROS, ");
		sql.append("T02.").append(V50bSuscriptoresBD.PASAPORTE).append(" AS PASAPORTE, ");
		sql.append("T02.").append(V50bSuscriptoresBD.INDOCU).append(" AS TIPO_IDENTIFICACION, ");
		sql.append("T02.").append(V50bSuscriptoresBD.AP1SUS).append(" ||' '|| T02.").append(V50bSuscriptoresBD.AP2SUS).append(" || ', ' || ");
		sql.append("T02.").append(V50bSuscriptoresBD.NOMSUS).append(" AS NOMAPE, ");
		sql.append("DECODE(T02.").append(V50bSuscriptoresBD.ESTADO).append(",?,?,?,?) AS ESTADO, ");
		arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.suscrita",strIdioma));
		arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.baja",strIdioma));
		
		sql.append("T02.").append(V50bSuscriptoresBD.RNOTIF).append(" AS RNOTIFICACION, ");
		sql.append("T02.").append(V50bSuscriptoresBD.EMAIL).append(" AS EMAIL, ");
		sql.append("T02.").append(V50bSuscriptoresBD.MOVIL).append(" AS MOVIL, ");
		sql.append("T02.").append(V50bSuscriptoresBD.USUARIO).append(" AS USUARIO, ");
		sql.append("T02.").append(V50bSuscriptoresBD.CLAVE).append(" AS CLAVE, ");
		//sql.append("T02.").append(V50bSuscriptoresBD.DIRECCION).append(" AS DIRECCION, ");
		sql.append("T22.").append(V50bProvinciasBD.DS_O).append(" AS TH, ");
		sql.append("T23.").append(V50bMunicipiosBD.DS_O).append(" AS MUNICIPIO, ");
		//sql.append("T02.").append(V50bSuscriptoresBD.CP).append(" AS CP, ");
		sql.append("T02.").append(V50bSuscriptoresBD.AP1SUS).append(" AS APELLIDO1, ");
		sql.append("T02.").append(V50bSuscriptoresBD.AP2SUS).append(" AS APELLIDO2, ");
		sql.append("T02.").append(V50bSuscriptoresBD.NOMSUS).append(" AS NOMBRE, ");
		sql.append("NVL2(T02.").append(V50bSuscriptoresBD.EMAIL).append(",?,?) AS TIENEMAIL, ");
		arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",strIdioma));
		arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",strIdioma));
		
		sql.append("NVL2(T02.").append(V50bSuscriptoresBD.MOVIL).append(",?,?) AS TIENEMOVIL ");
		arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",strIdioma));
		arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",strIdioma));
		
		sql.append("FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02, ");
		sql.append(V50bProvinciasBD.TABLA_PROVINCIAS).append(" T22, ");
		sql.append(V50bMunicipiosBD.TABLA_MUNICIPIOS).append(" T23 ");
		sql.append("WHERE T02.").append(V50bSuscriptoresBD.CSUSCR).append(" > 0 ");
		sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV).append(" = ");
		sql.append("T22.").append(V50bProvinciasBD.ID).append("(+)");
		sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI).append(" = ");
		sql.append("T23.").append(V50bMunicipiosBD.ID).append("(+)");
		sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV).append(" = ");
		sql.append("T23.").append(V50bMunicipiosBD.PROVINCIA_ID).append("(+)");
		
		if(StringUtils.isNotEmpty(form.getCodigo())){
			sql.append(" AND T02.").append(V50bSuscriptoresBD.CSUSCR).append(" = ? ");
			arrParams.add(Integer.valueOf(form.getCodigo()));
		}
		
		if(StringUtils.isNotEmpty(form.getCodigoDesde())){
			sql.append(" AND T02.").append(V50bSuscriptoresBD.CSUSCR).append(" >= ? ");
			arrParams.add(Integer.valueOf(form.getCodigoDesde()));
		}
		
		if(StringUtils.isNotEmpty(form.getCodigoHasta())){
			sql.append(" AND T02.").append(V50bSuscriptoresBD.CSUSCR).append(" <= ? ");
			arrParams.add(Integer.valueOf(form.getCodigoHasta()));
		}
		
		if(StringUtils.isNotEmpty(form.getNifOtros())){
			if(!form.getIndDocumento().equals(V50bClsConstantes.CONSTANTE_PASAPORTE)){
				sql.append(" AND T02.").append(V50bSuscriptoresBD.DNICIF).append(" = ? ");
				arrParams.add(form.getNifOtros());
			}else{
				sql.append(" AND T02.").append(V50bSuscriptoresBD.PASAPORTE).append(" = ? ");
				arrParams.add(form.getNifOtros());
			}
		}
		
		if(StringUtils.isNotEmpty(form.getNombre())){
			sql.append(" AND T02.").append(V50bSuscriptoresBD.NOMSUS).append(" LIKE ? ");
			arrParams.add(form.getNombre()+"%");
		}
		
		if(StringUtils.isNotEmpty(form.getApellido1())){
			sql.append(" AND T02.").append(V50bSuscriptoresBD.AP1SUS).append(" LIKE ? ");
			arrParams.add(form.getApellido1()+"%");
		}
		
		if(StringUtils.isNotEmpty(form.getApellido2())){
			sql.append(" AND T02.").append(V50bSuscriptoresBD.AP2SUS).append(" LIKE ? ");
			arrParams.add(form.getApellido2()+"%");
		}
		
		if(StringUtils.isNotEmpty(form.getIndMail())){
			if(V50bClsConstantes.CONSTANTE_SI.equals(form.getIndMail())){
				sql.append(" AND T02.").append(V50bSuscriptoresBD.EMAIL).append(" IS NOT NULL ");
			} else {
				sql.append(" AND T02.").append(V50bSuscriptoresBD.EMAIL).append(" IS NULL ");
			}
		}
		
		if(StringUtils.isNotEmpty(form.getIndMovil())){
			if(V50bClsConstantes.CONSTANTE_SI.equals(form.getIndMovil())){
				sql.append(" AND T02.").append(V50bSuscriptoresBD.MOVIL).append(" IS NOT NULL ");
			} else {
				sql.append(" AND T02.").append(V50bSuscriptoresBD.MOVIL).append(" IS NULL ");
			}
		}
		
		if(StringUtils.isNotEmpty(form.getRecibirNotif())){
			if(V50bClsConstantes.CONSTANTE_SI.equals(form.getRecibirNotif())){
				sql.append(" AND T02.").append(V50bSuscriptoresBD.RNOTIF).append(" != ? ");
				arrParams.add(V50bClsConstantes.AVISO_NO);
			} else {
				sql.append(" AND T02.").append(V50bSuscriptoresBD.RNOTIF).append(" = ? ");
				arrParams.add(V50bClsConstantes.AVISO_NO);
			}
		}
		
		sql.append(" ORDER BY 1");
		
		return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bUsuariosRegistradosRowMapper());
	}
	
	/**
	 * 
	 * <p>Ttulo: fncDetalleUsuarioRegistrado</p>
	 * <p>Descripcin: Busca los datos de un usuario</p>
	 * <p>Copyright: Copyright (c) Nov 7, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form formulario con el cdigo del usuario
	 * @return Objeto con los datos del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public V50bSuscriptorBean fncDetalleUsuarioRegistrado(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosDAOImpl.fncDetalleUsuarioRegistrado() ");
		
		final StringBuffer sql = new StringBuffer(527);
		final List arrParams = new ArrayList();
		final String strIdioma = form.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		final List lResult = new ArrayList();
		
		sql.append("SELECT T02.").append(V50bSuscriptoresBD.CSUSCR).append(" AS CODIGO, ");
		sql.append("T02.").append(V50bSuscriptoresBD.ESTADO).append(" AS ESTADO, ");
		sql.append("T02.").append(V50bSuscriptoresBD.INDOCU).append(" AS TIPO_IDENTIFICACION, ");
		sql.append("T02.").append(V50bSuscriptoresBD.DNICIF).append(" AS NIFOTROS, ");
		sql.append("T02.").append(V50bSuscriptoresBD.PASAPORTE).append(" AS PASAPORTE, ");
		sql.append("T02.").append(V50bSuscriptoresBD.AP1SUS).append(" AS APELLIDO1, ");
		sql.append("T02.").append(V50bSuscriptoresBD.AP2SUS).append(" AS APELLIDO2, ");
		sql.append("T02.").append(V50bSuscriptoresBD.NOMSUS).append(" AS NOMBRE, ");
		sql.append("T02.").append(V50bSuscriptoresBD.COPROV).append(" AS CODTH, ");
		sql.append("T02.").append(V50bSuscriptoresBD.COMUNI).append(" AS CODMUN, ");
		sql.append("T02.").append(V50bSuscriptoresBD.TFNO).append(" AS TELEFONO, ");
		sql.append("T02.").append(V50bSuscriptoresBD.MOVIL).append(" AS MOVIL, ");
		sql.append("T02.").append(V50bSuscriptoresBD.EMAIL).append(" AS EMAIL, ");
		sql.append("T02.").append(V50bSuscriptoresBD.RNOTIF).append(" AS NOTIFICACION, ");
		sql.append("T02.").append(V50bSuscriptoresBD.CODTRA).append(" AS TRABAJO, ");
		sql.append("T02.").append(V50bSuscriptoresBD.COPROF).append(" AS PROFESION, ");
		sql.append("T02.").append(V50bSuscriptoresBD.ACEPTACION).append(" AS ACEPTACION, ");
		sql.append("T02.").append(V50bSuscriptoresBD.SEXOSUSCR).append(" AS SEXO, ");
		sql.append("TO_CHAR(T02.").append(V50bSuscriptoresBD.FENACI).append(",?) AS FECHA_NACIMIENTO, ");
		arrParams.add(masc);
		
		sql.append("TO_CHAR(T02.").append(V50bSuscriptoresBD.FEALTA).append(",?) AS FECHA_ALTA, ");
		arrParams.add(masc);
		
		sql.append("TO_CHAR(T02.").append(V50bSuscriptoresBD.FEBAJA).append(",?) AS FECHA_BAJA, ");
		arrParams.add(masc);
		
		sql.append("T02.").append(V50bSuscriptoresBD.USUARIO).append(" AS USUARIO, ");
		sql.append("T02.").append(V50bSuscriptoresBD.CLAVE).append(" AS CLAVE, ");
//		sql.append("T02.").append(V50bSuscriptoresBD.DIRECCION).append(" AS DIRECCION, ");
//		sql.append("T02.").append(V50bSuscriptoresBD.CP).append(" AS CP, ");
		sql.append("TPROV.").append(V50bProvinciasBD.DS_O).append(" AS NOMTH, ");
		sql.append("TMUN.").append(V50bMunicipiosBD.DS_O).append(" AS NOMMUN ");
		
		sql.append("FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02, ");
		sql.append(V50bProvinciasBD.TABLA_PROVINCIAS).append(" TPROV, ");
		sql.append(V50bMunicipiosBD.TABLA_MUNICIPIOS).append(" TMUN ");
		sql.append("WHERE T02.").append(V50bSuscriptoresBD.CSUSCR).append(" = ? ");
		arrParams.add(Integer.valueOf(form.getCodigo()));
		
		sql.append("AND T02.").append(V50bSuscriptoresBD.COPROV).append(" = ");
		sql.append("TPROV.").append(V50bProvinciasBD.ID).append("(+) ");
		sql.append("AND T02.").append(V50bSuscriptoresBD.COPROV).append(" = ");
		sql.append("TMUN.").append(V50bMunicipiosBD.PROVINCIA_ID).append("(+) ");
		sql.append("AND T02.").append(V50bSuscriptoresBD.COMUNI).append(" = ");
		sql.append("TMUN.").append(V50bMunicipiosBD.ID).append("(+) ");
		
		lResult.addAll(new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bDetUsuarioRegistradoRowMapper()));
		
		return (V50bSuscriptorBean)lResult.get(0);
	}
	
	
	/**
	 * 
	 * <p>Ttulo: fncNuevoUsuarioRegistrado</p>
	 * <p>Descripcin: Inserta en BDD un nuevo suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario de Detalle del usuario
	 * @return Lista con el resultado de la operacin y el cdigo del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public List fncNuevoUsuarioRegistrado(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosDAOImpl.fncNuevoUsuarioRegistrado() ");
		
		final StringBuffer sql = new StringBuffer(238);
		final List arrParams = new ArrayList();
		final String strIdioma = form.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		final List lResult = new ArrayList();
		final String codSus = V50bDAOFactory.getConsultasDAO().fncGenericoNextVal(V50bSuscriptoresBD.SEQ_SUSCRIPTORES).toString();
		final String fechaActualFormateada = V50bClsFecha.fncPresentarFechaCorta(V50bClsFecha.fncObtenerFechaSistemaCorta(), strIdioma.toString());
		
		sql.append("INSERT INTO ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 (");
		sql.append("T02.").append(V50bSuscriptoresBD.CSUSCR).append(", T02.").append(V50bSuscriptoresBD.ESTADO).append(", ");
		if(!form.getIndDocumento().equals(V50bClsConstantes.CONSTANTE_PASAPORTE)){
			sql.append("T02.").append(V50bSuscriptoresBD.DNICIF);	
		}else{
			sql.append("T02.").append(V50bSuscriptoresBD.PASAPORTE);
		}
		sql.append(", T02.").append(V50bSuscriptoresBD.AP1SUS).append(", ");
		sql.append("T02.").append(V50bSuscriptoresBD.AP2SUS).append(", T02.").append(V50bSuscriptoresBD.NOMSUS).append(", ");
		sql.append("T02.").append(V50bSuscriptoresBD.COPROV).append(", T02.").append(V50bSuscriptoresBD.COMUNI).append(", ");
		sql.append("T02.").append(V50bSuscriptoresBD.TFNO).append(", T02.").append(V50bSuscriptoresBD.MOVIL).append(", ");
		sql.append("T02.").append(V50bSuscriptoresBD.EMAIL).append(", T02.").append(V50bSuscriptoresBD.RNOTIF).append(", ");
		sql.append("T02.").append(V50bSuscriptoresBD.CODTRA).append(", T02.").append(V50bSuscriptoresBD.COPROF).append(", ");
		sql.append("T02.").append(V50bSuscriptoresBD.FENACI).append(", T02.").append(V50bSuscriptoresBD.FEALTA).append(", ");
		sql.append("T02.").append(V50bSuscriptoresBD.FEBAJA).append(", T02.").append(V50bSuscriptoresBD.USUARIO).append(", ");
		sql.append("T02.").append(V50bSuscriptoresBD.CLAVE).append(", T02.").append(V50bSuscriptoresBD.FECMOD).append(", ");
		sql.append("T02.").append(V50bSuscriptoresBD.SEXOSUSCR).append(", T02.").append(V50bSuscriptoresBD.ACEPTACION).append(", ");
		sql.append("T02.").append(V50bSuscriptoresBD.INDOCU);
//		sql.append(", T02.").append(V50bSuscriptoresBD.DIRECCION).append(", ");
//		sql.append("T02.").append(V50bSuscriptoresBD.CP);
		sql.append(") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,TO_DATE(?,?),TO_DATE(?,?),TO_DATE(?,?),?,?,TO_DATE(?,?),?,?,?)");
		
		arrParams.add(Integer.valueOf(codSus));
		
		if(StringUtils.isNotEmpty(form.getEstado())){
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		}
				
		if(form.getNifOtros()!=null && !form.getNifOtros().equals("")) {
			arrParams.add(form.getNifOtros().toUpperCase());
		} else if(form.getPasaporte()!=null && !form.getPasaporte().equals("")){
			arrParams.add(form.getPasaporte().toUpperCase());
		}
		
		arrParams.add(form.getApellido1());
		
		if(StringUtils.isNotEmpty(form.getApellido2())){
			arrParams.add(form.getApellido2());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getNombre())){
			arrParams.add(form.getNombre());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getCodTh())){
			arrParams.add(form.getCodTh());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getCodMunicipio())){
			arrParams.add(form.getCodMunicipio());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getTelefono())){
			arrParams.add(form.getTelefono());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getMovil())){
			arrParams.add(form.getMovil());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getEmail())){
			arrParams.add(form.getEmail());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getRecibirNotif())){
			arrParams.add(form.getRecibirNotif());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getCodTipoTrabajo())){
			arrParams.add(Integer.valueOf(form.getCodTipoTrabajo()));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_INTEGER);
		}
		
		if(StringUtils.isNotEmpty(form.getCodProfesion())){
			arrParams.add(Integer.valueOf(form.getCodProfesion()));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_INTEGER);
		}
		
		if(StringUtils.isNotEmpty(form.getFechaNacimiento())){
			arrParams.add(form.getFechaNacimiento());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParams.add(masc);
		
		arrParams.add(form.getFechaAlta());
		arrParams.add(masc);
		
		if(StringUtils.isNotEmpty(form.getFechaBaja())){
			arrParams.add(form.getFechaBaja());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParams.add(masc);

		arrParams.add(form.getUsuario());

		arrParams.add(form.getClave());
		
		arrParams.add(fechaActualFormateada);
		arrParams.add(masc);
		
		if(StringUtils.isNotEmpty(form.getSexo())){
			arrParams.add(form.getSexo());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getAceptacion())){
			arrParams.add(form.getAceptacion());
		}else{
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(form.getIndDocumento())){
			arrParams.add(form.getIndDocumento());	
		}else{
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
//		if(StringUtils.isNotEmpty(form.getDireccion())){
//			arrParams.add(form.getDireccion());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
//		}
//		
//		if(StringUtils.isNotEmpty(form.getCp())){
//			arrParams.add(form.getCp());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
//		}
		
		lResult.add(new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams)));
		lResult.add(codSus);
		return lResult;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncModificarUsuarioRegistrado</p>
	 * <p>Descripcin: Modifica un suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con los datos a modificar
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncModificarUsuarioRegistrado(V50bSuscriptorBean form) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosDAOImpl.fncModificarUsuarioRegistrado() ");
		
		final StringBuffer sql = new StringBuffer(250);
		final List arrParams = new ArrayList();
		final String strIdioma = form.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		final String fechaActualFormateada = V50bClsFecha.fncPresentarFechaCorta(V50bClsFecha.fncObtenerFechaSistemaCorta(), strIdioma.toString());
		
		sql.append("UPDATE ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 SET ");
		
		sql.append("T02.").append(V50bSuscriptoresBD.FECMOD).append("= TO_DATE(?,?), ");
		if(StringUtils.isNotEmpty(fechaActualFormateada)){
			arrParams.add(fechaActualFormateada);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParams.add(masc);
		
		sql.append("T02.").append(V50bSuscriptoresBD.ESTADO).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getEstado())){
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		}
		if(!form.getIndDocumento().equals(V50bClsConstantes.CONSTANTE_PASAPORTE)){
			sql.append("T02.").append(V50bSuscriptoresBD.DNICIF).append("= ?, ");
			sql.append("T02.").append(V50bSuscriptoresBD.PASAPORTE).append("= ?, ");
			if(StringUtils.isNotEmpty(form.getNifOtros())){
				arrParams.add(form.getNifOtros());
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}
		}else{
			sql.append("T02.").append(V50bSuscriptoresBD.PASAPORTE).append("= ?, ");
			sql.append("T02.").append(V50bSuscriptoresBD.DNICIF).append("= ?, ");
			if(StringUtils.isNotEmpty(form.getNifOtros())){
				arrParams.add(form.getNifOtros());
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			} else {
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.INDOCU).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getIndDocumento())){
			arrParams.add(form.getIndDocumento());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.AP1SUS).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getApellido1())){
			arrParams.add(form.getApellido1());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.AP2SUS).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getApellido2())){
			arrParams.add(form.getApellido2());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.NOMSUS).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getNombre())){
			arrParams.add(form.getNombre());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.COPROV).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getCodTh())){
			arrParams.add(form.getCodTh());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.COMUNI).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getCodMunicipio())){
			arrParams.add(form.getCodMunicipio());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.TFNO).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getTelefono())){
			arrParams.add(form.getTelefono());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.MOVIL).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getMovil())){
			arrParams.add(form.getMovil());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.EMAIL).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getEmail())){
			arrParams.add(form.getEmail());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.RNOTIF).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getRecibirNotif())){
			arrParams.add(form.getRecibirNotif());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.CODTRA).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getCodTipoTrabajo())){
			arrParams.add(Integer.valueOf(form.getCodTipoTrabajo()));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_INTEGER);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.COPROF).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getCodProfesion())){
			arrParams.add(Integer.valueOf(form.getCodProfesion()));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_INTEGER);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.FENACI).append("= TO_DATE(?,?), ");
		if(StringUtils.isNotEmpty(form.getFechaNacimiento())){
			arrParams.add(form.getFechaNacimiento());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParams.add(masc);
		
		sql.append("T02.").append(V50bSuscriptoresBD.FEALTA).append("= TO_DATE(?,?), ");
		if(StringUtils.isNotEmpty(form.getFechaAlta())){
			arrParams.add(form.getFechaAlta());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParams.add(masc);
		
		sql.append("T02.").append(V50bSuscriptoresBD.FEBAJA).append("= TO_DATE(?,?), ");
		if(StringUtils.isNotEmpty(form.getFechaBaja())){
			arrParams.add(form.getFechaBaja());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		arrParams.add(masc);
		
		sql.append("T02.").append(V50bSuscriptoresBD.USUARIO).append("= ?, ");
		if(StringUtils.isNotEmpty(form.getUsuario())){
			arrParams.add(form.getUsuario());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.CLAVE).append("=?, ");
		if(StringUtils.isNotEmpty(form.getClave())){
			arrParams.add(form.getClave());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
						
		sql.append("T02.").append(V50bSuscriptoresBD.SEXOSUSCR).append("=?, ");
		if(StringUtils.isNotEmpty(form.getSexo())){
			arrParams.add(form.getSexo());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		sql.append("T02.").append(V50bSuscriptoresBD.ACEPTACION).append("=? ");
		if(StringUtils.isNotEmpty(form.getAceptacion())){
			arrParams.add(form.getAceptacion());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
//		sql.append("T02.").append(V50bSuscriptoresBD.DIRECCION).append("=?, ");
//		if(StringUtils.isNotEmpty(form.getDireccion())){
//			arrParams.add(form.getDireccion());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
//		}
//		
//		sql.append("T02.").append(V50bSuscriptoresBD.CP).append("=? ");
//		if(StringUtils.isNotEmpty(form.getCp())){
//			arrParams.add(form.getCp());
//		} else {
//			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
//		}
		
		sql.append("WHERE ");
		sql.append("T02.").append(V50bSuscriptoresBD.CSUSCR).append("= ?");
		arrParams.add(Integer.valueOf(form.getCodigo()));
		
		return new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams));
	}
	
	/**
	 * <p>Ttulo: fncExisteSuscriptor</p>
	 * <p>Descripcin: Funcion q comprueba si existe un suscriptor en la base de datos. Si existe envia un true</p>
	 * <p>Copyright: Copyright (c) 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param dni DNI
	 * @param codSus El cdigo del suscriptor
	 * @return boolean
	 * @throws Exception Cualquier excepcion
	 */
	public boolean fncExisteSuscriptor(String dni, String codSus) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosDAOImpl.fncExisteSuscriptor() ");
		
		boolean existe=false;
		final StringBuffer sql = new StringBuffer(35);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT COUNT(1) FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES);
		sql.append(" WHERE ").append(V50bSuscriptoresBD.DNICIF).append("= ?");
		arrParams.add(dni);
		
		if(StringUtils.isNotEmpty(codSus)){
			sql.append(" AND ").append(V50bSuscriptoresBD.CSUSCR).append("!= ?");
			arrParams.add(Integer.valueOf(codSus));
		}
		
		String a = new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString(), arrParams);
		
		if(a!=null && Integer.parseInt(a)>0) {
			existe = true;
		} else {
			existe = false;
		}
		
		return existe;
	}
	
	/**
	 * <p>Ttulo: fncExisteUsuario</p>
	 * <p>Descripcin: Funcion q comprueba si existe un suscriptor en la base de datos. Si existe envia un true</p>
	 * <p>Copyright: Copyright (c) 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param usuario usuario
	 * @param codSus codigo del suscriptor
	 * @return boolean
	 * @throws Exception Cualquier excepcion
	 */
	public boolean fncExisteUsuario(String usuario,String codSus) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosDAOImpl.fncExisteUsuario() ");
		
		boolean existe=false;
		final StringBuffer sql = new StringBuffer(40);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT COUNT(1) FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES);
		sql.append(" WHERE ").append(V50bSuscriptoresBD.USUARIO).append("= ?");
		arrParams.add(usuario);
		if(StringUtils.isNotEmpty(codSus)){
			sql.append(" AND ").append(V50bSuscriptoresBD.CSUSCR).append("!= ?");
			arrParams.add(Integer.valueOf(codSus));
		}
		
		String a = new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString(), arrParams);
		
		if(a!=null && Integer.parseInt(a)>0) {
			existe = true;
		} else {
			existe = false;
		}
		
		return existe;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncCargaEmailRemitente</p>
	 * <p>Descripcin: Obtiene el email del remitente</p>
	 * <p>Copyright: Copyright (c) Nov 20, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @return String email del remitente
	 * @throws Exception Cualquier excepcin
	 */
	public String fncCargaEmailRemitente() throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosDAOImpl.fncCargaEmailRemitente() ");
		
		final StringBuffer sql = new StringBuffer(23);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT ").append(V50bConfiguracionTextosBD.EMAIL);
		sql.append(" FROM ").append(V50bConfiguracionTextosBD.TABLA_CONFIG_TEXTOS);
		sql.append(" WHERE ").append(V50bConfiguracionTextosBD.CPROPI).append("= ?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.CONSTANTE_TEXTO_EMAIL_REMITENTE));
		
		String result = new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString(), arrParams);
		
		if(StringUtils.isNotEmpty(result)){
			return result;
		} else {
			return "";
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncComunicacionSuscriptor</p>
	 * <p>Descripcin: Obtiene los datos para comunicacin al suscriptor</p>
	 * <p>Copyright: Copyright (c) Nov 20, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codSuscr cdigo del suscriptor
	 * @return V50bSuscriptorBean Los datos de comunicacin del suscriptor
	 * @throws Exception Cualquier excepcin
	 */
	public V50bSuscriptorBean fncComunicacionSuscriptor(String codSuscr) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosDAOImpl.fncComunicacionSuscriptor() ");
		
		final StringBuffer sql = new StringBuffer(75);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T02.").append(V50bSuscriptoresBD.EMAIL).append(" AS EMAIL, ");
		sql.append("T02.").append(V50bSuscriptoresBD.MOVIL).append(" AS MOVIL, ");
		sql.append("T02.").append(V50bSuscriptoresBD.RNOTIF).append(" AS AVISO ");
		sql.append("FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 ");
		sql.append("WHERE T02.").append(V50bSuscriptoresBD.CSUSCR).append(" = ?");
		arrParams.add(Integer.valueOf(codSuscr));
		
		return (V50bSuscriptorBean)(new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bComunicacionSuscriptorRowMapper())).get(0);
	}
	
	/**
	 * 
	 * <p>Ttulo: fncModificarConsultas</p>
	 * <p>Descripcin: Modifica las consultas de un usuario</p>
	 * <p>Copyright: Copyright (c) Nov 11, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codUsuario String con el codigo de usuario
	 * @return Entero con el resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncModificarConsultas(String codUsuario) throws Exception {
		V50bClsTrazas.depura("V50bUsuariosRegistradosDAOImpl.fncModificarConsultas ");
		
		final StringBuffer sql=new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("UPDATE ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 SET ");
		sql.append("T01.").append(V50bConsultasBD.CSUSCR).append("=? ");
		sql.append("WHERE T01.").append(V50bConsultasBD.CSUSCR).append("=?");
		arrParams.add(Integer.toString(V50bClsConstantes.NOVENTAYNUEVEMIL_NOVECIENTOS_NOVENTAYNUEVE));
		arrParams.add(codUsuario);
		
		return new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams));
	}
	
	/**
	 * <p>Ttulo: fncEliminarUsuarioRegistrado</p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) 04/2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param usuario v50aUsuario
	 * @return int
	 * @throws Exception Cualquier excepcion
	 */
	public int fncEliminarUsuarioRegistrado(V50bSuscriptorBean usuario) throws Exception
	{
		V50bClsTrazas.depura("V50bUsuariosRegistradosDAOImpl.fncEliminarUsuarioRegistrado ");
		
		final StringBuffer sql=new StringBuffer(50);
		final List arrParams=new ArrayList();
		
		sql.append("DELETE FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES);
		sql.append(" WHERE ");
		sql.append(V50bSuscriptoresBD.CSUSCR).append("=?");
		
		arrParams.add(usuario.getCodigo());
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	//***************
	//* ROW-MAPPERS *
	//***************
	/**
	 * 
	 * @author llaparra
	 *
	 */
	class V50bUsuariosRegistradosRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Excepcin SQL.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bSuscriptorBean suscriptor = new V50bSuscriptorBean();
			
			suscriptor.setCodigo(rs.getString("CODIGO"));
			suscriptor.setCodigoOrden(rs.getString("CODIGOORDEN"));
			suscriptor.setIndDocumento(rs.getString("TIPO_IDENTIFICACION"));
			if(!suscriptor.getIndDocumento().equals(V50bClsConstantes.CONSTANTE_PASAPORTE)){
				suscriptor.setNifOtros(rs.getString("NIFOTROS"));
			}else{
				suscriptor.setNifOtros(rs.getString("PASAPORTE"));
			}
			
			suscriptor.setNomApe(rs.getString("NOMAPE"));
			suscriptor.setEstado(rs.getString("ESTADO"));
			suscriptor.setRecibirNotif(rs.getString("RNOTIFICACION"));
			suscriptor.setEmail(rs.getString("EMAIL"));
			suscriptor.setMovil(rs.getString("MOVIL"));
			suscriptor.setUsuario(rs.getString("USUARIO"));
			suscriptor.setClave(rs.getString("CLAVE"));
			//suscriptor.setDireccion(rs.getString("DIRECCION"));
			suscriptor.setNomTh(rs.getString("TH"));
			suscriptor.setNomMunicipio(rs.getString("MUNICIPIO"));
			//suscriptor.setCp(rs.getString("CP"));
			suscriptor.setApellido1(rs.getString("APELLIDO1"));
			suscriptor.setApellido2(rs.getString("APELLIDO2"));
			suscriptor.setNombre(rs.getString("NOMBRE"));
			suscriptor.setIndMail(rs.getString("TIENEMAIL"));
			suscriptor.setIndMovil(rs.getString("TIENEMOVIL"));
			
			
			return suscriptor;
		}
	}
	
	/**
	 * 
	 * @author llaparra
	 *
	 */
	class V50bComunicacionSuscriptorRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Excepcin SQL.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bSuscriptorBean suscriptor = new V50bSuscriptorBean();
			
			suscriptor.setEmail(rs.getString("EMAIL"));
			suscriptor.setMovil(rs.getString("MOVIL"));
			suscriptor.setRecibirNotif(rs.getString("AVISO"));
			
			return suscriptor;
		}
	}
	
	
	/**
	 * 
	 * @author llaparra
	 *
	 */
	class V50bDetUsuarioRegistradoRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Excepcin SQL.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bSuscriptorBean suscriptor = new V50bSuscriptorBean();
			
			suscriptor.setCodigo(rs.getString("CODIGO"));
			suscriptor.setEstado(rs.getString("ESTADO"));
			suscriptor.setIndDocumento(rs.getString("TIPO_IDENTIFICACION"));
			if(!suscriptor.getIndDocumento().equals(V50bClsConstantes.CONSTANTE_PASAPORTE)){
				suscriptor.setNifOtros(rs.getString("NIFOTROS"));
			}else{
				suscriptor.setNifOtros(rs.getString("PASAPORTE"));
			}
			suscriptor.setApellido1(rs.getString("APELLIDO1"));
			suscriptor.setApellido2(rs.getString("APELLIDO2"));
			suscriptor.setNombre(rs.getString("NOMBRE"));
			suscriptor.setCodTh(rs.getString("CODTH"));
			suscriptor.setCodMunicipio(rs.getString("CODMUN"));
			suscriptor.setTelefono(rs.getString("TELEFONO"));
			suscriptor.setMovil(rs.getString("MOVIL"));
			suscriptor.setEmail(rs.getString("EMAIL"));
			suscriptor.setRecibirNotif(rs.getString("NOTIFICACION"));
			suscriptor.setCodTipoTrabajo(rs.getString("TRABAJO"));
			suscriptor.setCodProfesion(rs.getString("PROFESION"));
			suscriptor.setSexo(rs.getString("SEXO"));
			suscriptor.setFechaNacimiento(rs.getString("FECHA_NACIMIENTO"));
			suscriptor.setFechaAlta(rs.getString("FECHA_ALTA"));
			suscriptor.setFechaBaja(rs.getString("FECHA_BAJA"));
			suscriptor.setUsuario(rs.getString("USUARIO"));
			suscriptor.setClave(rs.getString("CLAVE"));
			//suscriptor.setDireccion(rs.getString("DIRECCION"));
			//suscriptor.setCp(rs.getString("CP"));
			suscriptor.setNomTh(rs.getString("NOMTH"));
			suscriptor.setNomMunicipio(rs.getString("NOMMUN"));
			suscriptor.setAceptacion(rs.getString("ACEPTACION"));
			
			return suscriptor;
		}
	}
}
