package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bBeans.V50bTipoTrabajoBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bSuscriptoresBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bTipoTrabajoBD;
import v50b.v50bModelo.v50bDao.V50bTipoTrabajoDAO;


/**
 * 
 * @author alata
 *
 */
public class V50bTipoTrabajoDAOImpl implements V50bTipoTrabajoDAO {
	
	/**
	 * @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception {
		V50bClsTrazas.depura("V50bTipoTrabajoDAOImpl.fncBuscarTiposTrabajo() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.DOSCIENTOSSEIS);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T11.").append(V50bTipoTrabajoBD.CODTRA).append(" AS CODIGO, ");
		sql.append("LPAD(T11.").append(V50bTipoTrabajoBD.CODTRA).append(",?,'0') AS CODIGOORDEN, T11.");
		arrParams.add(new Integer(V50bClsConstantes.DOS));
		sql.append(V50bTipoTrabajoBD.DESCC).append(" AS DESCRIPCIONCASTELLANO, T11.");
		sql.append(V50bTipoTrabajoBD.DESCE).append(" AS DESCRIPCIONEUSKERA, DECODE(T11.");
		sql.append(V50bTipoTrabajoBD.ESTADO).append(", '");
		sql.append(V50bClsConstantes.CONSTANTE_ALTA).append("', '");
		sql.append(V50bClsConstantes.LITERAL_DESC_ALTA).append("', '");
		sql.append(V50bClsConstantes.CONSTANTE_BAJA).append("', '"); 
		sql.append(V50bClsConstantes.LITERAL_DESC_BAJA).append("') AS ESTADO FROM ");
		sql.append(V50bTipoTrabajoBD.TABLA_TIPOTRABAJO).append(" T11 ");
		sql.append("WHERE T11.").append(V50bTipoTrabajoBD.CODTRA).append(" > 0");
		
		String codtra = tipoTrabajo.getCodtra();
		String descc = tipoTrabajo.getDescc();
		String desce = tipoTrabajo.getDesce();
		String estado = tipoTrabajo.getEstado();
		
		if(codtra!=null && !"".equals(codtra)){
			int codigo = Integer.parseInt(codtra);
			sql.append(" AND T11.").append(V50bTipoTrabajoBD.CODTRA);
			sql.append(" = ").append(codigo);
		}
		
		if(descc!=null && !"".equals(descc)){
			sql.append(" AND UPPER(T11.").append(V50bTipoTrabajoBD.DESCC);
			sql.append(") LIKE ?");
			arrParams.add("%"+descc.toUpperCase()+"%");
		}
		
		if(desce!=null && !"".equals(desce)){
			sql.append(" AND UPPER(T11.").append(V50bTipoTrabajoBD.DESCE);
			sql.append(") LIKE ?");
			arrParams.add("%"+desce.toUpperCase()+"%");
		}
		if (estado!=null){
			sql.append(" AND T11.").append(V50bTipoTrabajoBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append("'");
		}else{
			sql.append(" AND T11.").append(V50bTipoTrabajoBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_ALTA).append("'");
		}
		sql.append(" ORDER BY 1");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bTipoTrabajoRowMapper());
		
		return lista;
	}
	
	/**
	* @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception {
		
		V50bClsTrazas.depura("V50bTipoTrabajoDAOImpl.fncModificarTiposTrabajo() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CINCUENTAYNUEVE);
		final List arrParams = new ArrayList();
		
		String codtra = tipoTrabajo.getCodtra();
		String descc = tipoTrabajo.getDescc();
		String desce = tipoTrabajo.getDesce();
		String estado = tipoTrabajo.getEstado();
		
		sql.append("UPDATE ");sql.append(V50bTipoTrabajoBD.TABLA_TIPOTRABAJO).append(" T11");
		sql.append(" SET T11.");
		sql.append(V50bTipoTrabajoBD.DESCC);sql.append(" = ?, T11.");
		
		if (descc==null || "".equals(descc)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(descc);
		}
		
		sql.append(V50bTipoTrabajoBD.DESCE);sql.append(" = ?, T11.");
		
		if(desce==null || "".equals(desce)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(desce);
		}
		
		sql.append(V50bTipoTrabajoBD.ESTADO);sql.append(" = ? ");
		
		if(estado==null || "".equals(estado)){
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		}else{
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		}
		
		int codigo = Integer.parseInt(codtra);
		sql.append("WHERE T11.").append(V50bTipoTrabajoBD.CODTRA).append(" = ").append(codigo);
				
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	* @param tipoTrabajo : tipoTrabajo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirTiposTrabajo(V50bTipoTrabajoBean tipoTrabajo) throws Exception {
		V50bClsTrazas.depura("V50bTipoTrabajoDAOImpl.fncAniadirTiposTrabajo() ");
		
		final StringBuffer sql = new StringBuffer();
		final List arrParams = new ArrayList();
		final StringBuffer sqlVal = new StringBuffer(V50bClsConstantes.VEINTE);	
		
		sqlVal.append("SELECT MAX(");sqlVal.append(V50bTipoTrabajoBD.CODTRA);
		sqlVal.append(")+1 FROM ").append(V50bTipoTrabajoBD.TABLA_TIPOTRABAJO);
		
		String id = new V50bClsAccesoBD().fncConsultaEspecifica(sqlVal.toString());
		
		if(id==null || id.equals("")){
			//la tabla esta vaca, no hay expedientes an
			id="1";
		}
		
		if("100".equals(id)){
			return V50bClsConstantes.TRES_NEGATIVO;
		}else{
			tipoTrabajo.setCodtra(id);
			int codigo = Integer.parseInt(tipoTrabajo.getCodtra());
			
			sql.append("INSERT INTO ").append(V50bTipoTrabajoBD.TABLA_TIPOTRABAJO).append("(");
			sql.append(V50bTipoTrabajoBD.CODTRA).append(", ");
			sql.append(V50bTipoTrabajoBD.DESCC).append(", ");
			sql.append(V50bTipoTrabajoBD.DESCE).append(", ");
			sql.append(V50bTipoTrabajoBD.ESTADO).append(") VALUES(");
			sql.append(codigo).append(",?,?,?) ");
			
			String descc = tipoTrabajo.getDescc();
			String desce = tipoTrabajo.getDesce();
			String estado = tipoTrabajo.getEstado();
			
			
			if(descc==null || "".equals(descc)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(descc);
			}
			
			if(desce==null || "".equals(desce)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(desce);
			}
			
			if(estado==null || "".equals(estado)){
				arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
			}else{
				arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
			}
					
			return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		}
	}
	
	/**
	 * @param codTipoTrabajo : codigo de tipoTrabajo 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarTipoTrabajoUsuarios(String codTipoTrabajo) throws Exception {
		V50bClsTrazas.depura("V50bTipoTrabajoDAOImpl.fncBuscarTipoTrabajoUsuarios() ");

		final StringBuffer sql = new StringBuffer(34);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT ").append(V50bSuscriptoresBD.CSUSCR).append(" AS CODIGO");
		sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES);
		sql.append(" WHERE ").append(V50bSuscriptoresBD.CODTRA).append(" = ?");
		arrParams.add(Integer.valueOf(codTipoTrabajo));
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bTipoTrabajoUsuariosRowMapper());

		return lista;

	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bTipoTrabajoRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bTipoTrabajoBean tipoTrabajo = new V50bTipoTrabajoBean();
			
			tipoTrabajo.setCodtra(rs.getString("CODIGO"));
			tipoTrabajo.setCodtraOrden(rs.getString("CODIGOORDEN"));
			tipoTrabajo.setDescc(rs.getString("DESCRIPCIONCASTELLANO"));
			tipoTrabajo.setDesce(rs.getString("DESCRIPCIONEUSKERA"));
			tipoTrabajo.setEstado(rs.getString("ESTADO"));

			return tipoTrabajo;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bTipoTrabajoUsuariosRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bSuscriptorBean usuario = new V50bSuscriptorBean();
			
			usuario.setCodigo(rs.getString("CODIGO"));
			
			return usuario;
		}
	}

}
