package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bSubcategoriasBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bConsultasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bSubcategoriasBD;
import v50b.v50bModelo.v50bDao.V50bSubcategoriasDAO;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bAmbitoBD;

/**
 * 
 * @author acompes
 * 
 */
public class V50bSubcategoriasDAOImpl implements V50bSubcategoriasDAO {

	/**
	 * @param subcategorias
	 *            :Subcategorias con los datos de busqueda
	 * @return List
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public List fncBuscarSubcategorias(V50bSubcategoriasBean subcategorias)
			throws Exception {

		V50bClsTrazas
				.depura("V50bSubcategoriasDAOImpl.fncBuscarSubcategorias() ");
		final StringBuffer sql = new StringBuffer(320);
		final List arrParams = new ArrayList();

		sql.append("SELECT T08.").append(V50bSubcategoriasBD.CODSUB).append(
				" AS CODIGO, ");
		sql.append("LPAD(T08.").append(V50bSubcategoriasBD.CODSUB).append(
				",?,'0') AS CODIGOORDEN, T08.");
		arrParams.add(new Integer(V50bClsConstantes.DOS));
		sql.append(V50bSubcategoriasBD.DESCAS).append(
				" AS DESCRIPCIONCASTELLANO, T08.");
		sql.append(V50bSubcategoriasBD.DESEUS).append(
				" AS DESCRIPCIONEUSKERA, T08.");
		sql.append(V50bSubcategoriasBD.CODAMBITO).append(
				" AS CODIGOAMBITO, T07.");
		sql.append(V50bAmbitoBD.DESAMC)
				.append(" AS DESCRIPCIONAMBITOCAS, T07.");
		sql.append(V50bAmbitoBD.DESAME).append(" AS DESCRIPCIONAMBITOEUS,");
		sql.append(" DECODE(T08.");
		sql.append(V50bSubcategoriasBD.ESTADO).append(", '");
		sql.append(V50bClsConstantes.CONSTANTE_ALTA).append("', '");
		sql.append(V50bClsConstantes.LITERAL_DESC_ALTA).append("', '");
		sql.append(V50bClsConstantes.CONSTANTE_BAJA).append("', '");
		sql.append(V50bClsConstantes.LITERAL_DESC_BAJA).append(
				"') AS ESTADO FROM ");
		sql.append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS).append(" T08, ");
		sql.append(V50bAmbitoBD.TABLA_AMBITO).append(" T07 ");
		sql.append("WHERE T08.");
		sql.append(V50bSubcategoriasBD.CODSUB).append(" > 0 AND T08.");
		sql.append(V50bSubcategoriasBD.CODAMBITO).append("=");
		sql.append("T07.").append(V50bAmbitoBD.CAMBIT);

		String codSub = subcategorias.getCodSub();
		String desCas = subcategorias.getDesCas();
		String desEus = subcategorias.getDesEus();
		String codAmbito = subcategorias.getCodAmbito();
		String estado = subcategorias.getEstado();

		if (codSub != null && !"".equals(codSub)) {
			sql.append(" AND T08.").append(V50bSubcategoriasBD.CODSUB);
			sql.append(" = ?");
			arrParams.add(new Integer(codSub));
		}

		if (desCas != null && !"".equals(desCas)) {
			sql.append(" AND UPPER(T08.").append(V50bSubcategoriasBD.DESCAS);
			sql.append(") LIKE ?");
			arrParams.add("%" + desCas.toUpperCase() + "%");
		}

		if (desEus != null && !"".equals(desEus)) {
			sql.append(" AND UPPER(T08.").append(V50bSubcategoriasBD.DESEUS);
			sql.append(") LIKE ?");
			arrParams.add("%" + desEus.toUpperCase() + "%");
		}

		if (codAmbito != null && !"".equals(codAmbito)) {
			sql.append(" AND T08.").append(V50bSubcategoriasBD.CODAMBITO);
			sql.append(" = ? ");
			arrParams.add(new Integer(codAmbito));
		}

		if (estado != null) {
			sql.append(" AND T08.").append(V50bSubcategoriasBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append(
					"'");
		} else {
			sql.append(" AND T08.").append(V50bSubcategoriasBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_ALTA).append(
					"'");
		}
		sql.append(" ORDER BY 5,1");

		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bSubcategoriasRowMapper());

		return lista;
	}
	
	/**
	 * @param subcategorias
	 *            :Subcategorias con los datos de busqueda
	 * @return List
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public List fncBuscarSubcategConsultas(V50bSubcategoriasBean subcategorias)
			throws Exception {

		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncBuscarSubcategConsultas() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT ").append(V50bConsultasBD.CCATEG).append(" AS CODIGO");
		sql.append(" FROM ").append(V50bConsultasBD.TABLA_CONSULTAS);
		sql.append(" WHERE ").append(V50bConsultasBD.CCATEG).append(" = ?");
		arrParams.add(Integer.valueOf(subcategorias.getCodSub()));
		sql.append(" AND ").append(V50bConsultasBD.CODEST).append(" != ").append(V50bClsConstantes.SEIS);
		sql.append(" AND ").append(V50bConsultasBD.CODEST).append(" != ").append(V50bClsConstantes.OCHO);
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bSubcategConsultasRowMapper());

		return lista;
		
	}

	/**
	 * @param listaAmbitos
	 *            :lista con los ambitos de subcategoria
	 * @return boolean
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public boolean fncBuscarSubcategBaja(List listaAmbitos)
			throws Exception {
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncBuscarSubcategBaja() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT ").append(V50bAmbitoBD.CAMBIT).append(" AS CODIGO");
		sql.append(" FROM ").append(V50bAmbitoBD.TABLA_AMBITO);
		sql.append(" WHERE (").append(V50bAmbitoBD.CAMBIT).append(" = ?");
		sql.append(" AND ").append(V50bAmbitoBD.ESTADO).append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append("')");
		//String[] ambitos = subcategorias.getAmbitos();
		V50bSubcategoriasBean subcategoria = (V50bSubcategoriasBean)listaAmbitos.get(0);
		arrParams.add(Integer.valueOf(subcategoria.getCodAmbito()));
		for (int i=1;i<listaAmbitos.size();i++) {
			subcategoria = (V50bSubcategoriasBean)listaAmbitos.get(i);
			sql.append(" OR (").append(V50bAmbitoBD.CAMBIT).append(" = ?");
			arrParams.add(Integer.valueOf(subcategoria.getCodAmbito()));
			sql.append(" AND ").append(V50bAmbitoBD.ESTADO).append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append("')");
		}
		
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bSubcategConsultasRowMapper());

		return lista.isEmpty();
		
	}

	/**
	 * @param subcategorias :
	 *            subcategorias con los datos de modificacin
	 * @return int: el resultado de la update
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public int fncModificarSubcategorias(V50bSubcategoriasBean subcategorias)
			throws Exception {
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncModificarSubcategorias() ");
		
		boolean iguales = true;
		
		int codigo = Integer.parseInt(subcategorias.getCodSub());

		// Verificamos si existe ya consulta en la que aparezca una subcategora asociada
		// a unos mbitos diferentes a los que hemos introducido en la modificacin
		
		String[] ambitos = subcategorias.getAmbitos();
		List ambitosOrigen = this.fncAmbitosConsultas(codigo);
		V50bSubcategoriasBean subcategoriasOrigen = new V50bSubcategoriasBean();
		int resultado=0;
		for (int i=0;i<ambitosOrigen.size();i++){
			iguales = false;
			subcategoriasOrigen = (V50bSubcategoriasBean)ambitosOrigen.get(i);
			String codAmbitoOrigen = subcategoriasOrigen.getCodAmbito();
			
			for (int j=0;j<ambitos.length;j++){
				String codAmbito = ambitos[j];	
				if (codAmbito.equals(codAmbitoOrigen)){
					iguales = true;
					break;
				}
			}
			if (!iguales){
				break;
			}
		}
		
		if (!iguales){
			//hay algn mbito diferente con respecto a la consulta que tiene
			//la subcategoria que se est modificando
			resultado = V50bClsConstantes.DOS_NEGATIVO;
		}
		
		else {
			resultado = this.fncActualizarSubcategorias(subcategorias);
	
		}
		return resultado;
		
	}
	
	/**
	 * @param subcategoria : subcategoria con los datos a aadir
	 * @param ambitoViejo : mbito que se elimina de la subcategoria
	 * @return int: el resultado de la update
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public int fncAmbitoSubcategoriaEliminar(V50bSubcategoriasBean subcategoria, int ambitoViejo)
			throws Exception {
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncAmbitoSubcategoriaEliminar() ");

		int codigosub = Integer.parseInt(subcategoria.getCodSub());
		
		final StringBuffer sql = new StringBuffer(30);
		final List arrParams = new ArrayList();
		
		sql.append("DELETE FROM ").append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS);
		sql.append(" WHERE ").append(V50bSubcategoriasBD.CODAMBITO).append("= ").append(ambitoViejo);
		sql.append(" AND ").append(V50bSubcategoriasBD.CODSUB).append("= ").append(codigosub);
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		
	}
	
	/**
	 * @param subcategoria : subcategoria con los datos a aadir
	 * @param ambitoNuevo : nuevo mbito que se aade a la subcategora
	 * @return int: el resultado de la update
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public int fncAmbitoSubcategoriaAniadir(V50bSubcategoriasBean subcategoria, int ambitoNuevo)
			throws Exception {
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.AmbitoSubcategoriaAniadir() ");

		int codigosub = Integer.parseInt(subcategoria.getCodSub());
		
		final StringBuffer sql = new StringBuffer(30);
		final List arrParams = new ArrayList();
		
		sql.append("INSERT INTO ").append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS).append(" VALUES(");
		sql.append(codigosub).append(",").append(ambitoNuevo).append(",?,?,?").append(")");
		
		String descc = subcategoria.getDesCas();
		String desce = subcategoria.getDesEus();
		String estado = subcategoria.getEstado();
		
		if(descc==null || "".equals(descc)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(descc);
		}
		
		if(desce==null || "".equals(desce)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(desce);
		}
		
		if(estado==null || "".equals(estado)){
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		}else{
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		}
				
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		
	}
	
	/**
	 * @param subcategorias : subcategorias con los datos a aadir
	 * @return int: el resultado de la update
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public int fncActualizarSubcategorias(V50bSubcategoriasBean subcategorias)
			throws Exception {
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncActualizarSubcategorias() ");
		
		int resultado;
		
		List ambitosViejos=this.fncAmbitosAlmacenados(subcategorias.getCodSub());
		String[] ambitosNuevos=subcategorias.getAmbitos();
		V50bSubcategoriasBean subcategoria = new V50bSubcategoriasBean(); 
		for(int i=0;i<ambitosNuevos.length;i++){
			boolean encontrado=false;
			for(int j=0;j<ambitosViejos.size();j++){
				subcategoria = (V50bSubcategoriasBean)ambitosViejos.get(j);
				if(ambitosNuevos[i].equals(subcategoria.getCodAmbito())){
					encontrado=true;
					break;
				}								
			}
			if(!encontrado){
				int codAmbito= Integer.parseInt(ambitosNuevos[i]);
				resultado=this.fncAmbitoSubcategoriaAniadir(subcategorias,codAmbito);
			}		
		}
		for(int i=0;i<ambitosViejos.size();i++){
			boolean encontrado=false;
			subcategoria = (V50bSubcategoriasBean)ambitosViejos.get(i);
			for(int j=0;j<ambitosNuevos.length;j++){
				if(ambitosNuevos[j].equals(subcategoria.getCodAmbito())){
					encontrado=true;
					break;
				}								
			}
			if(!encontrado){
				int codAmbito= Integer.parseInt(subcategoria.getCodAmbito());
				resultado=this.fncAmbitoSubcategoriaEliminar(subcategorias,codAmbito);
			}		
		}
		resultado = this.fncUpdate(subcategorias);
		return resultado;
		
	}
	
	/**
	 * @param subcategorias : subcategorias con los datos a aadir
	 * @return int: el resultado de la update
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	private int fncUpdate(V50bSubcategoriasBean subcategorias)
			throws Exception {
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncUpdate()");
		final StringBuffer sql = new StringBuffer(40);
		final List arrParams = new ArrayList();
		
		sql.append("UPDATE ").append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS).append(" SET ");
		sql.append(V50bSubcategoriasBD.DESCAS).append(" = ?, ");
		sql.append(V50bSubcategoriasBD.DESEUS).append(" = ?, ");
		sql.append(V50bSubcategoriasBD.ESTADO).append(" = ? ");
		sql.append("WHERE ").append(V50bSubcategoriasBD.CODSUB).append(" = ?");
		
		String cod = subcategorias.getCodSub();
		String descc = subcategorias.getDesCas();
		String desce = subcategorias.getDesEus();
		String estado = subcategorias.getEstado();
		
		if(descc==null || "".equals(descc)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(descc);
		}
		
		if(desce==null || "".equals(desce)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(desce);
		}
		
		if(estado==null || "".equals(estado)){
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		}else{
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		}
		arrParams.add(cod);
				
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		
	}
	
	/**
	 * @param codigo : codigo de subcategoria 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncAmbitosAlmacenados(String codigo) throws Exception{
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncAmbitosAlmacenados() ");
		
		final StringBuffer sql = new StringBuffer(50);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT DISTINCT(").append(V50bSubcategoriasBD.CODAMBITO).append(") AS CODIGOAMBITO FROM ");
		sql.append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS);
		sql.append(" WHERE ").append(V50bSubcategoriasBD.CODSUB).append(" = ").append(codigo);
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitosSubcategoriaRowMapper());
		
		return lista;
	}

	/**
	 * @param codigo : codigo de subcategoria 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncAmbitosConsultas(int codigo) throws Exception {
		
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncAmbitosConsultas() ");
		
		final StringBuffer sql = new StringBuffer(50);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT DISTINCT(").append(V50bConsultasBD.CAMBIT).append(") AS CODIGOAMBITO FROM ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS);
		sql.append(" WHERE ").append(V50bConsultasBD.CCATEG).append(" = ").append(codigo);
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitosSubcategoriaRowMapper());
		V50bClsTrazas.depura("fncAmbitosConsultas()LISTA="+lista.toString());
		return lista;
	}
	
	/**
	 * @param codigo : codigo de subcategoria 
	 * @return int: el resultado de Delete
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncEliminarSubcategoria(int codigo) throws Exception {
		
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncEliminarSubcategoria() ");
		final StringBuffer sql = new StringBuffer(20);
		final List arrParams = new ArrayList();
		
		sql.append("DELETE ").append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS);
		sql.append(" WHERE ");
		sql.append(V50bSubcategoriasBD.CODSUB).append(" = ").append(codigo);
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}

	/**
	 * @param subcategorias :
	 *            subcategorias con los datos a aadir
	 * @return int: el resultado de la update
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public int fncAniadirSubcategorias(V50bSubcategoriasBean subcategorias)
			throws Exception {
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncAniadirSubcategorias() ");

		final StringBuffer sqlVal = new StringBuffer(70);	
		
		String codigo = subcategorias.getCodSub();
		String id = codigo;
		if (codigo == null || "".equals(codigo)){
			sqlVal.append("SELECT MAX(");sqlVal.append(V50bSubcategoriasBD.CODSUB);
			sqlVal.append(")+1 FROM ").append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS);
			
			id = new V50bClsAccesoBD().fncConsultaEspecifica(sqlVal.toString());
		}
		
		if (id.equals(V50bClsConstantes.CONSTANTE_UNO) && subcategorias.getEstado()!=null){
			return V50bClsConstantes.DOS;
		}
		
		int resultado = 0;
		
		String[] lista = subcategorias.getAmbitos();
		int codAmbito = 0;
		for (int i=0;i<lista.length;i++){
			codAmbito = Integer.parseInt(lista[i]);
			resultado = this.fncInsertarSubcategoria(codAmbito,id,subcategorias);
			if (resultado!=1){
				return resultado;
			}
		}
		return resultado;
			
	}
	
	/**
	 * @param codAmbito : codigo de ambito
	 * @param id : codigo de subcategoria
	 * @param subcategoria : subcategoria con los datos de busqueda 
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncInsertarSubcategoria(int codAmbito, String id, V50bSubcategoriasBean subcategoria) throws Exception {
		
		V50bClsTrazas.depura("V50bDificultadDAOImpl.fncInsertarDificultad() ");
		final StringBuffer sql = new StringBuffer();
		final List arrParams = new ArrayList();
		String codsub = id;
		if(codsub==null || codsub.equals("")){
			//la tabla esta vaca, no hay expedientes an
			codsub="1";
		}
		
		if("100".equals(codsub)){
			return V50bClsConstantes.TRES_NEGATIVO;
		}else{
			subcategoria.setCodSub(codsub);
			int codigo = Integer.parseInt(subcategoria.getCodSub());
			
			sql.append("INSERT INTO ").append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS).append("(");
			sql.append(V50bSubcategoriasBD.CODSUB).append(", ");
			sql.append(V50bSubcategoriasBD.CODAMBITO).append(", ");
			sql.append(V50bSubcategoriasBD.DESCAS).append(", ");
			sql.append(V50bSubcategoriasBD.DESEUS).append(", ");
			sql.append(V50bSubcategoriasBD.ESTADO);
			sql.append(") VALUES(");
			sql.append(codigo).append(",").append(codAmbito).append(",?,?,?").append(") ");
			
			String descc = subcategoria.getDesCas();
			String desce = subcategoria.getDesEus();
			String estado = subcategoria.getEstado();
			
			if(descc==null || "".equals(descc)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(descc);
			}
			
			if(desce==null || "".equals(desce)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(desce);
			}
			
			if(estado==null || "".equals(estado)){
				arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
			}else{
				arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
			}
					
			return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		}
	}
	
	/**
	 * @param subcategoria : subcategoria con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se lanza la excepcin.
	 */
	public List fncBuscarAmbitosSubcategoria(V50bSubcategoriasBean subcategoria) throws Exception{
		V50bClsTrazas.depura("V50bSubcategoriasDAOImpl.fncBuscarAmbitosSubcategoria() ");
		final StringBuffer sql = new StringBuffer(70);
		final List arrParams = new ArrayList();
		
		String codsub = subcategoria.getCodSub();
		String estado = subcategoria.getEstado();
		int codigo = Integer.parseInt(codsub);
		
		sql.append("SELECT T08.").append(V50bSubcategoriasBD.CODAMBITO).append(" AS CODIGOAMBITO");
		sql.append(" FROM ");
		sql.append(V50bSubcategoriasBD.TABLA_SUBCATEGORIAS).append(" T08");
		sql.append(" WHERE T08.");
		sql.append(V50bSubcategoriasBD.CODSUB).append(" = ").append(codigo);
		sql.append(" AND ").append(V50bSubcategoriasBD.ESTADO).append(" = ?");
		
		if (estado!=null && estado.equals(V50bClsConstantes.LITERAL_DESC_BAJA)){
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		}else {
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		}
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitosSubcategoriaRowMapper());
		
		return lista;
		
	}

	/**
	 * 
	 * @author acompes
	 * 
	 */
	class V50bSubcategoriasRowMapper implements V50bRowMapper {

		/**
		 * @param rs
		 *            :Resultset
		 * @return Object
		 * @throws SQLException
		 *             Se lanza la excepcin.
		 */
		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bSubcategoriasBean subcategorias = new V50bSubcategoriasBean();

			subcategorias.setCodSub(rs.getString("CODIGO"));
			subcategorias.setCodSubOrden(rs.getString("CODIGOORDEN"));
			subcategorias.setDesCas(rs.getString("DESCRIPCIONCASTELLANO"));
			subcategorias.setDesEus(rs.getString("DESCRIPCIONEUSKERA"));
			subcategorias.setCodAmbito(rs.getString("CODIGOAMBITO"));
			subcategorias.setDesAmbitoCas(rs.getString("DESCRIPCIONAMBITOCAS"));
			subcategorias.setDesAmbitoEus(rs.getString("DESCRIPCIONAMBITOEUS"));
			subcategorias.setEstado(rs.getString("ESTADO"));
			if(subcategorias.getEstado().equals(V50bClsConstantes.LITERAL_DESC_ALTA)|| subcategorias.getEstado()== null){
				subcategorias.setFormHabilitado(V50bClsConstantes.CONSTANTE_SI);
			} else {
				subcategorias.setFormHabilitado(V50bClsConstantes.CONSTANTE_NO);
			}
			
			return subcategorias;
		}
	}
	
	/**
	 * 
	 * @author brey
	 *
	 */
	class V50bAmbitosSubcategoriaRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bSubcategoriasBean subcategoria = new V50bSubcategoriasBean();
			
			subcategoria.setCodAmbito(rs.getString("CODIGOAMBITO"));
			
			return subcategoria;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bSubcategConsultasRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bSubcategoriasBean subcategoria = new V50bSubcategoriasBean();
			
			subcategoria.setCodSub(rs.getString("CODIGO"));
			
			return subcategoria;
		}
	}


}
