package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import v50b.v50bBeans.V50bConsultaBean;
import v50b.v50bBeans.V50bResolutoresBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bClasesComunes.v50bBeansComunes.V50bUsuarioBean;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bAmbitoBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bAmbitos_ResolutorBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bConsultasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bResolutoresBD;
import v50b.v50bModelo.v50bDao.V50bResolutoresDAO;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

/**
 * 
 * @author iurkidi
 * 
 */
public class V50bResolutoresDAOImpl implements V50bResolutoresDAO {

	/**
	 * Ttulo: fncObtenerPerfilUsuario Descripcin: Devuelve el perfil del
	 * usuario logueado Empresa: Eurohelp
	 * 
	 * @author iurkidi
	 * @version 1.0
	 * @param usuarioBean
	 *            bean con los datos del usuario logueado
	 * @return lista List
	 * @throws Exception
	 *             SQLException
	 */
	public List fncObtenerPerfilUsuario(V50bUsuarioBean usuarioBean)
			throws Exception {

		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncObtenerPerfilUsuario()");

		List lstParam = new ArrayList();
		StringBuffer sqlPerfil = new StringBuffer(V50bClsConstantes.SETENTA);

		sqlPerfil.append("SELECT T03.").append(V50bResolutoresBD.ID_RESOL)
				.append(" AS DNI");
		sqlPerfil.append(",T03.").append(V50bResolutoresBD.PERFIL_RESOL)
				.append(" AS PERFIL");
		sqlPerfil.append(",T03.").append(V50bResolutoresBD.NOMBRE_RESOL).append("|| ' ' ||")
		.append(V50bResolutoresBD.AP1_RESOL).append("|| ' ' ||").append(V50bResolutoresBD.AP2_RESOL)
		.append(" AS NOMBREUSUARIO");
		sqlPerfil.append(" FROM ").append(V50bResolutoresBD.TABLA_RESOLUTORES)
				.append(" T03");
		sqlPerfil.append(" WHERE T03.").append(V50bResolutoresBD.ID_RESOL)
				.append("=? AND T03.").append(V50bResolutoresBD.ESTADO_RESOL).append("=?");

		if (usuarioBean.getDniUsuario() != null
				&& !"".equals(usuarioBean.getDniUsuario())) {
			// lstParam.add(usuarioBean.getDniUsuario());
			lstParam.add(usuarioBean.getUsuarioXlnets());
		} else {
			lstParam.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		lstParam.add(V50bClsConstantes.CONSTANTE_ALTA);

		return (List) new V50bClsAccesoBD().fncLanzaBusqueda(sqlPerfil
				.toString(), lstParam, new V50bPerfilUsuarioRowMapper());
	}// FIN fncObtenerPerfilUsuario

	/**
	 * @param resolutores
	 *            :Resolutores con los datos de busqueda
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public List fncBuscarResolutores(V50bResolutoresBean resolutores)
			throws Exception {
		
		String idioma = resolutores.getIdioma();

		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncBuscarResolutores() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUATROCIENTOSDIECISIETE);
		final List arrParams = new ArrayList();

		sql.append("SELECT T03.").append(V50bResolutoresBD.COD_RESOL).append(" AS CODIGORESOLUTORIOS, T03.");
		sql.append(V50bResolutoresBD.ID_RESOL).append(" AS IDENTIFICADORRESOLUTORIOS, T03.");
		sql.append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS NOMBRE, T03.");
		sql.append(V50bResolutoresBD.AP1_RESOL).append(
				" AS PRIMERAPELLIDO, T03.");
		sql.append(V50bResolutoresBD.AP2_RESOL).append(
				" AS SEGUNDOAPELLIDO, T03.");
		sql.append(V50bResolutoresBD.EMAIL_RESOL).append(" AS EMAIL, T03.");
		sql.append(V50bResolutoresBD.MOVIL_RESOL).append(" AS MOVIL, T03.");
		sql.append(V50bResolutoresBD.RECIBE_AVISOS_RESOL).append(" AS AVISO,");
		sql.append(" DECODE(T03.");
		sql.append(V50bResolutoresBD.RECIBE_AVISOS_RESOL).append(", '");
		sql.append(V50bClsConstantes.AVISO_NO).append("', '");
		sql.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no", idioma)).append("', '");
		sql.append(V50bClsConstantes.AVISO_EMAIL).append("', '");
		sql.append(
				Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",
						"comun.si", idioma)).append("', '");
		sql.append(V50bClsConstantes.AVISO_MOVIL).append("', '");
		sql.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",
				"comun.si", idioma));
		sql.append("') AS AVISOMENSAJE, ");
		sql.append(" DECODE(T03.");
		sql.append(V50bResolutoresBD.PERFIL_RESOL).append(", '");
		sql.append(V50bClsConstantes.PERFIL_TECNICO_IVAP_BD).append("', '");
		sql.append(
				Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",
						"resolutores.tecnico", idioma)).append("', '");
		sql.append(V50bClsConstantes.PERFIL_RESOLUTOR_BD).append("', '");
		sql.append(
				Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",
						"resolutores.resolutor", idioma)).append("', '");
		sql.append(V50bClsConstantes.PERFIL_AMBOS_BD).append("', '");
		sql.append(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun",
				"resolutores.ambos", idioma));
		sql.append("') AS PERFILDESCRIPCION, T03.");
		sql.append(V50bResolutoresBD.PERFIL_RESOL).append(" AS PERFIL, T03.");
		sql.append(V50bResolutoresBD.ESTADO_RESOL).append(" AS ESTADO FROM ");
		sql.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03 ");
		sql.append("WHERE T03.");
		sql.append(V50bResolutoresBD.COD_RESOL).append(" > 0 ");
		
		String codResol = resolutores.getCodResol();
		String idResol = resolutores.getIdResol();
		String estado = resolutores.getEstado();
		String nombre = resolutores.getNombre();
		String apellido1 = resolutores.getApe1();
		String apellido2 = resolutores.getApe2();
		String tieneMovil = resolutores.getTieneMovil();
		String tieneEmail = resolutores.getTieneEmail();
		String perfil = resolutores.getPerfil();
		String enviarAvisoBandEntrada = resolutores.getAvisoBandEntrada();
		
		if (codResol != null && !"".equals(codResol)) {
			int codigo = Integer.parseInt(codResol);
			sql.append(" AND T03.").append(V50bResolutoresBD.COD_RESOL);
			sql.append(" = ").append(codigo);
		}
		
		if (idResol != null && !"".equals(idResol)) {
			sql.append(" AND T03.").append(V50bResolutoresBD.ID_RESOL);
			sql.append(" = ?");
			arrParams.add(idResol);
		}

		if (estado != null) {
			sql.append(" AND T03.").append(V50bResolutoresBD.ESTADO_RESOL);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append(
					"'");
		} else {
			sql.append(" AND T03.").append(V50bResolutoresBD.ESTADO_RESOL);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_ALTA).append("'");

		}

		if (nombre != null && !"".equals(nombre)) {
			sql.append(" AND T03.").append(V50bResolutoresBD.NOMBRE_RESOL);
			sql.append(" LIKE ?");
			arrParams.add(nombre.toUpperCase() + "%");
		}

		if (apellido1 != null && !"".equals(apellido1)) {
			sql.append(" AND T03.").append(V50bResolutoresBD.AP1_RESOL);
			sql.append(" LIKE ?");
			arrParams.add(apellido1.toUpperCase() + "%");
		}

		if (apellido2 != null && !"".equals(apellido2)) {
			sql.append(" AND T03.").append(V50bResolutoresBD.AP2_RESOL);
			sql.append(" LIKE ?");
			arrParams.add(apellido2.toUpperCase() + "%");
		}

		if(StringUtils.isNotEmpty(tieneMovil)){
			if(V50bClsConstantes.CONSTANTE_SI.equals(tieneMovil)){
				sql.append(" AND T03.").append(V50bResolutoresBD.MOVIL_RESOL).append(" IS NOT NULL ");
			} else {
				sql.append(" AND T03.").append(V50bResolutoresBD.MOVIL_RESOL).append(" IS NULL ");
			}
		}

		if(StringUtils.isNotEmpty(tieneEmail)){
			if(V50bClsConstantes.CONSTANTE_SI.equals(tieneEmail)){
				sql.append(" AND T03.").append(V50bResolutoresBD.EMAIL_RESOL).append(" IS NOT NULL ");
			} else {
				sql.append(" AND T03.").append(V50bResolutoresBD.EMAIL_RESOL).append(" IS NULL ");
			}
		}

		if (perfil != null && !"".equals(perfil)) {
			sql.append(" AND T03.").append(V50bResolutoresBD.PERFIL_RESOL);
			sql.append(" = ?");
			arrParams.add(perfil);
		}
		
		if(StringUtils.isNotEmpty(enviarAvisoBandEntrada)){
			if(V50bClsConstantes.CONSTANTE_NO.equals(enviarAvisoBandEntrada)){
				sql.append(" AND T03.").append(V50bResolutoresBD.RECIBE_AVISOS_RESOL);
				sql.append(" LIKE ?");
				arrParams.add(V50bClsConstantes.AVISO_NO);
			} else {
				sql.append(" AND (T03.").append(V50bResolutoresBD.RECIBE_AVISOS_RESOL);
				sql.append(" LIKE ?");
				arrParams.add(V50bClsConstantes.AVISO_EMAIL);
				sql.append(" OR T03.").append(V50bResolutoresBD.RECIBE_AVISOS_RESOL);
				sql.append(" LIKE ?)");
				arrParams.add(V50bClsConstantes.AVISO_MOVIL);
			}
		}

		sql.append(" ORDER BY 1");

		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bResolutoresRowMapper());

		return lista;

	}
	
	
	/**
	 * @param codigo : codigo de dificultad 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncAmbitosConsultas(int codigo) throws Exception {
		
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncAmbitosConsultas() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTA);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT ").append(V50bConsultasBD.CAMBIT).append(" AS CODIGOAMBITO FROM ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS);
		sql.append(" WHERE ").append(V50bConsultasBD.CRESOL).append(" = ").append(codigo);
		sql.append(" AND ").append(V50bConsultasBD.CODEST).append(" != ?");
		sql.append(" AND ").append(V50bConsultasBD.CODEST).append(" != ?");
		arrParams.add(V50bClsConstantes.ESTADO_DENEGADA);
		arrParams.add(V50bClsConstantes.ESTADO_CATALOGADA);
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitosResolutorRowMapper());
		
		return lista;
	}
	

	/**
	 * @param resolutores :
	 *            Resolutores con los datos de modificacin
	 * @return int: el resultado de la update
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public int fncModificarResolutores(V50bResolutoresBean resolutores) throws Exception {

		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncModificarResolutores() ");
		
		final StringBuffer existeID = new StringBuffer(V50bClsConstantes.CINCUENTAYNUEVE);
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOTREINTA);
		final List arrParams = new ArrayList();
		boolean hayAsociados = true;
		boolean iguales = true;
		
		int codigo = Integer.parseInt(resolutores.getCodResol());
		String id = resolutores.getIdResol();
		String nombre = resolutores.getNombre();
		String apellido1 = resolutores.getApe1();
		String apellido2 = resolutores.getApe2();
		String email = resolutores.getEmail();
		String movil = resolutores.getMovil();
		String perfilTecnico = resolutores.getPerfilTecnico();
		String perfilResolutor = resolutores.getPerfilResolutor();
		String aviso = resolutores.getAviso();
		String estado = resolutores.getEstado();
		
		//Comprobamos si existe en la tabla el ID introducido
		
		existeID.append("SELECT COUNT(T03.").append(V50bResolutoresBD.ID_RESOL).append(") FROM ");
		existeID.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03 ");
		existeID.append("WHERE T03.");
		existeID.append(V50bResolutoresBD.ID_RESOL).append(" = '");
		existeID.append(resolutores.getIdResol()).append("'");
		existeID.append(" AND T03.").append(V50bResolutoresBD.COD_RESOL).append(" != '");
		existeID.append(resolutores.getCodResol()).append("'");
		
		if((Integer.parseInt(new V50bClsAccesoBD().fncConsultaEspecifica(existeID.toString())))!=0){
			// Devolvemos -1 para posteriormente visualizar mensaje de error
			// de ID repetido
			return -1;
		}
		
		if (estado!=null && estado.equals(V50bClsConstantes.CONSTANTE_BAJA)){
			hayAsociados = this.fncComprobarConsultasAsociadas(codigo);
			if (!hayAsociados){
				return 2;	
			}
		}


		// Verificamos si existe ya consulta en la que aparezca una resolutor asociado
		// a unos mbitos diferentes a los que hemos introducido en la modificacin
		
		String[] ambitos = resolutores.getAmbitos();
		List ambitosOrigen = this.fncAmbitosConsultas(codigo);
		V50bResolutoresBean resolutoresOrigen = new V50bResolutoresBean();
		
		for (int i=0;i<ambitosOrigen.size();i++){
			iguales = false;
			resolutoresOrigen = (V50bResolutoresBean)ambitosOrigen.get(i);
			String codAmbitoOrigen = resolutoresOrigen.getCodambito();
			if (codAmbitoOrigen==null) {
				iguales = true;
			} else {
				for (int j=0;j<ambitos.length;j++){
					String codAmbito = ambitos[j];	
					if (codAmbito.equals(codAmbitoOrigen)){
						iguales = true;
						break;
					}
				}
			}
			if (!iguales){
				break;
			}
		}
		
		if (!iguales){
			//hay algn mbito diferente con respecto a la consulta que tiene
			//el resolutor que se est modificando
			return V50bClsConstantes.DOS_NEGATIVO;
		}
		
		
		int resultado = this.fncEliminarResolutorAmbitos(codigo);
		if (resultado<0){
			return resultado;
		}
		
		sql.append("UPDATE ");sql.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03");
		sql.append(" SET T03.").append(V50bResolutoresBD.COD_RESOL).append(" = ").append(codigo);
		sql.append(", T03.").append(V50bResolutoresBD.ID_RESOL).append(" = ?,");
		if (id==null || "".equals(id)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(id);
		}
		
		sql.append(" T03.").append(V50bResolutoresBD.NOMBRE_RESOL).append(" = ?,");
		if (nombre==null || "".equals(nombre)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(nombre);
		}
		
		sql.append(" T03.").append(V50bResolutoresBD.AP1_RESOL).append(" = ?,");
		if (apellido1==null || "".equals(apellido1)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(apellido1);
		}
		
		sql.append(" T03.").append(V50bResolutoresBD.AP2_RESOL).append(" = ?,");
		if (apellido2==null || "".equals(apellido2)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(apellido2);
		}
		
		sql.append(" T03.").append(V50bResolutoresBD.EMAIL_RESOL).append(" = ?,");
		if (email==null || "".equals(email)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(email);
		}
		
		sql.append(" T03.").append(V50bResolutoresBD.MOVIL_RESOL).append(" = ?,");
		if (movil==null || "".equals(movil)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(movil);
		}
		
		sql.append(" T03.").append(V50bResolutoresBD.PERFIL_RESOL).append(" = ?,");
		if (perfilTecnico == null && perfilResolutor == null){

			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);

		} else if (perfilTecnico != null && perfilResolutor != null) {

			arrParams.add(V50bClsConstantes.PERFIL_AMBOS_BD);

		} else if (perfilTecnico != null) {

			arrParams.add(V50bClsConstantes.PERFIL_TECNICO_IVAP_BD);

		} else {

			arrParams.add(V50bClsConstantes.PERFIL_RESOLUTOR_BD);
		}
		
		sql.append(" T03.").append(V50bResolutoresBD.RECIBE_AVISOS_RESOL).append(" = ?,");
		if (aviso==null || "".equals(aviso)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(aviso);
		}
		
		sql.append(" T03.").append(V50bResolutoresBD.ESTADO_RESOL).append(" = ?");
		if (estado==null || "".equals(estado)){
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		}else{
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		}
		
		sql.append(" WHERE T03.").append(V50bResolutoresBD.COD_RESOL).append(" = ").append(codigo);
		
		resultado = new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		if (resultado!=1){
			return resultado;
		}
		
		String[] lista = resolutores.getAmbitos();
		int codAmbito = 0;
		for (int i=0;i<lista.length;i++){
			codAmbito = Integer.parseInt(lista[i]);
			resultado = this.fncInsertarResolutorAmbito(codAmbito,codigo);
			if (resultado!=1){
				return resultado;
			}
		}
		
		return resultado;

	}
	
	/**
	* @param codResolutor : codigo de resolutor 
	* @return boolean: true si no hay asociados
	* @throws Exception Se eleva la excepcin.
	*/
	public boolean fncComprobarConsultasAsociadas(int codResolutor) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncComprobarConsultasAsociadas() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT ").append(V50bConsultasBD.CRESOL).append(" AS CODIGO FROM ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS);
		sql.append(" WHERE ").append(V50bConsultasBD.CRESOL).append(" = ").append(codResolutor);
		sql.append(" AND ").append(V50bConsultasBD.CODEST).append(" != ").append(V50bClsConstantes.SEIS);
		sql.append(" AND ").append(V50bConsultasBD.CODEST).append(" != ").append(V50bClsConstantes.OCHO);
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bResolutorCodigoRowMapper());
		
		return lista.isEmpty();
	}
	
	/**
	 * @param codigo : codigo de resolutor 
	 * @return int: el resultado de Delete
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncEliminarResolutorAmbitos(int codigo) throws Exception {
		
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncEliminarResolutorAmbitos() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.DIECIOCHO);
		final List arrParams = new ArrayList();
		
		sql.append("DELETE ").append(V50bAmbitos_ResolutorBD.TABLA_AMBITOS_RESOLUTOR);
		sql.append(" WHERE ");
		sql.append(V50bAmbitos_ResolutorBD.CRESOL).append(" = ").append(codigo);
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	

	/**
	 * @param resolutores :
	 *            resolutores con los datos a aadir
	 * @return int: el resultado de la update
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public int fncAniadirResolutores(V50bResolutoresBean resolutores) throws Exception {
	
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncAniadirResolutores()");
		
		final StringBuffer existeID= new StringBuffer(V50bClsConstantes.CUARENTAYCINCO);
		
		//Comprobamos si existe en la tabla el ID introducido
		
		existeID.append("SELECT COUNT(T03.").append(V50bResolutoresBD.ID_RESOL).append(") FROM ");
		existeID.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03 ");
		existeID.append("WHERE T03.");
		existeID.append(V50bResolutoresBD.ID_RESOL).append(" = '").append(resolutores.getIdResol()).append("'");
		
		if((Integer.parseInt(new V50bClsAccesoBD().fncConsultaEspecifica(existeID.toString())))!=0){
			// Devolvemos -1 para posteriormente visualizar mensaje de error
			// de ID repetido
			return -1;
		}

		/*final StringBuffer sqlVal = new StringBuffer();
		int resultado = 0;
		
		String codres = resolutores.getCodResol();
		String id = codres;
		if (codres == null || "".equals(codres)){
			sqlVal.append("SELECT MAX(");sqlVal.append(V50bResolutoresBD.COD_RESOL);
			sqlVal.append(")+1 FROM ").append(V50bResolutoresBD.TABLA_RESOLUTORES);
			
			id = new V50bClsAccesoBD().fncConsultaEspecifica(sqlVal.toString());
		}
		*/
		final StringBuffer sqlSec = new StringBuffer(V50bClsConstantes.VEINTICINCO);
		int resultado = 0;

		sqlSec.append("SELECT ");
		sqlSec.append(V50bResolutoresBD.SEQ_RESOLUTORES);
		sqlSec.append(".NEXTVAL FROM DUAL");
		
		String id = new V50bClsAccesoBD().fncConsultaEspecifica(sqlSec.toString());
		resolutores.setCodResol(id);
		int codResolutor = Integer.parseInt(id);

		resultado = this.fncInsertarResolutores(resolutores,codResolutor);
		
		String[] lista = resolutores.getAmbitos();
		int codAmbito = 0;
		for (int i=0;i<lista.length;i++){
			codAmbito = Integer.parseInt(lista[i]);
			resultado = this.fncInsertarResolutorAmbito(codAmbito,codResolutor);
			if (resultado!=1){
				return resultado;
			}
		}

		return resultado;

	}
	
	/**
	 * @param resolutores : resolutores con los datos a aadir
	 * * @param codResolutor : codigo de resolutor
	 * @return int: el resultado de la update
	 * @throws Exception  Se eleva la excepcin.
	 */
	public int fncInsertarResolutores(V50bResolutoresBean resolutores, int codResolutor) throws Exception {
		
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncInsertarResolutores()");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CINCUENTAYNUEVE);
		final List arrParams = new ArrayList();
		
		sql.append("INSERT INTO ").append(V50bResolutoresBD.TABLA_RESOLUTORES).append("(");
		sql.append(V50bResolutoresBD.COD_RESOL).append(", ");
		sql.append(V50bResolutoresBD.ID_RESOL).append(", ");
		sql.append(V50bResolutoresBD.ESTADO_RESOL).append(", ");
		sql.append(V50bResolutoresBD.NOMBRE_RESOL).append(", ");
		sql.append(V50bResolutoresBD.AP1_RESOL).append(", ");
		sql.append(V50bResolutoresBD.AP2_RESOL).append(", ");
		sql.append(V50bResolutoresBD.EMAIL_RESOL).append(", ");
		sql.append(V50bResolutoresBD.MOVIL_RESOL).append(", ");
		sql.append(V50bResolutoresBD.PERFIL_RESOL).append(", ");
		sql.append(V50bResolutoresBD.RECIBE_AVISOS_RESOL);
		sql.append(") VALUES(").append(codResolutor).append(",?,?,?,?,?,?,?,?,?)");

		if (resolutores.getIdResol() == null
				|| "".equals(resolutores.getIdResol())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(resolutores.getIdResol());
		}

		if (resolutores.getEstado() == null
				|| "".equals(resolutores.getEstado())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		}

		if (resolutores.getNombre() == null
				|| "".equals(resolutores.getNombre())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(resolutores.getNombre());
		}

		if (resolutores.getApe1() == null || "".equals(resolutores.getApe1())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(resolutores.getApe1());
		}

		if (resolutores.getApe2() == null || "".equals(resolutores.getApe2())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(resolutores.getApe2());
		}

		if (resolutores.getEmail() == null || "".equals(resolutores.getEmail())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(resolutores.getEmail());
		}

		if (resolutores.getMovil() == null || "".equals(resolutores.getMovil())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(resolutores.getMovil());
		}

		if (resolutores.getPerfilTecnico() == null && resolutores
				.getPerfilResolutor() == null){

			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);

		} else if (resolutores.getPerfilTecnico() != null && resolutores
				.getPerfilResolutor() != null) {

			arrParams.add(V50bClsConstantes.PERFIL_AMBOS_BD);

		} else if (resolutores.getPerfilTecnico() != null) {

			arrParams.add(V50bClsConstantes.PERFIL_TECNICO_IVAP_BD);

		} else {

			arrParams.add(V50bClsConstantes.PERFIL_RESOLUTOR_BD);
		}

		if (resolutores.getAviso() == null || "".equals(resolutores.getAviso())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(resolutores.getAviso());
		}
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(),arrParams);
	}
	
	/**
	 * @param codAmbito : codigo de ambito
	 * @param codResolutor : codigo de resolutor
	 * @return int: el resultado de la insert
	 * @throws Exception Se eleva la excepcin.
	 */
	public int fncInsertarResolutorAmbito(int codAmbito, int codResolutor) throws Exception {
		
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncInsertarResolutorAmbito() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.VEINTIOCHO);
		final List arrParams = new ArrayList();
		
		sql.append("INSERT INTO ").append(V50bAmbitos_ResolutorBD.TABLA_AMBITOS_RESOLUTOR).append("(");
			sql.append(V50bAmbitos_ResolutorBD.CRESOL).append(", ");
			sql.append(V50bAmbitos_ResolutorBD.CAMBIT);
			sql.append(") VALUES(");
			sql.append(codResolutor).append(",").append(codAmbito).append(") ");
			
			return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		}
	
	/**
	 * @param resolutores : resolutor con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarAmbitosResolutor(V50bResolutoresBean resolutores) throws Exception {
		
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncBuscarAmbitosResolutor() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CINCUENTAYCINCO);
		final List arrParams = new ArrayList();
		
		String codres = resolutores.getCodResol();
		int codigo = Integer.parseInt(codres);
		
		sql.append("SELECT T06.").append(V50bAmbitos_ResolutorBD.CAMBIT).append(" AS CODIGOAMBITO");
		sql.append(" FROM ");
		sql.append(V50bAmbitos_ResolutorBD.TABLA_AMBITOS_RESOLUTOR).append(" T06");
		sql.append(" WHERE T06.");
		sql.append(V50bAmbitos_ResolutorBD.CRESOL).append(" = ").append(codigo);

		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bAmbitosResolutorRowMapper());
		
		return lista;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSituacionResolutoresArea</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 4, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param form Formulario con el mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSituacionResolutoresArea(V50bConsultaBean form) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncBuscSituacionResolutoresArea() ");
		
		final StringBuffer sqlSitResol = new StringBuffer(V50bClsConstantes.SETECIENTOSTREINTA);
		final List arrParams = new ArrayList();
		
		sqlSitResol.append("SELECT T03.").append(V50bResolutoresBD.COD_RESOL).append(" AS CODIGO, ");
		sqlSitResol.append("T03.").append(V50bResolutoresBD.ID_RESOL).append(" AS ID, "); 
		sqlSitResol.append("T03.").append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS NOMBRE, "); 
		sqlSitResol.append("T03.").append(V50bResolutoresBD.AP1_RESOL).append("||' '||T03.").append(V50bResolutoresBD.AP2_RESOL).append(" AS APELLIDOS, ");
		sqlSitResol.append("NVL(V24H.DIF24H, 0) AS DIF24H, NVL(CPENDIENTES.PENDIENTES, 0) AS PENDIENTES, ");
		sqlSitResol.append("fncatrasadasresolutor(T03.").append(V50bResolutoresBD.COD_RESOL).append(") AS RETRASADAS, ");
		sqlSitResol.append("LPAD(NVL(V24H.DIF24H, 0),4,0) AS DIF24HORDEN, LPAD(NVL(CPENDIENTES.PENDIENTES, 0),4,0) AS PENDIENTESORDEN, ");
		sqlSitResol.append("LPAD(fncatrasadasresolutor(T03.").append(V50bResolutoresBD.COD_RESOL).append("),4,0) AS RETRASADASORDEN ");
		sqlSitResol.append("FROM ").append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03, ");
		
		if(StringUtils.isNotEmpty(form.getAmbito().getCambit())) {
			sqlSitResol.append(V50bAmbitos_ResolutorBD.TABLA_AMBITOS_RESOLUTOR).append(" T06, ");
		}
		
		sqlSitResol.append("(SELECT T01.").append(V50bConsultasBD.CRESOL).append(" AS CODRESOL1, COUNT(1) AS DIF24H ");
		sqlSitResol.append("FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sqlSitResol.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append(">0");
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODDIF).append("=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.DIFICULTAD_24H));		
//		sqlSitResol.append(" AND SYSDATE BETWEEN T01.").append(V50bConsultasBD.FECCON);
//		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.FECCON).append("+1");
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RECIBIDA));
		
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_DENEGADA));
		
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RESPONDIDA));
		
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_CATALOGADA));
		
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_ABANDONADA));
		sqlSitResol.append(" GROUP BY T01.").append(V50bConsultasBD.CRESOL).append(") V24H, ");
		sqlSitResol.append("(SELECT T01.").append(V50bConsultasBD.CRESOL).append(" AS CODRESOL2, ");
		sqlSitResol.append("COUNT(1) AS PENDIENTES ");
		sqlSitResol.append("FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sqlSitResol.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append(">0");
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RECIBIDA));
		
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_DENEGADA));
		
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RESPONDIDA));
		
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_CATALOGADA));
		
		sqlSitResol.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_ABANDONADA));
		
		sqlSitResol.append(" GROUP BY T01.").append(V50bConsultasBD.CRESOL).append(") CPENDIENTES, ");
		
		sqlSitResol.append("(SELECT T06.").append(V50bAmbitos_ResolutorBD.CRESOL).append(" AS CODRESOL3, COUNT(1) ");
		sqlSitResol.append("FROM ").append(V50bAmbitos_ResolutorBD.TABLA_AMBITOS_RESOLUTOR).append(" T06 ");
		sqlSitResol.append("WHERE T06.").append(V50bAmbitos_ResolutorBD.CRESOL).append(">0 ");
		sqlSitResol.append("AND T06.").append(V50bAmbitos_ResolutorBD.CAMBIT).append(">0 ");
		sqlSitResol.append("GROUP BY T06.").append(V50bAmbitos_ResolutorBD.CRESOL).append(") AMBITOS_RES ");
		
		sqlSitResol.append("WHERE T03.").append(V50bResolutoresBD.COD_RESOL).append(">0");
		sqlSitResol.append(" AND CODRESOL1(+) = T03.").append(V50bResolutoresBD.COD_RESOL);
		sqlSitResol.append(" AND CODRESOL2(+) = T03.").append(V50bResolutoresBD.COD_RESOL);
		sqlSitResol.append(" AND CODRESOL3 = T03.").append(V50bResolutoresBD.COD_RESOL);
		sqlSitResol.append(" AND T03.").append(V50bResolutoresBD.ESTADO_RESOL).append("=?");
		arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		
		sqlSitResol.append(" AND (T03.").append(V50bResolutoresBD.PERFIL_RESOL).append("=? OR T03.").append(V50bResolutoresBD.PERFIL_RESOL).append("=?) ");
		arrParams.add(V50bClsConstantes.PERFIL_RESOLUTOR_BD);
		arrParams.add(V50bClsConstantes.PERFIL_AMBOS_BD);
				
		
		
		if(StringUtils.isNotEmpty(form.getAmbito().getCambit())) {
			sqlSitResol.append(" AND T03.").append(V50bResolutoresBD.COD_RESOL).append(" = ");
			sqlSitResol.append("T06.").append(V50bAmbitos_ResolutorBD.CRESOL);
			sqlSitResol.append(" AND T06.").append(V50bAmbitos_ResolutorBD.CAMBIT).append("=?");
			arrParams.add(Integer.valueOf(form.getAmbito().getCambit()));
		}
		
		sqlSitResol.append(" ORDER BY T03.").append(V50bResolutoresBD.COD_RESOL);
		
		return new V50bClsAccesoBD().fncLanzaBusqueda(sqlSitResol.toString(), arrParams, new V50bSituacionResolutoresAreaRowMapper());
	}
	
	/**
	 * @param resolutores : resolutor con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarResolutoresAmbito(V50bResolutoresBean resolutores) throws Exception {
		
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncBuscarResolutoresAmbito() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOCINCUENTA);
		final List arrParams = new ArrayList();
	
		int codigo = Integer.parseInt(resolutores.getCodambito());
		
		sql.append("SELECT T03.").append(V50bResolutoresBD.COD_RESOL).append(" AS CODIGORESOLUTORIOS, T03.");
		sql.append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS NOMBRE, T03.");
		sql.append(V50bResolutoresBD.AP1_RESOL).append(" AS PRIMERAPELLIDO, T03.");
		sql.append(V50bResolutoresBD.AP2_RESOL).append(" AS SEGUNDOAPELLIDO");
		sql.append(" FROM ");
		sql.append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03, ");
		sql.append(V50bAmbitos_ResolutorBD.TABLA_AMBITOS_RESOLUTOR).append(" T06");
		sql.append(" WHERE T06.");
		sql.append(V50bAmbitos_ResolutorBD.CRESOL).append(" = T03.").append(V50bResolutoresBD.COD_RESOL);
		sql.append(" AND T06.").append(V50bAmbitos_ResolutorBD.CAMBIT).append(" = ").append(codigo);

		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bResolutoresAmbitoRowMapper());
		
		return lista;
	}
	
	/**
	 * 
	 * <p>Ttulo: fncBuscSitResolutores</p>
	 * <p>Descripcin: Busca resolutores y su carga de consultas</p>
	 * <p>Copyright: Copyright (c) Dec 10, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author alata
	 * @version 1.0
	 * @param codAmbito String con el codigo de mbito
	 * @return List Lista de los resolutores y su carga
	 * @throws Exception Cualquier excepcim
	 */
	public List fncBuscSitResolutores(String codAmbito) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncBuscSitResolutores() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.SETECIENTOSTREINTA);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T03.").append(V50bResolutoresBD.COD_RESOL).append(" AS CODIGO, ");
		sql.append("T03.").append(V50bResolutoresBD.ID_RESOL).append(" AS ID, ");
		sql.append("T03.").append(V50bResolutoresBD.NOMBRE_RESOL).append(" AS NOMBRE, "); 
		sql.append("T03.").append(V50bResolutoresBD.AP1_RESOL).append("||' '||T03.").append(V50bResolutoresBD.AP2_RESOL).append(" AS APELLIDOS, ");
		sql.append("NVL(V24H.DIF24H, 0) AS DIF24H, NVL(CPENDIENTES.PENDIENTES, 0) AS PENDIENTES, ");
		sql.append("fncatrasadasresolutor(T03.").append(V50bResolutoresBD.COD_RESOL).append(") AS RETRASADAS, ");
		sql.append("LPAD(NVL(V24H.DIF24H, 0),4,0) AS DIF24HORDEN, LPAD(NVL(CPENDIENTES.PENDIENTES, 0),4,0) AS PENDIENTESORDEN, ");
		sql.append("LPAD(fncatrasadasresolutor(T03.").append(V50bResolutoresBD.COD_RESOL).append("),4,0) AS RETRASADASORDEN ");
		sql.append("FROM ").append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03, ");
		
		if(StringUtils.isNotEmpty(codAmbito)) {
			sql.append(V50bAmbitos_ResolutorBD.TABLA_AMBITOS_RESOLUTOR).append(" T06, ");
		}
		
		sql.append("(SELECT T01.").append(V50bConsultasBD.CRESOL).append(" AS CODRESOL1, COUNT(1) AS DIF24H ");
		sql.append("FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append(">0");
		sql.append(" AND T01.").append(V50bConsultasBD.CODDIF).append("=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.DIFICULTAD_24H));		
//		sql.append(" AND SYSDATE BETWEEN T01.").append(V50bConsultasBD.FECCON);
//		sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append("+1");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RECIBIDA));
		
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_DENEGADA));
		
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RESPONDIDA));
		
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_CATALOGADA));
		
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_ABANDONADA));
		
		sql.append(" GROUP BY T01.").append(V50bConsultasBD.CRESOL).append(") V24H, ");
		sql.append("(SELECT T01.").append(V50bConsultasBD.CRESOL).append(" AS CODRESOL2, ");
		sql.append("COUNT(1) AS PENDIENTES ");
		sql.append("FROM ").append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sql.append("WHERE T01.").append(V50bConsultasBD.CCONSU).append(">0");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RECIBIDA));
		
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_DENEGADA));
		
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_RESPONDIDA));
		
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_CATALOGADA));
		
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("!=?");
		arrParams.add(Integer.valueOf(V50bClsConstantes.ESTADO_ABANDONADA));
		
		sql.append(" GROUP BY T01.").append(V50bConsultasBD.CRESOL).append(") CPENDIENTES, ");
		
		sql.append("(SELECT T06.").append(V50bAmbitos_ResolutorBD.CRESOL).append(" AS CODRESOL3, COUNT(1) ");
		sql.append("FROM ").append(V50bAmbitos_ResolutorBD.TABLA_AMBITOS_RESOLUTOR).append(" T06 ");
		sql.append("WHERE T06.").append(V50bAmbitos_ResolutorBD.CRESOL).append(">0 ");
		sql.append("AND T06.").append(V50bAmbitos_ResolutorBD.CAMBIT).append(">0 ");
		sql.append("GROUP BY T06.").append(V50bAmbitos_ResolutorBD.CRESOL).append(") AMBITOS_RES ");
		
		sql.append("WHERE T03.").append(V50bResolutoresBD.COD_RESOL).append(">0");
		sql.append(" AND CODRESOL1(+) = T03.").append(V50bResolutoresBD.COD_RESOL);
		sql.append(" AND CODRESOL2(+) = T03.").append(V50bResolutoresBD.COD_RESOL);
		sql.append(" AND CODRESOL3 = T03.").append(V50bResolutoresBD.COD_RESOL);
		sql.append(" AND T03.").append(V50bResolutoresBD.ESTADO_RESOL).append("=?");
		arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		
		sql.append(" AND (T03.").append(V50bResolutoresBD.PERFIL_RESOL).append("=? OR T03.").append(V50bResolutoresBD.PERFIL_RESOL).append("=?) ");
		arrParams.add(V50bClsConstantes.PERFIL_RESOLUTOR_BD);
		arrParams.add(V50bClsConstantes.PERFIL_AMBOS_BD);
		
		if(StringUtils.isNotEmpty(codAmbito)) {
			sql.append(" AND T03.").append(V50bResolutoresBD.COD_RESOL).append(" = ");
			sql.append("T06.").append(V50bAmbitos_ResolutorBD.CRESOL);
			sql.append(" AND T06.").append(V50bAmbitos_ResolutorBD.CAMBIT).append("=?");
			arrParams.add(Integer.valueOf(codAmbito));
		}
		
		sql.append(" ORDER BY T03.").append(V50bResolutoresBD.COD_RESOL);
		
		return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bSituacionResolutoresAreaRowMapper());
	}
	
	/**
	 * 
	 * <p>Ttulo: fncComunicacionResolutor</p>
	 * <p>Descripcin: Obtiene los datos para comunicacin al resolutor o tcnico</p>
	 * <p>Copyright: Copyright (c) Nov 20, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param codResol cdigo del resolutor
	 * @return V50bResolutoresBean Los datos de comunicacin del resolutor
	 * @throws Exception Cualquier excepcin
	 */
	public V50bResolutoresBean fncComunicacionResolutor(String codResol) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncComunicacionResolutor() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.SETENTAYNUEVE);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T03.").append(V50bResolutoresBD.EMAIL_RESOL).append(" AS EMAIL, ");
		sql.append("T03.").append(V50bResolutoresBD.MOVIL_RESOL).append(" AS MOVIL, ");
		sql.append("T03.").append(V50bResolutoresBD.RECIBE_AVISOS_RESOL).append(" AS AVISO ");
		sql.append("FROM ").append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03 ");
		sql.append("WHERE T03.").append(V50bResolutoresBD.COD_RESOL).append(" = ?");
		arrParams.add(Integer.valueOf(codResol));
		
		return (V50bResolutoresBean)(new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bComunicacionResolutorRowMapper())).get(0);
	}
	
	/**
	 * alata
	 * 
	 * @param listaAmbitos
	 *            :lista con los ambitos de subcategoria
	 * @return boolean
	 * @throws Exception
	 *             Se lanza la excepcin.
	 */
	public boolean fncBuscarResolBaja(List listaAmbitos) throws Exception {
		V50bClsTrazas.depura("V50bResolutoresDAOImpl.fncBuscarResolBaja() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TREINTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT ").append(V50bAmbitoBD.CAMBIT).append(" AS CODIGOAMBITO");
		sql.append(" FROM ").append(V50bAmbitoBD.TABLA_AMBITO);
		sql.append(" WHERE (").append(V50bAmbitoBD.CAMBIT).append(" = ?");
		sql.append(" AND ").append(V50bAmbitoBD.ESTADO).append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append("')");
		//String[] ambitos = subcategorias.getAmbitos();
		V50bResolutoresBean resolutor = (V50bResolutoresBean)listaAmbitos.get(0);
		arrParams.add(Integer.valueOf(resolutor.getCodambito()));
		for (int i=1;i<listaAmbitos.size();i++) {
			resolutor = (V50bResolutoresBean)listaAmbitos.get(i);
			sql.append(" OR (").append(V50bAmbitoBD.CAMBIT).append(" = ?");
			arrParams.add(Integer.valueOf(resolutor.getCodambito()));
			sql.append(" AND ").append(V50bAmbitoBD.ESTADO).append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append("')");
		}
		
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bAmbitosResolutorRowMapper());

		return lista.isEmpty();
		
	}
	
	
	
	//***************
	//* ROW-MAPPERS *
	//***************
	
	/**
	 * 
	 * @author llaparra
	 *
	 */
	class V50bComunicacionResolutorRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Excepcin SQL.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bResolutoresBean resolutor = new V50bResolutoresBean();
			
			resolutor.setEmail(rs.getString("EMAIL"));
			resolutor.setMovil(rs.getString("MOVIL"));
			resolutor.setAviso(rs.getString("AVISO"));
			
			return resolutor;
		}
	}
	
	/**
	 * 
	 * @author iurkidi
	 * 
	 */
	class V50bPerfilUsuarioRowMapper implements V50bRowMapper {

		/**
		 * @param rs
		 *            :Resultset
		 * @return Object
		 * @throws SQLException
		 *             Se eleva la excepcin.
		 */
		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bUsuarioBean usuario = new V50bUsuarioBean();

			usuario.setDniUsuario(rs.getString("DNI"));
			usuario.setPerfilUsuario(rs.getString("PERFIL"));
			usuario.setNombreUsuario(rs.getString("NOMBREUSUARIO"));

			return usuario;
		}
	}

	/**
	 * 
	 * @author acompes
	 * 
	 */
	class V50bResolutoresRowMapper implements V50bRowMapper {

		/**
		 * @param rs
		 *            :Resultset
		 * @return Object
		 * @throws SQLException
		 *             Se eleva la excepcin.
		 */
		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bResolutoresBean resolutores = new V50bResolutoresBean();

			resolutores.setCodResol(rs.getString("CODIGORESOLUTORIOS"));
			resolutores.setIdResol(rs.getString("IDENTIFICADORRESOLUTORIOS"));
			resolutores.setNombre(rs.getString("NOMBRE"));
			resolutores.setApe1(rs.getString("PRIMERAPELLIDO"));
			resolutores.setApe2(rs.getString("SEGUNDOAPELLIDO"));
			resolutores.setEmail(rs.getString("EMAIL"));
			resolutores.setMovil(rs.getString("MOVIL"));
			resolutores.setEstado(rs.getString("ESTADO"));
			
			if(resolutores.getEstado().equals(V50bClsConstantes.CONSTANTE_ALTA)|| resolutores.getEstado()== null){
				resolutores.setFormHabilitado(V50bClsConstantes.CONSTANTE_SI);
			} else {
				resolutores.setFormHabilitado(V50bClsConstantes.CONSTANTE_NO);
			}
			
			resolutores.setPerfil(rs.getString("PERFIL"));
			resolutores.setPerfilDescripcion(rs.getString("PERFILDESCRIPCION"));
			resolutores.setAviso(rs.getString("AVISO"));
			resolutores.setAvisoMensaje(rs.getString("AVISOMENSAJE"));
			String nombre= rs.getString("NOMBRE");
			String ape1= rs.getString("PRIMERAPELLIDO");
			String ape2= rs.getString("SEGUNDOAPELLIDO");
			
			StringBuffer nombreApellidos= new StringBuffer("");
			
			if (ape1 != null){
				nombreApellidos.append(ape1);
			}
			if (ape2 != null){
				nombreApellidos.append(" ");
				nombreApellidos.append(ape2);
			}
			if (nombre != null){
				if(!"".equals(nombreApellidos.toString())){
				nombreApellidos.append(", ");
				}
				nombreApellidos.append(nombre);
			}
						
			resolutores.setNombreApellidos(nombreApellidos.toString());

			return resolutores;

		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bAmbitosResolutorRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bResolutoresBean resolutor = new V50bResolutoresBean();
			
			resolutor.setCodambito(rs.getString("CODIGOAMBITO"));
			
			return resolutor;
		}
	}
	
	/**
	 * 
	 * @author llaparra
	 *
	 */
	class V50bSituacionResolutoresAreaRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bResolutoresBean resolutor = new V50bResolutoresBean();
			
			resolutor.setCodResol(rs.getString("CODIGO"));
			resolutor.setIdResol(rs.getString("ID"));
			resolutor.setNombre(rs.getString("NOMBRE"));
			String nombre = rs.getString("NOMBRE");
			resolutor.setNombreApellidos(rs.getString("APELLIDOS"));
			String apellidos = rs.getString("APELLIDOS");
			resolutor.setEn24Horas(rs.getString("DIF24H"));
			resolutor.setConsultasPendientes(rs.getString("PENDIENTES"));
			resolutor.setRetrasadas(rs.getString("RETRASADAS"));
			resolutor.setEn24HorasOrden(rs.getString("DIF24HORDEN"));
			resolutor.setConsultasPendientesOrden(rs.getString("PENDIENTESORDEN"));
			resolutor.setRetrasadasOrden(rs.getString("RETRASADASORDEN"));
			
			StringBuffer nombreApellidos= new StringBuffer("");
			
			if (apellidos != null){
				nombreApellidos.append(apellidos);
			}
			if (nombre != null){
				if(!" ".equals(nombreApellidos.toString())){
					nombreApellidos.append(", ");
				}
				nombreApellidos.append(nombre);
			}
						
			resolutor.setNombreApellidos(nombreApellidos.toString());
			
			return resolutor;
		}
	}
	
	/**
	 * 
	 * @author alata
	 * 
	 */
	class V50bResolutoresAmbitoRowMapper implements V50bRowMapper {

		/**
		 * @param rs
		 *            :Resultset
		 * @return Object
		 * @throws SQLException
		 *             Se eleva la excepcin.
		 */
		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bResolutoresBean resolutores = new V50bResolutoresBean();

			resolutores.setCodResol(rs.getString("CODIGORESOLUTORIOS"));
			resolutores.setNombre(rs.getString("NOMBRE"));
			resolutores.setApe1(rs.getString("PRIMERAPELLIDO"));
			resolutores.setApe2(rs.getString("SEGUNDOAPELLIDO"));
			String nombre= rs.getString("NOMBRE");
			String ape1= rs.getString("PRIMERAPELLIDO");
			String ape2= rs.getString("SEGUNDOAPELLIDO");
			
			StringBuffer nombreApellidos= new StringBuffer("");
			
			if (ape1 != null){
				nombreApellidos.append(ape1);
			}
			if (ape2 != null){
				nombreApellidos.append(" ");
				nombreApellidos.append(ape2);
			}
			if (nombre != null){
				if(!"".equals(nombreApellidos.toString())){
				nombreApellidos.append(", ");
				}
				nombreApellidos.append(nombre);
			}
						
			resolutores.setNombreApellidos(nombreApellidos.toString());

			return resolutores;

		}
	}
	
	/**
	 * 
	 * @author llaparra
	 *
	 */
	class V50bSitResolutoresRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bResolutoresBean resolutor = new V50bResolutoresBean();
			
			resolutor.setCodResol(rs.getString("CODIGO"));
			resolutor.setIdResol(rs.getString("IDRESOLUTOR"));
			String nombre = rs.getString("NOMBRE");
			String apellidos = rs.getString("APELLIDOS");
			resolutor.setEn24Horas(rs.getString("DIF24H"));
			resolutor.setConsultasPendientes(rs.getString("PENDIENTES"));
			resolutor.setRetrasadas(rs.getString("RETRASADAS"));
			resolutor.setEn24HorasOrden(rs.getString("DIF24HORDEN"));
			resolutor.setConsultasPendientesOrden(rs.getString("PENDIENTESORDEN"));
			resolutor.setRetrasadasOrden(rs.getString("RETRASADASORDEN"));
			
			StringBuffer nombreApellidos= new StringBuffer("");
			
			if (apellidos != null){
				nombreApellidos.append(apellidos);
			}
			if (nombre != null){
				if(!" ".equals(nombreApellidos.toString())){
					nombreApellidos.append(", ");
				}
				nombreApellidos.append(nombre);
			}
						
			resolutor.setNombreApellidos(nombreApellidos.toString());

			
			return resolutor;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bResolutorCodigoRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bResolutoresBean ambito = new V50bResolutoresBean();
			
			ambito.setCodResol(rs.getString("CODIGO"));

			return ambito;
		}
	}

}
