package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import v50b.v50bBeans.V50bProfesionesBean;
import v50b.v50bBeans.V50bSuscriptorBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bProfesionesBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bSuscriptoresBD;
import v50b.v50bModelo.V50bDAOFactory;
import v50b.v50bModelo.v50bDao.V50bProfesionesDAO;


/**
 * 
 * @author acompes
 * 
 */
public class V50bProfesionesDAOImpl implements V50bProfesionesDAO {

	/**
	 * @param profesiones
	 *            :Profesiones con los datos de busqueda
	 * @return List
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public List fncBuscarProfesiones(V50bProfesionesBean profesiones)
			throws Exception {

		V50bClsTrazas.depura("V50bProfesionesDAOImpl.fncBuscarProfesiones() ");
		final StringBuffer sql = new StringBuffer(240);
		final List arrParams = new ArrayList();

		sql.append("SELECT T10.").append(V50bProfesionesBD.CODPROF).append(" AS CODIGO, ");
		sql.append("LPAD(T10.").append(V50bProfesionesBD.CODPROF).append(",?,'0') AS CODIGOORDEN, T10.");
		arrParams.add(new Integer(V50bClsConstantes.DOS));
		sql.append(V50bProfesionesBD.DESCAS).append(
				" AS DESCRIPCIONCASTELLANO, T10.");
		sql.append(V50bProfesionesBD.DESEUS).append(" AS DESCRIPCIONEUSKERA,");
		sql.append(" DECODE(T10.");
		sql.append(V50bProfesionesBD.ESTADO).append(", '");
		sql.append(V50bClsConstantes.CONSTANTE_ALTA).append("', '");
		sql.append(V50bClsConstantes.LITERAL_DESC_ALTA).append("', '");
		sql.append(V50bClsConstantes.CONSTANTE_BAJA).append("', '"); 
		sql.append(V50bClsConstantes.LITERAL_DESC_BAJA).append("') AS ESTADO, T10.");
		sql.append(V50bProfesionesBD.ESTADO).append(" AS CODIGOESTADO FROM ");
		sql.append(V50bProfesionesBD.TABLA_PROFESIONES).append(" T10 ");
		sql.append("WHERE T10.");
		sql.append(V50bProfesionesBD.CODPROF).append(" > 0");

		String codProf = profesiones.getCodProf();
		String desCas = profesiones.getDesCas();
		String desEus = profesiones.getDesEus();
		String estado = profesiones.getEstado();

		if (codProf != null && !"".equals(codProf)) {
			sql.append(" AND T10.").append(V50bProfesionesBD.CODPROF);
			sql.append(" = ?");
			arrParams.add(new Integer(codProf));
		}

		if (desCas != null && !"".equals(desCas)) {
			sql.append(" AND T10.").append(V50bProfesionesBD.DESCAS);
			sql.append(" LIKE ?");
			arrParams.add("%"+desCas.toUpperCase() + "%");
		}

		if (desEus != null && !"".equals(desEus)) {
			sql.append(" AND T10.").append(V50bProfesionesBD.DESEUS);
			sql.append(" LIKE ?");
			arrParams.add("%"+desEus.toUpperCase() + "%");
		}

		if (estado != null) {
			sql.append(" AND T10.").append(V50bProfesionesBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append(
					"'");
		} else {
			sql.append(" AND T10.").append(V50bProfesionesBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_ALTA).append(
					"'");
		}
		sql.append(" ORDER BY 1");

		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bProfesionesRowMapper());

		return lista;
	}

	/**
	 * @param profesiones :
	 *            Profesiones con los datos de modificacin
	 * @return int: el resultado de la update
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public int fncModificarProfesiones(V50bProfesionesBean profesiones)
			throws Exception {
		V50bClsTrazas
				.depura("V50bProfesionesDAOImpl.fncModificarProfesiones() ");
		
		final StringBuffer existeCod = new StringBuffer(50);
		final StringBuffer sql = new StringBuffer(70);
		final List arrParams = new ArrayList();

		//Comprobamos si existe en la tabla el cdigo introducido
		
		existeCod.append("SELECT COUNT(T10.").append(V50bProfesionesBD.CODPROF).append(") FROM ");
		existeCod.append(V50bProfesionesBD.TABLA_PROFESIONES).append(" T10 ");
		existeCod.append("WHERE T10.");
		existeCod.append(V50bProfesionesBD.CODPROF).append(" = '");
		existeCod.append(profesiones.getCodProf()).append("'");
		
		sql.append("UPDATE ");
		sql.append(V50bProfesionesBD.TABLA_PROFESIONES).append(" T10");
		sql.append(" SET T10.").append(V50bProfesionesBD.CODPROF).append(
				"= ?, T10.");

		arrParams.add(new Integer(profesiones.getCodProf()));

		sql.append(V50bProfesionesBD.DESCAS);
		sql.append(" = ?, T10.");

		if (profesiones.getDesCas() == null
				|| "".equals(profesiones.getDesCas())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(profesiones.getDesCas());
		}

		sql.append(V50bProfesionesBD.DESEUS);
		sql.append(" = ?, T10.");

		if (profesiones.getDesEus() == null
				|| "".equals(profesiones.getDesEus())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(profesiones.getDesEus());
		}

		sql.append(V50bProfesionesBD.ESTADO);
		sql.append(" = ? ");
		
		if (profesiones.getEstado() == null
				|| "".equals(profesiones.getEstado())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		}

		sql.append("WHERE T10.").append(V50bProfesionesBD.CODPROF);
		sql.append(" = ? ");

		arrParams.add(new Integer(profesiones.getCodProf()));

		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(),
				arrParams);
	}

	/**
	 * @param profesiones :
	 *            profesiones con los datos a aadir
	 * @return int: el resultado de la update
	 * @throws Exception
	 *             Se eleva la excepcin.
	 */
	public int fncAniadirProfesiones(V50bProfesionesBean profesiones)
			throws Exception {
		V50bClsTrazas.depura("V50bProfesionesDAOImpl.fncAniadirProfesiones() ");

		final StringBuffer sql = new StringBuffer(40);
		final List arrParams = new ArrayList();

		sql.append("INSERT INTO ").append(V50bProfesionesBD.TABLA_PROFESIONES)
				.append("(");
		sql.append(V50bProfesionesBD.CODPROF).append(", ");
		sql.append(V50bProfesionesBD.DESCAS).append(", ");
		sql.append(V50bProfesionesBD.DESEUS).append(", ");
		sql.append(V50bProfesionesBD.ESTADO);
		sql.append(") VALUES(").append(V50bDAOFactory.getConsultasDAO().fncGenericoNextVal(V50bProfesionesBD.SEQ_PROFESIONES)).append(",?,?,?) ");

		if (profesiones.getDesCas() == null
				|| "".equals(profesiones.getDesCas())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(profesiones.getDesCas());
		}

		if (profesiones.getDesEus() == null
				|| "".equals(profesiones.getDesEus())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		} else {
			arrParams.add(profesiones.getDesEus());
		}

		if (profesiones.getCodEstado() == null
				|| "".equals(profesiones.getCodEstado())) {
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		}

		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(),
				arrParams);
	}
	
	/**
	 * 
	 * @param codProfesion : codigo de profesin
	 * @return List
	 * @throws Exception Se lanza la excepcin.
	 */
	public List fncBuscarProfesionesUsuarios(String codProfesion) throws Exception {
		V50bClsTrazas.depura("V50bProfesionesDAOImpl.fncBuscarProfesionesUsuarios() ");

		final StringBuffer sql = new StringBuffer(34);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT ").append(V50bSuscriptoresBD.CSUSCR).append(" AS CODIGO");
		sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES);
		sql.append(" WHERE ").append(V50bSuscriptoresBD.COPROF).append(" = ?");
		arrParams.add(Integer.valueOf(codProfesion));
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),
				arrParams, new V50bProfesionesUsuariosRowMapper());

		return lista;

	}

	/**
	 * 
	 * @author acompes
	 * 
	 */
	class V50bProfesionesRowMapper implements V50bRowMapper {

		/**
		 * @param rs
		 *            :Resultset
		 * @return Object
		 * @throws SQLException
		 *             Se eleva la excepcin.
		 */
		public Object mapRow(ResultSet rs) throws SQLException {

			final V50bProfesionesBean profesiones = new V50bProfesionesBean();

			profesiones.setCodProf(rs.getString("CODIGO"));
			profesiones.setCodProfOrden(rs.getString("CODIGOORDEN"));
			profesiones.setDesCas(rs.getString("DESCRIPCIONCASTELLANO"));
			profesiones.setDesEus(rs.getString("DESCRIPCIONEUSKERA"));
			profesiones.setCodEstado(rs.getString("CODIGOESTADO"));
			profesiones.setEstado(rs.getString("ESTADO"));
			if(profesiones.getEstado().equals(V50bClsConstantes.LITERAL_DESC_ALTA)|| profesiones.getEstado()== null){
				profesiones.setFormHabilitado(V50bClsConstantes.CONSTANTE_SI);
			} else {
				profesiones.setFormHabilitado(V50bClsConstantes.CONSTANTE_NO);
			}
			
			return profesiones;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bProfesionesUsuariosRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se lanza la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bSuscriptorBean usuario = new V50bSuscriptorBean();
			
			usuario.setCodigo(rs.getString("CODIGO"));
			
			return usuario;
		}
	}

}
