package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import v50b.v50bBeans.V50bMotivoConsultaBean;
import v50b.v50bBeans.V50bMotivosBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bMotivosBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bMotivosConsultaDenegadaBD;
import v50b.v50bModelo.v50bDao.V50bMotivosDAO;


/**
 * 
 * @author iurkidi
 *
 */
public class V50bMotivosDAOImpl implements V50bMotivosDAO{

	/**
	 * @param motivo : motivo con los datos de busqueda 
	 * @return List: el resultado de la select
	 * @throws Exception Se eleva la excepcin.
	 */
	public List fncBuscarMotivos(V50bMotivosBean motivo) throws Exception {
		V50bClsTrazas.depura("V50bMotivosDAOImpl.fncBuscarMotivos() ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.DOSCIENTOSTREINTA);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT T04.").append(V50bMotivosBD.CMOTIV).append(" AS CODIGO, ");
		sql.append("LPAD(T04.").append(V50bMotivosBD.CMOTIV).append(",?,'0') AS CODIGOORDEN, T04.");
		arrParams.add(new Integer(V50bClsConstantes.DOS));
		sql.append(V50bMotivosBD.DMOTIC).append(" AS DESCRIPCIONCASTELLANO, T04.");
		sql.append(V50bMotivosBD.DMOTIE).append(" AS DESCRIPCIONEUSKERA, DECODE(T04.");
		sql.append(V50bMotivosBD.ESTADO).append(", '");
		sql.append(V50bClsConstantes.CONSTANTE_ALTA).append("', '");
		sql.append(V50bClsConstantes.LITERAL_DESC_ALTA).append("', '");
		sql.append(V50bClsConstantes.CONSTANTE_BAJA).append("', '"); 
		sql.append(V50bClsConstantes.LITERAL_DESC_BAJA).append("') AS ESTADO FROM ");
		sql.append(V50bMotivosBD.TABLA_MOTIVOS).append(" T04 ");
		sql.append("WHERE T04.").append(V50bMotivosBD.CMOTIV).append(" > 0");
		
		String cmotiv = motivo.getCmotiv();
		String tipoMotivo = motivo.getTipmot();
		String descc = motivo.getDmotic();
		String desce = motivo.getDmotie();
		String estado = motivo.getEstado();
		
		if(cmotiv!=null && !"".equals(cmotiv)){
			int codigo = Integer.parseInt(cmotiv);
			sql.append(" AND T04.").append(V50bMotivosBD.CMOTIV);
			sql.append(" = ").append(codigo);
		}
		
		if(descc!=null && !"".equals(descc)){
			sql.append(" AND UPPER(T04.").append(V50bMotivosBD.DMOTIC);
			sql.append(") LIKE ?");
			arrParams.add("%"+descc.toUpperCase()+"%");
		}
		
		if(desce!=null && !"".equals(desce)){
			sql.append(" AND UPPER(T04.").append(V50bMotivosBD.DMOTIE);
			sql.append(") LIKE ?");
			arrParams.add("%"+desce.toUpperCase()+"%");
		}
		if (estado!=null){
			sql.append(" AND T04.").append(V50bMotivosBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_BAJA).append("'");
		}else{
			sql.append(" AND T04.").append(V50bMotivosBD.ESTADO);
			sql.append(" = '").append(V50bClsConstantes.CONSTANTE_ALTA).append("'");
		}
		
		sql.append(" AND T04.").append(V50bMotivosBD.TIPMOT);
		sql.append(" = '").append(tipoMotivo).append("'");
		sql.append(" ORDER BY 1");
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(), arrParams, new V50bMotivosRowMapper());
		
		return lista;
	}
	/**
	* @param motivo : motivo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncModificarMotivos(V50bMotivosBean motivo) throws Exception {
		
		V50bClsTrazas.depura("V50bMotivosDAOImpl.fncModificarMotivos() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.SETENTAYNUEVE);
		final List arrParams = new ArrayList();
		
		String cmotiv = motivo.getCmotiv();
		String tipoMotivo = motivo.getTipmot();
		String descc = motivo.getDmotic();
		String desce = motivo.getDmotie();
		String estado = motivo.getEstado();
		
		sql.append("UPDATE ");sql.append(V50bMotivosBD.TABLA_MOTIVOS).append(" T04");
		sql.append(" SET T04.");
		sql.append(V50bMotivosBD.DMOTIC);sql.append(" = ?, T04.");
		
		if (descc==null || "".equals(descc)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(descc);
		}
		
		sql.append(V50bMotivosBD.DMOTIE);sql.append(" = ?, T04.");
		
		if(desce==null || "".equals(desce)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(desce);
		}
		
		sql.append(V50bMotivosBD.ESTADO);sql.append(" = ? ");
		
		if(estado==null || "".equals(estado)){
			arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
		}else{
			arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
		}
		
		int codigo = Integer.parseInt(cmotiv);
		sql.append("WHERE T04.").append(V50bMotivosBD.CMOTIV).append(" = ").append(codigo);
		
		sql.append(" AND T04.").append(V50bMotivosBD.TIPMOT).append(" = ? ");
		if(tipoMotivo==null || "".equals(tipoMotivo)){
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}else{
			arrParams.add(tipoMotivo);
		}
		
		return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
	}
	
	/**
	* @param motivo : motivo con los datos de busqueda 
	* @return int: el resultado de la update
	* @throws Exception Se eleva la excepcin.
	*/
	public int fncAniadirMotivos(V50bMotivosBean motivo) throws Exception {
		
		V50bClsTrazas.depura("V50bMotivosDAOImpl.fncAniadirMotivos() ");
		
		final StringBuffer sql = new StringBuffer();
		final List arrParams = new ArrayList();
		final StringBuffer sqlCod = new StringBuffer(V50bClsConstantes.CUARENTAYCINCO);
		final List arrParamsCod = new ArrayList();
		
		String tipoMotivo = motivo.getTipmot();
		
		sqlCod.append("SELECT (MAX(").append(V50bMotivosBD.CMOTIV).append(")+1) AS CODIGO FROM ");
		sqlCod.append(V50bMotivosBD.TABLA_MOTIVOS);
		sqlCod.append(" WHERE ").append(V50bMotivosBD.TIPMOT).append(" = ? ");
		
		arrParamsCod.add(tipoMotivo);
		
		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sqlCod.toString(), arrParamsCod,new V50bMotivosCodRowMapper());
		V50bMotivosBean motivoBean = (V50bMotivosBean)lista.get(0);
		String cmotiv = motivoBean.getCmotiv();
		
		if(cmotiv==null || cmotiv.equals("")){
			//la tabla esta vaca, no hay expedientes an
			cmotiv="1";
		}
		
		if("100".equals(cmotiv)){
			return V50bClsConstantes.TRES_NEGATIVO;
		}else{
			motivo.setCmotiv(cmotiv);
			int codigo = Integer.parseInt(cmotiv);
			
			sql.append("INSERT INTO ").append(V50bMotivosBD.TABLA_MOTIVOS).append("(");
			sql.append(V50bMotivosBD.CMOTIV).append(", ");
			sql.append(V50bMotivosBD.TIPMOT).append(", ");
			sql.append(V50bMotivosBD.DMOTIC).append(", ");
			sql.append(V50bMotivosBD.DMOTIE).append(", ");
			sql.append(V50bMotivosBD.ESTADO).append(") VALUES(");
			sql.append(codigo).append(",?,?,?,?) ");
			
			String descc = motivo.getDmotic();
			String desce = motivo.getDmotie();
			String estado = motivo.getEstado();
			
			if(tipoMotivo==null || "".equals(tipoMotivo)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(tipoMotivo);
			}
			
			if(descc==null || "".equals(descc)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(descc);
			}
			
			if(desce==null || "".equals(desce)){
				arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
			}else{
				arrParams.add(desce);
			}
			
			if(estado==null || "".equals(estado)){
				arrParams.add(V50bClsConstantes.CONSTANTE_ALTA);
			}else{
				arrParams.add(V50bClsConstantes.CONSTANTE_BAJA);
			}
					
			return new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams);
		}
	}
	
	/**
	 * 
	 * <p>Ttulo: fncObtenerCorrelMotivoCons</p>
	 * <p>Descripcin: Obtiene el siguiente correlativo</p>
	 * <p>Copyright: Copyright (c) Dec 6, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param motivo Motivo
	 * @return Integer El correlativo
	 * @throws Exception Cualquier excepcin
	 */
	private Integer fncObtenerCorrelMotivoCons(V50bMotivoConsultaBean motivo) throws Exception {
		V50bClsTrazas.depura("V50bMotivosDAOImpl.fncObtenerCorrelMotivoCons() ");
		
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CINCUENTAYCINCO);
		final List arrParams = new ArrayList();
		
		sql.append("SELECT NVL(MAX(").append(V50bMotivosConsultaDenegadaBD.CORREL).append("),0)+1 ");
		sql.append("FROM ").append(V50bMotivosConsultaDenegadaBD.TABLA_MOTIVOS_CONSULTA).append(" T05 ");
		sql.append("WHERE T05.").append(V50bMotivosConsultaDenegadaBD.CCONSU).append("=?");
		arrParams.add(Integer.valueOf(motivo.getCodConsulta()));
		
//		sql.append(" AND T05.").append(V50bMotivosConsultaDenegadaBD.CMOTIV).append("=?");
//		arrParams.add(Integer.valueOf(motivo.getCodMotivo()));
		
		sql.append(" AND T05.").append(V50bMotivosConsultaDenegadaBD.TIPMOT).append("=?");
		arrParams.add(motivo.getTipoMotivo());
		
		return Integer.valueOf(new V50bClsAccesoBD().fncConsultaEspecifica(sql.toString(),arrParams));
	}
	
	/**
	 * 
	 * <p>Ttulo: fncNuevoMotivoConsulta</p>
	 * <p>Descripcin: Inserta un nuevo motivo de consulta en BDD</p>
	 * <p>Copyright: Copyright (c) Dec 6, 2008</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author llaparra
	 * @version 1.0
	 * @param motivo Motivo
	 * @return Integer Resultado de la operacin
	 * @throws Exception Cualquier excepcin
	 */
	public Integer fncNuevoMotivoConsulta(V50bMotivoConsultaBean motivo) throws Exception {
		V50bClsTrazas.depura("V50bMotivosDAOImpl.fncNuevoMotivoConsulta() ");
		
		Integer correl = this.fncObtenerCorrelMotivoCons(motivo);
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.CUARENTA);
		final List arrParams = new ArrayList();
		
		sql.append("INSERT INTO ").append(V50bMotivosConsultaDenegadaBD.TABLA_MOTIVOS_CONSULTA).append(" T05 ");
		sql.append("VALUES (?,?,?,?,?,?)");
		arrParams.add(Integer.valueOf(motivo.getCodConsulta()));
		arrParams.add(Integer.valueOf(motivo.getCodMotivo()));
		arrParams.add(motivo.getTipoMotivo());
		arrParams.add(correl);
		
		if(StringUtils.isNotEmpty(motivo.getMensaje())){
			arrParams.add(motivo.getMensaje());
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_STRING);
		}
		
		if(StringUtils.isNotEmpty(motivo.getCodResolutor())){
			arrParams.add(Integer.valueOf(motivo.getCodResolutor()));
		} else {
			arrParams.add(V50bClsConstantes.CONSTANTE_NULO_INTEGER);
		}
		
		return new Integer(new V50bClsAccesoBD().fncLanzaMovimiento(sql.toString(), arrParams));
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bMotivosRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bMotivosBean motivo = new V50bMotivosBean();
			
			motivo.setCmotiv(rs.getString("CODIGO"));
			motivo.setCmotivOrden(rs.getString("CODIGOORDEN"));
			motivo.setDmotic(rs.getString("DESCRIPCIONCASTELLANO"));
			motivo.setDmotie(rs.getString("DESCRIPCIONEUSKERA"));
			motivo.setEstado(rs.getString("ESTADO"));

			return motivo;
		}
	}
	
	/**
	 * 
	 * @author alata
	 *
	 */
	class V50bMotivosCodRowMapper implements V50bRowMapper{
		
		/**
		 * @param rs :Resultset
		 * @return Object
		 * @throws SQLException Se eleva la excepcin.
		 */
		public Object mapRow (ResultSet rs) throws SQLException{
			
			final V50bMotivosBean motivo = new V50bMotivosBean();
			
			motivo.setCmotiv(rs.getString("CODIGO"));

			return motivo;
		}
	}
	
}
