package v50b.v50bModelo.v50bJdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import v50b.v50bClasesComunes.V50bClsFecha;
import v50b.v50bBeans.V50bAmbitoBean;
import v50b.v50bBeans.V50bConsultaEdadPorcentajeBean;
import v50b.v50bBeans.V50bConsultaGraficoBarraPorcentajeBean;
import v50b.v50bBeans.V50bConsultaGraficoPorcentajeBean;
import v50b.v50bBeans.V50bConsultaRespuestasPorTecnicoPorcentajeBean;
import v50b.v50bBeans.V50bCriteriosConsultaBean;
import v50b.v50bClasesComunes.V50bClsAccesoBD;
import v50b.v50bClasesComunes.V50bClsConstantes;
import v50b.v50bClasesComunes.V50bClsFunciones;
import v50b.v50bClasesComunes.V50bClsTrazas;
import v50b.v50bClasesComunes.V50bRowMapper;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bAmbitoBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bConsultasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bDificultadBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bEstadosBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bMotivosBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bMotivosConsultaBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bMunicipiosBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bProfesionesBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bProvinciasBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bResolutoresBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bSuscriptoresBD;
import v50b.v50bEsquemaBD.v50bEsquemaV50.V50bTipoTrabajoBD;
import v50b.v50bModelo.v50bDao.V50bGraficosDAO;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
/**
 * 
 * @author mmonge
 *
 */

public class V50bGraficosDAOImpl implements V50bGraficosDAO{
	
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 21, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosBean criterios
	 * @return List lista	
	 * @throws Exception exception
	 */
	public List fncObtenerDatosGraficosTiempoMedioRespuesta(V50bCriteriosConsultaBean criteriosBean) throws Exception 
	{
		V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorTiempoMedioRespuesta");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TRESCIENTOSTRES);
		final List arrParams = new ArrayList();		
		final String strIdioma = criteriosBean.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		sql.append("SELECT TO_NUMBER(TO_CHAR(TRUNC(T01.").append(V50bConsultasBD.FECRES).append(")-TRUNC(T01.").append(V50bConsultasBD.FECASI).append("))) AS TITULO , ");
		sql.append("COUNT(1) AS COUNT");
		sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sql.append("WHERE T01.");
		sql.append(V50bConsultasBD.CCONSU).append(" > 0");
		sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR).append(" (+) ");
		sql.append(" AND T01.").append(V50bConsultasBD.FECASI).append(" IS NOT NULL");
		sql.append(" AND T01.").append(V50bConsultasBD.FECRES).append(" IS NOT NULL");
		String[] codAmbito = criteriosBean.getCodComboAmbitos();
		String codEstado = criteriosBean.getCodEstado();
		String codDificultad = criteriosBean.getCodDificultad();
		String fechaD = criteriosBean.getFechaD();
		String fechaH = criteriosBean.getFechaH();
		String codMunicipio= criteriosBean.getCodMunicipio();
		String th = criteriosBean.getCodTh();
		if(codAmbito.length>0){
			boolean hay = false;
			for (int i=0; i<codAmbito.length;i++){
				String codamb=codAmbito[i];
				if((!"".equals(codamb))&&(codamb!=null)){
					int codigo = Integer.parseInt(codamb);
					if (!hay) {
						hay = true;
						sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
						sql.append(" = ").append(codigo);	
					} else {
						sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
						sql.append(" = ").append(codigo);
					}
				}
			}
			if (hay) {
				sql.append(")");
			}
			
		}
		if(codEstado!=null && !"".equals(codEstado)){
			int codigo = Integer.parseInt(codEstado);
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
			sql.append(" = ").append(codigo);
		}
		if(codDificultad!=null && !"".equals(codDificultad)){
			int codigo = Integer.parseInt(codDificultad);
			sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
			sql.append(" = ").append(codigo);
		}
		
		if(StringUtils.isNotEmpty(fechaD)){
			sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
			arrParams.add(fechaD);
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(fechaH)){
			sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
			arrParams.add(fechaH);
			arrParams.add(masc);
		}
		if(StringUtils.isEmpty(fechaD))
		{
			fechaD="01/01/2009";
			sql.append(" AND TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", 'YYYY') = TO_CHAR(TO_DATE(?,?),'YYYY')");
			arrParams.add(fechaD);
			arrParams.add("DD/MM/YYYY");
		}	
				
		if(codMunicipio!=null && !"".equals(codMunicipio)){
			int codigo = Integer.parseInt(codMunicipio);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
			sql.append(" = ").append(codigo);
		}
		if(th!=null && !"".equals(th)){
			int codigo = Integer.parseInt(th);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
			sql.append(" = ").append(codigo);
		}
		sql.append(" GROUP BY ");
		sql.append(" TO_CHAR(TRUNC(T01.").append(V50bConsultasBD.FECRES).append(")-TRUNC(T01.").append(V50bConsultasBD.FECASI).append("))");
		sql.append(" ORDER BY 1");


		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
		
		return lista;
		
	}
	

	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 20, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosBean criterios
	 * @return List list
	 * @throws Exception exception
	 */
	public List fncObtenerDatosGraficosEvolucionUsuariosAlta(V50bCriteriosConsultaBean criteriosBean) throws Exception 
	{
		V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosEvolucionAlta ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.DOSCIENTOSCINCUENTAYCINCO);
		final List arrParams = new ArrayList();		
		final String strIdioma = criteriosBean.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		sql.append("SELECT TO_CHAR(T02.").append(V50bSuscriptoresBD.FEALTA).append(",'MM/YYYY') AS MES , ");
		sql.append("COUNT(1) AS CONTADOR");
		sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 ");
//		sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sql.append("WHERE T02.");
		sql.append(V50bSuscriptoresBD.CSUSCR).append(" > 0");
//		sql.append(" AND T02.").append(V50bSuscriptoresBD.CSUSCR).append(" = T01.").append(V50bConsultasBD.CSUSCR).append(" (+) ");
		sql.append(" AND T02.").append(V50bSuscriptoresBD.FEBAJA).append(" IS NULL");
//		String[] codAmbito = criteriosBean.getCodComboAmbitos();
//		String codEstado = criteriosBean.getCodEstado();
//		String codDificultad = criteriosBean.getCodDificultad();
		String fechaD = criteriosBean.getFechaD();
		String fechaH = criteriosBean.getFechaH();
		String codMunicipio= criteriosBean.getCodMunicipio();
		String th = criteriosBean.getCodTh();		
//		if(codAmbito.length>0){
//			
//			boolean hay = false;
//			for (int i=0; i<codAmbito.length;i++){
//				String codamb=codAmbito[i];
//				if((!"".equals(codamb))&&(codamb!=null)){
//					int codigo = Integer.parseInt(codamb);
//					if (!hay) {
//						hay = true;
//						sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
//						sql.append(" = ").append(codigo);	
//					} else {
//						sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
//						sql.append(" = ").append(codigo);
//					}
//				}
//			}
//			if (hay) {
//				sql.append(")");
//			}
//			
//		}

//		if(codEstado!=null && !"".equals(codEstado)){
//			int codigo = Integer.parseInt(codEstado);
//			sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
//			sql.append(" = ").append(codigo);
//		}
//		if(codDificultad!=null && !"".equals(codDificultad)){
//			int codigo = Integer.parseInt(codDificultad);
//			sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
//			sql.append(" = ").append(codigo);
//		}
		
		if(StringUtils.isNotEmpty(fechaD)){
			sql.append(" AND T02.").append(V50bSuscriptoresBD.FEALTA).append(" >= TO_DATE(?, ?) ");
			arrParams.add(fechaD);
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(fechaH)){
			sql.append(" AND T02.").append(V50bSuscriptoresBD.FEALTA).append(" <= TO_DATE(?, ?) ");
			arrParams.add(fechaH);
			arrParams.add(masc);
		}
		if(StringUtils.isEmpty(fechaD))
		{
			fechaD="01/01/2009";
			sql.append(" AND TO_CHAR(T02.").append(V50bSuscriptoresBD.FEALTA).append(", 'YYYY') = TO_CHAR(TO_DATE(?,?),'YYYY')");
			arrParams.add(fechaD);
			arrParams.add("DD/MM/YYYY");
		}	
				
		if(codMunicipio!=null && !"".equals(codMunicipio)){
			int codigo = Integer.parseInt(codMunicipio);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
			sql.append(" = ").append(codigo);
		}
		if(th!=null && !"".equals(th)){
			int codigo = Integer.parseInt(th);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
			sql.append(" = ").append(codigo);
		}
		sql.append(" GROUP BY ");
		sql.append(" TO_CHAR(T02.").append(V50bSuscriptoresBD.FEALTA).append(",'MM/YYYY')");
		sql.append(" ORDER BY 1");

		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoBarraConsultasRowMapper(strIdioma));
		
		return lista;
		
	}
	
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 20, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosBean criterios
	 * @return List list
	 * @throws Exception exception
	 */
	public List fncObtenerDatosGraficosEvolucionUsuariosBaja(V50bCriteriosConsultaBean criteriosBean) throws Exception 
	{
		
		V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosEvolucionBaja ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.DOSCIENTOSSETENTAYNUEVE);
		final List arrParams = new ArrayList();		
		final String strIdioma = criteriosBean.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		sql.append("SELECT TO_CHAR(T02.").append(V50bSuscriptoresBD.FEBAJA).append(",'MM/YYYY') AS MES , ");
		sql.append("COUNT(1) AS CONTADOR");
		sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 ");
//		sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sql.append("WHERE T02.");
		sql.append(V50bSuscriptoresBD.CSUSCR).append(" > 0");
		sql.append(" AND T02.").append(V50bSuscriptoresBD.FEBAJA).append(" IS NOT NULL");
//		sql.append(" AND T02.").append(V50bSuscriptoresBD.CSUSCR).append(" = T01.").append(V50bConsultasBD.CSUSCR).append(" (+) ");
//		String[] codAmbito = criteriosBean.getCodComboAmbitos();
//		String codEstado = criteriosBean.getCodEstado();
//		String codDificultad = criteriosBean.getCodDificultad();
		String fechaD = criteriosBean.getFechaD();
		String fechaH = criteriosBean.getFechaH();
		String codMunicipio= criteriosBean.getCodMunicipio();
		String th = criteriosBean.getCodTh();
//		if(codAmbito.length>0){
//			boolean hay = false;
//			for (int i=0; i<codAmbito.length;i++){
//				String codamb=codAmbito[i];
//				if((!"".equals(codamb))&&(codamb!=null)){
//					int codigo = Integer.parseInt(codamb);
//					if (!hay) {
//						hay = true;
//						sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
//						sql.append(" = ").append(codigo);	
//					} else {
//						sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
//						sql.append(" = ").append(codigo);
//					}
//				}
//			}
//			if (hay) {
//				sql.append(")");
//			}
//			
//		}

//		if(codEstado!=null && !"".equals(codEstado)){
//			int codigo = Integer.parseInt(codEstado);
//			sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
//			sql.append(" = ").append(codigo);
//		}
//		if(codDificultad!=null && !"".equals(codDificultad)){
//			int codigo = Integer.parseInt(codDificultad);
//			sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
//			sql.append(" = ").append(codigo);
//		}
		
		if(StringUtils.isNotEmpty(fechaD)){
			sql.append(" AND T02.").append(V50bSuscriptoresBD.FEBAJA).append(" >= TO_DATE(?, ?) ");
			arrParams.add(fechaD);
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(fechaH)){
			sql.append(" AND T02.").append(V50bSuscriptoresBD.FEBAJA).append(" <= TO_DATE(?, ?) ");
			arrParams.add(fechaH);
			arrParams.add(masc);
		}
		if(StringUtils.isEmpty(fechaD))
		{
			fechaD="01/01/2009";
			sql.append(" AND TO_CHAR(T02.").append(V50bSuscriptoresBD.FEBAJA).append(", 'YYYY') = TO_CHAR(TO_DATE(?,?),'YYYY')");
			arrParams.add(fechaD);
			arrParams.add("DD/MM/YYYY");
		}	
				
		if(codMunicipio!=null && !"".equals(codMunicipio)){
			int codigo = Integer.parseInt(codMunicipio);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
			sql.append(" = ").append(codigo);
		}
		if(th!=null && !"".equals(th)){
			int codigo = Integer.parseInt(th);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
			sql.append(" = ").append(codigo);
		}
		sql.append(" GROUP BY ");
		sql.append(" TO_CHAR(T02.").append(V50bSuscriptoresBD.FEBAJA).append(",'MM/YYYY')");
		sql.append(" ORDER BY ");
		sql.append(" TO_CHAR(T02.").append(V50bSuscriptoresBD.FEBAJA).append(",'MM/YYYY')");

		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoBarraConsultasRowMapper(strIdioma));
		
		return lista;
		
	}
	
	
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 14, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosBean criterios
	 * @return List lista
	 * @throws Exception exception
	 */
	public List fncObtenerDatosGraficosEvolucionConsultas(V50bCriteriosConsultaBean criteriosBean) throws Exception 
	{
		V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosEvolucionConsultas ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TRESCIENTOSTRES);
		final List arrParams = new ArrayList();		
		final String strIdioma = criteriosBean.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		sql.append("SELECT TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(",'MM/YYYY') AS MES , ");
		sql.append("COUNT(1) AS CONTADOR");
		sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sql.append("WHERE T01.");
		sql.append(V50bConsultasBD.CCONSU).append(" > 0");
		sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("! = '6' ");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("! = '7' ");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("! = '8' ");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("! = '9' ");
		String[] codAmbito = criteriosBean.getCodComboAmbitos();
		String codEstado = criteriosBean.getCodEstado();
		String codDificultad = criteriosBean.getCodDificultad();
		String fechaD = criteriosBean.getFechaD();
		String fechaH = criteriosBean.getFechaH();
		String codMunicipio= criteriosBean.getCodMunicipio();
		String th = criteriosBean.getCodTh();
		if(codAmbito.length>0){
			boolean hay = false;
			for (int i=0; i<codAmbito.length;i++){
				String codamb=codAmbito[i];
				if((!"".equals(codamb))&&(codamb!=null)){
					int codigo = Integer.parseInt(codamb);
					if (!hay) {
						hay = true;
						sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
						sql.append(" = ").append(codigo);	
					} else {
						sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
						sql.append(" = ").append(codigo);
					}
				}
			}
			if (hay) {
				sql.append(")");
			}
		}
		if(codEstado!=null && !"".equals(codEstado)){
			int codigo = Integer.parseInt(codEstado);
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
			sql.append(" = ").append(codigo);
		}
		if(codDificultad!=null && !"".equals(codDificultad)){
			int codigo = Integer.parseInt(codDificultad);
			sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
			sql.append(" = ").append(codigo);
		}
		
		if(StringUtils.isNotEmpty(fechaD)){
			sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
			arrParams.add(fechaD);
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(fechaH)){
			sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
			arrParams.add(fechaH);
			arrParams.add(masc);
		}
		if(StringUtils.isEmpty(fechaD))
		{
			fechaD="01/01/2009";
			sql.append(" AND TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", 'YYYY') = TO_CHAR(TO_DATE(?,?),'YYYY')");
			arrParams.add(fechaD);
			arrParams.add("DD/MM/YYYY");
		}	
				
		if(codMunicipio!=null && !"".equals(codMunicipio)){
			int codigo = Integer.parseInt(codMunicipio);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
			sql.append(" = ").append(codigo);
		}
		if(th!=null && !"".equals(th)){
			int codigo = Integer.parseInt(th);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
			sql.append(" = ").append(codigo);
		}
		sql.append(" GROUP BY ");
		sql.append(" TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(",'MM/YYYY')");
		sql.append(" ORDER BY 1");

		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoBarraConsultasRowMapper(strIdioma));
		
		return lista;
		
	}
	/**
	 * 
	 * <p>Ttulo: </p>
	 * <p>Descripcin: </p>
	 * <p>Copyright: Copyright (c) Jan 14, 2009</p>
	 * <p>Empresa: Eurohelp</p>
	 * 
	 * @author mmonge
	 * @version 1.0
	 * @param criteriosBean criterios
	 * @return List list
	 * @throws Exception exception
	 */
	public List fncObtenerDatosGraficosEvolucionRespuestas(V50bCriteriosConsultaBean criteriosBean) throws Exception 
	{

		V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosEvolucionRespuestas ");
		final StringBuffer sql = new StringBuffer(V50bClsConstantes.TRESCIENTOSVENTIUNO);
		final List arrParams = new ArrayList();		
		final String strIdioma = criteriosBean.getIdioma();
		final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
		sql.append("SELECT TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(",'MM/YYYY') AS MES , ");
		sql.append("COUNT(1) AS CONTADOR");
		sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
		sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
		sql.append("WHERE T01.");
		sql.append(V50bConsultasBD.CCONSU).append(" > 0");
		sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR).append("(+)");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("! = '1' ");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("! = '2' ");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("! = '3' ");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("! = '4' ");
		sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append("! = '5' ");
		String[] codAmbito = criteriosBean.getCodComboAmbitos();
		String codEstado = criteriosBean.getCodEstado();
		String codDificultad = criteriosBean.getCodDificultad();
		String fechaD = criteriosBean.getFechaD();
		String fechaH = criteriosBean.getFechaH();
		String codMunicipio= criteriosBean.getCodMunicipio();
		String th = criteriosBean.getCodTh();
		if(codAmbito.length>0){
			boolean hay = false;
			for (int i=0; i<codAmbito.length;i++){
				String codamb=codAmbito[i];
				if((!"".equals(codamb))&&(codamb!=null)){
					int codigo = Integer.parseInt(codamb);
					if (!hay) {
						hay = true;
						sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
						sql.append(" = ").append(codigo);	
					} else {
						sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
						sql.append(" = ").append(codigo);
					}
				}
			}
			if (hay) {
				sql.append(")");
			}
		}
		if(codEstado!=null && !"".equals(codEstado)){
			int codigo = Integer.parseInt(codEstado);
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
			sql.append(" = ").append(codigo);
		}
		if(codDificultad!=null && !"".equals(codDificultad)){
			int codigo = Integer.parseInt(codDificultad);
			sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
			sql.append(" = ").append(codigo);
		}
		if(StringUtils.isNotEmpty(fechaD)){
			sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
			arrParams.add(fechaD);
			arrParams.add(masc);
		}
		
		if(StringUtils.isNotEmpty(fechaH)){
			sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
			arrParams.add(fechaH);
			arrParams.add(masc);
		}		
		
		if(StringUtils.isEmpty(fechaD))
		{
			fechaD="01/01/2009";
			sql.append(" AND TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(", 'YYYY') = TO_CHAR(TO_DATE(?,?),'YYYY')");
			arrParams.add(fechaD);
			arrParams.add("DD/MM/YYYY");
		}
						
		if(codMunicipio!=null && !"".equals(codMunicipio)){
			int codigo = Integer.parseInt(codMunicipio);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
			sql.append(" = ").append(codigo);
		}
		if(th!=null && !"".equals(th)){
			int codigo = Integer.parseInt(th);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
			sql.append(" = ").append(codigo);
		}
		sql.append(" GROUP BY ");
		sql.append(" TO_CHAR(T01.").append(V50bConsultasBD.FECCON).append(",'MM/YYYY')");
		sql.append(" ORDER BY 1");

		List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoBarraRespuestasRowMapper(strIdioma));
		
		return lista;
		
	}
	/**
	 * @author mmonge
	 * @param criteriosBean parametro de entrada
	 * @return List parametro de salida
	 * @throws Exception excepcion
	 */
		public List fncObtenerDatosGraficosPorSexo(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorSexo ");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOOCHENTA);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
			sql.append("SELECT COUNT(T01.").append(V50bConsultasBD.CCONSU).append(") AS COUNT , ");
			sql.append("NVL(DECODE(T02.").append(V50bSuscriptoresBD.SEXOSUSCR).append(",?,?,?,?),?) AS TITULO");
			arrParams.add(V50bClsConstantes.CONSTANTE_HOMBRE);
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.hombre",strIdioma));
			arrParams.add(V50bClsConstantes.CONSTANTE_MUJER);
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.mujer",strIdioma));
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.noInformado",strIdioma));
			
			sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR).append("(+)");
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
				
			}

			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
			}
			sql.append(" GROUP BY ");
			sql.append(" T02.").append(V50bSuscriptoresBD.SEXOSUSCR);
			sql.append(" ORDER BY 1");
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
			
			return lista;
			
		}
		/**
		 * @author mmonge
		 * @param criteriosBean parametro de entrada
		 * @return List parametro de salida
		 * @throws Exception excepcion 
		 */
		public List fncObtenerDatosGraficosPorEstado(
				V50bCriteriosConsultaBean criteriosBean) throws Exception {		
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorEstado ");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTONOVENTAYOCHO);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);	
			
			sql.append("SELECT COUNT(T01.").append(V50bConsultasBD.CODEST).append(") AS COUNT , ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("T21.").append(V50bEstadosBD.DESCC).append(" AS TITULO ");
			} else {
				sql.append("T21.").append(V50bEstadosBD.DESCE).append(" AS TITULO ");
			}
			//sql.append("SUM(CODESTADO").append(") AS TOTAL ");
			sql.append(" FROM ").append(V50bEstadosBD.TABLA_ESTADOS).append(" T21 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 , ");
			sql.append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = T21.").append(V50bEstadosBD.CODEST);
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR);
			sql.append("(+)");
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			//String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}
			
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
				
			}			
			sql.append(" GROUP BY ");
			sql.append(" T21.").append(V50bEstadosBD.CODEST);
			sql.append(" , T21.").append(V50bEstadosBD.DESCC);
			sql.append(" , T21.").append(V50bEstadosBD.DESCE);
			sql.append(" ORDER BY 1");
			return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
			
		}
		
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Dec 29, 2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criteriosBean
		 * @return List
		 * @throws Exception the exception
		 */
		public List fncObtenerDatosGraficosPorLocalizacion(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{		
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorLocalizacion ");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOOCHENTAYDOS);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);	
			sql.append("SELECT COUNT(T01.").append(V50bConsultasBD.CCONSU).append(") AS COUNT , ");
			sql.append("NVL(T22.").append(V50bProvinciasBD.DS_O).append(",?) AS TITULO ");
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.noInformado",strIdioma));
			
			sql.append(" FROM ").append(V50bProvinciasBD.TABLA_PROVINCIAS).append(" T22 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 , ");
			sql.append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR);
			sql.append("(+)");
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV).append(" = T22.").append(V50bProvinciasBD.ID).append("(+)");
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			//String codMunicipio= criteriosBean.getCodMunicipio();
			//String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}
			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			
			sql.append(" GROUP BY ");
			sql.append(" T22.").append(V50bProvinciasBD.DS_O);
			sql.append(" ORDER BY 1");
			return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
			
		}
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Dec 29, 2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criteriosBean
		 * @return List lista
		 * @throws Exception the exception
		 */
		public List fncObtenerDatosGraficosPorLocalizacionMunicipio(V50bCriteriosConsultaBean criteriosBean) throws Exception {
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorLocalizacionMunicipio ");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOOCHENTAYDOS);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);	
			sql.append("SELECT COUNT(T02.").append(V50bSuscriptoresBD.COMUNI).append(") AS COUNT , ");
			sql.append("T23.").append(V50bMunicipiosBD.DS_O).append(" AS TITULO ");
			sql.append(" FROM ").append(V50bMunicipiosBD.TABLA_MUNICIPIOS).append(" T23 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 , ");
			sql.append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR);
			sql.append("(+)");
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI).append(" = T23.").append(V50bMunicipiosBD.ID);
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			//String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}
			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			/*if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}*/
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T23.").append(V50bMunicipiosBD.PROVINCIA_ID);
				sql.append(" = ").append(codigo);
				
			}			
			sql.append(" GROUP BY ");
			sql.append(" T23.").append(V50bMunicipiosBD.DS_O);
			sql.append(" ORDER BY 1");
			return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
			
		}
		
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Dec 29, 2008</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criteriosBean
		 * @return List lista
		 * @throws Exception the exception
		 */
		public List fncObtenerDatosGraficosPorReenvios(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorReenviosYCausas ");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.DOSCIENTOSSEIS);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
			sql.append("SELECT COUNT(T04.").append(V50bMotivosBD.CMOTIV).append(") AS COUNT , ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("T04.").append(V50bMotivosBD.DMOTIC).append(" AS TITULO ");
			} else {
				sql.append("T04.").append(V50bMotivosBD.DMOTIE).append(" AS TITULO ");
			}
			sql.append(" FROM ").append(V50bMotivosBD.TABLA_MOTIVOS).append(" T04 , ");
			sql.append(V50bMotivosConsultaBD.TABLA_MOTIVOS_CONSULTA).append(" T05 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 , ");
			sql.append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR);
			sql.append("(+)");
			sql.append(" AND T01.").append(V50bConsultasBD.CCONSU).append(" = T05.").append(V50bMotivosConsultaBD.CCONSU);
			sql.append(" AND T05.").append(V50bMotivosConsultaBD.CMOTIV).append(" = T04.").append(V50bMotivosBD.CMOTIV);
			sql.append(" AND T04.").append(V50bMotivosBD.CMOTIV).append(" > 0 ");
			if (V50bClsConstantes.CAUSAS_REENVIOS.equals(criteriosBean.getRadio()))
			{
				sql.append(" AND T05.").append(V50bMotivosConsultaBD.TIPMOT).append(" = '").append(V50bClsConstantes.CONSTANTE_MOTIVO_TIPO_REENVIO);
				sql.append("'");
				sql.append(" AND T04.").append(V50bMotivosBD.TIPMOT).append(" = '").append(V50bClsConstantes.CONSTANTE_MOTIVO_TIPO_REENVIO);
				sql.append("'");
			}
			else if (V50bClsConstantes.CAUSAS_DENEGACION.equals(criteriosBean.getRadio())){
				sql.append(" AND T05.").append(V50bMotivosConsultaBD.TIPMOT).append(" = '").append(V50bClsConstantes.CONSTANTE_MOTIVO_DENEGACION);
				sql.append("'");
				sql.append(" AND T04.").append(V50bMotivosBD.TIPMOT).append(" = '").append(V50bClsConstantes.CONSTANTE_MOTIVO_DENEGACION);
				sql.append("'");
			}
			else if (V50bClsConstantes.CAUSAS_RECHAZOS.equals(criteriosBean.getRadio())){
				sql.append(" AND T05.").append(V50bMotivosConsultaBD.TIPMOT).append(" = '").append(V50bClsConstantes.CONSTANTE_MOTIVO_TIPO_RECHAZO);
				sql.append("'");
				sql.append(" AND T04.").append(V50bMotivosBD.TIPMOT).append(" = '").append(V50bClsConstantes.CONSTANTE_MOTIVO_TIPO_RECHAZO);
				sql.append("'");
			}
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}

			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
			}
			sql.append(" GROUP BY ");
			sql.append(" T04.").append(V50bMotivosBD.CMOTIV).append(", ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("T04.").append(V50bMotivosBD.DMOTIC);
			} else {
				sql.append("T04.").append(V50bMotivosBD.DMOTIE);
			}
			sql.append(" ORDER BY 1");
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
			
			return lista;
			
		}

		
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Jan 5, 2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criterios 
		 * @return List lista
		 * @throws Exception excepcion
		 */
		public List fncObtenerDatosGraficosPorRespuestasTecnico(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorRespuestasTecnico ");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.DOSCIENTOSDIECISIETE);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
			sql.append("SELECT COUNT(T01.").append(V50bConsultasBD.CCONSU).append(") AS CONTRESPUESTAS , ");
			sql.append("T03.").append(V50bResolutoresBD.ID_RESOL).append(" AS TITULORESPUESTA , ");
			sql.append("T03.").append(V50bResolutoresBD.COD_RESOL).append(" AS RESOL");
			sql.append(" FROM ").append(V50bResolutoresBD.TABLA_RESOLUTORES).append(" T03 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.RESPUESTA).append(" IS NOT NULL");
			sql.append(" AND T01.").append(V50bConsultasBD.CRESOL).append(" = T03.").append(V50bResolutoresBD.COD_RESOL);
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}

			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
			}
			sql.append(" GROUP BY ");
			sql.append(" T03.").append(V50bResolutoresBD.COD_RESOL);
			sql.append(" , T03.").append(V50bResolutoresBD.ID_RESOL);
			sql.append(" ORDER BY 1");
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionPorRespuestasTecnicoRowMapper());
			
			return lista;
			
		}
		
		
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Jan 5, 2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criterios 
		 * @return List lista
		 * @throws Exception excepcion
		 */
		public List fncObtenerDatosGraficosPorTipoTrabajo(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{
			
			
			
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorTipoTrabajo");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOOCHENTA);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
			sql.append("SELECT COUNT(T01.").append(V50bConsultasBD.CCONSU).append(") AS COUNT , ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("NVL(T11.").append(V50bTipoTrabajoBD.DESCC).append(",?) AS TITULO ");
			} else {
				sql.append("NVL(T11.").append(V50bTipoTrabajoBD.DESCE).append(",?) AS TITULO ");
			}
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.noInformado",strIdioma));
			
			sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 , ");
			sql.append(V50bTipoTrabajoBD.TABLA_TIPOTRABAJO).append(" T11 ");
			
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.CODTRA).append(" = T11.").append(V50bTipoTrabajoBD.CODTRA).append("(+)");
			
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}

			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
			}
			sql.append(" GROUP BY ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("T11.").append(V50bTipoTrabajoBD.DESCC);
			} else {
				sql.append("T11.").append(V50bTipoTrabajoBD.DESCE);
			}
			sql.append(" , T02.").append(V50bSuscriptoresBD.CODTRA);
			sql.append(" ORDER BY 1");
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
			
			return lista;
			
		}
		
		
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Jan 5, 2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criterios 
		 * @return List lista
		 * @throws Exception excepcion
		 */
		public List fncObtenerDatosGraficosPorTipoProfesion(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{
			
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorTipoProfesion");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOOCHENTA);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);
			sql.append("SELECT COUNT(T01.").append(V50bConsultasBD.CCONSU).append(") AS COUNT , ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("NVL(T10.").append(V50bProfesionesBD.DESCAS).append(",?) AS TITULO ");
			} else {
				sql.append("NVL(T10.").append(V50bProfesionesBD.DESEUS).append(",?) AS TITULO ");
			}
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.noInformado",strIdioma));
			
			sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 , ");
			sql.append(V50bProfesionesBD.TABLA_PROFESIONES).append(" T10 ");			
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR);
			sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROF).append(" = T10.").append(V50bProfesionesBD.CODPROF).append("(+)");
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}

			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
			}
			sql.append(" GROUP BY ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("T10.").append(V50bProfesionesBD.DESCAS);
			} else {
				sql.append("T10.").append(V50bProfesionesBD.DESEUS);
			}
			sql.append(" , T02.").append(V50bSuscriptoresBD.COPROF);
			sql.append(" ORDER BY 1");
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
			
			return lista;
			
			
		}
		
		
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Jan 5, 2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criterios 
		 * @return List lista
		 * @throws Exception excepcion
		 */
		public List fncObtenerDatosGraficosPorEdades(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{
			
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorEdad");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.DOSCIENTOSTREINTA);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);			
			sql.append("SELECT NVL(TO_CHAR(T02.").append(V50bSuscriptoresBD.FENACI).append(",?),?) AS FECHANACIMIENTO ,  ");
			arrParams.add(V50bClsConstantes.FORMATO_FECHA_CASTELLANO);
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.noInformado",strIdioma));
			
			sql.append(" (TRUNC(SYSDATE)-T02.").append(V50bSuscriptoresBD.FENACI).append(")/365 AS EDAD , ");
			sql.append("T01.").append(V50bConsultasBD.CSUSCR).append(" AS SUSCRIPTOR ");
			sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR);
			//sql.append(" AND T02.").append(V50bSuscriptoresBD.FENACI).append(" IS NOT NULL");
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}

			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
			}
			sql.append(" GROUP BY ");
			sql.append(" T02.").append(V50bSuscriptoresBD.FENACI);
			sql.append(" , T01.").append(V50bConsultasBD.CSUSCR);
			sql.append(" ORDER BY 1");
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionPorEdadRowMapper());
			
			return lista;
			
			
		}
		
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Jan 12, 2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criterios
		 * @return List lista
		 * @throws Exception exception
		 */
		public List fncObtenerDatosGraficosPorMultiterm(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{
			
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorMultiterm");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTOOCHENTA);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);		
			sql.append("SELECT DECODE(T01.").append(V50bConsultasBD.MULTIT).append(",?,?,?,?) AS TITULO , ");
			arrParams.add(V50bClsConstantes.CONSTANTE_SI);
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.si",strIdioma));
			arrParams.add(V50bClsConstantes.CONSTANTE_NO);
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.no",strIdioma));
			
			sql.append(" COUNT(T01.").append(V50bConsultasBD.CCONSU).append(")AS COUNT ");
			sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR).append("(+)");
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}

			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
			}
			sql.append(" GROUP BY ");
			sql.append(" T01.").append(V50bConsultasBD.MULTIT);
			sql.append(" ORDER BY 1");
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
			
			return lista;
			
			
		}
		
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Jan 12, 2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criterios
		 * @return List lista
		 * @throws Exception exception
		 */
		public List fncObtenerDatosGraficosPorCatalogadas(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{
			
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorCatalogadas");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.DOSCIENTOSSEIS);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);	
			sql.append("SELECT COUNT(T01.").append(V50bConsultasBD.CCONSU).append(") AS COUNT ,  ");
			sql.append("T01.").append(V50bConsultasBD.CODEST).append(" AS ESTADO ,  ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("T21.").append(V50bEstadosBD.DESCC).append(" AS TITULO ");
			} else {
				sql.append("T21.").append(V50bEstadosBD.DESCE).append(" AS TITULO ");
			}
			sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 , ");
			sql.append(V50bEstadosBD.TABLA_ESTADOS).append(" T21 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR).append("(+) ");
			sql.append(" AND T01.").append(V50bConsultasBD.CODEST).append(" = T21.").append(V50bEstadosBD.CODEST).append("(+)");
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}

			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
			}
			sql.append(" GROUP BY ");
			sql.append("T01.").append(V50bConsultasBD.CODEST).append(", ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("T21.").append(V50bEstadosBD.DESCC);
			} else {
				sql.append("T21.").append(V50bEstadosBD.DESCE);
			}
			sql.append(" ORDER BY 1");
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoEstadoRowMapper());
			
			return lista;
			
			
		}
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Jan 13, 2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criterios
		 * @return List lista
		 * @throws Exception exception
		 */
		public List fncObtenerDatosGraficosPorDificultad(
				V50bCriteriosConsultaBean criteriosBean) throws Exception {		
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorDificultad ");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTONOVENTAYOCHO);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);	
			sql.append("SELECT COUNT(T01.").append(V50bConsultasBD.CCONSU).append(") AS COUNT , ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("NVL(T09.").append(V50bDificultadBD.DESCC).append(",?) AS TITULO  ");
			} else {
				sql.append("NVL(T09.").append(V50bDificultadBD.DESCE).append(",?) AS TITULO ");
			}
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.noInformado",strIdioma));
			
			sql.append(" FROM ").append(V50bDificultadBD.TABLA_DIFICULTAD).append(" T09 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 , ");
			sql.append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CODDIF).append(" = T09.").append(V50bDificultadBD.CODDIF);
			sql.append("(+)");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR);
			sql.append("(+)");
			sql.append(" AND T01.").append(V50bConsultasBD.CAMBIT).append(" = T09.").append(V50bDificultadBD.CAMBIT);
			sql.append("(+)");
			
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			//String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}

			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			/*if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}*/
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
				
			}			
			sql.append(" GROUP BY ");
			sql.append(" T01.").append(V50bConsultasBD.CODDIF).append(", ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("T09.").append(V50bDificultadBD.DESCC);
			} else {
				sql.append("T09.").append(V50bDificultadBD.DESCE);
			}
			sql.append(" ORDER BY 1");
			return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
			
		}

	
		
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Jan 26, 2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param idioma idioma
		 * @return List lista
		 * @throws Exception exception
		 */
		public List fncObtenerDatosAmbitos(String idioma) throws Exception {
			V50bClsTrazas.depura("V50bGraficosDAOImpl.V50bGraficosImpl.fncObtenerDatosGraficosPorDificultad ");
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.OCHENTAYUNO);
			final List arrParams = new ArrayList();		
			final String strIdioma = idioma;
			//final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);	
			sql.append("SELECT T07.").append(V50bAmbitoBD.CAMBIT).append(" AS CODAMBITO , ");
			if(V50bClsConstantes.CONSTANTE_CASTELLANO.equals(strIdioma)){
				sql.append("T07.").append(V50bAmbitoBD.DESAMC).append(" AS NOMBREAMBITO  ");
			} else {
				sql.append("T07.").append(V50bAmbitoBD.DESAME).append(" AS NOMBREAMBITO ");
			}
			sql.append(" FROM ").append(V50bAmbitoBD.TABLA_AMBITO).append(" T07 ");
			sql.append("WHERE T07.");
			sql.append(V50bAmbitoBD.CAMBIT).append(" > 0");
			sql.append(" ORDER BY 1");
			return new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionAmbitoRowMapper());
			
		}
		
		/**
		 * 
		 * <p>Ttulo: </p>
		 * <p>Descripcin: </p>
		 * <p>Copyright: Copyright (c) Jan 13, 2009</p>
		 * <p>Empresa: Eurohelp</p>
		 * 
		 * @author mmonge
		 * @version 1.0
		 * @param criteriosBean criterios
		 * @return List lista
		 * @throws Exception exception
		 */
		public List fncObtenerDatosGraficosPorLlegadaConsulta(V50bCriteriosConsultaBean criteriosBean) throws Exception 
		{
			V50bClsTrazas.depura("V50bGraficosDAOImpl.fncObtenerDatosGraficosPorLlegadaConsulta() ");
			
			final StringBuffer sql = new StringBuffer(V50bClsConstantes.CIENTONOVENTAYOCHO);
			final List arrParams = new ArrayList();		
			final String strIdioma = criteriosBean.getIdioma();
			final String masc = V50bClsFunciones.fncMascaraToCharToDate(strIdioma);	
			sql.append("SELECT NVL(DECODE(T01.").append(V50bConsultasBD.RECIBI).append(",?,?,?,?,?,?,?,?,?,?),?) AS TITULO , ");
			arrParams.add(V50bClsConstantes.RECEPCION_CORREO);
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.correo",strIdioma));
			arrParams.add(V50bClsConstantes.RECEPCION_INICIATIVA);
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.iniciativaPropia",strIdioma));
			arrParams.add(V50bClsConstantes.RECEPCION_MIGRACION);
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.migracionInicial",strIdioma));
			arrParams.add(V50bClsConstantes.RECEPCION_PROPUESTA);
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.propuesta",strIdioma));
			arrParams.add(V50bClsConstantes.RECEPCION_TELEFONO);
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","comun.telefono",strIdioma));
			arrParams.add(Q70GestorMensajesi18n.getSingleton().getMessage("v50bcomun","aplicacion.titulo",strIdioma));
			
			sql.append(" COUNT(T01.").append(V50bConsultasBD.CCONSU).append(")AS COUNT ");
			sql.append(" FROM ").append(V50bSuscriptoresBD.TABLA_SUSCRIPTORES).append(" T02 , ");
			sql.append(V50bConsultasBD.TABLA_CONSULTAS).append(" T01 ");
			sql.append("WHERE T01.");
			sql.append(V50bConsultasBD.CCONSU).append(" > 0");
			sql.append(" AND T01.").append(V50bConsultasBD.CSUSCR).append(" = T02.").append(V50bSuscriptoresBD.CSUSCR).append("(+)");
			String[] codAmbito = criteriosBean.getCodComboAmbitos();
			String codEstado = criteriosBean.getCodEstado();
			String codDificultad = criteriosBean.getCodDificultad();
			String fechaD = criteriosBean.getFechaD();
			String fechaH = criteriosBean.getFechaH();
			String codMunicipio= criteriosBean.getCodMunicipio();
			String th = criteriosBean.getCodTh();
			if(codAmbito.length>0){
				boolean hay = false;
				for (int i=0; i<codAmbito.length;i++){
					String codamb=codAmbito[i];
					if((!"".equals(codamb))&&(codamb!=null)){
						int codigo = Integer.parseInt(codamb);
						if (!hay) {
							hay = true;
							sql.append(" AND (T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);	
						} else {
							sql.append(" OR T01.").append(V50bConsultasBD.CAMBIT);
							sql.append(" = ").append(codigo);
						}
					}
				}
				if (hay) {
					sql.append(")");
				}
			}
			if(codEstado!=null && !"".equals(codEstado)){
				int codigo = Integer.parseInt(codEstado);
				sql.append(" AND T01.").append(V50bConsultasBD.CODEST);
				sql.append(" = ").append(codigo);
			}
			if(codDificultad!=null && !"".equals(codDificultad)){
				int codigo = Integer.parseInt(codDificultad);
				sql.append(" AND T01.").append(V50bConsultasBD.CODDIF);
				sql.append(" = ").append(codigo);
			}
			
			if(StringUtils.isNotEmpty(fechaD)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" >= TO_DATE(?, ?) ");
				arrParams.add(fechaD);
				arrParams.add(masc);
			}
			
			if(StringUtils.isNotEmpty(fechaH)){
				sql.append(" AND T01.").append(V50bConsultasBD.FECCON).append(" <= TO_DATE(?, ?) ");
				arrParams.add(fechaH);
				arrParams.add(masc);
			}
			
			if(codMunicipio!=null && !"".equals(codMunicipio)){
				int codigo = Integer.parseInt(codMunicipio);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COMUNI);
				sql.append(" = ").append(codigo);
			}
			if(th!=null && !"".equals(th)){
				int codigo = Integer.parseInt(th);
				sql.append(" AND T02.").append(V50bSuscriptoresBD.COPROV);
				sql.append(" = ").append(codigo);
			}
			sql.append(" GROUP BY ");
			sql.append(" T01.").append(V50bConsultasBD.RECIBI);
			sql.append(" ORDER BY 1");
			List lista = new V50bClsAccesoBD().fncLanzaBusqueda(sql.toString(),arrParams,new V50IndicadoresGestionGraficoRowMapper());
			
			return lista;
			
			
		}
		
	

		
		//***************
		//* ROW-MAPPERS *
		//***************
		
		
		/**
		 * @author mmonge
		 */
		class V50IndicadoresGestionAmbitoRowMapper implements V50bRowMapper
		
		{
			/**
			 * @param rs parametro de entrada
			 * @return Object
			 * @throws SQLException excepcion
			 */
			public Object mapRow(ResultSet rs) throws SQLException 
			{
				V50bAmbitoBean miBean= new V50bAmbitoBean();
				miBean.setCambit(rs.getString("CODAMBITO"));
				miBean.setDesamc(rs.getString("NOMBREAMBITO"));
				
				return miBean;
			}
			
			
			
			
		}
		
		/**
		 * 
		 * @author llaparra
		 *
		 */
		class V50IndicadoresGestionGraficoEstadoRowMapper implements V50bRowMapper {
			/**
			 * @param rs parametro de entrada
			 * @return Object
			 * @throws SQLException excepcion
			 */
			public Object mapRow(ResultSet rs) throws SQLException {
				V50bConsultaGraficoPorcentajeBean miBean= new V50bConsultaGraficoPorcentajeBean();
				miBean.setCountGraf(rs.getString("COUNT"));
				miBean.setEstadoConsulta(rs.getString("ESTADO"));
				miBean.setTituloGraf(rs.getString("TITULO"));
				return miBean;
			}
		}
		
		/**
		 * 
		 * @author mmonge
		 *
		 */
		class V50IndicadoresGestionGraficoRowMapper implements V50bRowMapper {
			/**
			 * @param rs parametro de entrada
			 * @return Object
			 * @throws SQLException excepcion
			 */
			public Object mapRow(ResultSet rs) throws SQLException {
				V50bConsultaGraficoPorcentajeBean miBean= new V50bConsultaGraficoPorcentajeBean();
				miBean.setCountGraf(rs.getString("COUNT"));
				miBean.setTituloGraf(rs.getString("TITULO"));
				return miBean;
			}
		}
		
		
		/**
		 * 
		 * @author mmonge
		 *
		 */
		class V50IndicadoresGestionPorRespuestasTecnicoRowMapper implements V50bRowMapper
		{

			/**
			* @param rs parametro de entrada
			* @return Object
			* @throws SQLException excepcion
			*/
			public Object mapRow(ResultSet rs) throws SQLException {
				V50bConsultaRespuestasPorTecnicoPorcentajeBean miBean= new V50bConsultaRespuestasPorTecnicoPorcentajeBean();
				miBean.setCountRespuestas(rs.getString("CONTRESPUESTAS"));
				miBean.setTituloRespuestas(rs.getString("TITULORESPUESTA"));
				miBean.setResolutor(rs.getString("RESOL"));
				return miBean;
			}
			
		}
		
		
		/**
		 * 
		 * @author mmonge
		 *
		 */
		class V50IndicadoresGestionPorEdadRowMapper implements V50bRowMapper
		{

			
			/**
			 * @param rs parametro de entrada
			 * @return Object objeto
			 * @throws SQLException exception
			 */
			public Object mapRow(ResultSet rs) throws SQLException {
				V50bConsultaEdadPorcentajeBean miBean= new V50bConsultaEdadPorcentajeBean();
				miBean.setFechaNac(rs.getString("FECHANACIMIENTO"));
				double aux;
				if(StringUtils.isNotEmpty(rs.getString("EDAD"))){
					aux = Double.valueOf(rs.getString("EDAD")).doubleValue();
				} else {
					aux = -1;
				}
				String edad=String.valueOf(aux);
				miBean.setEdad(edad);
				miBean.setCodigo(rs.getString("SUSCRIPTOR"));
				return miBean;
			}
			
		}
		
	/**
	 * 
	 * @author mmonge
	 *
	 */	
	class V50IndicadoresGestionGraficoBarraConsultasRowMapper implements V50bRowMapper {
		private transient String strIdioma;
		/**
		 * 
		 * @param idioma Idioma de la sesin
		 */
		public V50IndicadoresGestionGraficoBarraConsultasRowMapper(String idioma){
			this.strIdioma=idioma;
		}
		
		/**
		 * @param rs parametro de entrada
		 * @return Object
		 * @throws SQLException excepcion
		 */
		public Object mapRow(ResultSet rs) throws SQLException  {
			V50bConsultaGraficoBarraPorcentajeBean miBean= new V50bConsultaGraficoBarraPorcentajeBean();
			miBean.setCountC(rs.getString("CONTADOR"));
			miBean.setFecha(rs.getString("MES"));
			
			String mes = miBean.getFecha().substring(0, 1);
			if ("0".equals(mes)) {
				mes = miBean.getFecha().substring(1, 2);
			} else {
				mes = miBean.getFecha().substring(0, 2);
			}
			try{
				miBean.setMes(V50bClsFecha.fncObtenerNombreCodigoMes(mes,this.strIdioma));
			}catch (Exception e) {
				miBean.setMes("");
			}
			/*if (V50bClsConstantes.MES_ENERO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.enero", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_FEBRERO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.febrero", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_MARZO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.marzo", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_ABRIL.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.abril", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_MAYO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.mayo", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_JUNIO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.junio", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_JULIO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.julio", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_AGOSTO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.agosto", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_SEPTIEMBRE.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.septiembre", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_OCTUBRE.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.octubre", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_NOVIEMBRE.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.noviembre", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_DICIEMBRE.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.diciembre", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			}*/
			
			return miBean;
		}
		
		
		
		
	}
	
	/**
	 * 
	 * @author mmonge
	 *
	 */
	class V50IndicadoresGestionGraficoBarraRespuestasRowMapper implements V50bRowMapper {
		private transient String strIdioma;
		/**
		 * 
		 * @param idioma Idioma de la sesin
		 */
		public V50IndicadoresGestionGraficoBarraRespuestasRowMapper(String idioma){
			this.strIdioma=idioma;
		}
		
		/**
		 * @param rs parametro de entrada
		 * @return Object
		 * @throws SQLException excepcion
		 */
		public Object mapRow(ResultSet rs) throws SQLException {
			V50bConsultaGraficoBarraPorcentajeBean miBean= new V50bConsultaGraficoBarraPorcentajeBean();
			miBean.setCountR(rs.getString("CONTADOR"));
			miBean.setFecha(rs.getString("MES"));
			
			String mes = miBean.getFecha().substring(0, 1);
			if ("0".equals(mes)) {
				mes = miBean.getFecha().substring(1, 2);
			} else {
				mes = miBean.getFecha().substring(0, 2);
			}
			try{
				miBean.setMes(V50bClsFecha.fncObtenerNombreCodigoMes(mes,this.strIdioma));
			}catch (Exception e) {
				miBean.setMes("");
			}
			/*if (V50bClsConstantes.MES_ENERO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.enero", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_FEBRERO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.febrero", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_MARZO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.marzo", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_ABRIL.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.abril", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_MAYO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.mayo", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_JUNIO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.junio", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_JULIO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.julio", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_AGOSTO.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.agosto", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_SEPTIEMBRE.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.septiembre", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_OCTUBRE.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.octubre", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_NOVIEMBRE.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.noviembre", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			} else if (V50bClsConstantes.MES_DICIEMBRE.equals(mes)) {
				try{
					miBean.setMes(Q70GestorMensajesi18n.getSingleton().getMessage(
							"v50bcomun", "comun.diciembre", this.strIdioma));
				}catch (Exception e) {
					miBean.setMes("");
				}
			}*/
			return miBean;
		}
	}

	
		
		
}
		
